/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ntp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeStamp;

public class TimeInfo {
    private NtpV3Packet _message;
    private List _comments;
    private Long _delay;
    private Long _offset;
    private long _returnTime;
    private boolean _detailsComputed;

    public TimeInfo(NtpV3Packet ntpV3Packet, long l) {
        this(ntpV3Packet, l, null, true);
    }

    public TimeInfo(NtpV3Packet ntpV3Packet, long l, List list) {
        this(ntpV3Packet, l, list, true);
    }

    public TimeInfo(NtpV3Packet ntpV3Packet, long l, boolean bl) {
        this(ntpV3Packet, l, null, bl);
    }

    public TimeInfo(NtpV3Packet ntpV3Packet, long l, List list, boolean bl) {
        if (ntpV3Packet == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        this._returnTime = l;
        this._message = ntpV3Packet;
        this._comments = list;
        if (bl) {
            this.computeDetails();
        }
    }

    public void addComment(String string) {
        if (this._comments == null) {
            this._comments = new ArrayList();
        }
        this._comments.add(string);
    }

    public void computeDetails() {
        if (this._detailsComputed) {
            return;
        }
        this._detailsComputed = true;
        if (this._comments == null) {
            this._comments = new ArrayList();
        }
        TimeStamp timeStamp = this._message.getOriginateTimeStamp();
        long l = timeStamp.getTime();
        TimeStamp timeStamp2 = this._message.getReceiveTimeStamp();
        long l2 = timeStamp2.getTime();
        TimeStamp timeStamp3 = this._message.getTransmitTimeStamp();
        long l3 = timeStamp3.getTime();
        if (timeStamp.ntpValue() == 0L) {
            if (timeStamp3.ntpValue() != 0L) {
                this._offset = new Long(l3 - this._returnTime);
                this._comments.add("Error: zero orig time -- cannot compute delay");
            } else {
                this._comments.add("Error: zero orig time -- cannot compute delay/offset");
            }
        } else if (timeStamp2.ntpValue() == 0L || timeStamp3.ntpValue() == 0L) {
            this._comments.add("Warning: zero rcvNtpTime or xmitNtpTime");
            if (l > this._returnTime) {
                this._comments.add("Error: OrigTime > DestRcvTime");
            } else {
                this._delay = new Long(this._returnTime - l);
            }
            if (timeStamp2.ntpValue() != 0L) {
                this._offset = new Long(l2 - l);
            } else if (timeStamp3.ntpValue() != 0L) {
                this._offset = new Long(l3 - this._returnTime);
            }
        } else {
            long l4 = this._returnTime - l;
            if (l3 < l2) {
                this._comments.add("Error: xmitTime < rcvTime");
            } else {
                long l5 = l3 - l2;
                if (l5 <= l4) {
                    l4 -= l5;
                } else if (l5 - l4 == 1L) {
                    if (l4 != 0L) {
                        this._comments.add("Info: processing time > total network time by 1 ms -> assume zero delay");
                        l4 = 0L;
                    }
                } else {
                    this._comments.add("Warning: processing time > total network time");
                }
            }
            this._delay = new Long(l4);
            if (l > this._returnTime) {
                this._comments.add("Error: OrigTime > DestRcvTime");
            }
            this._offset = new Long((l2 - l + (l3 - this._returnTime)) / 2L);
        }
    }

    public List getComments() {
        return this._comments;
    }

    public Long getDelay() {
        return this._delay;
    }

    public Long getOffset() {
        return this._offset;
    }

    public NtpV3Packet getMessage() {
        return this._message;
    }

    public long getReturnTime() {
        return this._returnTime;
    }
}

