/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.ErrorHandler;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.StreamTarget;
import org.apache.log.util.DefaultErrorHandler;
import org.apache.log.util.LoggerListener;

public class Hierarchy {
    public static final String DEFAULT_FORMAT = "%7.7{priority} %23.23{time:yyyy-MM-dd' 'HH:mm:ss.SSS} [%8.8{category}] (%{context}): %{message}\n%{throwable}";
    private static final Hierarchy c_hierarchy = new Hierarchy();
    private ErrorHandler m_errorHandler = new DefaultErrorHandler();
    private Logger m_rootLogger = new Logger(new InnerErrorHandler(), new InnerLoggerListener(), "", null, null);
    private LoggerListener m_loggerListener;

    public static Hierarchy getDefaultHierarchy() {
        return c_hierarchy;
    }

    public Hierarchy() {
        PatternFormatter patternFormatter = new PatternFormatter(DEFAULT_FORMAT);
        StreamTarget streamTarget = new StreamTarget(System.out, patternFormatter);
        this.setDefaultLogTarget(streamTarget);
    }

    public void setDefaultLogTarget(LogTarget logTarget) {
        if (null == logTarget) {
            throw new IllegalArgumentException("Can not set DefaultLogTarget to null");
        }
        LogTarget[] logTargetArray = new LogTarget[]{logTarget};
        this.getRootLogger().setLogTargets(logTargetArray);
    }

    public void setDefaultLogTargets(LogTarget[] logTargetArray) {
        if (null == logTargetArray || 0 == logTargetArray.length) {
            throw new IllegalArgumentException("Can not set DefaultLogTargets to null");
        }
        for (int i = 0; i < logTargetArray.length; ++i) {
            if (null != logTargetArray[i]) continue;
            throw new IllegalArgumentException("Can not set DefaultLogTarget element to null");
        }
        this.getRootLogger().setLogTargets(logTargetArray);
    }

    public void setDefaultPriority(Priority priority) {
        if (null == priority) {
            throw new IllegalArgumentException("Can not set default Hierarchy Priority to null");
        }
        this.getRootLogger().setPriority(priority);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (null == errorHandler) {
            throw new IllegalArgumentException("Can not set default Hierarchy ErrorHandler to null");
        }
        this.m_errorHandler = errorHandler;
    }

    public synchronized void addLoggerListener(LoggerListener loggerListener) {
        if (null == loggerListener) {
            throw new NullPointerException("loggerListener");
        }
        if (null != this.m_loggerListener) {
            throw new UnsupportedOperationException("LoggerListener already set on a unicast event notifier");
        }
        this.m_loggerListener = loggerListener;
    }

    public synchronized void removeLoggerListener(LoggerListener loggerListener) {
        if (null == loggerListener) {
            throw new NullPointerException("loggerListener");
        }
        if (null == this.m_loggerListener || this.m_loggerListener == loggerListener) {
            // empty if block
        }
        this.m_loggerListener = null;
    }

    public Logger getLoggerFor(String string) {
        return this.getRootLogger().getChildLogger(string);
    }

    private synchronized void notifyLoggerCreated(String string, Logger logger2) {
        if (null != this.m_loggerListener) {
            this.m_loggerListener.loggerCreated(string, logger2);
        }
    }

    public final Logger getRootLogger() {
        return this.m_rootLogger;
    }

    private class InnerErrorHandler
    implements ErrorHandler {
        private InnerErrorHandler() {
        }

        public void error(String string, Throwable throwable, LogEvent logEvent) {
            Hierarchy.this.m_errorHandler.error(string, throwable, logEvent);
        }
    }

    private class InnerLoggerListener
    extends LoggerListener {
        private InnerLoggerListener() {
        }

        public void loggerCreated(String string, Logger logger2) {
            Hierarchy.this.notifyLoggerCreated(string, logger2);
        }
    }
}

