/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.io.Serializable;

public final class Priority
implements Serializable {
    public static final Priority DEBUG = new Priority("DEBUG", 5);
    public static final Priority INFO = new Priority("INFO", 10);
    public static final Priority WARN = new Priority("WARN", 15);
    public static final Priority ERROR = new Priority("ERROR", 20);
    public static final Priority FATAL_ERROR = new Priority("FATAL_ERROR", 25);
    public static final Priority NONE = new Priority("NONE", Integer.MAX_VALUE);
    private final String m_name;
    private final int m_priority;

    public static Priority getPriorityForName(String string) {
        if (DEBUG.getName().equals(string)) {
            return DEBUG;
        }
        if (INFO.getName().equals(string)) {
            return INFO;
        }
        if (WARN.getName().equals(string)) {
            return WARN;
        }
        if (ERROR.getName().equals(string)) {
            return ERROR;
        }
        if (FATAL_ERROR.getName().equals(string)) {
            return FATAL_ERROR;
        }
        if (NONE.getName().equals(string)) {
            return NONE;
        }
        return DEBUG;
    }

    private Priority(String string, int n) {
        if (null == string) {
            throw new NullPointerException("name");
        }
        this.m_name = string;
        this.m_priority = n;
    }

    public String toString() {
        return "Priority[" + this.getName() + "/" + this.getValue() + "]";
    }

    public int getValue() {
        return this.m_priority;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isGreater(Priority priority) {
        return this.m_priority > priority.getValue();
    }

    public boolean isLower(Priority priority) {
        return this.m_priority < priority.getValue();
    }

    public boolean isLowerOrEqual(Priority priority) {
        return this.m_priority <= priority.getValue();
    }

    private Object readResolve() {
        return Priority.getPriorityForName(this.m_name);
    }
}

