/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.Logger;
import org.apache.log.format.PatternFormatter;
import org.apache.log.util.StackIntrospector;

public class ExtendedPatternFormatter
extends PatternFormatter {
    private static final int TYPE_METHOD = 9;
    private static final int TYPE_THREAD = 10;
    private static final String TYPE_METHOD_STR = "method";
    private static final String TYPE_THREAD_STR = "thread";
    private int m_callStackOffset = 0;

    public ExtendedPatternFormatter(String string) {
        this(string, 0);
    }

    public ExtendedPatternFormatter(String string, int n) {
        super(string);
        this.m_callStackOffset = n;
    }

    protected int getTypeIdFor(String string) {
        if (string.equalsIgnoreCase(TYPE_METHOD_STR)) {
            return 9;
        }
        if (string.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 10;
        }
        return super.getTypeIdFor(string);
    }

    protected String formatPatternRun(LogEvent logEvent, PatternFormatter.PatternRun patternRun) {
        switch (patternRun.m_type) {
            case 9: {
                return this.getMethod(logEvent);
            }
            case 10: {
                return this.getThread(logEvent);
            }
        }
        return super.formatPatternRun(logEvent, patternRun);
    }

    private String getMethod(LogEvent logEvent) {
        Object object;
        ContextMap contextMap = logEvent.getContextMap();
        if (null != contextMap && null != (object = contextMap.get(TYPE_METHOD_STR))) {
            return object.toString();
        }
        object = StackIntrospector.getCallerClass(Logger.class, this.m_callStackOffset - 1);
        if (null == object) {
            return "UnknownMethod";
        }
        String string = StackIntrospector.getCallerMethod((Class)object);
        if (null == string) {
            return "UnknownMethod";
        }
        return string;
    }

    private String getThread(LogEvent logEvent) {
        Object object;
        ContextMap contextMap = logEvent.getContextMap();
        if (null != contextMap && null != (object = contextMap.get(TYPE_THREAD_STR))) {
            return object.toString();
        }
        return Thread.currentThread().getName();
    }
}

