/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.StreamTarget;

public class FileTarget
extends StreamTarget {
    private File m_file;
    private boolean m_append;

    public FileTarget(File file, boolean bl, Formatter formatter) throws IOException {
        super(null, formatter);
        if (null != file) {
            this.setFile(file, bl);
            this.openFile();
        }
    }

    protected synchronized void setFile(File file, boolean bl) throws IOException {
        if (null == file) {
            throw new NullPointerException("file property must not be null");
        }
        if (this.isOpen()) {
            throw new IOException("target must be closed before file property can be set");
        }
        this.m_append = bl;
        this.m_file = file;
    }

    protected synchronized void openFile() throws IOException {
        File file;
        File file2;
        if (this.isOpen()) {
            this.close();
        }
        if (null != (file2 = (file = this.getFile().getCanonicalFile()).getParentFile()) && !file2.exists()) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file.getPath(), this.m_append);
        this.setOutputStream(fileOutputStream);
        this.open();
    }

    protected synchronized File getFile() {
        return this.m_file;
    }
}

