/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class StreamTarget
extends AbstractOutputTarget {
    private OutputStream m_outputStream;
    private String m_encoding;

    public StreamTarget(OutputStream outputStream, Formatter formatter, String string) {
        super(formatter);
        this.m_encoding = string;
        if (null != outputStream) {
            this.setOutputStream(outputStream);
            this.open();
        }
    }

    public StreamTarget(OutputStream outputStream, Formatter formatter) {
        this(outputStream, formatter, null);
    }

    protected synchronized void setOutputStream(OutputStream outputStream) {
        if (null == outputStream) {
            throw new NullPointerException("outputStream property must not be null");
        }
        this.m_outputStream = outputStream;
    }

    protected synchronized void write(String string) {
        OutputStream outputStream = this.m_outputStream;
        if (null == outputStream) {
            String string2 = "Attempted to write data '" + string + "' to Null OutputStream";
            this.getErrorHandler().error(string2, null, null);
            return;
        }
        try {
            byte[] byArray = this.m_encoding == null ? string.getBytes() : string.getBytes(this.m_encoding);
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            String string3 = "Error writing data '" + string + "' to OutputStream";
            this.getErrorHandler().error(string3, iOException, null);
        }
    }

    public synchronized void close() {
        super.close();
        this.shutdownStream();
    }

    protected synchronized void shutdownStream() {
        OutputStream outputStream = this.m_outputStream;
        this.m_outputStream = null;
        try {
            if (null != outputStream && (System.out != outputStream || System.err != outputStream)) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            this.getErrorHandler().error("Error closing OutputStream", iOException, null);
        }
    }
}

