/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io.rotate;

import java.io.File;
import org.apache.log.output.io.rotate.RotateStrategy;

public class RotateStrategyByTime
implements RotateStrategy {
    private long m_timeInterval;
    private long m_startingTime = System.currentTimeMillis();
    private long m_currentRotation = 0L;

    public RotateStrategyByTime() {
        this(86400000L);
    }

    public RotateStrategyByTime(long l) {
        this.m_timeInterval = l;
    }

    public void reset() {
        this.m_startingTime = System.currentTimeMillis();
        this.m_currentRotation = 0L;
    }

    public boolean isRotationNeeded(String string, File file) {
        long l = (System.currentTimeMillis() - this.m_startingTime) / this.m_timeInterval;
        if (l > this.m_currentRotation) {
            this.m_currentRotation = l;
            return true;
        }
        return false;
    }
}

