/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io.rotate;

import java.io.File;
import java.util.GregorianCalendar;
import org.apache.log.output.io.rotate.RotateStrategy;

public class RotateStrategyByTimeOfDay
implements RotateStrategy {
    private static final long TIME_24_HOURS = 86400000L;
    private long m_currentRotation;

    public RotateStrategyByTimeOfDay() {
        this(0L);
    }

    public RotateStrategyByTimeOfDay(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(14, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(11, 0);
        this.m_currentRotation = gregorianCalendar.getTime().getTime() + l;
        if (this.m_currentRotation > System.currentTimeMillis()) {
            this.m_currentRotation -= 86400000L;
        }
    }

    public void reset() {
        long l = System.currentTimeMillis();
        while (this.m_currentRotation + 86400000L < l) {
            this.m_currentRotation += 86400000L;
        }
    }

    public boolean isRotationNeeded(String string, File file) {
        long l = System.currentTimeMillis();
        return this.m_currentRotation + 86400000L < l;
    }
}

