/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.config.PropertyGetter;

public class PropertyPrinter
implements PropertyGetter.PropertyCallback {
    protected int numAppenders = 0;
    protected Hashtable appenderNames = new Hashtable();
    protected Hashtable layoutNames = new Hashtable();
    protected PrintWriter out;
    protected boolean doCapitalize;

    public PropertyPrinter(PrintWriter out) {
        this(out, false);
    }

    public PropertyPrinter(PrintWriter out, boolean doCapitalize) {
        this.out = out;
        this.doCapitalize = doCapitalize;
        this.print(out);
        out.flush();
    }

    protected String genAppName() {
        return "A" + this.numAppenders++;
    }

    protected boolean isGenAppName(String name) {
        if (name.length() < 2 || name.charAt(0) != 'A') {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) < '0' || name.charAt(i) > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void print(PrintWriter out) {
        this.printOptions(out, Category.getRoot());
        Enumeration cats = Category.getCurrentCategories();
        while (cats.hasMoreElements()) {
            this.printOptions(out, (Category)cats.nextElement());
        }
    }

    protected void printOptions(PrintWriter out, Category cat) {
        String catKey;
        Enumeration appenders = cat.getAllAppenders();
        Level prio = cat.getLevel();
        String appenderString = prio == null ? "" : prio.toString();
        while (appenders.hasMoreElements()) {
            Appender app2 = (Appender)appenders.nextElement();
            String name = (String)this.appenderNames.get(app2);
            if (name == null) {
                name = app2.getName();
                if (name == null || this.isGenAppName(name)) {
                    name = this.genAppName();
                }
                this.appenderNames.put(app2, name);
                this.printOptions(out, app2, "log4j.appender." + name);
                if (app2.getLayout() != null) {
                    this.printOptions(out, app2.getLayout(), "log4j.appender." + name + ".layout");
                }
            }
            appenderString = appenderString + ", " + name;
        }
        String string = catKey = cat == Category.getRoot() ? "log4j.rootCategory" : "log4j.category." + cat.getName();
        if (appenderString != "") {
            out.println(catKey + "=" + appenderString);
        }
    }

    protected void printOptions(PrintWriter out, Object obj, String fullname) {
        out.println(fullname + "=" + obj.getClass().getName());
        PropertyGetter.getProperties(obj, this, fullname + ".");
    }

    public void foundProperty(Object obj, String prefix, String name, Object value) {
        if (obj instanceof Appender && "name".equals(name)) {
            return;
        }
        if (this.doCapitalize) {
            name = PropertyPrinter.capitalize(name);
        }
        this.out.println(prefix + name + "=" + value.toString());
    }

    public static String capitalize(String name) {
        if (Character.isLowerCase(name.charAt(0)) && (name.length() == 1 || Character.isLowerCase(name.charAt(1)))) {
            StringBuffer newname = new StringBuffer(name);
            newname.setCharAt(0, Character.toUpperCase(name.charAt(0)));
            return newname.toString();
        }
        return name;
    }

    public static void main(String[] args) {
        new PropertyPrinter(new PrintWriter(System.out));
    }
}

