/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.apache.xml.serializer.TreeWalker;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLReaderManager;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class TransformerIdentityImpl
extends Transformer
implements TransformerHandler,
DeclHandler {
    boolean m_flushedStartDoc = false;
    private FileOutputStream m_outputStream = null;
    private ContentHandler m_resultContentHandler;
    private LexicalHandler m_resultLexicalHandler;
    private DTDHandler m_resultDTDHandler;
    private DeclHandler m_resultDeclHandler;
    private Serializer m_serializer;
    private Result m_result;
    private String m_systemID;
    private Hashtable m_params;
    private ErrorListener m_errorListener = new DefaultErrorHandler(false);
    URIResolver m_URIResolver;
    private OutputProperties m_outputFormat = new OutputProperties("xml");
    boolean m_foundFirstElement;
    private boolean m_isSecureProcessing = false;

    public TransformerIdentityImpl(boolean bl) {
        this.m_isSecureProcessing = bl;
    }

    public TransformerIdentityImpl() {
        this(false);
    }

    public void setResult(Result result) throws IllegalArgumentException {
        if (null == result) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_RESULT_NULL", null));
        }
        this.m_result = result;
    }

    public void setSystemId(String string) {
        this.m_systemID = string;
    }

    public String getSystemId() {
        return this.m_systemID;
    }

    public Transformer getTransformer() {
        return this;
    }

    public void reset() {
        this.m_flushedStartDoc = false;
        this.m_foundFirstElement = false;
        this.m_outputStream = null;
        this.m_params.clear();
        this.m_result = null;
        this.m_resultContentHandler = null;
        this.m_resultDeclHandler = null;
        this.m_resultDTDHandler = null;
        this.m_resultLexicalHandler = null;
        this.m_serializer = null;
        this.m_systemID = null;
        this.m_URIResolver = null;
        this.m_outputFormat = new OutputProperties("xml");
    }

    private void createResultContentHandler(Result result) throws TransformerException {
        if (result instanceof SAXResult) {
            SAXResult sAXResult = (SAXResult)result;
            this.m_resultContentHandler = sAXResult.getHandler();
            this.m_resultLexicalHandler = sAXResult.getLexicalHandler();
            if (this.m_resultContentHandler instanceof Serializer) {
                this.m_serializer = (Serializer)((Object)this.m_resultContentHandler);
            }
        } else if (result instanceof DOMResult) {
            Object object;
            Document document;
            short s;
            DOMResult dOMResult = (DOMResult)result;
            Node node = dOMResult.getNode();
            Node node2 = dOMResult.getNextSibling();
            if (null != node) {
                s = node.getNodeType();
                document = 9 == s ? (Document)node : node.getOwnerDocument();
            } else {
                try {
                    object = DocumentBuilderFactory.newInstance();
                    ((DocumentBuilderFactory)object).setNamespaceAware(true);
                    if (this.m_isSecureProcessing) {
                        try {
                            ((DocumentBuilderFactory)object).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            // empty catch block
                        }
                    }
                    DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                    document = documentBuilder.newDocument();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new TransformerException(parserConfigurationException);
                }
                node = document;
                s = node.getNodeType();
                ((DOMResult)result).setNode(node);
            }
            Object object2 = object = 11 == s ? new DOMBuilder(document, (DocumentFragment)node) : new DOMBuilder(document, node);
            if (node2 != null) {
                ((DOMBuilder)object).setNextSibling(node2);
            }
            this.m_resultContentHandler = object;
            this.m_resultLexicalHandler = object;
        } else if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            String string = this.m_outputFormat.getProperty("method");
            try {
                Serializer serializer;
                this.m_serializer = serializer = SerializerFactory.getSerializer(this.m_outputFormat.getProperties());
                if (null != streamResult.getWriter()) {
                    serializer.setWriter(streamResult.getWriter());
                } else if (null != streamResult.getOutputStream()) {
                    serializer.setOutputStream(streamResult.getOutputStream());
                } else if (null != streamResult.getSystemId()) {
                    String string2 = streamResult.getSystemId();
                    if (string2.startsWith("file:///")) {
                        string2 = string2.substring(8).indexOf(":") > 0 ? string2.substring(8) : string2.substring(7);
                    } else if (string2.startsWith("file:/")) {
                        string2 = string2.substring(6).indexOf(":") > 0 ? string2.substring(6) : string2.substring(5);
                    }
                    this.m_outputStream = new FileOutputStream(string2);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException(XSLMessages.createMessage("ER_NO_OUTPUT_SPECIFIED", null));
                }
                this.m_resultContentHandler = serializer.asContentHandler();
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        } else {
            throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_TRANSFORM_TO_RESULT_TYPE", new Object[]{result.getClass().getName()}));
        }
        if (this.m_resultContentHandler instanceof DTDHandler) {
            this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof DeclHandler) {
            this.m_resultDeclHandler = (DeclHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof LexicalHandler) {
            this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Source source, Result result) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        this.createResultContentHandler(result);
        if (source instanceof StreamSource && source.getSystemId() == null && ((StreamSource)source).getInputStream() == null && ((StreamSource)source).getReader() == null || source instanceof SAXSource && ((SAXSource)source).getInputSource() == null && ((SAXSource)source).getXMLReader() == null || source instanceof DOMSource && ((DOMSource)source).getNode() == null) {
            try {
                object3 = DocumentBuilderFactory.newInstance();
                object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
                object = source.getSystemId();
                source = new DOMSource(((DocumentBuilder)object2).newDocument());
                if (object != null) {
                    source.setSystemId((String)object);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new TransformerException(parserConfigurationException.getMessage());
            }
        }
        try {
            if (source instanceof DOMSource) {
                object3 = (DOMSource)source;
                this.m_systemID = ((DOMSource)object3).getSystemId();
                object2 = ((DOMSource)object3).getNode();
                if (null != object2) {
                    try {
                        if (object2.getNodeType() == 2) {
                            this.startDocument();
                        }
                        try {
                            if (object2.getNodeType() == 2) {
                                object = object2.getNodeValue();
                                char[] cArray = ((String)object).toCharArray();
                                this.characters(cArray, 0, cArray.length);
                            } else {
                                object = new TreeWalker(this, this.m_systemID);
                                ((TreeWalker)object).traverse((Node)object2);
                            }
                        }
                        finally {
                            if (object2.getNodeType() == 2) {
                                this.endDocument();
                            }
                        }
                    }
                    catch (SAXException sAXException) {
                        throw new TransformerException(sAXException);
                    }
                    return;
                }
                object = XSLMessages.createMessage("ER_ILLEGAL_DOMSOURCE_INPUT", null);
                throw new IllegalArgumentException((String)object);
            }
            object3 = SAXSource.sourceToInputSource(source);
            if (null == object3) {
                throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_TRANSFORM_SOURCE_TYPE", new Object[]{source.getClass().getName()}));
            }
            if (null != ((InputSource)object3).getSystemId()) {
                this.m_systemID = ((InputSource)object3).getSystemId();
            }
            object2 = null;
            boolean bl = false;
            try {
                if (source instanceof SAXSource) {
                    object2 = ((SAXSource)source).getXMLReader();
                }
                if (null == object2) {
                    try {
                        object2 = XMLReaderManager.getInstance().getXMLReader();
                        bl = true;
                    }
                    catch (SAXException sAXException) {
                        throw new TransformerException(sAXException);
                    }
                }
                try {
                    object2.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                TransformerIdentityImpl transformerIdentityImpl = this;
                object2.setContentHandler(transformerIdentityImpl);
                if (transformerIdentityImpl instanceof DTDHandler) {
                    object2.setDTDHandler(transformerIdentityImpl);
                }
                try {
                    if (transformerIdentityImpl instanceof LexicalHandler) {
                        object2.setProperty("http://xml.org/sax/properties/lexical-handler", transformerIdentityImpl);
                    }
                    if (transformerIdentityImpl instanceof DeclHandler) {
                        object2.setProperty("http://xml.org/sax/properties/declaration-handler", transformerIdentityImpl);
                    }
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                try {
                    if (transformerIdentityImpl instanceof LexicalHandler) {
                        object2.setProperty("http://xml.org/sax/handlers/LexicalHandler", transformerIdentityImpl);
                    }
                    if (transformerIdentityImpl instanceof DeclHandler) {
                        object2.setProperty("http://xml.org/sax/handlers/DeclHandler", transformerIdentityImpl);
                    }
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
                object2.parse((InputSource)object3);
            }
            catch (WrappedRuntimeException wrappedRuntimeException) {
                Exception exception = wrappedRuntimeException.getException();
                while (exception instanceof WrappedRuntimeException) {
                    exception = ((WrappedRuntimeException)exception).getException();
                }
                throw new TransformerException(wrappedRuntimeException.getException());
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
            finally {
                if (bl) {
                    XMLReaderManager.getInstance().releaseXMLReader((XMLReader)object2);
                }
            }
        }
        finally {
            if (null != this.m_outputStream) {
                try {
                    this.m_outputStream.close();
                }
                catch (IOException iOException) {}
                this.m_outputStream = null;
            }
        }
    }

    public void setParameter(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_INVALID_SET_PARAM_VALUE", new Object[]{string}));
        }
        if (null == this.m_params) {
            this.m_params = new Hashtable();
        }
        this.m_params.put(string, object);
    }

    public Object getParameter(String string) {
        if (null == this.m_params) {
            return null;
        }
        return this.m_params.get(string);
    }

    public void clearParameters() {
        if (null == this.m_params) {
            return;
        }
        this.m_params.clear();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_URIResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.m_URIResolver;
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (null != properties) {
            String string = (String)properties.get("method");
            this.m_outputFormat = null != string ? new OutputProperties(string) : new OutputProperties();
            this.m_outputFormat.copyFrom(properties);
        } else {
            this.m_outputFormat = null;
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.m_outputFormat.getProperties().clone();
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        if (!OutputProperties.isLegalPropertyKey(string)) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{string}));
        }
        this.m_outputFormat.setProperty(string, string2);
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        String string2 = null;
        OutputProperties outputProperties = this.m_outputFormat;
        string2 = outputProperties.getProperty(string);
        if (null == string2) {
            if (!OutputProperties.isLegalPropertyKey(string)) {
                throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{string}));
            }
        }
        return string2;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NULL_ERROR_HANDLER", null));
        }
        this.m_errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (null != this.m_resultDTDHandler) {
            this.m_resultDTDHandler.notationDecl(string, string2, string3);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (null != this.m_resultDTDHandler) {
            this.m_resultDTDHandler.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    public void setDocumentLocator(Locator locator) {
        try {
            if (null == this.m_resultContentHandler) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
        this.m_resultContentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        try {
            if (null == this.m_resultContentHandler) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException.getMessage(), transformerException);
        }
        this.m_flushedStartDoc = false;
        this.m_foundFirstElement = false;
    }

    protected final void flushStartDoc() throws SAXException {
        if (!this.m_flushedStartDoc) {
            if (this.m_resultContentHandler == null) {
                try {
                    this.createResultContentHandler(this.m_result);
                }
                catch (TransformerException transformerException) {
                    throw new SAXException(transformerException);
                }
            }
            this.m_resultContentHandler.startDocument();
            this.m_flushedStartDoc = true;
        }
    }

    public void endDocument() throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endDocument();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endPrefixMapping(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.m_foundFirstElement && null != this.m_serializer) {
            Serializer serializer;
            this.m_foundFirstElement = true;
            try {
                serializer = SerializerSwitcher.switchSerializerIfHTML(string, string2, this.m_outputFormat.getProperties(), this.m_serializer);
            }
            catch (TransformerException transformerException) {
                throw new SAXException(transformerException);
            }
            if (serializer != this.m_serializer) {
                try {
                    this.m_resultContentHandler = serializer.asContentHandler();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
                if (this.m_resultContentHandler instanceof DTDHandler) {
                    this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
                }
                if (this.m_resultContentHandler instanceof LexicalHandler) {
                    this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
                }
                this.m_serializer = serializer;
            }
        }
        this.flushStartDoc();
        this.m_resultContentHandler.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.m_resultContentHandler.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.m_resultContentHandler.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.processingInstruction(string, string2);
    }

    public void skippedEntity(String string) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.skippedEntity(string);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.flushStartDoc();
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.startDTD(string, string2, string3);
        }
    }

    public void endDTD() throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.endDTD();
        }
    }

    public void startEntity(String string) throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.startEntity(string);
        }
    }

    public void endEntity(String string) throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.endEntity(string);
        }
    }

    public void startCDATA() throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.endCDATA();
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushStartDoc();
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.comment(cArray, n, n2);
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.elementDecl(string, string2);
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.attributeDecl(string, string2, string3, string4, string5);
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.internalEntityDecl(string, string2);
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.externalEntityDecl(string, string2, string3);
        }
    }
}

