/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.util.InstructionFinder;
import org.apache.xalan.xsltc.compiler.AttributeSet;
import org.apache.xalan.xsltc.compiler.Constants;
import org.apache.xalan.xsltc.compiler.DecimalFormatting;
import org.apache.xalan.xsltc.compiler.Include;
import org.apache.xalan.xsltc.compiler.Key;
import org.apache.xalan.xsltc.compiler.Mode;
import org.apache.xalan.xsltc.compiler.NamespaceAlias;
import org.apache.xalan.xsltc.compiler.Output;
import org.apache.xalan.xsltc.compiler.Param;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SourceLoader;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.TopLevelElement;
import org.apache.xalan.xsltc.compiler.Variable;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.Whitespace;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;
import org.apache.xml.utils.SystemIDResolver;

public final class Stylesheet
extends SyntaxTreeNode {
    private String _version;
    private QName _name;
    private String _systemId;
    private Stylesheet _parentStylesheet;
    private Vector _globals = new Vector();
    private Boolean _hasLocalParams = null;
    private String _className;
    private final Vector _templates = new Vector();
    private Vector _allValidTemplates = null;
    private int _nextModeSerial = 1;
    private final Hashtable _modes = new Hashtable();
    private Mode _defaultMode;
    private final Hashtable _extensions = new Hashtable();
    public Stylesheet _importedFrom = null;
    public Stylesheet _includedFrom = null;
    private Vector _includedStylesheets = null;
    private int _importPrecedence = 1;
    private int _minimumDescendantPrecedence = -1;
    private Hashtable _keys = new Hashtable();
    private SourceLoader _loader = null;
    private boolean _numberFormattingUsed = false;
    private boolean _simplified = false;
    private boolean _multiDocument = false;
    private boolean _callsNodeset = false;
    private boolean _hasIdCall = false;
    private boolean _templateInlining = true;
    private Output _lastOutputElement = null;
    private Properties _outputProperties = null;
    private int _outputMethod = 0;
    public static final int UNKNOWN_OUTPUT = 0;
    public static final int XML_OUTPUT = 1;
    public static final int HTML_OUTPUT = 2;
    public static final int TEXT_OUTPUT = 3;

    public int getOutputMethod() {
        return this._outputMethod;
    }

    private void checkOutputMethod() {
        String string;
        if (this._lastOutputElement != null && (string = this._lastOutputElement.getOutputMethod()) != null) {
            if (string.equals("xml")) {
                this._outputMethod = 1;
            } else if (string.equals("html")) {
                this._outputMethod = 2;
            } else if (string.equals("text")) {
                this._outputMethod = 3;
            }
        }
    }

    public boolean getTemplateInlining() {
        return this._templateInlining;
    }

    public void setTemplateInlining(boolean bl) {
        this._templateInlining = bl;
    }

    public boolean isSimplified() {
        return this._simplified;
    }

    public void setSimplified() {
        this._simplified = true;
    }

    public void setHasIdCall(boolean bl) {
        this._hasIdCall = bl;
    }

    public void setOutputProperty(String string, String string2) {
        if (this._outputProperties == null) {
            this._outputProperties = new Properties();
        }
        this._outputProperties.setProperty(string, string2);
    }

    public void setOutputProperties(Properties properties) {
        this._outputProperties = properties;
    }

    public Properties getOutputProperties() {
        return this._outputProperties;
    }

    public Output getLastOutputElement() {
        return this._lastOutputElement;
    }

    public void setMultiDocument(boolean bl) {
        this._multiDocument = bl;
    }

    public boolean isMultiDocument() {
        return this._multiDocument;
    }

    public void setCallsNodeset(boolean bl) {
        if (bl) {
            this.setMultiDocument(bl);
        }
        this._callsNodeset = bl;
    }

    public boolean callsNodeset() {
        return this._callsNodeset;
    }

    public void numberFormattingUsed() {
        this._numberFormattingUsed = true;
        Stylesheet stylesheet = this.getParentStylesheet();
        if (null != stylesheet) {
            stylesheet.numberFormattingUsed();
        }
    }

    public void setImportPrecedence(int n) {
        Constants constants;
        this._importPrecedence = n;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Stylesheet stylesheet;
            constants = (SyntaxTreeNode)enumeration.nextElement();
            if (!(constants instanceof Include) || (stylesheet = ((Include)constants).getIncludedStylesheet()) == null || stylesheet._includedFrom != this) continue;
            stylesheet.setImportPrecedence(n);
        }
        if (this._importedFrom != null) {
            if (this._importedFrom.getImportPrecedence() < n) {
                constants = this.getParser();
                int n2 = ((Parser)constants).getNextImportPrecedence();
                this._importedFrom.setImportPrecedence(n2);
            }
        } else if (this._includedFrom != null && this._includedFrom.getImportPrecedence() != n) {
            this._includedFrom.setImportPrecedence(n);
        }
    }

    public int getImportPrecedence() {
        return this._importPrecedence;
    }

    public int getMinimumDescendantPrecedence() {
        if (this._minimumDescendantPrecedence == -1) {
            int n = this.getImportPrecedence();
            int n2 = this._includedStylesheets != null ? this._includedStylesheets.size() : 0;
            for (int i = 0; i < n2; ++i) {
                int n3 = ((Stylesheet)this._includedStylesheets.elementAt(i)).getMinimumDescendantPrecedence();
                if (n3 >= n) continue;
                n = n3;
            }
            this._minimumDescendantPrecedence = n;
        }
        return this._minimumDescendantPrecedence;
    }

    public boolean checkForLoop(String string) {
        if (this._systemId != null && this._systemId.equals(string)) {
            return true;
        }
        if (this._parentStylesheet != null) {
            return this._parentStylesheet.checkForLoop(string);
        }
        return false;
    }

    public void setParser(Parser parser2) {
        super.setParser(parser2);
        this._name = this.makeStylesheetName("__stylesheet_");
    }

    public void setParentStylesheet(Stylesheet stylesheet) {
        this._parentStylesheet = stylesheet;
    }

    public Stylesheet getParentStylesheet() {
        return this._parentStylesheet;
    }

    public void setImportingStylesheet(Stylesheet stylesheet) {
        this._importedFrom = stylesheet;
        stylesheet.addIncludedStylesheet(this);
    }

    public void setIncludingStylesheet(Stylesheet stylesheet) {
        this._includedFrom = stylesheet;
        stylesheet.addIncludedStylesheet(this);
    }

    public void addIncludedStylesheet(Stylesheet stylesheet) {
        if (this._includedStylesheets == null) {
            this._includedStylesheets = new Vector();
        }
        this._includedStylesheets.addElement(stylesheet);
    }

    public void setSystemId(String string) {
        if (string != null) {
            this._systemId = SystemIDResolver.getAbsoluteURI(string);
        }
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSourceLoader(SourceLoader sourceLoader) {
        this._loader = sourceLoader;
    }

    public SourceLoader getSourceLoader() {
        return this._loader;
    }

    private QName makeStylesheetName(String string) {
        return this.getParser().getQName(string + this.getXSLTC().nextStylesheetSerial());
    }

    public boolean hasGlobals() {
        return this._globals.size() > 0;
    }

    public boolean hasLocalParams() {
        if (this._hasLocalParams == null) {
            Vector vector = this.getAllValidTemplates();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Template template = (Template)vector.elementAt(i);
                if (!template.hasParams()) continue;
                this._hasLocalParams = new Boolean(true);
                return true;
            }
            this._hasLocalParams = new Boolean(false);
            return false;
        }
        return this._hasLocalParams;
    }

    protected void addPrefixMapping(String string, String string2) {
        if (string.equals("") && string2.equals("http://www.w3.org/1999/xhtml")) {
            return;
        }
        super.addPrefixMapping(string, string2);
    }

    private void extensionURI(String string, SymbolTable symbolTable) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = this.lookupNamespace(string2);
                if (string3 == null) continue;
                this._extensions.put(string3, string2);
            }
        }
    }

    public boolean isExtension(String string) {
        return this._extensions.get(string) != null;
    }

    public void excludeExtensionPrefixes(Parser parser2) {
        SymbolTable symbolTable = parser2.getSymbolTable();
        String string = this.getAttribute("exclude-result-prefixes");
        String string2 = this.getAttribute("extension-element-prefixes");
        symbolTable.excludeURI("http://www.w3.org/1999/XSL/Transform");
        symbolTable.excludeNamespaces(string);
        symbolTable.excludeNamespaces(string2);
        this.extensionURI(string2, symbolTable);
    }

    public void parseContents(Parser parser2) {
        Object object;
        SymbolTable symbolTable = parser2.getSymbolTable();
        this.addPrefixMapping("xml", "http://www.w3.org/XML/1998/namespace");
        Stylesheet stylesheet = symbolTable.addStylesheet(this._name, this);
        if (stylesheet != null) {
            object = new ErrorMsg("MULTIPLE_STYLESHEET_ERR", this);
            parser2.reportError(3, (ErrorMsg)object);
        }
        if (this._simplified) {
            symbolTable.excludeURI("http://www.w3.org/1999/XSL/Transform");
            object = new Template();
            ((Template)object).parseSimplified(this, parser2);
        } else {
            this.parseOwnChildren(parser2);
        }
    }

    public final void parseOwnChildren(Parser parser2) {
        SyntaxTreeNode syntaxTreeNode;
        int n;
        Vector vector = this.getContents();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            syntaxTreeNode = (SyntaxTreeNode)vector.elementAt(n);
            if (!(syntaxTreeNode instanceof VariableBase) && !(syntaxTreeNode instanceof NamespaceAlias)) continue;
            parser2.getSymbolTable().setCurrentNode(syntaxTreeNode);
            syntaxTreeNode.parseContents(parser2);
        }
        for (n = 0; n < n2; ++n) {
            syntaxTreeNode = (SyntaxTreeNode)vector.elementAt(n);
            if (!(syntaxTreeNode instanceof VariableBase) && !(syntaxTreeNode instanceof NamespaceAlias)) {
                parser2.getSymbolTable().setCurrentNode(syntaxTreeNode);
                syntaxTreeNode.parseContents(parser2);
            }
            if (this._templateInlining || !(syntaxTreeNode instanceof Template)) continue;
            Template template = (Template)syntaxTreeNode;
            String string = "template$dot$" + template.getPosition();
            template.setName(parser2.getQName(string));
        }
    }

    public void processModes() {
        if (this._defaultMode == null) {
            this._defaultMode = new Mode(null, this, "");
        }
        this._defaultMode.processPatterns(this._keys);
        Enumeration enumeration = this._modes.elements();
        while (enumeration.hasMoreElements()) {
            Mode mode = (Mode)enumeration.nextElement();
            mode.processPatterns(this._keys);
        }
    }

    private void compileModes(ClassGenerator classGenerator) {
        this._defaultMode.compileApplyTemplates(classGenerator);
        Enumeration enumeration = this._modes.elements();
        while (enumeration.hasMoreElements()) {
            Mode mode = (Mode)enumeration.nextElement();
            mode.compileApplyTemplates(classGenerator);
        }
    }

    public Mode getMode(QName qName) {
        if (qName == null) {
            if (this._defaultMode == null) {
                this._defaultMode = new Mode(null, this, "");
            }
            return this._defaultMode;
        }
        Mode mode = (Mode)this._modes.get(qName);
        if (mode == null) {
            String string = Integer.toString(this._nextModeSerial++);
            mode = new Mode(qName, this, string);
            this._modes.put(qName, mode);
        }
        return mode;
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        int n = this._globals.size();
        for (int i = 0; i < n; ++i) {
            VariableBase variableBase = (VariableBase)this._globals.elementAt(i);
            variableBase.typeCheck(symbolTable);
        }
        return this.typeCheckContents(symbolTable);
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        this.translate();
    }

    private void addDOMField(ClassGenerator classGenerator) {
        FieldGen fieldGen = new FieldGen(1, Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), "_dom", classGenerator.getConstantPool());
        classGenerator.addField(fieldGen.getField());
    }

    private void addStaticField(ClassGenerator classGenerator, String string, String string2) {
        FieldGen fieldGen = new FieldGen(12, Util.getJCRefType(string), string2, classGenerator.getConstantPool());
        classGenerator.addField(fieldGen.getField());
    }

    public void translate() {
        this._className = this.getXSLTC().getClassName();
        ClassGenerator classGenerator = new ClassGenerator(this._className, "org.apache.xalan.xsltc.runtime.AbstractTranslet", "", 33, null, this);
        this.addDOMField(classGenerator);
        this.compileTransform(classGenerator);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            TopLevelElement topLevelElement;
            Object e = enumeration.nextElement();
            if (e instanceof Template) {
                topLevelElement = (Template)e;
                this.getMode(((Template)topLevelElement).getModeName()).addTemplate((Template)topLevelElement);
                continue;
            }
            if (e instanceof AttributeSet) {
                ((AttributeSet)e).translate(classGenerator, null);
                continue;
            }
            if (!(e instanceof Output) || !((Output)(topLevelElement = (Output)e)).enabled()) continue;
            this._lastOutputElement = topLevelElement;
        }
        this.checkOutputMethod();
        this.processModes();
        this.compileModes(classGenerator);
        this.compileStaticInitializer(classGenerator);
        this.compileConstructor(classGenerator, this._lastOutputElement);
        if (!this.getParser().errorsFound()) {
            this.getXSLTC().dumpClass(classGenerator.getJavaClass());
        }
    }

    private void compileStaticInitializer(ClassGenerator classGenerator) {
        int n;
        String string;
        int n2;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(9, org.apache.bcel.generic.Type.VOID, null, null, "<clinit>", this._className, instructionList, constantPoolGen);
        this.addStaticField(classGenerator, "[Ljava/lang/String;", "_sNamesArray");
        this.addStaticField(classGenerator, "[Ljava/lang/String;", "_sUrisArray");
        this.addStaticField(classGenerator, "[I", "_sTypesArray");
        this.addStaticField(classGenerator, "[Ljava/lang/String;", "_sNamespaceArray");
        int n3 = this.getXSLTC().getCharacterDataCount();
        for (int i = 0; i < n3; ++i) {
            this.addStaticField(classGenerator, "[C", "_scharData" + i);
        }
        Vector vector = this.getXSLTC().getNamesIndex();
        int n4 = vector.size();
        String[] stringArray = new String[n4];
        String[] stringArray2 = new String[n4];
        int[] nArray = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            string = (String)vector.elementAt(n2);
            int n5 = string.lastIndexOf(58);
            if (n5 > -1) {
                stringArray2[n2] = string.substring(0, n5);
            }
            if (string.charAt(++n5) == '@') {
                nArray[n2] = 2;
                ++n5;
            } else if (string.charAt(n5) == '?') {
                nArray[n2] = 13;
                ++n5;
            } else {
                nArray[n2] = 1;
            }
            stringArray[n2] = n5 == 0 ? string : string.substring(n5);
        }
        instructionList.append(new PUSH(constantPoolGen, n4));
        instructionList.append(new ANEWARRAY(constantPoolGen.addClass("java.lang.String")));
        for (n2 = 0; n2 < n4; ++n2) {
            string = stringArray[n2];
            instructionList.append(DUP);
            instructionList.append(new PUSH(constantPoolGen, n2));
            instructionList.append(new PUSH(constantPoolGen, string));
            instructionList.append(AASTORE);
        }
        instructionList.append(new PUTSTATIC(constantPoolGen.addFieldref(this._className, "_sNamesArray", "[Ljava/lang/String;")));
        instructionList.append(new PUSH(constantPoolGen, n4));
        instructionList.append(new ANEWARRAY(constantPoolGen.addClass("java.lang.String")));
        for (n2 = 0; n2 < n4; ++n2) {
            string = stringArray2[n2];
            instructionList.append(DUP);
            instructionList.append(new PUSH(constantPoolGen, n2));
            instructionList.append(new PUSH(constantPoolGen, string));
            instructionList.append(AASTORE);
        }
        instructionList.append(new PUTSTATIC(constantPoolGen.addFieldref(this._className, "_sUrisArray", "[Ljava/lang/String;")));
        instructionList.append(new PUSH(constantPoolGen, n4));
        instructionList.append(new NEWARRAY(BasicType.INT));
        for (n2 = 0; n2 < n4; ++n2) {
            int n6 = nArray[n2];
            instructionList.append(DUP);
            instructionList.append(new PUSH(constantPoolGen, n2));
            instructionList.append(new PUSH(constantPoolGen, n6));
            instructionList.append(IASTORE);
        }
        instructionList.append(new PUTSTATIC(constantPoolGen.addFieldref(this._className, "_sTypesArray", "[I")));
        Vector vector2 = this.getXSLTC().getNamespaceIndex();
        instructionList.append(new PUSH(constantPoolGen, vector2.size()));
        instructionList.append(new ANEWARRAY(constantPoolGen.addClass("java.lang.String")));
        for (n = 0; n < vector2.size(); ++n) {
            String string2 = (String)vector2.elementAt(n);
            instructionList.append(DUP);
            instructionList.append(new PUSH(constantPoolGen, n));
            instructionList.append(new PUSH(constantPoolGen, string2));
            instructionList.append(AASTORE);
        }
        instructionList.append(new PUTSTATIC(constantPoolGen.addFieldref(this._className, "_sNamespaceArray", "[Ljava/lang/String;")));
        n = this.getXSLTC().getCharacterDataCount();
        int n7 = constantPoolGen.addMethodref("java.lang.String", "toCharArray", "()[C");
        for (int i = 0; i < n; ++i) {
            instructionList.append(new PUSH(constantPoolGen, this.getXSLTC().getCharacterData(i)));
            instructionList.append(new INVOKEVIRTUAL(n7));
            instructionList.append(new PUTSTATIC(constantPoolGen.addFieldref(this._className, "_scharData" + i, "[C")));
        }
        instructionList.append(RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        classGenerator.addMethod(methodGenerator.getMethod());
    }

    private void compileConstructor(ClassGenerator classGenerator, Output output) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, null, null, "<init>", this._className, instructionList, constantPoolGen);
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new INVOKESPECIAL(constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "<init>", "()V")));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETSTATIC(constantPoolGen.addFieldref(this._className, "_sNamesArray", "[Ljava/lang/String;")));
        instructionList.append(new PUTFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namesArray", "[Ljava/lang/String;")));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETSTATIC(constantPoolGen.addFieldref(this._className, "_sUrisArray", "[Ljava/lang/String;")));
        instructionList.append(new PUTFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "urisArray", "[Ljava/lang/String;")));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETSTATIC(constantPoolGen.addFieldref(this._className, "_sTypesArray", "[I")));
        instructionList.append(new PUTFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "typesArray", "[I")));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETSTATIC(constantPoolGen.addFieldref(this._className, "_sNamespaceArray", "[Ljava/lang/String;")));
        instructionList.append(new PUTFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namespaceArray", "[Ljava/lang/String;")));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new PUSH(constantPoolGen, 101));
        instructionList.append(new PUTFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "transletVersion", "I")));
        if (this._hasIdCall) {
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(new PUSH(constantPoolGen, Boolean.TRUE));
            instructionList.append(new PUTFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "_hasIdCall", "Z")));
        }
        if (output != null) {
            output.translate(classGenerator, methodGenerator);
        }
        if (this._numberFormattingUsed) {
            DecimalFormatting.translateDefaultDFS(classGenerator, methodGenerator);
        }
        instructionList.append(RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        classGenerator.addMethod(methodGenerator.getMethod());
    }

    private String compileTopLevel(ClassGenerator classGenerator, Enumeration enumeration) {
        VariableBase variableBase;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        org.apache.bcel.generic.Type[] typeArray = new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;")};
        String[] stringArray = new String[]{"document", "iterator", "handler"};
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, typeArray, stringArray, "topLevel", this._className, instructionList, classGenerator.getConstantPool());
        methodGenerator.addException("org.apache.xalan.xsltc.TransletException");
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("current", org.apache.bcel.generic.Type.INT, instructionList.getEnd(), null);
        int n = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "setFilter", "(Lorg/apache/xalan/xsltc/StripFilter;)V");
        instructionList.append(new PUSH(constantPoolGen, 0));
        instructionList.append(new ISTORE(localVariableGen.getIndex()));
        this._globals = this.resolveReferences(this._globals);
        int n2 = this._globals.size();
        for (int i = 0; i < n2; ++i) {
            variableBase = (VariableBase)this._globals.elementAt(i);
            variableBase.translate(classGenerator, methodGenerator);
        }
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            variableBase = enumeration.nextElement();
            if (variableBase instanceof DecimalFormatting) {
                ((DecimalFormatting)((Object)variableBase)).translate(classGenerator, methodGenerator);
                continue;
            }
            if (!(variableBase instanceof Whitespace)) continue;
            vector.addAll(((Whitespace)((Object)variableBase)).getRules());
        }
        if (vector.size() > 0) {
            Whitespace.translateRules(vector, classGenerator);
        }
        if (classGenerator.containsMethod("stripSpace", "(Lorg/apache/xalan/xsltc/DOM;II)Z") != null) {
            instructionList.append(methodGenerator.loadDOM());
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(new INVOKEINTERFACE(n, 2));
        }
        instructionList.append(RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
        return "(Lorg/apache/xalan/xsltc/DOM;Lorg/apache/xml/dtm/DTMAxisIterator;Lorg/apache/xml/serializer/SerializationHandler;)V";
    }

    private Vector resolveReferences(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            VariableBase variableBase = (VariableBase)vector.elementAt(i);
            Vector vector2 = variableBase.getDependencies();
            int n = vector2 != null ? vector2.size() : 0;
            for (int j = 0; j < n; ++j) {
                VariableBase variableBase2 = (VariableBase)vector2.elementAt(j);
                if (vector.contains(variableBase2)) continue;
                vector.addElement(variableBase2);
            }
        }
        Vector<VariableBase> vector3 = new Vector<VariableBase>();
        while (vector.size() > 0) {
            boolean bl = false;
            int n = 0;
            while (n < vector.size()) {
                VariableBase variableBase = (VariableBase)vector.elementAt(n);
                Vector vector4 = variableBase.getDependencies();
                if (vector4 == null || vector3.containsAll(vector4)) {
                    vector3.addElement(variableBase);
                    vector.remove(n);
                    bl = true;
                    continue;
                }
                ++n;
            }
            if (bl) continue;
            ErrorMsg errorMsg = new ErrorMsg("CIRCULAR_VARIABLE_ERR", (Object)vector.toString(), this);
            this.getParser().reportError(3, errorMsg);
            return vector3;
        }
        return vector3;
    }

    private String compileBuildKeys(ClassGenerator classGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        org.apache.bcel.generic.Type[] typeArray = new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;"), org.apache.bcel.generic.Type.INT};
        String[] stringArray = new String[]{"document", "iterator", "handler", "current"};
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, typeArray, stringArray, "buildKeys", this._className, instructionList, classGenerator.getConstantPool());
        methodGenerator.addException("org.apache.xalan.xsltc.TransletException");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Key)) continue;
            Key key = (Key)e;
            key.translate(classGenerator, methodGenerator);
            this._keys.put(key.getName(), key);
        }
        instructionList.append(RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
        return "(Lorg/apache/xalan/xsltc/DOM;Lorg/apache/xml/dtm/DTMAxisIterator;Lorg/apache/xml/serializer/SerializationHandler;I)V";
    }

    private void compileTransform(ClassGenerator classGenerator) {
        int n;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        org.apache.bcel.generic.Type[] typeArray = new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xml/dtm/DTMAxisIterator;"), Util.getJCRefType("Lorg/apache/xml/serializer/SerializationHandler;")};
        String[] stringArray = new String[]{"document", "iterator", "handler"};
        InstructionList instructionList = new InstructionList();
        MethodGenerator methodGenerator = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, typeArray, stringArray, "transform", this._className, instructionList, classGenerator.getConstantPool());
        methodGenerator.addException("org.apache.xalan.xsltc.TransletException");
        LocalVariableGen localVariableGen = methodGenerator.addLocalVariable("current", org.apache.bcel.generic.Type.INT, instructionList.getEnd(), null);
        String string = classGenerator.getApplyTemplatesSig();
        int n2 = constantPoolGen.addMethodref(this.getClassName(), "applyTemplates", string);
        int n3 = constantPoolGen.addFieldref(this.getClassName(), "_dom", "Lorg/apache/xalan/xsltc/DOM;");
        instructionList.append(classGenerator.loadTranslet());
        if (this.isMultiDocument()) {
            instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.MultiDOM")));
            instructionList.append(DUP);
        }
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(methodGenerator.loadDOM());
        instructionList.append(new INVOKEVIRTUAL(constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "makeDOMAdapter", "(Lorg/apache/xalan/xsltc/DOM;)Lorg/apache/xalan/xsltc/dom/DOMAdapter;")));
        if (this.isMultiDocument()) {
            n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.MultiDOM", "<init>", "(Lorg/apache/xalan/xsltc/DOM;)V");
            instructionList.append(new INVOKESPECIAL(n));
        }
        instructionList.append(new PUTFIELD(n3));
        instructionList.append(new PUSH(constantPoolGen, 0));
        instructionList.append(new ISTORE(localVariableGen.getIndex()));
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(methodGenerator.loadHandler());
        n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "transferOutputSettings", "(Lorg/apache/xml/serializer/SerializationHandler;)V");
        instructionList.append(new INVOKEVIRTUAL(n));
        String string2 = this.compileBuildKeys(classGenerator);
        int n4 = constantPoolGen.addMethodref(this.getClassName(), "buildKeys", string2);
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETFIELD(n3));
        instructionList.append(methodGenerator.loadIterator());
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(new PUSH(constantPoolGen, 0));
        instructionList.append(new INVOKEVIRTUAL(n4));
        Enumeration enumeration = this.elements();
        if (this._globals.size() > 0 || enumeration.hasMoreElements()) {
            String string3 = this.compileTopLevel(classGenerator, enumeration);
            int n5 = constantPoolGen.addMethodref(this.getClassName(), "topLevel", string3);
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(classGenerator.loadTranslet());
            instructionList.append(new GETFIELD(n3));
            instructionList.append(methodGenerator.loadIterator());
            instructionList.append(methodGenerator.loadHandler());
            instructionList.append(new INVOKEVIRTUAL(n5));
        }
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(methodGenerator.startDocument());
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(classGenerator.loadTranslet());
        instructionList.append(new GETFIELD(n3));
        instructionList.append(methodGenerator.loadIterator());
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(new INVOKEVIRTUAL(n2));
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(methodGenerator.endDocument());
        instructionList.append(RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
    }

    private void peepHoleOptimization(MethodGenerator methodGenerator) {
        InstructionList instructionList = methodGenerator.getInstructionList();
        InstructionFinder instructionFinder = new InstructionFinder(instructionList);
        Iterator iterator = instructionFinder.search("`aload'`pop'`instruction'");
        while (iterator.hasNext()) {
            InstructionHandle[] instructionHandleArray = (InstructionHandle[])iterator.next();
            try {
                instructionList.delete(instructionHandleArray[0], instructionHandleArray[1]);
            }
            catch (TargetLostException targetLostException) {}
        }
    }

    public int addParam(Param param) {
        this._globals.addElement(param);
        return this._globals.size() - 1;
    }

    public int addVariable(Variable variable) {
        this._globals.addElement(variable);
        return this._globals.size() - 1;
    }

    public void display(int n) {
        this.indent(n);
        Util.println("Stylesheet");
        this.displayContents(n + 4);
    }

    public String getNamespace(String string) {
        return this.lookupNamespace(string);
    }

    public String getClassName() {
        return this._className;
    }

    public Vector getTemplates() {
        return this._templates;
    }

    public Vector getAllValidTemplates() {
        if (this._includedStylesheets == null) {
            return this._templates;
        }
        if (this._allValidTemplates == null) {
            Vector vector = new Vector();
            int n = this._includedStylesheets.size();
            for (int i = 0; i < n; ++i) {
                Stylesheet stylesheet = (Stylesheet)this._includedStylesheets.elementAt(i);
                vector.addAll(stylesheet.getAllValidTemplates());
            }
            vector.addAll(this._templates);
            if (this._parentStylesheet != null) {
                return vector;
            }
            this._allValidTemplates = vector;
        }
        return this._allValidTemplates;
    }

    protected void addTemplate(Template template) {
        this._templates.addElement(template);
    }
}

