/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.AbsolutePathPattern;
import org.apache.xalan.xsltc.compiler.ApplyTemplates;
import org.apache.xalan.xsltc.compiler.CallTemplate;
import org.apache.xalan.xsltc.compiler.Choose;
import org.apache.xalan.xsltc.compiler.Constants;
import org.apache.xalan.xsltc.compiler.If;
import org.apache.xalan.xsltc.compiler.Number;
import org.apache.xalan.xsltc.compiler.Otherwise;
import org.apache.xalan.xsltc.compiler.Param;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.Text;
import org.apache.xalan.xsltc.compiler.ValueOf;
import org.apache.xalan.xsltc.compiler.Variable;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.When;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.runtime.AttributeList;
import org.xml.sax.Attributes;

public abstract class SyntaxTreeNode
implements Constants {
    private Parser _parser;
    protected SyntaxTreeNode _parent;
    private Stylesheet _stylesheet;
    private Template _template;
    private final Vector _contents = new Vector(2);
    protected QName _qname;
    private int _line;
    protected AttributeList _attributes = null;
    private Hashtable _prefixMapping = null;
    static final SyntaxTreeNode Dummy = new AbsolutePathPattern(null);
    protected static final int IndentIncrement = 4;
    private static final char[] _spaces = "                                                       ".toCharArray();

    public SyntaxTreeNode() {
        this._line = 0;
        this._qname = null;
    }

    public SyntaxTreeNode(int n) {
        this._line = n;
        this._qname = null;
    }

    public SyntaxTreeNode(String string, String string2, String string3) {
        this._line = 0;
        this.setQName(string, string2, string3);
    }

    protected final void setLineNumber(int n) {
        this._line = n;
    }

    public final int getLineNumber() {
        if (this._line > 0) {
            return this._line;
        }
        SyntaxTreeNode syntaxTreeNode = this.getParent();
        return syntaxTreeNode != null ? syntaxTreeNode.getLineNumber() : 0;
    }

    protected void setQName(QName qName) {
        this._qname = qName;
    }

    protected void setQName(String string, String string2, String string3) {
        this._qname = new QName(string, string2, string3);
    }

    protected QName getQName() {
        return this._qname;
    }

    protected void setAttributes(AttributeList attributeList) {
        this._attributes = attributeList;
    }

    protected String getAttribute(String string) {
        if (this._attributes == null) {
            return "";
        }
        String string2 = this._attributes.getValue(string);
        return string2 == null || string2.equals("") ? "" : string2;
    }

    protected String getAttribute(String string, String string2) {
        return this.getAttribute(string + ':' + string2);
    }

    protected boolean hasAttribute(String string) {
        return this._attributes != null && this._attributes.getValue(string) != null;
    }

    protected void addAttribute(String string, String string2) {
        this._attributes.add(string, string2);
    }

    protected Attributes getAttributes() {
        return this._attributes;
    }

    protected void setPrefixMapping(Hashtable hashtable) {
        this._prefixMapping = hashtable;
    }

    protected Hashtable getPrefixMapping() {
        return this._prefixMapping;
    }

    protected void addPrefixMapping(String string, String string2) {
        if (this._prefixMapping == null) {
            this._prefixMapping = new Hashtable();
        }
        this._prefixMapping.put(string, string2);
    }

    protected String lookupNamespace(String string) {
        String string2 = null;
        if (this._prefixMapping != null) {
            string2 = (String)this._prefixMapping.get(string);
        }
        if (string2 == null && this._parent != null) {
            string2 = this._parent.lookupNamespace(string);
            if (string == "" && string2 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    protected String lookupPrefix(String string) {
        String string2 = null;
        if (this._prefixMapping != null && this._prefixMapping.contains(string)) {
            Enumeration enumeration = this._prefixMapping.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                String string3 = (String)this._prefixMapping.get(string2);
                if (!string3.equals(string)) continue;
                return string2;
            }
        } else if (this._parent != null) {
            string2 = this._parent.lookupPrefix(string);
            if (string == "" && string2 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    protected void setParser(Parser parser2) {
        this._parser = parser2;
    }

    public final Parser getParser() {
        return this._parser;
    }

    protected void setParent(SyntaxTreeNode syntaxTreeNode) {
        if (this._parent == null) {
            this._parent = syntaxTreeNode;
        }
    }

    protected final SyntaxTreeNode getParent() {
        return this._parent;
    }

    protected final boolean isDummy() {
        return this == Dummy;
    }

    protected int getImportPrecedence() {
        Stylesheet stylesheet = this.getStylesheet();
        if (stylesheet == null) {
            return Integer.MIN_VALUE;
        }
        return stylesheet.getImportPrecedence();
    }

    public Stylesheet getStylesheet() {
        if (this._stylesheet == null) {
            SyntaxTreeNode syntaxTreeNode;
            for (syntaxTreeNode = this; syntaxTreeNode != null; syntaxTreeNode = syntaxTreeNode.getParent()) {
                if (!(syntaxTreeNode instanceof Stylesheet)) continue;
                return (Stylesheet)syntaxTreeNode;
            }
            this._stylesheet = (Stylesheet)syntaxTreeNode;
        }
        return this._stylesheet;
    }

    protected Template getTemplate() {
        if (this._template == null) {
            SyntaxTreeNode syntaxTreeNode;
            for (syntaxTreeNode = this; syntaxTreeNode != null && !(syntaxTreeNode instanceof Template); syntaxTreeNode = syntaxTreeNode.getParent()) {
            }
            this._template = (Template)syntaxTreeNode;
        }
        return this._template;
    }

    protected final XSLTC getXSLTC() {
        return this._parser.getXSLTC();
    }

    protected final SymbolTable getSymbolTable() {
        return this._parser == null ? null : this._parser.getSymbolTable();
    }

    public void parseContents(Parser parser2) {
        this.parseChildren(parser2);
    }

    protected final void parseChildren(Parser parser2) {
        int n;
        Vector<QName> vector = null;
        int n2 = this._contents.size();
        for (n = 0; n < n2; ++n) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)this._contents.elementAt(n);
            parser2.getSymbolTable().setCurrentNode(syntaxTreeNode);
            syntaxTreeNode.parseContents(parser2);
            QName qName = this.updateScope(parser2, syntaxTreeNode);
            if (qName == null) continue;
            if (vector == null) {
                vector = new Vector<QName>(2);
            }
            vector.addElement(qName);
        }
        parser2.getSymbolTable().setCurrentNode(this);
        if (vector != null) {
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                parser2.removeVariable((QName)vector.elementAt(i));
            }
        }
    }

    protected QName updateScope(Parser parser2, SyntaxTreeNode syntaxTreeNode) {
        if (syntaxTreeNode instanceof Variable) {
            Variable variable = (Variable)syntaxTreeNode;
            parser2.addVariable(variable);
            return variable.getName();
        }
        if (syntaxTreeNode instanceof Param) {
            Param param = (Param)syntaxTreeNode;
            parser2.addParameter(param);
            return param.getName();
        }
        return null;
    }

    public abstract Type typeCheck(SymbolTable var1) throws TypeCheckError;

    protected Type typeCheckContents(SymbolTable symbolTable) throws TypeCheckError {
        int n = this.elementCount();
        for (int i = 0; i < n; ++i) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)this._contents.elementAt(i);
            syntaxTreeNode.typeCheck(symbolTable);
        }
        return Type.Void;
    }

    public abstract void translate(ClassGenerator var1, MethodGenerator var2);

    protected void translateContents(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        SyntaxTreeNode syntaxTreeNode;
        int n;
        int n2 = this.elementCount();
        for (n = 0; n < n2; ++n) {
            syntaxTreeNode = (SyntaxTreeNode)this._contents.elementAt(n);
            syntaxTreeNode.translate(classGenerator, methodGenerator);
        }
        for (n = 0; n < n2; ++n) {
            if (!(this._contents.elementAt(n) instanceof VariableBase)) continue;
            syntaxTreeNode = (VariableBase)this._contents.elementAt(n);
            ((VariableBase)syntaxTreeNode).unmapRegister(methodGenerator);
        }
    }

    private boolean isSimpleRTF(SyntaxTreeNode syntaxTreeNode) {
        Vector vector = syntaxTreeNode.getContents();
        for (int i = 0; i < vector.size(); ++i) {
            SyntaxTreeNode syntaxTreeNode2 = (SyntaxTreeNode)vector.elementAt(i);
            if (this.isTextElement(syntaxTreeNode2, false)) continue;
            return false;
        }
        return true;
    }

    private boolean isAdaptiveRTF(SyntaxTreeNode syntaxTreeNode) {
        Vector vector = syntaxTreeNode.getContents();
        for (int i = 0; i < vector.size(); ++i) {
            SyntaxTreeNode syntaxTreeNode2 = (SyntaxTreeNode)vector.elementAt(i);
            if (this.isTextElement(syntaxTreeNode2, true)) continue;
            return false;
        }
        return true;
    }

    private boolean isTextElement(SyntaxTreeNode syntaxTreeNode, boolean bl) {
        if (syntaxTreeNode instanceof ValueOf || syntaxTreeNode instanceof Number || syntaxTreeNode instanceof Text) {
            return true;
        }
        if (syntaxTreeNode instanceof If) {
            return bl ? this.isAdaptiveRTF(syntaxTreeNode) : this.isSimpleRTF(syntaxTreeNode);
        }
        if (syntaxTreeNode instanceof Choose) {
            Vector vector = syntaxTreeNode.getContents();
            for (int i = 0; i < vector.size(); ++i) {
                SyntaxTreeNode syntaxTreeNode2 = (SyntaxTreeNode)vector.elementAt(i);
                if (syntaxTreeNode2 instanceof Text || (syntaxTreeNode2 instanceof When || syntaxTreeNode2 instanceof Otherwise) && (bl && this.isAdaptiveRTF(syntaxTreeNode2) || !bl && this.isSimpleRTF(syntaxTreeNode2))) continue;
                return false;
            }
            return true;
        }
        return bl && (syntaxTreeNode instanceof CallTemplate || syntaxTreeNode instanceof ApplyTemplates);
    }

    protected void compileResultTree(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        Stylesheet stylesheet = classGenerator.getStylesheet();
        boolean bl = this.isSimpleRTF(this);
        boolean bl2 = false;
        if (!bl) {
            bl2 = this.isAdaptiveRTF(this);
        }
        int n = bl ? 0 : (bl2 ? 1 : 2);
        instructionList.append(methodGenerator.loadHandler());
        String string = classGenerator.getDOMClass();
        instructionList.append(methodGenerator.loadDOM());
        int n2 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getResultTreeFrag", "(IIZ)Lorg/apache/xalan/xsltc/DOM;");
        instructionList.append(new PUSH(constantPoolGen, 32));
        instructionList.append(new PUSH(constantPoolGen, n));
        instructionList.append(new PUSH(constantPoolGen, stylesheet.callsNodeset()));
        instructionList.append(new INVOKEINTERFACE(n2, 4));
        instructionList.append(DUP);
        n2 = constantPoolGen.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getOutputDomBuilder", "()Lorg/apache/xml/serializer/SerializationHandler;");
        instructionList.append(new INVOKEINTERFACE(n2, 1));
        instructionList.append(DUP);
        instructionList.append(methodGenerator.storeHandler());
        instructionList.append(methodGenerator.startDocument());
        this.translateContents(classGenerator, methodGenerator);
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(methodGenerator.endDocument());
        if (stylesheet.callsNodeset() && !string.equals("org/apache/xalan/xsltc/DOM")) {
            n2 = constantPoolGen.addMethodref("org/apache/xalan/xsltc/dom/DOMAdapter", "<init>", "(Lorg/apache/xalan/xsltc/DOM;[Ljava/lang/String;[Ljava/lang/String;[I[Ljava/lang/String;)V");
            instructionList.append(new NEW(constantPoolGen.addClass("org/apache/xalan/xsltc/dom/DOMAdapter")));
            instructionList.append(new DUP_X1());
            instructionList.append(SWAP);
            if (!stylesheet.callsNodeset()) {
                instructionList.append(new ICONST(0));
                instructionList.append(new ANEWARRAY(constantPoolGen.addClass("java.lang.String")));
                instructionList.append(DUP);
                instructionList.append(DUP);
                instructionList.append(new ICONST(0));
                instructionList.append(new NEWARRAY(BasicType.INT));
                instructionList.append(SWAP);
                instructionList.append(new INVOKESPECIAL(n2));
            } else {
                instructionList.append(ALOAD_0);
                instructionList.append(new GETFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namesArray", "[Ljava/lang/String;")));
                instructionList.append(ALOAD_0);
                instructionList.append(new GETFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "urisArray", "[Ljava/lang/String;")));
                instructionList.append(ALOAD_0);
                instructionList.append(new GETFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "typesArray", "[I")));
                instructionList.append(ALOAD_0);
                instructionList.append(new GETFIELD(constantPoolGen.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "namespaceArray", "[Ljava/lang/String;")));
                instructionList.append(new INVOKESPECIAL(n2));
                instructionList.append(DUP);
                instructionList.append(methodGenerator.loadDOM());
                instructionList.append(new CHECKCAST(constantPoolGen.addClass(classGenerator.getDOMClass())));
                instructionList.append(SWAP);
                n2 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.MultiDOM", "addDOMAdapter", "(Lorg/apache/xalan/xsltc/dom/DOMAdapter;)I");
                instructionList.append(new INVOKEVIRTUAL(n2));
                instructionList.append(POP);
            }
        }
        instructionList.append(SWAP);
        instructionList.append(methodGenerator.storeHandler());
    }

    protected boolean contextDependent() {
        return true;
    }

    protected boolean dependentContents() {
        int n = this.elementCount();
        for (int i = 0; i < n; ++i) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)this._contents.elementAt(i);
            if (!syntaxTreeNode.contextDependent()) continue;
            return true;
        }
        return false;
    }

    protected final void addElement(SyntaxTreeNode syntaxTreeNode) {
        this._contents.addElement(syntaxTreeNode);
        syntaxTreeNode.setParent(this);
    }

    protected final void setFirstElement(SyntaxTreeNode syntaxTreeNode) {
        this._contents.insertElementAt(syntaxTreeNode, 0);
        syntaxTreeNode.setParent(this);
    }

    protected final void removeElement(SyntaxTreeNode syntaxTreeNode) {
        this._contents.remove(syntaxTreeNode);
        syntaxTreeNode.setParent(null);
    }

    protected final Vector getContents() {
        return this._contents;
    }

    protected final boolean hasContents() {
        return this.elementCount() > 0;
    }

    protected final int elementCount() {
        return this._contents.size();
    }

    protected final Enumeration elements() {
        return this._contents.elements();
    }

    protected final Object elementAt(int n) {
        return this._contents.elementAt(n);
    }

    protected final SyntaxTreeNode lastChild() {
        if (this._contents.size() == 0) {
            return null;
        }
        return (SyntaxTreeNode)this._contents.lastElement();
    }

    public void display(int n) {
        this.displayContents(n);
    }

    protected void displayContents(int n) {
        int n2 = this.elementCount();
        for (int i = 0; i < n2; ++i) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)this._contents.elementAt(i);
            syntaxTreeNode.display(n);
        }
    }

    protected final void indent(int n) {
        System.out.print(new String(_spaces, 0, n));
    }

    protected void reportError(SyntaxTreeNode syntaxTreeNode, Parser parser2, String string, String string2) {
        ErrorMsg errorMsg = new ErrorMsg(string, (Object)string2, syntaxTreeNode);
        parser2.reportError(3, errorMsg);
    }

    protected void reportWarning(SyntaxTreeNode syntaxTreeNode, Parser parser2, String string, String string2) {
        ErrorMsg errorMsg = new ErrorMsg(string, (Object)string2, syntaxTreeNode);
        parser2.reportError(4, errorMsg);
    }
}

