/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class ObjectVector
implements Cloneable {
    protected int m_blocksize;
    protected Object[] m_map;
    protected int m_firstFree = 0;
    protected int m_mapSize;

    public ObjectVector() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new Object[this.m_blocksize];
    }

    public ObjectVector(int n) {
        this.m_blocksize = n;
        this.m_mapSize = n;
        this.m_map = new Object[n];
    }

    public ObjectVector(int n, int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n;
        this.m_map = new Object[n];
    }

    public ObjectVector(ObjectVector objectVector) {
        this.m_map = new Object[objectVector.m_mapSize];
        this.m_mapSize = objectVector.m_mapSize;
        this.m_firstFree = objectVector.m_firstFree;
        this.m_blocksize = objectVector.m_blocksize;
        System.arraycopy(objectVector.m_map, 0, this.m_map, 0, this.m_firstFree);
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void setSize(int n) {
        this.m_firstFree = n;
    }

    public final void addElement(Object object) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Object[] objectArray = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree + 1);
            this.m_map = objectArray;
        }
        this.m_map[this.m_firstFree] = object;
        ++this.m_firstFree;
    }

    public final void addElements(Object object, int n) {
        if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + n;
            Object[] objectArray = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree + 1);
            this.m_map = objectArray;
        }
        for (int i = 0; i < n; ++i) {
            this.m_map[this.m_firstFree] = object;
            ++this.m_firstFree;
        }
    }

    public final void addElements(int n) {
        if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + n;
            Object[] objectArray = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree + 1);
            this.m_map = objectArray;
        }
        this.m_firstFree += n;
    }

    public final void insertElementAt(Object object, int n) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Object[] objectArray = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree + 1);
            this.m_map = objectArray;
        }
        if (n <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n, this.m_map, n + 1, this.m_firstFree - n);
        }
        this.m_map[n] = object;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        for (int i = 0; i < this.m_firstFree; ++i) {
            this.m_map[i] = null;
        }
        this.m_firstFree = 0;
    }

    public final boolean removeElement(Object object) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != object) continue;
            if (i + 1 < this.m_firstFree) {
                System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
            } else {
                this.m_map[i] = null;
            }
            --this.m_firstFree;
            return true;
        }
        return false;
    }

    public final void removeElementAt(int n) {
        if (n > this.m_firstFree) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n, this.m_firstFree);
        } else {
            this.m_map[n] = null;
        }
        --this.m_firstFree;
    }

    public final void setElementAt(Object object, int n) {
        this.m_map[n] = object;
    }

    public final Object elementAt(int n) {
        return this.m_map[n];
    }

    public final boolean contains(Object object) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != object) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(Object object, int n) {
        for (int i = n; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != object) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public final int indexOf(Object object) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != object) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public final int lastIndexOf(Object object) {
        for (int i = this.m_firstFree - 1; i >= 0; --i) {
            if (this.m_map[i] != object) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public final void setToSize(int n) {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree);
        this.m_mapSize = n;
        this.m_map = objectArray;
    }

    public Object clone() throws CloneNotSupportedException {
        return new ObjectVector(this);
    }
}

