/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.jaxp;

import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.QName;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;

public class JAXPVariableStack
extends VariableStack {
    private final XPathVariableResolver resolver;

    public JAXPVariableStack(XPathVariableResolver xPathVariableResolver) {
        this.resolver = xPathVariableResolver;
    }

    public XObject getVariableOrParam(XPathContext xPathContext, QName qName) throws TransformerException, IllegalArgumentException {
        if (qName == null) {
            String string = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"Variable qname"});
            throw new IllegalArgumentException(string);
        }
        javax.xml.namespace.QName qName2 = new javax.xml.namespace.QName(qName.getNamespace(), qName.getLocalPart());
        Object object = this.resolver.resolveVariable(qName2);
        if (object == null) {
            String string = XSLMessages.createXPATHMessage("ER_RESOLVE_VARIABLE_RETURNS_NULL", new Object[]{qName2.toString()});
            throw new TransformerException(string);
        }
        return XObject.create(object, xPathContext);
    }
}

