/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class InformationPanel
extends JPanel {
    public Timer MyTimer;
    private ImageIcon DNAIcon;
    int InfoPosition = 350;
    int MemoryPosition;
    private String Java3DTitle;
    private String Java3DVendor;
    private String Java3DVersion;

    public InformationPanel() {
        this.setBackground(new Color(0, 71, 153));
        this.MyTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InformationPanel.this.repaint(40, InformationPanel.this.MemoryPosition, 500, 100);
            }
        });
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            classLoader.loadClass("com.sun.j3d.utils.universe.SimpleUniverse");
            Package package_ = Package.getPackage("javax.media.j3d");
            if (package_ == null) {
                this.Java3DTitle = "not installed";
                this.Java3DVendor = "not available";
                this.Java3DVersion = "not available";
            } else {
                this.Java3DTitle = package_.getImplementationTitle();
                this.Java3DVendor = package_.getImplementationVendor();
                this.Java3DVersion = package_.getImplementationVersion();
            }
        }
        catch (Exception exception) {
            this.Java3DTitle = "not installed";
            this.Java3DVendor = "not available";
            this.Java3DVersion = "not available";
        }
    }

    public void Start() {
        this.MyTimer.start();
    }

    public void Stop() {
        this.MyTimer.stop();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        Font font = new Font("serif", 1, 54);
        graphics2D.setFont(font);
        graphics2D.drawString("TIGR MeV", 40, 70);
        Font font2 = new Font("monospaced", 1, 14);
        graphics2D.setFont(font2);
        graphics2D.drawString("Version 2.2", 40, 90);
        int n = 150;
        graphics2D.setColor(new Color(155, 180, 215));
        graphics2D.drawString("Java Runtime Environment version:", 40, n);
        graphics2D.drawString(System.getProperty("java.version"), this.InfoPosition, n);
        graphics2D.drawString("Java Runtime Environment vendor:", 40, n += 20);
        graphics2D.drawString(System.getProperty("java.vendor"), this.InfoPosition, n);
        graphics2D.drawString("Java Virtual Machine name:", 40, n += 20);
        graphics2D.drawString(System.getProperty("java.vm.name"), this.InfoPosition, n);
        graphics2D.drawString("Java Virtual Machine version:", 40, n += 20);
        graphics2D.drawString(System.getProperty("java.vm.version"), this.InfoPosition, n);
        graphics2D.drawString("Java Virtual Machine vendor:", 40, n += 20);
        graphics2D.drawString(System.getProperty("java.vm.vendor"), this.InfoPosition, n);
        graphics2D.drawString("Java 3D Runtime Environment:", 40, n += 20);
        graphics2D.drawString(this.Java3DTitle, this.InfoPosition, n);
        graphics2D.drawString("Java 3D Runtime Environment vendor:", 40, n += 20);
        graphics2D.drawString(this.Java3DVendor, this.InfoPosition, n);
        graphics2D.drawString("Java 3D Runtime Environment version:", 40, n += 20);
        graphics2D.drawString(this.Java3DVersion, this.InfoPosition, n);
        graphics2D.drawString("Operating System name:", 40, n += 20);
        graphics2D.drawString(System.getProperty("os.name"), this.InfoPosition, n);
        graphics2D.drawString("Operating System version:", 40, n += 20);
        graphics2D.drawString(System.getProperty("os.version"), this.InfoPosition, n);
        graphics2D.drawString("Operating System architecture:", 40, n += 20);
        graphics2D.drawString(System.getProperty("os.arch"), this.InfoPosition, n);
        graphics2D.drawString("User's account name:", 40, n += 20);
        graphics2D.drawString(System.getProperty("user.name"), this.InfoPosition, n);
        graphics2D.drawString("User's home directory:", 40, n += 20);
        graphics2D.drawString(System.getProperty("user.home"), this.InfoPosition, n);
        graphics2D.drawString("User's current working directory:", 40, n += 20);
        graphics2D.drawString(System.getProperty("user.dir"), this.InfoPosition, n);
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingSize(3);
        this.MemoryPosition = n;
        graphics2D.drawString("Free System Memory:", 40, n += 20);
        long l = Runtime.getRuntime().freeMemory();
        graphics2D.drawString(decimalFormat.format(l) + " Bytes", this.InfoPosition, n);
        graphics2D.drawString("Total System Memory:", 40, n += 20);
        long l2 = Runtime.getRuntime().totalMemory();
        graphics2D.drawString(decimalFormat.format(l2) + " Bytes", this.InfoPosition, n);
        n += 20;
        graphics2D.setColor(new Color(55, 110, 175));
        graphics2D.setColor(new Color(110, 150, 200));
        double d = (double)l2 / 175.0;
        graphics2D.setColor(new Color(110, 150, 200));
        for (int i = 0; i < 175; ++i) {
            if (Math.round(d * (double)i) >= l) {
                graphics2D.setColor(new Color(55, 110, 175));
            }
            graphics2D.fillRect(40 + i * 3, n, 2, 20);
        }
    }

    public String getJava3DRunTimeEnvironment() {
        return this.Java3DTitle;
    }

    public String getJava3DVendor() {
        return this.Java3DVendor;
    }

    public String getJava3DVersion() {
        return this.Java3DVersion;
    }
}

