/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.AcknowlegementDialog;
import org.tigr.microarray.mev.ArrayViewer;
import org.tigr.microarray.mev.DatabaseLoginDialog;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.InfoDisplay;
import org.tigr.microarray.mev.InformationPanel;
import org.tigr.microarray.mev.MevCitationDialog;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.PaperReferencesDialog;
import org.tigr.microarray.mev.SetDatabaseDialog;
import org.tigr.microarray.mev.SingleArrayViewer;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.Query;
import org.tigr.util.awt.ActionInfoEvent;
import org.tigr.util.awt.ActionInfoListener;
import org.tigr.util.awt.ImageScreen;
import org.tigr.util.awt.MessageDisplay;

public class Manager {
    private static Vector activeComponents;
    private JFrame frame;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newMultipleArrayViewerItem;
    private JMenuItem newSingleArrayViewerItem;
    private JMenuItem newPreferencesItem;
    private JMenuItem loginItem;
    private JMenuItem quitItem;
    private JMenu displayMenu;
    private JRadioButtonMenuItem javaLFItem;
    private JRadioButtonMenuItem windowsLFItem;
    private JRadioButtonMenuItem motifLFItem;
    private JCheckBoxMenuItem toolTipsItem;
    private JMenu windowMenu;
    private JMenu referencesMenu;
    private JMenuItem systemInfoItem;
    private JMenuItem acknolMenuItem;
    private JMenuItem papersMenuItem;
    private JMenuItem citationMenuItem;
    private JMenuItem aboutMenuItem;
    private ButtonGroup buttonGroup;
    private EventListener eventListener;

    public Manager() {
        try {
            activeComponents = new Vector();
            this.eventListener = new EventListener();
            this.initializeFrame();
            this.initializeInput();
        }
        catch (Exception exception) {
            System.out.println("Exception (Manager.const()): " + exception);
        }
    }

    public void initializeFrame() {
        this.frame = new JFrame("TIGR MultiExperiment Viewer");
        this.initializeMenuBar(this.frame);
        this.frame.addWindowListener(this.eventListener);
        this.frame.setSize(Toolkit.getDefaultToolkit().getScreenSize().width, 50);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public void initializeMenuBar(JFrame jFrame) {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.newMultipleArrayViewerItem = new JMenuItem("New Multiple Array Viewer");
        this.newMultipleArrayViewerItem.addActionListener(this.eventListener);
        this.newMultipleArrayViewerItem.setMnemonic(77);
        this.fileMenu.add(this.newMultipleArrayViewerItem);
        this.newSingleArrayViewerItem = new JMenuItem("New Single Array Viewer");
        this.newSingleArrayViewerItem.addActionListener(this.eventListener);
        this.newSingleArrayViewerItem.setMnemonic(83);
        this.fileMenu.add(this.newSingleArrayViewerItem);
        this.fileMenu.addSeparator();
        this.quitItem = new JMenuItem("Quit");
        this.quitItem.addActionListener(this.eventListener);
        this.quitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.fileMenu.add(this.quitItem);
        this.menuBar.add(this.fileMenu);
        this.displayMenu = new JMenu("Display");
        this.buttonGroup = new ButtonGroup();
        this.javaLFItem = new JRadioButtonMenuItem("Metal L&F");
        this.javaLFItem.addActionListener(this.eventListener);
        this.displayMenu.add(this.javaLFItem);
        this.buttonGroup.add(this.javaLFItem);
        this.javaLFItem.setSelected(true);
        this.windowsLFItem = new JRadioButtonMenuItem("Windows L&F");
        this.windowsLFItem.addActionListener(this.eventListener);
        this.displayMenu.add(this.windowsLFItem);
        this.buttonGroup.add(this.windowsLFItem);
        this.motifLFItem = new JRadioButtonMenuItem("Motif L&F");
        this.motifLFItem.addActionListener(this.eventListener);
        this.displayMenu.add(this.motifLFItem);
        this.buttonGroup.add(this.motifLFItem);
        this.toolTipsItem = new JCheckBoxMenuItem("Show ToolTips");
        this.toolTipsItem.addActionListener(this.eventListener);
        this.displayMenu.add(this.toolTipsItem);
        this.toolTipsItem.setSelected(true);
        this.menuBar.add(this.displayMenu);
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setEnabled(false);
        this.menuBar.add(this.windowMenu);
        this.referencesMenu = new JMenu("References");
        this.acknolMenuItem = new JMenuItem("Contributions...");
        this.acknolMenuItem.addActionListener(this.eventListener);
        this.referencesMenu.add(this.acknolMenuItem);
        this.papersMenuItem = new JMenuItem("Papers / Publications");
        this.papersMenuItem.addActionListener(this.eventListener);
        this.referencesMenu.add(this.papersMenuItem);
        this.citationMenuItem = new JMenuItem("Referencing TMeV...");
        this.citationMenuItem.addActionListener(this.eventListener);
        this.referencesMenu.add(this.citationMenuItem);
        this.referencesMenu.addSeparator();
        this.systemInfoItem = new JMenuItem("System Info");
        this.systemInfoItem.addActionListener(this.eventListener);
        this.referencesMenu.add(this.systemInfoItem);
        this.referencesMenu.addSeparator();
        this.aboutMenuItem = new JMenuItem("About MeV");
        this.aboutMenuItem.addActionListener(this.eventListener);
        this.referencesMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.referencesMenu);
        jFrame.setJMenuBar(this.menuBar);
    }

    public boolean selectPreferencesFile() {
        File file = null;
        String string = "";
        boolean bl = false;
        Dimension dimension = this.frame.getToolkit().getScreenSize();
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String string = "";
                if (file.isDirectory()) {
                    return true;
                }
                if (file.getName().endsWith("Preferences")) {
                    return true;
                }
                if (file.getName().endsWith("preferences")) {
                    return true;
                }
                return file.getName().endsWith(".pref");
            }

            public String getDescription() {
                return "Preference Files";
            }
        });
        jFileChooser.setDialogTitle("Select Preferences File");
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setCurrentDirectory(new File("Preferences"));
        if (jFileChooser.showOpenDialog(this.frame) != 0) {
            System.out.println("No preference file selected");
            return false;
        }
        file = jFileChooser.getSelectedFile();
        if (TMEV.readPreferencesFile(file)) {
            System.out.println("Successfully read preferences file - " + file.getName());
            return true;
        }
        Manager.message(this.frame, "Error in preferences file: " + file.getName());
        TMEV.quit();
        return false;
    }

    public static void addComponent(Component component) {
        activeComponents.addElement(component);
    }

    public static Component getComponent(int n) {
        return (Component)activeComponents.elementAt(n);
    }

    public static void removeComponent(Component component) {
        activeComponents.removeElement(component);
    }

    public void initializeInput() {
        try {
            String string = "Only File";
            if (string.equals("Database")) {
                this.databaseLogin();
                this.systemEnable(1001);
                this.systemEnable(1002);
            } else if (string.equals("File")) {
                this.databaseLogin();
                this.systemEnable(1001);
                this.systemEnable(1002);
            } else if (!string.equals("Only File")) {
                Manager.message(this.frame, "Error: Invalid Preferences File");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception (TMEV.initializeInput()): " + exception);
        }
    }

    public static void createNewMultipleArrayViewer() {
    }

    public static void createNewMultipleArrayViewer(MultipleArrayData multipleArrayData, String string) {
    }

    public static void createNewSingleArrayViewer() {
        SingleArrayViewer singleArrayViewer = new SingleArrayViewer(new JFrame("Single Array Viewer"));
        Manager.addComponent(singleArrayViewer);
        singleArrayViewer.systemEnable(1001);
        singleArrayViewer.systemEnable(1002);
        singleArrayViewer.getFrame().setSize(650, 650);
        singleArrayViewer.getFrame().setLocation(100, 100);
        singleArrayViewer.getFrame().setVisible(true);
    }

    public static void createNewSingleArrayViewer(ISlideData iSlideData) {
        SingleArrayViewer singleArrayViewer = new SingleArrayViewer(new JFrame("Single Array Viewer"), iSlideData);
        singleArrayViewer.getFrame().setSize(650, 650);
        singleArrayViewer.getFrame().setLocation(100, 100);
        singleArrayViewer.getFrame().setVisible(true);
        singleArrayViewer.refreshSlide();
    }

    public static void createNewSingleArrayViewer(ISlideData iSlideData, float f, float f2) {
        SingleArrayViewer singleArrayViewer = new SingleArrayViewer(new JFrame("Single Array Viewer"), iSlideData);
        Manager.addComponent(singleArrayViewer);
        singleArrayViewer.systemEnable(1001);
        singleArrayViewer.systemEnable(1002);
        singleArrayViewer.setUpperLimits(f, f2);
        singleArrayViewer.panel.setXYScrollbars((long)f, (long)f2);
        singleArrayViewer.getFrame().setSize(650, 650);
        singleArrayViewer.getFrame().setLocation(100, 100);
        singleArrayViewer.getFrame().setVisible(true);
        singleArrayViewer.refreshSlide();
    }

    public static void displaySlideElementInfo(JFrame jFrame, MultipleArrayData multipleArrayData, int n, int n2) {
        new InfoDisplay(jFrame, multipleArrayData, n, n2);
    }

    public static void displaySlideElementInfo(JFrame jFrame, ISlideData iSlideData, ISlideDataElement iSlideDataElement, int n) {
        new InfoDisplay(jFrame, iSlideData, iSlideDataElement, n);
    }

    public void systemDisable(int n) {
        switch (n) {
            case 1000: {
                break;
            }
            case 1003: {
                break;
            }
            case 1001: {
                break;
            }
        }
        for (int i = 0; i < activeComponents.size(); ++i) {
            ((ArrayViewer)activeComponents.elementAt(i)).systemDisable(n);
        }
    }

    public void systemEnable(int n) {
        switch (n) {
            case 1000: {
                break;
            }
            case 1003: {
                break;
            }
            case 1001: {
                break;
            }
        }
        for (int i = 0; i < activeComponents.size(); ++i) {
            ((ArrayViewer)activeComponents.elementAt(i)).systemEnable(n);
        }
    }

    public void databaseLogin() {
        DatabaseLoginDialog databaseLoginDialog = new DatabaseLoginDialog(this.frame);
        databaseLoginDialog.addActionInfoListener(new ActionInfoListener(){

            public void actionInfoPerformed(ActionInfoEvent actionInfoEvent) {
                Hashtable hashtable = actionInfoEvent.getHashtable();
                Manager.this.databaseLoad((String)hashtable.get("username"), (String)hashtable.get("password"));
            }
        });
        databaseLoginDialog.show();
    }

    public void databaseLoad(String string, String string2) {
        SetDatabaseDialog setDatabaseDialog;
        if ((TMEV.getConnection() != null || TMEV.connect(string, string2)) && (setDatabaseDialog = new SetDatabaseDialog(this.frame)).showModal() == 0) {
            this.useDatabase(setDatabaseDialog.getDatabase());
        }
    }

    public void useDatabase(String string) {
        try {
            Query query = new Query("use " + string);
            query.executeUpdate(TMEV.getConnection());
            for (int i = 0; i < activeComponents.size(); ++i) {
                ((ArrayViewer)activeComponents.elementAt(i)).systemEnable(1002);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception (ColumnApplet.useDatabase()): " + exception);
        }
    }

    public static void message(JFrame jFrame, String string) {
        System.out.println(string);
        MessageDisplay messageDisplay = new MessageDisplay(jFrame, string);
        messageDisplay.show();
    }

    public static void message(JFrame jFrame, Exception exception) {
        Manager.message(jFrame, exception.toString());
    }

    public static void exception(JFrame jFrame, String string) {
        System.out.println("EXCEPTION: " + string);
        MessageDisplay messageDisplay = new MessageDisplay(jFrame, string);
        messageDisplay.show();
    }

    public static void exception(JFrame jFrame, Exception exception) {
        Manager.exception(jFrame, exception.toString());
    }

    private void handleItems(Object object) {
    }

    private class EventListener
    implements ActionListener,
    WindowListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            Manager.this.handleItems(object);
            if (object == Manager.this.newMultipleArrayViewerItem) {
                Manager.createNewMultipleArrayViewer();
            } else if (object == Manager.this.newSingleArrayViewerItem) {
                Manager.createNewSingleArrayViewer();
            } else if (object == Manager.this.loginItem) {
                Manager.this.databaseLogin();
            } else if (object == Manager.this.newPreferencesItem) {
                Manager.this.selectPreferencesFile();
            } else if (object == Manager.this.quitItem) {
                TMEV.quit();
            } else if (object == Manager.this.javaLFItem) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(Manager.this.frame);
                    for (int i = 0; i < activeComponents.size(); ++i) {
                        SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
                    }
                }
                catch (Exception exception) {}
            } else if (object == Manager.this.windowsLFItem) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(Manager.this.frame);
                    for (int i = 0; i < activeComponents.size(); ++i) {
                        SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
                    }
                }
                catch (Exception exception) {}
            } else if (object == Manager.this.motifLFItem) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(Manager.this.frame);
                    for (int i = 0; i < activeComponents.size(); ++i) {
                        SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
                    }
                }
                catch (Exception exception) {}
            } else if (object == Manager.this.toolTipsItem) {
                if (Manager.this.toolTipsItem.isSelected()) {
                    ToolTipManager.sharedInstance().setEnabled(true);
                } else {
                    ToolTipManager.sharedInstance().setEnabled(false);
                }
            } else if (object == Manager.this.acknolMenuItem) {
                new AcknowlegementDialog((Frame)Manager.this.frame, AcknowlegementDialog.createAcknowlegementText());
            } else if (object == Manager.this.papersMenuItem) {
                new PaperReferencesDialog((Frame)Manager.this.frame, PaperReferencesDialog.createReferencesText());
            } else if (object == Manager.this.citationMenuItem) {
                new MevCitationDialog((Frame)Manager.this.frame, MevCitationDialog.createCitationText());
            } else if (object == Manager.this.aboutMenuItem) {
                ImageScreen imageScreen = new ImageScreen();
                imageScreen.showImageScreen();
            } else if (object == Manager.this.systemInfoItem) {
                int n = 640;
                int n2 = 550;
                InformationPanel informationPanel = new InformationPanel();
                JFrame jFrame = new JFrame("System Information");
                jFrame.getContentPane().add(informationPanel);
                jFrame.setSize(n, n2);
                Dimension dimension = jFrame.getToolkit().getScreenSize();
                jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
                jFrame.setResizable(false);
                jFrame.setVisible(true);
                informationPanel.Start();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            Manager.this.frame.dispose();
            System.exit(0);
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

