/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.ExpressionSliderWidget;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayGUI;
import ca.ucalgary.bluejay.gui.microarray.MicroarrayFunctions;
import com.sun.media.jai.codec.ImageEncodeParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.tigr.microarray.mev.ArrayViewer;
import org.tigr.microarray.mev.BluejayMultipleArrayCanvas;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.InformationPanel;
import org.tigr.microarray.mev.Manager;
import org.tigr.microarray.mev.MultipleArrayCanvas;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.MultipleArrayMenubar;
import org.tigr.microarray.mev.MultipleArrayToolbar;
import org.tigr.microarray.mev.SetDetectionFilterDialog;
import org.tigr.microarray.mev.SetFoldFilterDialog;
import org.tigr.microarray.mev.SetLowerCutoffsDialog;
import org.tigr.microarray.mev.SetPercentageCutoffsDialog;
import org.tigr.microarray.mev.SetRatioScaleDialog;
import org.tigr.microarray.mev.SetUpperLimitsDialog;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterTable;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.st.HCLSupportTree;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.util.awt.ColorSchemeSelectionDialog;
import org.tigr.microarray.util.awt.SetElementSizeDialog;
import org.tigr.util.swing.BMPFileFilter;
import org.tigr.util.swing.ImageFileFilter;
import org.tigr.util.swing.JPGFileFilter;
import org.tigr.util.swing.PNGFileFilter;
import org.tigr.util.swing.TIFFFileFilter;

public class MultipleArrayViewer
extends ArrayViewer
implements Printable {
    private MultipleArrayMenubar menubar;
    private MultipleArrayToolbar toolbar;
    private JSplitPane splitPane;
    private JScrollPane viewScrollPane;
    private JLabel statusLabel;
    private JScrollPane treeScrollPane;
    private JTree tree;
    private DefaultMutableTreeNode clusterNode;
    private DefaultMutableTreeNode analysisNode;
    private DefaultMutableTreeNode historyNode;
    private IViewer viewer;
    private IFramework framework = new FrameworkImpl();
    private MultipleArrayData data = new MultipleArrayData();
    private int resultCount = 1;
    private ClusterRepository geneClusterRepository;
    private ClusterRepository experimentClusterRepository;
    private ClusterTable geneClusterManager;
    private ClusterTable experimentClusterManager;
    private JFrame mainframe;
    private JFrame viewerFrame;
    public static final String FILE_TIME_PATTERN = "\\A.*?([0-9\\.]+)[ _-]?([smhdjt]).*\\Z";
    private static TreeMap gbToLocMap;
    private static TreeMap gbToColumnLocMap;
    private static TreeMap locToGbMap;
    private static TreeMap ratioToGbMap;
    private static TreeMap gbToRatioMap;
    private static TreeMap[] gbToRatioAndSlideMap;
    private static TreeMap gbToClusterID;
    private static TreeMap clusterIDToIViewer;
    private static TreeMap clusterIDToIViewers;
    private static int gbNumberIndex;
    private static boolean dataLoaded;
    private BluejayMultipleArrayCanvas arrayViewerCanvas;
    private BluejayDObjectList dlist;
    private MicroarrayFunctions microArrayFunctions;
    private static boolean needCanvasRefresh;
    private double highExpressionBoundary = 0.0;
    private double lowExpressionBoundary = 0.0;
    private static int numberOfSlides;
    private static int currentSlide;
    private static boolean playerSelected;
    private static boolean comparisonSelected;
    private int expressionSliderMaximum;
    private int expressionSliderMinimum;
    private static Hashtable slideNames;
    private static String experimentName;

    public MultipleArrayViewer(JFrame jFrame) {
        super(new JFrame("TIGR Multiple Array Viewer"));
        TMEV.configure();
        this.mainframe = jFrame;
        EventListener eventListener = new EventListener();
        ActionManager actionManager = new ActionManager(eventListener, TMEV.getFieldNames(), TMEV.getGUIFactory());
        this.menubar = new MultipleArrayMenubar(actionManager);
        this.toolbar = new MultipleArrayToolbar(actionManager);
        this.viewScrollPane = this.createViewScrollPane(eventListener);
        this.viewScrollPane.setBackground(Color.white);
        this.treeScrollPane = this.createTreeScrollPane(eventListener);
        this.viewerFrame = new JFrame("Analysis Viewer");
        this.viewerFrame.getContentPane().add(this.viewScrollPane);
        this.statusLabel = new JLabel("TIGR MultiExperiment Viewer");
        this.viewerFrame.getContentPane().add((Component)this.statusLabel, "South");
        this.viewerFrame.setDefaultCloseOperation(2);
        this.viewerFrame.setSize(500, 400);
        this.arrayViewerCanvas = new BluejayMultipleArrayCanvas(this.framework, new Insets(0, 10, 0, 20));
    }

    public MultipleArrayViewer(MultipleArrayData multipleArrayData) {
        super(new JFrame("TIGR Multiple Array Viewer"));
        TMEV.configure();
        EventListener eventListener = new EventListener();
        this.mainframe.addWindowListener(eventListener);
        ActionManager actionManager = new ActionManager(eventListener, TMEV.getFieldNames(), TMEV.getGUIFactory());
        this.data = multipleArrayData;
        this.menubar = new MultipleArrayMenubar(actionManager);
        this.menubar.addLabelMenuItems(TMEV.getFieldNames());
        this.menubar.addSortMenuItems(TMEV.getFieldNames());
        this.toolbar = new MultipleArrayToolbar(actionManager);
    }

    public void systemDisable(int n) {
        this.menubar.systemDisable(n);
        this.toolbar.systemDisable(n);
    }

    public void systemEnable(int n) {
        this.menubar.systemEnable(n);
        this.toolbar.systemEnable(n);
    }

    public AlgorithmFactory getAlgorithmFactory() {
        return TMEV.getAlgorithmFactory();
    }

    public IData getData() {
        return this.data;
    }

    private void displaySingleArrayViewer(int n) {
        Manager.createNewSingleArrayViewer(this.data.getFeature(n));
    }

    private void displaySlideElementInfo(int n, int n2) {
        Manager.displaySlideElementInfo(this.mainframe, this.data, n, n2);
    }

    private String getStatusText() {
        return this.statusLabel.getText();
    }

    private void setStatusText(String string) {
        this.statusLabel.setText(string);
    }

    private Object getUserObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return null;
        }
        return ((LeafInfo)object).getUserObject();
    }

    public JFrame getFrame() {
        return this.mainframe;
    }

    public void setContentLocation(int n, int n2) {
        Dimension dimension = this.viewScrollPane.getViewport().getViewSize();
        Dimension dimension2 = this.viewScrollPane.getViewport().getExtentSize();
        if (dimension2.height + n2 > dimension.height) {
            n2 = dimension.height - dimension2.height;
        }
        this.viewScrollPane.getViewport().setViewPosition(new Point(n, n2));
    }

    private JScrollPane createTreeScrollPane(EventListener eventListener) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("MultipleExperimentViewer");
        this.viewer = new MultipleArrayCanvas(this.framework, new Insets(0, 10, 0, 20));
        this.clusterNode = new DefaultMutableTreeNode(new LeafInfo("Cluster Manager"));
        defaultMutableTreeNode.add(this.clusterNode);
        this.analysisNode = new DefaultMutableTreeNode(new LeafInfo("Analysis"));
        defaultMutableTreeNode.add(this.analysisNode);
        this.historyNode = new DefaultMutableTreeNode(new LeafInfo("History"));
        defaultMutableTreeNode.add(this.historyNode);
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.addTreeSelectionListener(eventListener);
        this.tree.addMouseListener(eventListener);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setEditable(false);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        return new JScrollPane(this.tree);
    }

    private JScrollPane createViewScrollPane(EventListener eventListener) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setScrollMode(0);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(33, 0);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(34, 0);
        jScrollPane.registerKeyboardAction(eventListener, "lineup", keyStroke, 2);
        jScrollPane.registerKeyboardAction(eventListener, "linedown", keyStroke2, 2);
        jScrollPane.registerKeyboardAction(eventListener, "pageup", keyStroke3, 2);
        jScrollPane.registerKeyboardAction(eventListener, "pagedown", keyStroke4, 2);
        return jScrollPane;
    }

    private void setCurrentViewer(IViewer iViewer) {
        if (iViewer == null || iViewer.getContentComponent() == null) {
            return;
        }
        if (this.viewer != null) {
            this.viewer.onDeselected();
        }
        this.viewer = iViewer;
        this.viewScrollPane.setViewportView(this.viewer.getContentComponent());
        JComponent jComponent = iViewer.getHeaderComponent();
        if (jComponent != null) {
            this.viewScrollPane.setColumnHeaderView(jComponent);
        } else {
            this.viewScrollPane.setColumnHeader(null);
        }
        this.viewer.onSelected(this.framework);
        this.doViewLayout();
        this.handleThumbnailButton(this.viewer);
    }

    private void handleThumbnailButton(IViewer iViewer) {
        if (iViewer instanceof MultipleArrayCanvas) {
            this.toolbar.setThumbnailEnabled(((MultipleArrayCanvas)iViewer).isThumbnailEnabled());
        } else {
            this.toolbar.setThumbnailEnabled(false);
        }
    }

    private IViewer getCurrentViewer() {
        return this.viewer;
    }

    private void fireOnCloseEvent(DefaultMutableTreeNode defaultMutableTreeNode) {
        LeafInfo leafInfo;
        IViewer iViewer;
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof LeafInfo && (iViewer = (leafInfo = (LeafInfo)object).getViewer()) != null) {
            iViewer.onClosed();
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.fireOnCloseEvent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
    }

    private void onClose() {
        TMEV.setDataType(1);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        this.fireOnCloseEvent((DefaultMutableTreeNode)defaultTreeModel.getRoot());
        this.mainframe.dispose();
        Manager.removeComponent(this);
    }

    public BufferedImage createDefaultImage(IViewer iViewer) {
        JComponent jComponent = iViewer.getContentComponent();
        JComponent jComponent2 = iViewer.getHeaderComponent();
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        if (jComponent2 != null) {
            n = Math.max(n, jComponent2.getWidth());
            n2 += jComponent2.getHeight();
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (jComponent2 != null) {
            int n3 = jComponent2.getHeight();
            graphics2D.setClip(0, 0, n, n3);
            jComponent2.paint(graphics2D);
            graphics2D.translate(0, n3);
            graphics2D.setClip(0, 0, n, n2 - n3);
        } else {
            graphics2D.setClip(0, 0, n, n2);
        }
        jComponent.paint(graphics2D);
        return bufferedImage;
    }

    private void onSaveImage() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setCurrentDirectory(new File("Data"));
        jFileChooser.addChoosableFileFilter(new BMPFileFilter());
        jFileChooser.addChoosableFileFilter(new JPGFileFilter());
        jFileChooser.addChoosableFileFilter(new PNGFileFilter());
        jFileChooser.addChoosableFileFilter(new TIFFFileFilter());
        int n = jFileChooser.showSaveDialog(this.getFrame());
        if (n == 0) {
            IViewer iViewer = this.getCurrentViewer();
            BufferedImage bufferedImage = iViewer.getImage();
            if (bufferedImage == null) {
                bufferedImage = this.createDefaultImage(iViewer);
            }
            final File file = jFileChooser.getSelectedFile();
            final BufferedImage bufferedImage2 = bufferedImage;
            final String string = ((ImageFileFilter)((Object)jFileChooser.getFileFilter())).getFileFormat();
            final ImageEncodeParam imageEncodeParam = ((ImageFileFilter)((Object)jFileChooser.getFileFilter())).getImageEncodeParam();
            try {
                Thread thread = new Thread(){

                    public void run() {
                        JAI.create("filestore", (RenderedImage)bufferedImage2, (Object)file.getPath(), (Object)string, (Object)imageEncodeParam);
                        Manager.message(MultipleArrayViewer.this.getFrame(), "Image saved: " + file.getPath());
                    }
                };
                thread.setPriority(1);
                thread.start();
            }
            catch (Exception exception) {
                Manager.message(this.getFrame(), exception);
            }
        }
    }

    private void onLoadDirectory() {
        try {
            ISlideData[] iSlideDataArray = this.loadDirectory(this.data.getSlideMetaData());
            if (iSlideDataArray != null) {
                this.addFeatures(iSlideDataArray);
                this.setMaxCY3AndCY5();
            }
        }
        catch (Exception exception) {
            ShowThrowableDialog.show(this.mainframe, "Load Directory Error", exception);
        }
    }

    private void setMaxCY3AndCY5() {
        this.menubar.setMaxCY3Scale(this.data.getMaxCY3());
        this.menubar.setMaxCY5Scale(this.data.getMaxCY5());
    }

    private void onLabelChanged(Action action) {
        String string = (String)action.getValue("command-parameter");
        this.menubar.setLabelIndex(Integer.parseInt(string));
        this.fireMenuChanged();
    }

    private void addFeature(ISlideData iSlideData) {
        this.data.addFeature(iSlideData);
        this.systemEnable(1003);
        this.fireDataChanged();
    }

    private void addFeatures(ISlideData[] iSlideDataArray) {
        this.data.addFeatures(iSlideDataArray);
        this.systemEnable(1003);
        this.fireDataChanged();
    }

    public void fireDataChanged() {
        IViewer iViewer = this.getCurrentViewer();
        if (iViewer == null) {
            return;
        }
        iViewer.onDataChanged(this.data);
        this.arrayViewerCanvas.onDataChanged(this.data);
        this.arrayViewerCanvas.onSelected(this.framework);
        this.doViewLayout();
    }

    private void fireMenuChanged() {
        IViewer iViewer = this.getCurrentViewer();
        if (iViewer == null) {
            return;
        }
        iViewer.onMenuChanged(this.menubar.getDisplayMenu());
        this.doViewLayout();
    }

    private void fireHeaderChanged() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return;
        }
        this.setCurrentViewer(((LeafInfo)object).getViewer());
    }

    private void doViewLayout() {
        JViewport jViewport = this.viewScrollPane.getColumnHeader();
        if (jViewport != null) {
            jViewport.doLayout();
        }
        this.viewScrollPane.getViewport().doLayout();
        this.viewScrollPane.doLayout();
        this.viewScrollPane.repaint();
    }

    private void onNormalizeData(int n) {
        this.setCursor(3);
        this.data.normalize(n, this);
        this.addHistory(SlideData.normalizationString(n));
        this.setCursor(0);
    }

    private void onNormalizeDataList(int n) {
        this.setCursor(3);
        this.data.normalizeList(n);
        this.addHistory(SlideData.normalizationString(n));
        this.setCursor(0);
    }

    private void onNodeChanged(TreeSelectionEvent treeSelectionEvent) {
        JTree jTree = (JTree)treeSelectionEvent.getSource();
        TreePath treePath = treeSelectionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            if (!(object instanceof String)) {
                return;
            }
        } else {
            if (this.viewerFrame != null) {
                this.viewerFrame.setVisible(true);
            }
            this.setCurrentViewer(((LeafInfo)object).getViewer());
        }
        if (this.performClusterCheck(defaultMutableTreeNode)) {
            this.showClusterInfo(defaultMutableTreeNode);
        } else {
            this.microArrayFunctions.updateColorSchema();
            this.microArrayFunctions.getAnalysisMonitor().setClusterDataShown(false, (int[])null);
            this.microArrayFunctions.restoreMicroArrayInfo();
        }
    }

    private void onElementSizeChanged(int n, int n2) {
        this.menubar.setElementSize(n, n2);
        this.fireMenuChanged();
    }

    private void onElementSizeChanged() {
        SetElementSizeDialog setElementSizeDialog = new SetElementSizeDialog(this.getFrame(), this.menubar.getDisplayMenu().getElementSize());
        if (setElementSizeDialog.showModal() == 0) {
            Dimension dimension = setElementSizeDialog.getElementSize();
            this.onElementSizeChanged(dimension.width, dimension.height);
        }
    }

    private void onColorSchemeChange(int n) {
        int n2 = this.menubar.getColorScheme();
        if (n == 5 || n == 6) {
            this.menubar.setColorSchemeIndex(n);
        } else {
            ColorSchemeSelectionDialog colorSchemeSelectionDialog = new ColorSchemeSelectionDialog((Frame)this.getFrame(), true, this.menubar.getNegativeGradientImage(), this.menubar.getPositiveGradientImage());
            colorSchemeSelectionDialog.pack();
            if (colorSchemeSelectionDialog.showModal() != 0) {
                return;
            }
            this.menubar.setPositiveCustomGradient(colorSchemeSelectionDialog.getPositiveGradient());
            this.menubar.setNegativeCustomGradient(colorSchemeSelectionDialog.getNegativeGradient());
            this.menubar.setColorSchemeIndex(n);
        }
        this.microArrayFunctions.getExpressionWidget().getColorGradientPreview().setPositiveGradient(this.menubar.getPositiveGradientImage());
        this.microArrayFunctions.getExpressionWidget().getColorGradientPreview().setNegativeGradient(this.menubar.getNegativeGradientImage());
        this.fireMenuChanged();
        needCanvasRefresh = true;
    }

    private void onPaletteStyleChanged(int n) {
        this.menubar.setPaletteStyle(n);
        this.fireMenuChanged();
        needCanvasRefresh = true;
    }

    private void onColorGradientChange(boolean bl) {
        this.menubar.setColorGradientState(bl);
        this.microArrayFunctions.getExpressionWidget().getColorGradientPreview().setPositiveGradient(this.menubar.getPositiveGradientImage());
        this.microArrayFunctions.getExpressionWidget().getColorGradientPreview().setNegativeGradient(this.menubar.getNegativeGradientImage());
        this.fireMenuChanged();
    }

    private void onTracing() {
        this.menubar.setTracing(!this.menubar.getDisplayMenu().isTracing());
        this.fireMenuChanged();
    }

    private void onGRScale() {
        this.menubar.setGRScale(!this.menubar.getDisplayMenu().isGRScale());
        this.fireMenuChanged();
    }

    private void onAntiAliasing() {
        this.menubar.setAntiAliasing(!this.menubar.getDisplayMenu().isAntiAliasing());
        this.fireMenuChanged();
    }

    private void onDrawBorders() {
        this.menubar.setDrawBorders(!this.menubar.getDisplayMenu().isDrawingBorder());
        this.fireMenuChanged();
    }

    private void onSort(Action action) {
        String string = (String)action.getValue("command-parameter");
        this.onSort(Integer.parseInt(string));
    }

    private void onSort(int n) {
        this.data.sort(n);
        this.fireDataChanged();
    }

    private void onSystemInfo() {
        int n = 640;
        int n2 = 550;
        InformationPanel informationPanel = new InformationPanel();
        JFrame jFrame = new JFrame("System Information");
        jFrame.getContentPane().add(informationPanel);
        jFrame.setSize(n, n2);
        Dimension dimension = this.getToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        jFrame.setResizable(false);
        jFrame.setVisible(true);
        informationPanel.Start();
    }

    private void onDefaultDistance() {
        String string = "<html><font color=\"#000000\"><b><u>Default Distances</u></b></font><p><table border=20 cellspacing=10 cellpadding = 10 width= 380 height= 400><tr><th><u><center><width=200>Algorithm</center></u></th><th width = 150><u><center>Default Metric</center></u></th></tr><tr><td><center>HCL, ST, SOTA, KMC, KMS, SOM, CAST, GSH, FOM</center></td><td><center>Euclidean</center></td></tr><tr><td><center>PCA</center></td><td><center>Covariance</center></td></tr><tr><td><center>SVM</center></td><td><center>Dot Product</center></td></tr><tr><td><center>RN, QTC, PTM</center></td><td><center>Pearson Correlation</center></td></tr></center></table></html>";
        JOptionPane.showMessageDialog(this.getFrame(), new JLabel(string), "Default Distances", -1);
    }

    private void setNormalizedState(int n) {
        if (n == 0) {
            this.menubar.setNormalizedButtonState(5);
        } else {
            this.addHistory(SlideData.normalizationString(n));
            if (n == 1) {
                this.menubar.setNormalizedButtonState(0);
            } else if (n == 3) {
                this.menubar.setNormalizedButtonState(1);
            } else if (n == 4 || n == 5) {
                this.menubar.setNormalizedButtonState(2);
            } else if (n == 6) {
                this.menubar.setNormalizedButtonState(3);
            }
        }
    }

    private void onNormalize(int n) {
        final int n2 = this.data.getFeature(0).getNormalizedState();
        final int n3 = n;
        this.setCursor(3);
        try {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    String string = MultipleArrayViewer.this.data.normalize(n3, MultipleArrayViewer.this);
                    if (!string.equals("no_change")) {
                        if (string.equals("normalized")) {
                            MultipleArrayViewer.this.addHistory(SlideData.normalizationString(n3));
                            needCanvasRefresh = true;
                            MultipleArrayViewer.this.updateColor();
                        } else if (string.equals("process_abort_reset")) {
                            MultipleArrayViewer.this.addHistory("Norm. aborted, reset to raw state");
                            MultipleArrayViewer.this.menubar.setNormalizedButtonState(5);
                        }
                        MultipleArrayViewer.this.fireDataChanged();
                        MultipleArrayViewer.this.setCursor(0);
                    } else if (n2 == 0) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(5);
                    } else if (n2 == 1) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(0);
                    } else if (n2 == 3) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(1);
                    } else if (n2 == 4 || n2 == 5) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(2);
                    } else if (n2 == 6) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(3);
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(0);
        this.fireDataChanged();
    }

    private void onNormalizeList(int n) {
        this.setCursor(3);
        this.data.normalizeList(n);
        this.addHistory(SlideData.normalizationString(n));
        this.fireDataChanged();
        this.setCursor(0);
    }

    private void onPrintImage() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this, printerJob.defaultPage());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        IViewer iViewer = this.getCurrentViewer();
        BufferedImage bufferedImage = iViewer.getImage();
        if (bufferedImage == null) {
            bufferedImage = this.createDefaultImage(iViewer);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d = pageFormat.getImageableWidth() / (double)bufferedImage.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)bufferedImage.getHeight();
        double d3 = Math.min(d, d2);
        affineTransform.scale(d3, d3);
        try {
            graphics2D.drawImage(bufferedImage, affineTransform, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
        return 0;
    }

    private synchronized void addAnalysisResult(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        if (defaultMutableTreeNode == null) {
            return;
        }
        System.out.println(defaultMutableTreeNode.getChildCount());
        this.viewerFrame.setVisible(true);
        this.dlist.showAnalysisTab();
        Object object2 = defaultMutableTreeNode.depthFirstEnumeration();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (object.toString() != "Expression Images") continue;
            ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode("All Clusters"));
        }
        object2 = (String)defaultMutableTreeNode.getUserObject();
        object2 = (String)object2 + " (" + this.resultCount + ")";
        ++this.resultCount;
        defaultMutableTreeNode.setUserObject(object2);
        object = (DefaultTreeModel)this.tree.getModel();
        ((DefaultTreeModel)object).insertNodeInto(defaultMutableTreeNode, this.analysisNode, this.analysisNode.getChildCount());
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        TreePath treePath = new TreePath(defaultMutableTreeNode.getFirstLeaf().getPath());
        treeSelectionModel.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
        JScrollBar jScrollBar = this.treeScrollPane.getHorizontalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.setValue(0);
        }
    }

    private void addHistory(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.historyNode, this.historyNode.getChildCount());
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        treeSelectionModel.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
        this.treeScrollPane.getHorizontalScrollBar().setValue(0);
    }

    private void onAnalysis(Action action) {
        String string = (String)action.getValue("command-parameter");
        try {
            Class<?> clazz = Class.forName(string);
            final IClusterGUI iClusterGUI = (IClusterGUI)clazz.newInstance();
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        DefaultMutableTreeNode defaultMutableTreeNode = iClusterGUI.execute(MultipleArrayViewer.this.framework);
                        MultipleArrayViewer.this.addAnalysisResult(defaultMutableTreeNode);
                    }
                    catch (AbortException abortException) {
                    }
                    catch (Exception exception) {
                        ShowThrowableDialog.show(MultipleArrayViewer.this.mainframe, "Analysis Error", false, exception);
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        }
        catch (ClassCastException classCastException) {
            System.out.println("Error: org.tigr.microarray.mev.cluster.gui.IClusterGUI interface is expected.");
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, classCastException);
        }
        catch (Exception exception) {
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, exception);
        }
    }

    private void onShowClusterInfo() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            System.err.println("Node is " + defaultMutableTreeNode);
            return;
        }
        IViewer iViewer = ((LeafInfo)defaultMutableTreeNode.getUserObject()).getViewer();
        int[] nArray = null;
        int[][] nArray2 = null;
        if (iViewer instanceof ExperimentViewer) {
            nArray = ((ExperimentViewer)iViewer).getCluster();
            nArray2 = ((ExperimentViewer)iViewer).getClusters();
        } else if (iViewer instanceof ExperimentClusterViewer) {
            nArray = ((ExperimentClusterViewer)iViewer).getCluster();
        } else if (iViewer instanceof CentroidViewer) {
            nArray = ((CentroidViewer)iViewer).getCluster();
        } else {
            return;
        }
        MicroArrayGUI microArrayGUI = new MicroArrayGUI(this.dlist, this.dlist.getViewMenu());
        String string = defaultMutableTreeNode.toString();
        String string2 = string.replaceAll("\\A.*?(\\d+)\\Z", "$1");
        if (string2.matches("\\A\\d+\\Z")) {
            Integer n = new Integer(Integer.parseInt(string2) - 1);
            microArrayGUI.createClusterTableMod(defaultMutableTreeNode.toString(), n, new Integer(nArray[0]));
        }
    }

    private void onDeleteNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.getParent() == null) {
            return;
        }
        this.fireOnCloseEvent(defaultMutableTreeNode);
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getPath());
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    private void onSetDetectionFilter() {
        SetDetectionFilterDialog setDetectionFilterDialog;
        int n = this.data.getFeaturesCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.data.getFullSampleName(i);
        }
        if (this.data.getdfSet()) {
            setDetectionFilterDialog = new SetDetectionFilterDialog(this.getFrame(), stringArray, this.data.getDetectionFilter());
        } else {
            setDetectionFilterDialog = new SetDetectionFilterDialog(this.getFrame(), stringArray);
            this.data.setdfSet(true);
        }
        if (setDetectionFilterDialog.showModal() == 0) {
            this.data.setDetectionFilter(setDetectionFilterDialog.getDetectionFilter());
            if (this.data.isDetectionFilter()) {
                this.addHistory("Detection Filter (" + this.data.getDetectionFilter() + ")");
                this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will used in subsequent analyses");
            }
        }
    }

    private void onSetFoldFilter() {
        int n = this.data.getFeaturesCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.data.getFullSampleName(i);
        }
        SetFoldFilterDialog setFoldFilterDialog = new SetFoldFilterDialog(this.getFrame(), stringArray);
        if (setFoldFilterDialog.showModal() == 0) {
            this.data.setFoldFilter(setFoldFilterDialog.getFoldFilter());
            if (this.data.isFoldFilter()) {
                this.addHistory("Fold Filter (" + this.data.getFoldFilter().toString() + ")");
                this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will used in subsequent analyses");
            }
        }
    }

    private void onSetLowerCutoffs() {
        SetLowerCutoffsDialog setLowerCutoffsDialog = new SetLowerCutoffsDialog(this.getFrame(), this.data.getLowerCY3Cutoff(), this.data.getLowerCY5Cutoff());
        if (setLowerCutoffsDialog.showModal() == 0) {
            this.data.setLowerCutoffs(setLowerCutoffsDialog.getLowerCY3Cutoff(), setLowerCutoffsDialog.getLowerCY5Cutoff());
            if (this.data.isLowerCutoffs()) {
                this.addHistory("Lower cutoffs (" + this.data.getLowerCY3Cutoff() + ", " + this.data.getLowerCY5Cutoff() + ")");
                this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will used in subsequent analyses");
            }
        }
    }

    private void onUseLowerCutoffs(AbstractButton abstractButton) {
        this.data.setUseLowerCutoffs(abstractButton.isSelected());
        if (this.data.isLowerCutoffs()) {
            this.addHistory("Lower cutoffs (" + this.data.getLowerCY3Cutoff() + ", " + this.data.getLowerCY5Cutoff() + ")");
        } else {
            this.addHistory("Lower cutoffs not used");
        }
        this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
    }

    private void onSetPercentageCutoffs() {
        SetPercentageCutoffsDialog setPercentageCutoffsDialog = new SetPercentageCutoffsDialog(this.getFrame(), this.data.getPercentageCutoff());
        if (setPercentageCutoffsDialog.showModal() == 0) {
            this.data.setPercentageCutoff(setPercentageCutoffsDialog.getPercentageCutoff());
            if (this.data.isPercentageCutoff()) {
                this.addHistory("Percentage cutoff (" + this.data.getPercentageCutoff() + "%)");
                this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
            }
        }
    }

    private void onUsePercentageCutoffs(AbstractButton abstractButton) {
        this.data.setUsePercentageCutoff(abstractButton.isSelected());
        if (this.data.isPercentageCutoff()) {
            this.addHistory("Percentage cutoff (" + this.data.getPercentageCutoff() + "%)");
        } else {
            this.addHistory("Percentage cutoffs not used");
        }
        this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
    }

    private void onUseDetectionFilter(AbstractButton abstractButton) {
        this.data.setUseDetectionFilter(abstractButton.isSelected());
        if (this.data.isDetectionFilter()) {
            this.addHistory("Detection Filter (" + this.data.getDetectionFilter() + ")");
        } else {
            this.addHistory("Detection Filter not used.");
        }
        this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
    }

    private void onUseFoldFilter(AbstractButton abstractButton) {
        this.data.setUseFoldFilter(abstractButton.isSelected());
        if (this.data.isFoldFilter()) {
            this.addHistory("Fold Filter (" + this.data.getDetectionFilter() + ")");
        } else {
            this.addHistory("Fold Filter not used.");
        }
        this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
    }

    private void onLog2Transform() {
        this.data.log2Transform();
        this.fireDataChanged();
        this.addHistory("Log2 Transform");
    }

    private void onNormalizeSpots() {
        this.data.normalizeSpots();
        this.fireDataChanged();
        this.addHistory("Normalize Spots");
    }

    private void onDivideSpotsRMS() {
        this.data.divideSpotsRMS();
        this.fireDataChanged();
        this.addHistory("Divide Spots by RMS");
    }

    private void onDivideSpotsSD() {
        this.data.divideSpotsSD();
        this.fireDataChanged();
        this.addHistory("Divide Spots by SD");
    }

    private void onMeanCenterSpots() {
        this.data.meanCenterSpots();
        this.fireDataChanged();
        this.addHistory("Mean Center Spots");
    }

    private void onMedianCenterSpots() {
        this.data.medianCenterSpots();
        this.fireDataChanged();
        this.addHistory("Median Center Spots");
    }

    private void onDigitalSpots() {
        this.data.digitalSpots();
        this.fireDataChanged();
        this.addHistory("Digital Spots");
    }

    private void onNormalizeExperiments() {
        this.data.normalizeExperiments();
        this.fireDataChanged();
        this.addHistory("Normalize Experiments");
    }

    private void onDivideExperimentsRMS() {
        this.data.divideExperimentsRMS();
        this.fireDataChanged();
        this.addHistory("Divide Experiments by RMS");
    }

    private void onDivideExperimentsSD() {
        this.data.divideExperimentsSD();
        this.fireDataChanged();
        this.addHistory("Divide Experiments by SD");
    }

    private void onMeanCenterExperiments() {
        this.data.meanCenterExperiments();
        this.fireDataChanged();
        this.addHistory("Mean Center Experiments");
    }

    private void onMedianCenterExperiments() {
        this.data.medianCenterExperiments();
        this.fireDataChanged();
        this.addHistory("Median Center Experiments");
    }

    private void onDigitalExperiments() {
        this.data.digitalExperiments();
        this.fireDataChanged();
        this.addHistory("Digital Experiments");
    }

    private void onLog10toLog2() {
        this.data.log10toLog2();
        this.fireDataChanged();
        this.addHistory("Log10 to Log2");
    }

    private void onAdjustIntensities(AbstractButton abstractButton) {
        this.data.setNonZero(abstractButton.isSelected());
        this.fireDataChanged();
    }

    private void onSaveMatrix() {
        try {
            ExperimentUtil.saveExperiment((Frame)this.mainframe, this.data.getExperiment(), this.data);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.mainframe, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetUpperLimits() {
        IDisplayMenu iDisplayMenu = this.menubar.getDisplayMenu();
        SetUpperLimitsDialog setUpperLimitsDialog = new SetUpperLimitsDialog(this.mainframe, iDisplayMenu.getMaxCY3Scale(), iDisplayMenu.getMaxCY5Scale());
        if (setUpperLimitsDialog.showModal() == 0) {
            this.menubar.setMaxCY3Scale(setUpperLimitsDialog.getUpperCY3());
            this.menubar.setMaxCY5Scale(setUpperLimitsDialog.getUpperCY5());
            this.fireMenuChanged();
        }
    }

    private void onSetRatioScale() {
        IDisplayMenu iDisplayMenu = this.menubar.getDisplayMenu();
        SetRatioScaleDialog setRatioScaleDialog = new SetRatioScaleDialog(this.mainframe, iDisplayMenu.getMaxRatioScale(), iDisplayMenu.getMinRatioScale());
        if (setRatioScaleDialog.showModal() == 0) {
            this.menubar.setMaxRatioScale(setRatioScaleDialog.getUpperRatio());
            this.menubar.setMinRatioScale(setRatioScaleDialog.getLowerRatio());
            this.fireMenuChanged();
        }
    }

    private void onDeleteAll() {
        this.data.deleteColors();
        this.geneClusterManager.deleteAllClusters();
        this.fireDataChanged();
        this.fireMenuChanged();
    }

    private void onDeleteAllExperimentClusters() {
        this.data.deleteExperimentColors();
        this.experimentClusterManager.deleteAllClusters();
        this.fireDataChanged();
        this.fireMenuChanged();
    }

    private void onShowThumbnail() {
        IViewer iViewer = this.getCurrentViewer();
        if (iViewer instanceof MultipleArrayCanvas) {
            ((MultipleArrayCanvas)iViewer).onShowThumbnail();
        }
    }

    private void onShowSupportTreeLegend() {
        JFrame jFrame = new JFrame("Support Tree Legend");
        JPanel jPanel = HCLSupportTree.getColorLegendPanel();
        jFrame.getContentPane().add(jPanel);
        jFrame.setSize(200, 300);
        jFrame.setLocation(300, 100);
        jFrame.setVisible(true);
    }

    private void selectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    private void addNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.treeScrollPane.getHorizontalScrollBar().setValue(0);
        this.fireDataChanged();
    }

    private Color storeCluster(int[] nArray, Experiment experiment, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreePath treePath = this.tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return null;
        }
        if (treePath.getPathCount() < 3) {
            return null;
        }
        Color color = null;
        String string = ((LeafInfo)defaultMutableTreeNode.getUserObject()).toString();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        String string2 = (String)defaultMutableTreeNode2.getUserObject();
        if (n == 0) {
            Cluster cluster;
            if (this.geneClusterRepository == null) {
                this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
                this.data.setGeneClusterRepository(this.geneClusterRepository);
            }
            if ((cluster = this.geneClusterRepository.storeCluster(this.resultCount - 1, string2, string, nArray, defaultMutableTreeNode, experiment)) != null) {
                color = cluster.getClusterColor();
                if (this.geneClusterManager == null) {
                    this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", this.geneClusterManager), false);
                    this.addNode(this.clusterNode, defaultMutableTreeNode3);
                } else {
                    this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
                }
            }
            this.geneClusterRepository.printRepository();
        } else {
            Cluster cluster;
            if (this.experimentClusterRepository == null) {
                this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
                this.data.setExperimentClusterRepository(this.experimentClusterRepository);
            }
            if ((cluster = this.experimentClusterRepository.storeCluster(this.resultCount - 1, string2, string, nArray, defaultMutableTreeNode, experiment)) != null) {
                color = cluster.getClusterColor();
                if (this.experimentClusterManager == null) {
                    this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new LeafInfo("Experiment Clusters", this.experimentClusterManager), false);
                    this.addNode(this.clusterNode, defaultMutableTreeNode4);
                } else {
                    this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
                }
            }
            this.experimentClusterRepository.printRepository();
        }
        this.fireDataChanged();
        this.tree.repaint();
        return color;
    }

    private Color storeSubCluster(int[] nArray, Experiment experiment, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreePath treePath = this.tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return null;
        }
        if (treePath.getPathCount() < 3) {
            return null;
        }
        Color color = null;
        String string = ((LeafInfo)defaultMutableTreeNode.getUserObject()).toString();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        String string2 = (String)defaultMutableTreeNode2.getUserObject();
        if (n == 0) {
            Cluster cluster;
            if (this.geneClusterRepository == null) {
                this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
                this.data.setGeneClusterRepository(this.geneClusterRepository);
            }
            if ((cluster = this.geneClusterRepository.storeSubCluster(this.resultCount - 1, string2, string, nArray, defaultMutableTreeNode, experiment)) != null) {
                color = cluster.getClusterColor();
                if (this.geneClusterManager == null) {
                    this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", this.geneClusterManager), false);
                    this.addNode(this.clusterNode, defaultMutableTreeNode3);
                } else {
                    this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
                }
            }
            this.geneClusterRepository.printRepository();
        } else {
            Cluster cluster;
            if (this.experimentClusterRepository == null) {
                this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
                this.data.setExperimentClusterRepository(this.experimentClusterRepository);
            }
            if ((cluster = this.experimentClusterRepository.storeSubCluster(this.resultCount - 1, string2, string, nArray, defaultMutableTreeNode, experiment)) != null) {
                color = cluster.getClusterColor();
                if (this.experimentClusterManager == null) {
                    this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new LeafInfo("Experiment Clusters", this.experimentClusterManager), false);
                    this.addNode(this.clusterNode, defaultMutableTreeNode4);
                } else {
                    this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
                }
            }
            this.experimentClusterRepository.printRepository();
        }
        this.fireDataChanged();
        this.tree.repaint();
        return color;
    }

    public void removeCluster(int[] nArray, Experiment experiment, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreePath treePath = this.tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return;
        }
        if (treePath.getPathCount() < 3) {
            return;
        }
        String string = ((LeafInfo)defaultMutableTreeNode.getUserObject()).toString();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        String string2 = (String)defaultMutableTreeNode2.getUserObject();
        if (n == 0) {
            if (this.geneClusterRepository == null) {
                return;
            }
            this.geneClusterRepository.removeCluster(nArray, string2, string);
            this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
        } else {
            if (this.experimentClusterRepository == null) {
                return;
            }
            this.experimentClusterRepository.removeCluster(nArray, string2, string);
            this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
        }
        this.fireDataChanged();
    }

    public void removeSubCluster(int[] nArray, Experiment experiment, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreePath treePath = this.tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return;
        }
        if (treePath.getPathCount() < 3) {
            return;
        }
        String string = ((LeafInfo)defaultMutableTreeNode.getUserObject()).toString();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        String string2 = (String)defaultMutableTreeNode2.getUserObject();
        if (n == 0) {
            if (this.geneClusterRepository == null) {
                return;
            }
            this.geneClusterRepository.removeSubCluster(nArray, string2, string);
            this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
        } else {
            if (this.experimentClusterRepository == null) {
                return;
            }
            this.experimentClusterRepository.removeSubCluster(nArray, string2, string);
            this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
        }
        this.fireDataChanged();
    }

    private void launchNewMAV(int[] nArray, Experiment experiment, String string, int n) {
        if (nArray.length < 1) {
            JOptionPane.showMessageDialog(this.getFrame(), "The selected cluster does not contain any members. The new viewer session has been aborted.", "New Session Abort", 2);
            return;
        }
        MultipleArrayData multipleArrayData = n == 0 ? this.data.getDataSubset(nArray) : this.data.getDataSubset(nArray, experiment.getRowMappingArrayCopy());
        Manager.createNewMultipleArrayViewer(multipleArrayData, string);
    }

    private void openClusterNode(String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNode(string, string2);
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.selectNode(defaultMutableTreeNode);
    }

    private DefaultMutableTreeNode findNode(String string, String string2) {
        Object object;
        int n;
        int n2 = this.analysisNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode = this.analysisNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (n = 0; n < n2; ++n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.analysisNode.getChildAt(n);
            object = defaultMutableTreeNode.getUserObject();
            if (object instanceof String && ((String)object).equals(string)) {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
                break;
            }
            if (!(object instanceof LeafInfo) || !((LeafInfo)object).toString().equals(string)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode;
            break;
        }
        if (defaultMutableTreeNode2 == null) {
            return null;
        }
        n2 = defaultMutableTreeNode2.getChildCount();
        for (n = 0; n < n2; ++n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n);
            object = defaultMutableTreeNode.getUserObject();
            if (object instanceof String && ((String)object).equals(string2)) {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
                break;
            }
            if (!(object instanceof LeafInfo) || !((LeafInfo)object).toString().equals(string)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode;
            break;
        }
        if (defaultMutableTreeNode2 != defaultMutableTreeNode) {
            return null;
        }
        return defaultMutableTreeNode;
    }

    public void fireDataLoaded(ISlideData[] iSlideDataArray, int n) {
        try {
            String[] stringArray = TMEV.getFieldNames();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("GB")) continue;
                gbNumberIndex = i;
                bl = true;
                i = stringArray.length;
            }
            if (!bl) {
                System.out.println("ERROR :: No file with GB# found");
                JOptionPane.showMessageDialog(null, "No GeneBank information found.  Please try again.", "Error", 0);
            } else {
                if (iSlideDataArray == null || iSlideDataArray.length < 1) {
                    return;
                }
                if (TMEV.getFieldNames() != null && this.data.getFeaturesCount() < 1) {
                    this.menubar.addLabelMenuItems(TMEV.getFieldNames());
                    this.menubar.addSortMenuItems(TMEV.getFieldNames());
                    this.menubar.setLabelIndex(0);
                }
                this.data.addFeatures(iSlideDataArray);
                this.data.setDataType(n);
                if (TMEV.getDataType() == 2) {
                    this.menubar.addAffyFilterMenuItems();
                }
                this.setMaxCY3AndCY5();
                this.systemEnable(1003);
                this.fireMenuChanged();
                this.fireDataChanged();
                this.fireHeaderChanged();
                this.dlist.enableMicroArrayMenu();
                this.dlist.getViewMenu().enableMicroArrayTabs();
                this.buildGBMap();
                currentSlide = playerSelected ? this.microArrayFunctions.getExperimentSelector().getPlayerGUI().getSlider().getValue() - 1 : this.microArrayFunctions.getExperimentSelector().getPlayerGUI().getSlider().getValue() - 1;
                numberOfSlides = this.data.getFeaturesCount() - 1;
                if (numberOfSlides < 0) {
                    this.dlist.getViewMenu().getcbExperiment().setEnabled(false);
                }
                if (numberOfSlides == 0) {
                    this.microArrayFunctions.getExperimentSelector().disablePlayerGUI();
                    this.microArrayFunctions.getExperimentSelector().disableSingleGUI();
                    this.microArrayFunctions.getExperimentSelector().getSingleModeRB().setSelected(true);
                    this.dlist.getAbstractLinearGraphics().getArrayViewer().setPlayerSelected(false);
                } else {
                    this.microArrayFunctions.getExperimentSelector().enablePlayerGUI(numberOfSlides + 1);
                    this.microArrayFunctions.getExperimentSelector().enableSingleGUI(numberOfSlides + 1);
                    this.dlist.getViewMenu().getcbExperiment().setEnabled(true);
                }
                if (!playerSelected) {
                    this.dlist.enableSaveRatioValues();
                } else {
                    this.dlist.disableSaveRatioValues();
                }
                float f = this.dlist.getAbstractLinearGraphics().getArrayViewer().getMaxRatio();
                float f2 = this.dlist.getAbstractLinearGraphics().getArrayViewer().getMinRatio();
                this.microArrayFunctions.getExpressionWidget().updateExtremeValues(f, f2);
                MultipleArrayViewer multipleArrayViewer = this.dlist.getAbstractLinearGraphics().getArrayViewer();
                this.microArrayFunctions.getExpressionWidget();
                multipleArrayViewer.setExpressionSliderMax(ExpressionSliderWidget.max.intValue());
                MultipleArrayViewer multipleArrayViewer2 = this.dlist.getAbstractLinearGraphics().getArrayViewer();
                this.microArrayFunctions.getExpressionWidget();
                multipleArrayViewer2.setExpressionSliderMin(ExpressionSliderWidget.min.intValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadData() {
        this.arrayViewerCanvas.onSelected(this.framework);
        SuperExpressionFileLoader superExpressionFileLoader = new SuperExpressionFileLoader(this);
        superExpressionFileLoader.setDlist(this.dlist);
    }

    public MultipleArrayMenubar getMenuBar() {
        return this.menubar;
    }

    public void buildGBMap() {
        Integer n;
        String string;
        Vector vector;
        Object object;
        int n2;
        gbToLocMap = new TreeMap();
        gbToColumnLocMap = new TreeMap();
        locToGbMap = new TreeMap();
        ratioToGbMap = new TreeMap();
        gbToRatioMap = new TreeMap();
        slideNames = new Hashtable();
        boolean bl = true;
        for (n2 = 0; n2 < this.data.getFeaturesCount(); ++n2) {
            object = this.getData().getFullSampleName(n2);
            if (((String)object).matches(FILE_TIME_PATTERN)) {
                object = ((String)object).replaceAll(FILE_TIME_PATTERN, "$1$2");
                vector = new JLabel((String)object);
                slideNames.put(new Integer(n2 + 1), vector);
                continue;
            }
            bl = false;
        }
        if (!bl) {
            slideNames = null;
        } else {
            this.microArrayFunctions.getExperimentSelector().getPlayerGUI().getSlider().setLabelTable(slideNames);
            this.microArrayFunctions.getExperimentSelector().getSingleSlideGUI().getSlider().setLabelTable(slideNames);
        }
        for (n2 = 0; n2 < this.data.getFeaturesSize(); ++n2) {
            string = this.data.getElementAttribute(n2, gbNumberIndex);
            if (!(string == null && string == "" || gbToLocMap.containsKey(string))) {
                n = new Integer(n2);
                object = new Float(this.getLogRatio(n, 0));
                gbToLocMap.put(string, n);
                locToGbMap.put(n, string);
                gbToRatioMap.put(string, object);
                if (!gbToColumnLocMap.containsKey(string)) {
                    gbToColumnLocMap.put(string, "0,");
                }
                if (ratioToGbMap.containsKey(object)) {
                    vector = (Vector)ratioToGbMap.get(object);
                    vector.add(string);
                    ratioToGbMap.put(object, vector);
                } else {
                    vector = new Vector();
                    vector.add(string);
                    ratioToGbMap.put(object, vector);
                }
            }
            string = null;
        }
        for (n2 = 1; n2 < this.data.getFeaturesCount(); ++n2) {
            for (int i = 0; i < this.data.getFeaturesSizeSpecific(n2); ++i) {
                string = this.data.getElementAttributeSpecific(i, gbNumberIndex, n2);
                if (string != null || string != "") {
                    if (!gbToColumnLocMap.containsKey(string)) {
                        gbToColumnLocMap.put(string, n2 + ",");
                    } else if (gbToColumnLocMap.containsKey(string)) {
                        vector = (String)gbToColumnLocMap.get(string);
                        vector = (String)((Object)vector) + n2 + ",";
                        gbToColumnLocMap.remove(string);
                        gbToColumnLocMap.put(string, vector);
                    }
                    if (!gbToLocMap.containsKey(string)) {
                        Vector vector2;
                        n = new Integer(i);
                        vector = new Float(this.getLogRatio(n, n2));
                        gbToLocMap.put(string, n);
                        locToGbMap.put(n, string);
                        gbToRatioMap.put(string, vector);
                        if (ratioToGbMap.containsKey(vector)) {
                            vector2 = (Vector)ratioToGbMap.get(vector);
                            vector2.add(string);
                            ratioToGbMap.put(vector, vector2);
                        } else {
                            vector2 = new Vector();
                            vector2.add(string);
                            ratioToGbMap.put(vector, vector2);
                        }
                    }
                }
                string = null;
            }
        }
        dataLoaded = true;
    }

    public TreeMap getGbToColumnLocMap() {
        return gbToColumnLocMap;
    }

    public void setGBNumberIndex(int n) {
        gbNumberIndex = n;
    }

    public float getLogRatio(int n, int n2) {
        return this.data.getRatio(n2, n, 1);
    }

    public int getSizeOfDataColumn(int n) {
        return this.data.getFeature(n).getSize();
    }

    public float getMaxRatio() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i <= numberOfSlides; ++i) {
            int n = this.data.getFeaturesSizeSpecific(i);
            for (int j = 0; j < n; ++j) {
                f2 = this.data.getRatio(i, j, 1);
                if (new Float(f2).isNaN()) continue;
                f = Math.max(f, f2);
            }
        }
        return f;
    }

    public float getMinRatio() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i <= numberOfSlides; ++i) {
            int n = this.data.getFeaturesSizeSpecific(i);
            for (int j = 0; j < n; ++j) {
                f2 = this.data.getRatio(i, j, 1);
                if (new Float(f2).isNaN()) continue;
                f = Math.min(f, f2);
            }
        }
        return f;
    }

    public Color getSpotColor(int n, int n2) {
        return this.arrayViewerCanvas.getColorforSlideElement(n, n2);
    }

    public Color getSpotBufferedImageColor(int n, int n2) {
        Color color = new Color(0, 0, 0);
        float f = this.getLogRatio(n, n2);
        if (f > 0.0f) {
            BufferedImage bufferedImage = this.menubar.getPositiveGradientImage();
            color = new Color(bufferedImage.getRGB(bufferedImage.getWidth() - 1, 0));
        } else if (f < 0.0f) {
            BufferedImage bufferedImage = this.menubar.getNegativeGradientImage();
            color = new Color(bufferedImage.getRGB(0, 0));
        }
        return color;
    }

    public TreeMap getGBToLocMap() {
        return gbToLocMap;
    }

    public TreeMap getLocToGbMap() {
        return locToGbMap;
    }

    public TreeMap getRatioToGbMap() {
        return ratioToGbMap;
    }

    public TreeMap getGbToRatioMap() {
        return gbToRatioMap;
    }

    public TreeMap getGbToClusterIDMap() {
        return gbToClusterID;
    }

    public TreeMap getClusterIDToIViewerMap() {
        return clusterIDToIViewer;
    }

    public TreeMap getClusterIDToIViewersMap() {
        return clusterIDToIViewers;
    }

    public JScrollPane getTreeScrollPane() {
        return this.treeScrollPane;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
    }

    public void setMicroArrayFunctions(MicroarrayFunctions microarrayFunctions) {
        this.microArrayFunctions = microarrayFunctions;
    }

    public void updateColor() {
        this.microArrayFunctions.updateColorSchema();
        needCanvasRefresh = false;
    }

    public void setHighExpressionBoundary(double d) {
        this.highExpressionBoundary = d;
    }

    public void setLowExpressionBoundary(double d) {
        this.lowExpressionBoundary = d;
    }

    public double getHighExpressionBoundary() {
        return this.highExpressionBoundary;
    }

    public double getLowExpressionBoundary() {
        return this.lowExpressionBoundary;
    }

    public void setExperimentName(String string) {
        experimentName = string;
    }

    public String getExperimentName() {
        return experimentName;
    }

    public boolean performClusterCheck() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        return this.performClusterCheck(defaultMutableTreeNode);
    }

    public boolean performClusterCheck(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        TreeNode treeNode = defaultMutableTreeNode2;
        Object var4_4 = null;
        boolean bl = false;
        try {
            while (treeNode == null || treeNode.toString() != "Analysis") {
                defaultMutableTreeNode2 = treeNode;
                treeNode = defaultMutableTreeNode2.getParent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (treeNode != null && defaultMutableTreeNode2 != null && treeNode.toString() == "Analysis") {
            Enumeration<? extends TreeNode> enumeration = defaultMutableTreeNode2.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                if (treeNode2.toString() != "Expression Images" && treeNode2.toString() != "Centroid Graphs" && treeNode2.toString() != "Expression Graphs") continue;
                bl = true;
            }
        }
        return bl;
    }

    public void showClusterInfo() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.showClusterInfo(defaultMutableTreeNode);
    }

    public void showClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        TreeNode treeNode = defaultMutableTreeNode2;
        Object var4_4 = null;
        int[][] nArray = null;
        try {
            while (treeNode == null || treeNode.toString() != "Analysis") {
                defaultMutableTreeNode2 = treeNode;
                treeNode = defaultMutableTreeNode2.getParent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (treeNode != null && defaultMutableTreeNode2 != null && treeNode.toString() == "Analysis") {
            Enumeration<? extends TreeNode> enumeration = defaultMutableTreeNode2.children();
            while (enumeration.hasMoreElements()) {
                IViewer iViewer;
                TreeNode treeNode2 = enumeration.nextElement();
                if (treeNode2.toString() != "Expression Images" && treeNode2.toString() != "Centroid Graphs" && treeNode2.toString() != "Expression Graphs") continue;
                int n = treeNode2.getIndex(defaultMutableTreeNode);
                this.storeClusterInfo(defaultMutableTreeNode);
                if (defaultMutableTreeNode.getUserObject() instanceof LeafInfo && n != -1) {
                    int[] nArray2;
                    iViewer = ((LeafInfo)defaultMutableTreeNode.getUserObject()).getViewer();
                    if (iViewer instanceof ExperimentViewer) {
                        nArray2 = ((ExperimentViewer)iViewer).getCluster();
                        nArray = ((ExperimentViewer)iViewer).getClusters();
                        this.microArrayFunctions.renderSingleCluster(nArray2, n);
                    } else if (iViewer instanceof ExperimentClusterViewer) {
                        nArray2 = ((ExperimentClusterViewer)iViewer).getCluster();
                        nArray = ((ExperimentClusterViewer)iViewer).getClusters();
                        this.microArrayFunctions.renderSingleCluster(nArray2, n);
                    } else if (iViewer instanceof CentroidViewer) {
                        nArray2 = ((CentroidViewer)iViewer).getCluster();
                        nArray = ((CentroidViewer)iViewer).getClusters();
                        this.microArrayFunctions.renderSingleCluster(nArray2, n);
                    } else if (iViewer instanceof CentroidsViewer) {
                        n = 0;
                        iViewer = ((LeafInfo)defaultMutableTreeNode.getPreviousLeaf().getUserObject()).getViewer();
                        nArray = ((CentroidViewer)iViewer).getClusters();
                        if (treeNode2.toString() == "Expression Images") {
                            this.microArrayFunctions.renderAllClusters(nArray);
                        }
                    }
                } else if (defaultMutableTreeNode.getUserObject() instanceof String && defaultMutableTreeNode.toString() == "All Clusters") {
                    n = 0;
                    iViewer = ((LeafInfo)defaultMutableTreeNode.getPreviousLeaf().getUserObject()).getViewer();
                    nArray = ((ExperimentViewer)iViewer).getClusters();
                    if (treeNode2.toString() == "Expression Images") {
                        this.microArrayFunctions.renderAllClusters(nArray);
                    }
                }
                if (this.microArrayFunctions.getAnalysisMonitor().isClustersInLegend()) continue;
                this.microArrayFunctions.addMicroarrayClustersToLegend(nArray, n);
            }
        }
    }

    public void storeClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        gbToClusterID = new TreeMap();
        clusterIDToIViewer = new TreeMap();
        clusterIDToIViewers = new TreeMap();
        if (defaultMutableTreeNode.getUserObject() instanceof LeafInfo) {
            Object object;
            Cloneable cloneable;
            IViewer iViewer = ((LeafInfo)defaultMutableTreeNode.getUserObject()).getViewer();
            int[][] nArray = null;
            if (iViewer instanceof ExperimentViewer) {
                nArray = ((ExperimentViewer)iViewer).getClusters();
            } else if (iViewer instanceof ExperimentClusterViewer) {
                nArray = ((ExperimentClusterViewer)iViewer).getClusters();
            } else if (iViewer instanceof CentroidViewer) {
                nArray = ((CentroidViewer)iViewer).getClusters();
            }
            TreeNode treeNode = defaultMutableTreeNode.getParent();
            TreeNode treeNode2 = treeNode.getParent();
            Enumeration<? extends TreeNode> enumeration = treeNode2.children();
            boolean bl = false;
            boolean bl2 = false;
            Object object2 = null;
            Object object3 = null;
            while (!(!enumeration.hasMoreElements() || bl && bl2)) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (defaultMutableTreeNode2.getChildCount() <= 0) continue;
                cloneable = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0);
                object = null;
                if (!(((DefaultMutableTreeNode)cloneable).getUserObject() instanceof LeafInfo)) continue;
                object = ((LeafInfo)((DefaultMutableTreeNode)cloneable).getUserObject()).getViewer();
                if (object instanceof ExperimentViewer) {
                    object2 = object;
                    bl = true;
                    continue;
                }
                if (object instanceof ExperimentClusterViewer) {
                    object2 = object;
                    bl = true;
                    continue;
                }
                if (!(object instanceof CentroidViewer)) continue;
                object3 = object;
                bl2 = true;
            }
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray[i].length; ++j) {
                    object = (String)this.getLocToGbMap().get(new Integer(nArray[i][j]));
                    int n = (Integer)this.getGBToLocMap().get(object);
                    gbToClusterID.put(object, new Integer(i));
                    clusterIDToIViewer.put(new Integer(i), iViewer);
                }
                cloneable = new Vector(2);
                ((Vector)cloneable).add(object2);
                ((Vector)cloneable).add(object3);
                clusterIDToIViewers.put(new Integer(i), cloneable);
            }
        }
    }

    public void unloadAllData() {
        this.dlist.getViewMenu().disableMicroArrayTabs();
        this.data = new MultipleArrayData();
        this.resetTreeScrollPane();
        dataLoaded = false;
        gbToLocMap = null;
        locToGbMap = null;
        gbToRatioMap = null;
        ratioToGbMap = null;
        gbToClusterID = null;
        clusterIDToIViewer = null;
        clusterIDToIViewers = null;
        slideNames = null;
        TMEV.setFieldNames(null);
    }

    public Map getSlideNames() {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        if (slideNames == null) {
            return treeMap;
        }
        for (Integer n : slideNames.keySet()) {
            treeMap.put(new Integer(n - 1), ((JLabel)slideNames.get(n)).getText());
        }
        return treeMap;
    }

    public void setNumSlides(int n) {
        numberOfSlides = n;
    }

    public int getNumSlides() {
        return numberOfSlides;
    }

    public int getCurrentSlide() {
        return currentSlide;
    }

    public int getSlideWith(DTDElementInstance dTDElementInstance) {
        int n = 0;
        for (int i = 0; i < this.data.getFeaturesCount(); ++i) {
            for (int j = 0; j < this.data.getFeaturesSizeSpecific(i); ++j) {
            }
        }
        return n;
    }

    public void setCurrentSlide(int n) {
        currentSlide = n;
        this.buildGBMap();
    }

    public boolean isPlayerSelected() {
        return playerSelected;
    }

    public boolean isComparisonSelected() {
        return comparisonSelected;
    }

    public void setPlayerSelected(boolean bl) {
        playerSelected = bl;
    }

    public void setComparisonSelected(boolean bl) {
        comparisonSelected = bl;
    }

    public boolean isDataLoaded() {
        return dataLoaded;
    }

    public void setExpressionSliderMax(int n) {
        this.expressionSliderMaximum = n;
    }

    public void setExpressionSliderMin(int n) {
        this.expressionSliderMinimum = n;
    }

    public int getExpressionSliderMax() {
        return this.expressionSliderMaximum;
    }

    public int getExpressionSliderMin() {
        return this.expressionSliderMinimum;
    }

    public ActionListener getActionListener() {
        TreeSelectionListener[] treeSelectionListenerArray = this.tree.getTreeSelectionListeners();
        for (int i = 0; treeSelectionListenerArray != null && i < treeSelectionListenerArray.length; ++i) {
            if (!(treeSelectionListenerArray[i] instanceof ActionListener)) continue;
            return (ActionListener)((Object)treeSelectionListenerArray[i]);
        }
        return null;
    }

    public void resetTreeScrollPane() {
        this.treeScrollPane = null;
        this.treeScrollPane = this.createTreeScrollPane(new EventListener());
        this.arrayViewerCanvas.repaint();
        this.viewerFrame.setVisible(false);
        this.viewScrollPane.setViewportView(null);
        this.viewScrollPane.setColumnHeaderView(null);
        this.viewScrollPane.setColumnHeader(null);
    }

    public Experiment getExperiment() {
        return this.framework.getData().getExperiment();
    }

    public Color getColorForSlideElement(int n, int n2) {
        return this.arrayViewerCanvas.getColorforSlideElement(n, n2);
    }

    public int[] getSelectedIndeces() {
        return this.microArrayFunctions.getExperimentSelector().getComparisonGUI().getIndecesSelected();
    }

    static {
        dataLoaded = false;
        needCanvasRefresh = false;
        numberOfSlides = 0;
        currentSlide = 0;
        playerSelected = false;
        comparisonSelected = false;
    }

    private class FrameworkImpl
    implements IFramework {
        private FrameworkImpl() {
        }

        public IData getData() {
            return MultipleArrayViewer.this.getData();
        }

        public AlgorithmFactory getAlgorithmFactory() {
            return MultipleArrayViewer.this.getAlgorithmFactory();
        }

        public IDisplayMenu getDisplayMenu() {
            return MultipleArrayViewer.this.menubar.getDisplayMenu();
        }

        public IDistanceMenu getDistanceMenu() {
            return MultipleArrayViewer.this.menubar.getDistanceMenu();
        }

        public Frame getFrame() {
            return MultipleArrayViewer.this.getFrame();
        }

        public void setContentLocation(int n, int n2) {
            MultipleArrayViewer.this.setContentLocation(n, n2);
        }

        public void displaySingleArrayViewer(int n) {
            MultipleArrayViewer.this.displaySingleArrayViewer(n);
        }

        public void displaySlideElementInfo(int n, int n2) {
            MultipleArrayViewer.this.displaySlideElementInfo(n, n2);
        }

        public String getStatusText() {
            return MultipleArrayViewer.this.getStatusText();
        }

        public void setStatusText(String string) {
            MultipleArrayViewer.this.setStatusText(string);
        }

        public Object getUserObject() {
            return MultipleArrayViewer.this.getUserObject();
        }

        public void setTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            MultipleArrayViewer.this.selectNode(defaultMutableTreeNode);
        }

        public void addNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            MultipleArrayViewer.this.addNode(defaultMutableTreeNode, defaultMutableTreeNode2);
        }

        public Color storeCluster(int[] nArray, Experiment experiment, int n) {
            return MultipleArrayViewer.this.storeCluster(nArray, experiment, n);
        }

        public Color storeSubCluster(int[] nArray, Experiment experiment, int n) {
            return MultipleArrayViewer.this.storeSubCluster(nArray, experiment, n);
        }

        public void removeSubCluster(int[] nArray, Experiment experiment, int n) {
            MultipleArrayViewer.this.removeSubCluster(nArray, experiment, n);
        }

        public void removeCluster(int[] nArray, Experiment experiment, int n) {
            MultipleArrayViewer.this.removeCluster(nArray, experiment, n);
        }

        public void launchNewMAV(int[] nArray, Experiment experiment, String string, int n) {
            MultipleArrayViewer.this.launchNewMAV(nArray, experiment, string, n);
        }

        public void openClusterNode(String string, String string2) {
            MultipleArrayViewer.this.openClusterNode(string, string2);
        }
    }

    private class EventListener
    extends MouseAdapter
    implements ActionListener,
    TreeSelectionListener,
    KeyListener,
    WindowListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("command-close")) {
                MultipleArrayViewer.this.onClose();
            } else if (string.equals("command-load")) {
                MultipleArrayViewer.this.loadData();
            } else if (string.equals("toggle-abbr-expt-names-cmd")) {
                MultipleArrayViewer.this.data.toggleExptNameLength();
                MultipleArrayViewer.this.fireDataChanged();
                MultipleArrayViewer.this.fireMenuChanged();
                MultipleArrayViewer.this.fireHeaderChanged();
                MultipleArrayViewer.this.doViewLayout();
            } else if (string.equals("display-label-cmd")) {
                MultipleArrayViewer.this.onLabelChanged((Action)actionEvent.getSource());
            } else if (string.equals("display-10x10-cmd")) {
                MultipleArrayViewer.this.onElementSizeChanged(10, 10);
            } else if (string.equals("display-20x5-cmd")) {
                MultipleArrayViewer.this.onElementSizeChanged(20, 5);
            } else if (string.equals("display-50x10-cmd")) {
                MultipleArrayViewer.this.onElementSizeChanged(50, 10);
            } else if (string.equals("display-5x2-cmd")) {
                MultipleArrayViewer.this.onElementSizeChanged(5, 2);
            } else if (string.equals("display-other-cmd")) {
                MultipleArrayViewer.this.onElementSizeChanged();
            } else if (string.equals("display-green-red-scheme-cmd")) {
                MultipleArrayViewer.this.onColorSchemeChange(5);
            } else if (string.equals("display-blue-yellow-scheme-cmd")) {
                MultipleArrayViewer.this.onColorSchemeChange(6);
            } else if (string.equals("display-custom-color-scheme-cmd")) {
                MultipleArrayViewer.this.onColorSchemeChange(7);
            } else if (string.equals("display-color-gradient-cmd")) {
                MultipleArrayViewer.this.onColorGradientChange(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            } else if (string.equals("display-green-red-cmd")) {
                MultipleArrayViewer.this.onPaletteStyleChanged(2);
            } else if (string.equals("display-gr-ratio-split-cmd")) {
                MultipleArrayViewer.this.onPaletteStyleChanged(4);
            } else if (string.equals("display-gr-overlay-cmd")) {
                MultipleArrayViewer.this.onPaletteStyleChanged(3);
            } else if (string.equals("display-tracing-cmd")) {
                MultipleArrayViewer.this.onTracing();
            } else if (string.equals("display-gr-dcale-cmd")) {
                MultipleArrayViewer.this.onGRScale();
            } else if (string.equals("display-use-antialiasing-cmd")) {
                MultipleArrayViewer.this.onAntiAliasing();
            } else if (string.equals("display-draw-borders-cmd")) {
                MultipleArrayViewer.this.onDrawBorders();
            } else if (string.equals("sort-by-location-cmd")) {
                MultipleArrayViewer.this.onSort(9000);
            } else if (string.equals("sort-by-ratio-cmd")) {
                MultipleArrayViewer.this.onSort(9001);
            } else if (string.equals("sort-label-cmd")) {
                MultipleArrayViewer.this.onSort((Action)actionEvent.getSource());
            } else if (string.equals("system-info-cmd")) {
                MultipleArrayViewer.this.onSystemInfo();
            } else if (string.equals("default-distances-cmd")) {
                MultipleArrayViewer.this.onDefaultDistance();
            } else if (string.equals("total-intensity-cmd")) {
                MultipleArrayViewer.this.onNormalize(1);
            } else if (string.equals("linear-regression-cmd")) {
                MultipleArrayViewer.this.onNormalize(3);
            } else if (string.equals("ratio-statistics-cmd")) {
                MultipleArrayViewer.this.onNormalize(5);
            } else if (string.equals("iterative-log-cmd")) {
                MultipleArrayViewer.this.onNormalize(6);
            } else if (string.equals("total-intensity-list-cmd")) {
                MultipleArrayViewer.this.onNormalizeList(101);
            } else if (string.equals("linear-regression-list-cmd")) {
                MultipleArrayViewer.this.onNormalizeList(103);
            } else if (string.equals("ratio-statistics-list-cmd")) {
                MultipleArrayViewer.this.onNormalizeList(105);
            } else if (string.equals("iterative-log-list-cmd")) {
                MultipleArrayViewer.this.onNormalizeList(106);
            } else if (string.equals("no-normalization-cmd")) {
                MultipleArrayViewer.this.onNormalize(0);
            } else if (string.equals("command-save-image")) {
                MultipleArrayViewer.this.onSaveImage();
            } else if (string.equals("command-print-image")) {
                MultipleArrayViewer.this.onPrintImage();
            } else if (string.equals("analysis-command")) {
                MultipleArrayViewer.this.onAnalysis((Action)actionEvent.getSource());
            } else if (string.equals("default-distance-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(0);
            } else if (string.equals("pearson-correlation-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(1);
            } else if (string.equals("pearson-uncentered-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(6);
            } else if (string.equals("pearson-squared-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(7);
            } else if (string.equals("cosine-correlation-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(2);
            } else if (string.equals("covariance-value-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(3);
            } else if (string.equals("euclidean-distance-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(4);
            } else if (string.equals("average-dot-product-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(5);
            } else if (string.equals("manhattan-distance-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(8);
            } else if (string.equals("mutual-information-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(11);
            } else if (string.equals("spearman-rank-correlation-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(9);
            } else if (string.equals("kendalls-tau-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceFunction(10);
            } else if (string.equals("absolute-distance-cmd")) {
                MultipleArrayViewer.this.menubar.setDistanceAbsolute(((AbstractButton)actionEvent.getSource()).isSelected());
            } else if (string.equals("delete-node-cmd")) {
                MultipleArrayViewer.this.onDeleteNode();
            } else if (string.equals("set-lower-cutoffs-cmd")) {
                MultipleArrayViewer.this.onSetLowerCutoffs();
            } else if (string.equals("set-percentage-cutoffs-cmd")) {
                MultipleArrayViewer.this.onSetPercentageCutoffs();
            } else if (string.equals("use-percentage-cutoffs-cmd")) {
                MultipleArrayViewer.this.onUsePercentageCutoffs((AbstractButton)actionEvent.getSource());
            } else if (string.equals("use-lower-cutoffs-cmd")) {
                MultipleArrayViewer.this.onUseLowerCutoffs((AbstractButton)actionEvent.getSource());
            } else if (string.equals("set-detection-filter-cmd")) {
                MultipleArrayViewer.this.onSetDetectionFilter();
            } else if (string.equals("set-fold-filter-cmd")) {
                MultipleArrayViewer.this.onSetFoldFilter();
            } else if (string.equals("use-detection-filter-cmd")) {
                MultipleArrayViewer.this.onUseDetectionFilter((AbstractButton)actionEvent.getSource());
            } else if (string.equals("use-fold-filter-cmd")) {
                MultipleArrayViewer.this.onUseFoldFilter((AbstractButton)actionEvent.getSource());
            } else if (string.equals("log2-transform-cmd")) {
                MultipleArrayViewer.this.onLog2Transform();
            } else if (string.equals("normalize-spots-cmd")) {
                MultipleArrayViewer.this.onNormalizeSpots();
            } else if (string.equals("divide-spots-rms-cmd")) {
                MultipleArrayViewer.this.onDivideSpotsRMS();
            } else if (string.equals("divide-spots-sd-cmd")) {
                MultipleArrayViewer.this.onDivideSpotsSD();
            } else if (string.equals("mean-center-spots-cmd")) {
                MultipleArrayViewer.this.onMeanCenterSpots();
            } else if (string.equals("median-center-spots-cmd")) {
                MultipleArrayViewer.this.onMedianCenterSpots();
            } else if (string.equals("digital-spots-cmd")) {
                MultipleArrayViewer.this.onDigitalSpots();
            } else if (string.equals("normalize-experiments-cmd")) {
                MultipleArrayViewer.this.onNormalizeExperiments();
            } else if (string.equals("divide-experiments-rms-cmd")) {
                MultipleArrayViewer.this.onDivideExperimentsRMS();
            } else if (string.equals("divide-experiments-sd-cmd")) {
                MultipleArrayViewer.this.onDivideExperimentsSD();
            } else if (string.equals("mean-center-experiments-cmd")) {
                MultipleArrayViewer.this.onMeanCenterExperiments();
            } else if (string.equals("median-center-experiments-cmd")) {
                MultipleArrayViewer.this.onMedianCenterExperiments();
            } else if (string.equals("digital-experiments-cmd")) {
                MultipleArrayViewer.this.onDigitalExperiments();
            } else if (string.equals("log10-to-log2-cmd")) {
                MultipleArrayViewer.this.onLog10toLog2();
            } else if (string.equals("adjust-intensities-0-cmd")) {
                MultipleArrayViewer.this.onAdjustIntensities((AbstractButton)actionEvent.getSource());
            } else if (string.equals("command-save-matrix")) {
                MultipleArrayViewer.this.onSaveMatrix();
            } else if (string.equals("display-set-upper-limits-cmd")) {
                MultipleArrayViewer.this.onSetUpperLimits();
            } else if (string.equals("display-set-ratio-scale-cmd")) {
                MultipleArrayViewer.this.onSetRatioScale();
            } else if (string.equals("delete-all-experiments-cmd")) {
                MultipleArrayViewer.this.onDeleteAllExperimentClusters();
            } else if (string.equals("delete-all-cmd")) {
                MultipleArrayViewer.this.onDeleteAll();
            } else if (string.equals("show-thumbnail-cmd")) {
                MultipleArrayViewer.this.onShowThumbnail();
            } else if (string.equals("show-supporttree-legend-command")) {
                MultipleArrayViewer.this.onShowSupportTreeLegend();
            } else if (string.equals(MicroArrayGUI.CLUSTER_HTML_CMD)) {
                MultipleArrayViewer.this.onShowClusterInfo();
            } else {
                System.out.println("unhandled command = " + string);
            }
            MultipleArrayViewer.this.arrayViewerCanvas.onSelected(MultipleArrayViewer.this.framework);
            if (needCanvasRefresh) {
                MultipleArrayViewer.this.updateColor();
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            MultipleArrayViewer.this.onNodeChanged(treeSelectionEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            TreePath treePath = MultipleArrayViewer.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            MultipleArrayViewer.this.tree.setSelectionPaths(new TreePath[]{treePath});
            JPopupMenu jPopupMenu = null;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof LeafInfo) {
                jPopupMenu = ((LeafInfo)object).getJPopupMenu();
            }
            if (treePath.getPathCount() > 2) {
                if (defaultMutableTreeNode.getParent() == MultipleArrayViewer.this.clusterNode) {
                    return;
                }
                if (jPopupMenu == null) {
                    jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(this.createDeleteMenuItem());
                    jPopupMenu.add(this.createClusterInfoMenuItem());
                } else if (!this.isContainsDeleteItem(jPopupMenu)) {
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(this.createDeleteMenuItem());
                    jPopupMenu.add(this.createClusterInfoMenuItem());
                }
            }
            if (jPopupMenu != null) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private JMenuItem createClusterInfoMenuItem() {
            JMenuItem jMenuItem = new JMenuItem("Show Cluster Info");
            jMenuItem.setActionCommand(MicroArrayGUI.CLUSTER_HTML_CMD);
            jMenuItem.addActionListener(this);
            return jMenuItem;
        }

        private JMenuItem createDeleteMenuItem() {
            JMenuItem jMenuItem = new JMenuItem("Delete");
            jMenuItem.setActionCommand("delete-node-cmd");
            jMenuItem.addActionListener(this);
            return jMenuItem;
        }

        private boolean isContainsDeleteItem(JPopupMenu jPopupMenu) {
            Component[] componentArray = jPopupMenu.getComponents();
            int n = componentArray.length;
            while (--n >= 0) {
                if (!(componentArray[n] instanceof JMenuItem) || !((JMenuItem)componentArray[n]).getActionCommand().equals("delete-node-cmd")) continue;
                return true;
            }
            return false;
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            MultipleArrayViewer.this.onClose();
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

