/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.TDistribution;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.Combinations;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class Ttest
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    private Vector[] clusters;
    private int k;
    private int numGenes;
    private int numExps;
    private float alpha;
    private int significanceMethod;
    private boolean isPermut;
    int[] groupAssignments;
    private int numCombs;
    boolean useAllCombs;
    double currentP = 0.0;
    double currentT = 0.0;
    int currentIndex = 0;
    Vector sigTValues = new Vector();
    Vector sigPValues = new Vector();
    Vector nonSigTValues = new Vector();
    Vector nonSigPValues = new Vector();
    Vector tValuesVector = new Vector();
    Vector pValuesVector = new Vector();
    int validN;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        int n2;
        this.groupAssignments = algorithmData.getIntArray("group-assignments");
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n3 = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.alpha = algorithmParameters.getFloat("alpha", 0.01f);
        this.significanceMethod = algorithmParameters.getInt("significance-method", 4);
        this.isPermut = algorithmParameters.getBoolean("is-permut", false);
        this.numCombs = algorithmParameters.getInt("num-combs", 100);
        this.useAllCombs = algorithmParameters.getBoolean("use-all-combs", false);
        Vector vector = new Vector();
        vector = this.isPermut ? this.sortGenesByPermutationSignificance() : this.sortGenesBySignificance();
        this.k = vector.size();
        FloatMatrix floatMatrix = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            floatMatrix.A[i][0] = 0.0f;
        }
        Vector vector2 = (Vector)vector.get(0);
        for (int i = 0; i < vector2.size(); ++i) {
            int n4 = (Integer)vector2.get(i);
            floatMatrix.A[n4][0] = 1.0f;
        }
        FloatMatrix floatMatrix2 = new FloatMatrix(this.tValuesVector.size(), 1);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.pValuesVector.size(), 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(this.numGenes, 1);
        for (n2 = 0; n2 < this.tValuesVector.size(); ++n2) {
            floatMatrix2.A[n2][0] = Math.abs(((Float)this.tValuesVector.get(n2)).floatValue());
        }
        for (n2 = 0; n2 < this.pValuesVector.size(); ++n2) {
            floatMatrix3.A[n2][0] = ((Float)this.pValuesVector.get(n2)).floatValue();
        }
        for (n2 = 0; n2 < this.numGenes; ++n2) {
            floatMatrix4.A[n2][0] = this.getDF(n2);
        }
        FloatMatrix floatMatrix5 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix6 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix7 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix8 = new FloatMatrix(this.numGenes, 1);
        Vector vector3 = this.getMeansAndSDs();
        float[] fArray = (float[])vector3.get(0);
        float[] fArray2 = (float[])vector3.get(1);
        float[] fArray3 = (float[])vector3.get(2);
        float[] fArray4 = (float[])vector3.get(3);
        for (n = 0; n < this.numGenes; ++n) {
            floatMatrix5.A[n][0] = fArray[n];
            floatMatrix6.A[n][0] = fArray2[n];
            floatMatrix7.A[n][0] = fArray3[n];
            floatMatrix8.A[n][0] = fArray4[n];
        }
        this.clusters = new Vector[this.k];
        for (n = 0; n < this.k; ++n) {
            this.clusters[n] = (Vector)vector.get(n);
        }
        FloatMatrix floatMatrix9 = this.getMeans(this.clusters);
        FloatMatrix floatMatrix10 = this.getVariances(this.clusters, floatMatrix9);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent(this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, n3, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData2.addMatrix("clusters_means", floatMatrix9);
        algorithmData2.addMatrix("clusters_variances", floatMatrix10);
        algorithmData2.addMatrix("pValues", floatMatrix3);
        algorithmData2.addMatrix("tValues", floatMatrix2);
        algorithmData2.addMatrix("dfValues", floatMatrix4);
        algorithmData2.addMatrix("meansAMatrix", floatMatrix5);
        algorithmData2.addMatrix("meansBMatrix", floatMatrix6);
        algorithmData2.addMatrix("sdAMatrix", floatMatrix7);
        algorithmData2.addMatrix("sdBMatrix", floatMatrix8);
        algorithmData2.addMatrix("isSigMatrix", floatMatrix);
        return algorithmData2;
    }

    public void abort() {
        this.stop = true;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.getSubExperiment(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-function", String.valueOf(this.function));
        algorithmData2.addParam("distance-absolute", String.valueOf(this.absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.numExps);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.numExps);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get((Integer)vector.get(j), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get((Integer)vector.get(i), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }

    private Vector sortGenesBySignificance() throws AlgorithmException {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.significanceMethod == 4 || this.significanceMethod == 5) {
            vector = new Vector();
            vector2 = new Vector();
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                if (this.isSignificant(i)) {
                    vector.add(new Integer(i));
                    this.sigTValues.add(new Float(this.currentT));
                    this.sigPValues.add(new Float(this.currentP));
                    this.tValuesVector.add(new Float(this.currentT));
                    this.pValuesVector.add(new Float(this.currentP));
                    continue;
                }
                vector2.add(new Integer(i));
                this.nonSigTValues.add(new Float(this.currentT));
                this.nonSigPValues.add(new Float(this.currentP));
                this.tValuesVector.add(new Float(this.currentT));
                this.pValuesVector.add(new Float(this.currentP));
            }
        } else if (this.significanceMethod == 6) {
            int n;
            vector = new Vector();
            vector2 = new Vector();
            float[] fArray = new float[this.numGenes];
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                fArray[i] = Math.abs(this.getTValue(i));
            }
            QSort qSort = new QSort(fArray);
            float[] fArray2 = qSort.getSorted();
            int[] nArray = qSort.getOrigIndx();
            double d = this.alpha;
            int n2 = this.numGenes;
            int n3 = 0;
            double d2 = Double.POSITIVE_INFINITY;
            double[] dArray = new double[this.numGenes];
            double[] dArray2 = new double[this.numGenes];
            for (n = fArray2.length - 1; n > 0; --n) {
                n3 = this.getDF(nArray[n]);
                if (Float.isNaN(fArray2[n]) || Float.isNaN(new Integer(n3).floatValue()) || n3 <= 0) {
                    vector2.add(new Integer(nArray[n]));
                    this.nonSigTValues.add(new Float(fArray2[n]));
                    this.nonSigPValues.add(new Float(Float.NaN));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = Double.NaN;
                    continue;
                }
                TDistribution tDistribution = new TDistribution(n3);
                double d3 = tDistribution.cumulative(fArray2[n]);
                d2 = 2.0 * (1.0 - d3);
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                if (d2 <= (d = (double)this.alpha / (double)n2)) {
                    vector.add(new Integer(nArray[n]));
                    this.sigTValues.add(new Float(fArray2[n]));
                    this.sigPValues.add(new Float(d2));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = d2;
                } else {
                    vector2.add(new Integer(nArray[n]));
                    this.nonSigTValues.add(new Float(fArray2[n]));
                    this.nonSigPValues.add(new Float(d2));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = d2;
                }
                if (!(fArray2[n] > fArray2[n - 1]) || --n2 >= 1) continue;
                System.out.println("Warning: denomAlpha = " + n2);
            }
            n3 = this.getDF(nArray[0]);
            if (Float.isNaN(fArray2[0]) || Float.isNaN(new Integer(n3).floatValue()) || n3 <= 0) {
                vector2.add(new Integer(nArray[0]));
                this.nonSigTValues.add(new Float(fArray2[0]));
                this.nonSigPValues.add(new Float(Float.NaN));
                dArray[nArray[0]] = fArray2[0];
                dArray2[nArray[0]] = Double.NaN;
            } else {
                TDistribution tDistribution = new TDistribution(n3);
                double d4 = tDistribution.cumulative(fArray2[0]);
                d2 = 2.0 * (1.0 - d4);
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                if (d2 <= (d = (double)this.alpha / (double)n2)) {
                    vector.add(new Integer(nArray[0]));
                    this.sigTValues.add(new Float(fArray2[0]));
                    this.sigPValues.add(new Float(d2));
                    dArray[nArray[0]] = fArray2[0];
                    dArray2[nArray[0]] = d2;
                } else {
                    vector2.add(new Integer(nArray[0]));
                    this.nonSigTValues.add(new Float(fArray2[0]));
                    this.nonSigPValues.add(new Float(d2));
                    dArray[nArray[0]] = fArray2[0];
                    dArray2[nArray[0]] = d2;
                }
            }
            this.tValuesVector = new Vector();
            this.pValuesVector = new Vector();
            for (n = 0; n < dArray.length; ++n) {
                this.tValuesVector.add(new Float(dArray[n]));
                this.pValuesVector.add(new Float(dArray2[n]));
            }
        }
        Vector<Vector<Integer>> vector3 = new Vector<Vector<Integer>>();
        vector3.add(vector);
        vector3.add(vector2);
        return vector3;
    }

    private Vector sortGenesByPermutationSignificance() throws AlgorithmException {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.significanceMethod == 4 || this.significanceMethod == 5) {
            vector = new Vector();
            vector2 = new Vector();
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                if (this.isSignificantByPermutation(i)) {
                    vector.add(new Integer(i));
                    this.sigTValues.add(new Float(this.currentT));
                    this.sigPValues.add(new Float(this.currentP));
                    this.tValuesVector.add(new Float(this.currentT));
                    this.pValuesVector.add(new Float(this.currentP));
                    continue;
                }
                vector2.add(new Integer(i));
                this.nonSigTValues.add(new Float(this.currentT));
                this.nonSigPValues.add(new Float(this.currentP));
                this.tValuesVector.add(new Float(this.currentT));
                this.pValuesVector.add(new Float(this.currentP));
            }
        } else if (this.significanceMethod == 6) {
            int n;
            vector = new Vector();
            vector2 = new Vector();
            float[] fArray = new float[this.numGenes];
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                fArray[i] = Math.abs(this.getTValue(i));
            }
            QSort qSort = new QSort(fArray);
            float[] fArray2 = qSort.getSorted();
            int[] nArray = qSort.getOrigIndx();
            double d = this.alpha;
            int n2 = this.numGenes;
            double d2 = Double.POSITIVE_INFINITY;
            double[] dArray = new double[this.numGenes];
            double[] dArray2 = new double[this.numGenes];
            for (n = fArray2.length - 1; n > 0; --n) {
                if (Float.isNaN(fArray2[n])) {
                    vector2.add(new Integer(nArray[n]));
                    this.nonSigTValues.add(new Float(fArray2[n]));
                    this.nonSigPValues.add(new Float(Float.NaN));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = Double.NaN;
                    continue;
                }
                d2 = this.getPermutedProb(nArray[n]);
                if (d2 <= (d = (double)this.alpha / (double)n2)) {
                    vector.add(new Integer(nArray[n]));
                    this.sigTValues.add(new Float(this.currentT));
                    this.sigPValues.add(new Float(d2));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = d2;
                } else {
                    vector2.add(new Integer(nArray[n]));
                    this.nonSigTValues.add(new Float(this.currentT));
                    this.nonSigPValues.add(new Float(d2));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = d2;
                }
                if (!(fArray2[n] > fArray2[n - 1]) || --n2 >= 1) continue;
                System.out.println("Warning: denomAlpha = " + n2);
            }
            if (Float.isNaN(fArray2[0])) {
                vector2.add(new Integer(nArray[0]));
                this.nonSigTValues.add(new Float(fArray2[0]));
                this.nonSigPValues.add(new Float(Float.NaN));
                dArray[nArray[0]] = fArray2[0];
                dArray2[nArray[0]] = Double.NaN;
            } else {
                d2 = this.getPermutedProb(nArray[0]);
                if (d2 <= (d = (double)this.alpha / (double)n2)) {
                    vector.add(new Integer(nArray[0]));
                    this.sigTValues.add(new Float(this.currentT));
                    this.sigPValues.add(new Float(d2));
                    dArray[nArray[0]] = fArray2[0];
                    dArray2[nArray[0]] = d2;
                } else {
                    vector2.add(new Integer(nArray[0]));
                    this.nonSigTValues.add(new Float(this.currentT));
                    this.nonSigPValues.add(new Float(d2));
                    dArray[nArray[0]] = fArray2[0];
                    dArray2[nArray[0]] = d2;
                }
            }
            this.tValuesVector = new Vector();
            this.pValuesVector = new Vector();
            for (n = 0; n < dArray.length; ++n) {
                this.tValuesVector.add(new Float(dArray[n]));
                this.pValuesVector.add(new Float(dArray2[n]));
            }
        }
        Vector<Vector<Integer>> vector3 = new Vector<Vector<Integer>>();
        vector3.add(vector);
        vector3.add(vector2);
        return vector3;
    }

    private double getPermutedProb(int n) {
        int n2;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = this.expMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        int[] nArray = new int[n2 + n3];
        n2 = 0;
        n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                ++n2;
                nArray[n4] = i;
                ++n4;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            ++n3;
            nArray[n4] = i;
            ++n4;
        }
        float f = Math.abs(this.calculateTValue(fArray2, fArray3));
        this.currentT = f;
        double d = 0.0;
        if (this.useAllCombs) {
            int n5 = 0;
            int[] nArray2 = new int[fArray2.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = -1;
            }
            while (Combinations.enumerateCombinations(nArray.length, fArray2.length, nArray2)) {
                int n6;
                float[] fArray4 = new float[fArray2.length];
                float[] fArray5 = new float[fArray3.length];
                int[] nArray3 = new int[fArray3.length];
                int n7 = 0;
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    if (this.belongsInArray(n6, nArray2)) continue;
                    nArray3[n7] = n6;
                    ++n7;
                }
                for (n6 = 0; n6 < nArray2.length; ++n6) {
                    fArray4[n6] = fArray[nArray[nArray2[n6]]];
                }
                for (n6 = 0; n6 < nArray3.length; ++n6) {
                    fArray5[n6] = fArray[nArray[nArray3[n6]]];
                }
                float f2 = Math.abs(this.calculateTValue(fArray4, fArray5));
                if (f < f2) {
                    d += 1.0;
                }
                ++n5;
            }
            d /= (double)n5;
        } else {
            int n8 = 0;
            d = 0.0;
            for (int i = 0; i < this.numCombs; ++i) {
                float[][] fArray6 = this.randomlyPermute(fArray, nArray, fArray2.length, fArray3.length);
                float f3 = Math.abs(this.calculateTValue(fArray6[0], fArray6[1]));
                if (f < f3) {
                    d += 1.0;
                }
                ++n8;
            }
            d /= (double)n8;
        }
        this.currentP = d;
        return d;
    }

    private boolean isSignificantByPermutation(int n) {
        int n2;
        boolean bl = false;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = this.expMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        int[] nArray = new int[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        n2 = 0;
        n3 = 0;
        int n6 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                if (!Float.isNaN(fArray[i])) {
                    ++n4;
                }
                ++n2;
                nArray[n6] = i;
                ++n6;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            if (!Float.isNaN(fArray[i])) {
                ++n5;
            }
            ++n3;
            nArray[n6] = i;
            ++n6;
        }
        if (n4 < 2 || n5 < 2) {
            this.currentP = Double.NaN;
            this.currentT = Double.NaN;
            return false;
        }
        float f = Math.abs(this.calculateTValue(fArray2, fArray3));
        this.currentT = f;
        double d = 0.0;
        double d2 = 0.0;
        if (this.significanceMethod == 4) {
            d2 = this.alpha;
        } else if (this.significanceMethod == 5) {
            d2 = (double)this.alpha / (double)this.numGenes;
        }
        if (Float.isNaN(f)) {
            bl = false;
            this.currentP = Double.NaN;
            return bl;
        }
        if (this.useAllCombs) {
            int n7 = 0;
            int[] nArray2 = new int[fArray2.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = -1;
            }
            while (Combinations.enumerateCombinations(nArray.length, fArray2.length, nArray2)) {
                int n8;
                float[] fArray4 = new float[fArray2.length];
                float[] fArray5 = new float[fArray3.length];
                int[] nArray3 = new int[fArray3.length];
                int n9 = 0;
                for (n8 = 0; n8 < nArray.length; ++n8) {
                    if (this.belongsInArray(n8, nArray2)) continue;
                    nArray3[n9] = n8;
                    ++n9;
                }
                for (n8 = 0; n8 < nArray2.length; ++n8) {
                    fArray4[n8] = fArray[nArray[nArray2[n8]]];
                }
                for (n8 = 0; n8 < nArray3.length; ++n8) {
                    fArray5[n8] = fArray[nArray[nArray3[n8]]];
                }
                float f2 = Math.abs(this.calculateTValue(fArray4, fArray5));
                if (f < f2) {
                    d += 1.0;
                }
                ++n7;
            }
            this.currentP = d /= (double)n7;
            if (d <= d2) {
                bl = true;
            }
            return bl;
        }
        int n10 = 0;
        d = 0.0;
        for (int i = 0; i < this.numCombs; ++i) {
            float[][] fArray6 = this.randomlyPermute(fArray, nArray, fArray2.length, fArray3.length);
            float f3 = Math.abs(this.calculateTValue(fArray6[0], fArray6[1]));
            if (f < f3) {
                d += 1.0;
            }
            ++n10;
        }
        this.currentP = d /= (double)n10;
        if (d <= d2) {
            bl = true;
        }
        return bl;
    }

    private float[][] randomlyPermute(float[] fArray, int[] nArray, int n, int n2) {
        int n3;
        int n4;
        float[][] fArrayArray = new float[][]{new float[n], new float[n2]};
        if (n > n2) {
            fArrayArray[0] = new float[n2];
            fArrayArray[1] = new float[n];
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (n4 = 0; n4 < nArray.length; ++n4) {
            vector.add(new Integer(nArray[n4]));
        }
        for (n4 = 0; n4 < fArrayArray[0].length; ++n4) {
            n3 = (int)Math.round(Math.random() * (double)(vector.size() - 1));
            int n5 = (Integer)vector.remove(n3);
            fArrayArray[0][n4] = fArray[n5];
        }
        for (n4 = 0; n4 < fArrayArray[1].length; ++n4) {
            n3 = (Integer)vector.get(n4);
            fArrayArray[1][n4] = fArray[n3];
        }
        return fArrayArray;
    }

    private float[][] randomlyPermute2(float[] fArray, int[] nArray, int n, int n2) {
        int n3;
        float[][] fArrayArray = new float[][]{new float[n], new float[n2]};
        boolean[] blArray = new boolean[nArray.length];
        for (n3 = 0; n3 < blArray.length; ++n3) {
            blArray[n3] = false;
        }
        n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            Random random = new Random();
            int n5 = random.nextInt(nArray.length);
            if (blArray[n5]) continue;
            fArrayArray[0][n3] = fArray[nArray[n5]];
            blArray[n5] = true;
            ++n3;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (blArray[i]) continue;
            fArrayArray[1][n4] = fArray[nArray[i]];
            ++n4;
        }
        return fArrayArray;
    }

    private boolean belongsInArray(int n, int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private float getTValue(int n) {
        int n2;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = this.expMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        n2 = 0;
        n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            ++n3;
        }
        float f = this.calculateTValue(fArray2, fArray3);
        return f;
    }

    private int getDF(int n) {
        int n2;
        int n3;
        float[] fArray = new float[this.numExps];
        for (n3 = 0; n3 < this.numExps; ++n3) {
            fArray[n3] = this.expMatrix.A[n][n3];
        }
        n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n3;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n4;
        }
        float[] fArray2 = new float[n3];
        float[] fArray3 = new float[n4];
        n3 = 0;
        n4 = 0;
        for (n2 = 0; n2 < this.groupAssignments.length; ++n2) {
            if (this.groupAssignments[n2] == 1) {
                fArray2[n3] = fArray[n2];
                ++n3;
                continue;
            }
            if (this.groupAssignments[n2] != 2) continue;
            fArray3[n4] = fArray[n2];
            ++n4;
        }
        n2 = this.calculateDf(fArray2, fArray3);
        return n2;
    }

    private Vector getMeansAndSDs() {
        float[] fArray = new float[this.numGenes];
        float[] fArray2 = new float[this.numGenes];
        float[] fArray3 = new float[this.numGenes];
        float[] fArray4 = new float[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            int n;
            float[] fArray5 = new float[this.numExps];
            for (n = 0; n < this.numExps; ++n) {
                fArray5[n] = this.expMatrix.A[i][n];
            }
            n = 0;
            int n2 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] == 1) {
                    ++n;
                    continue;
                }
                if (this.groupAssignments[j] != 2) continue;
                ++n2;
            }
            float[] fArray6 = new float[n];
            float[] fArray7 = new float[n2];
            n = 0;
            n2 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] == 1) {
                    fArray6[n] = fArray5[j];
                    ++n;
                    continue;
                }
                if (this.groupAssignments[j] != 2) continue;
                fArray7[n2] = fArray5[j];
                ++n2;
            }
            fArray[i] = this.getMean(fArray6);
            fArray2[i] = this.getMean(fArray7);
            fArray3[i] = (float)Math.sqrt(this.getVar(fArray6));
            fArray4[i] = (float)Math.sqrt(this.getVar(fArray7));
        }
        Vector<float[]> vector = new Vector<float[]>();
        vector.add(fArray);
        vector.add(fArray2);
        vector.add(fArray3);
        vector.add(fArray4);
        return vector;
    }

    private boolean isSignificant(int n) {
        int n2;
        boolean bl = false;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = this.expMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        int n4 = 0;
        int n5 = 0;
        n2 = 0;
        n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                if (!Float.isNaN(fArray[i])) {
                    ++n4;
                }
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            if (!Float.isNaN(fArray[i])) {
                ++n5;
            }
            ++n3;
        }
        if (n4 < 2 || n5 < 2) {
            this.currentP = Double.NaN;
            this.currentT = Double.NaN;
            return false;
        }
        float f = this.calculateTValue(fArray2, fArray3);
        this.currentT = f;
        int n6 = this.calculateDf(fArray2, fArray3);
        if (!this.isPermut) {
            if (Float.isNaN(f) || Float.isNaN(new Integer(n6).floatValue()) || n6 <= 0) {
                bl = false;
                this.currentP = Double.NaN;
            } else {
                TDistribution tDistribution = new TDistribution(n6);
                double d = tDistribution.cumulative(f);
                double d2 = 2.0 * (1.0 - d);
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                this.currentP = d2;
                if (this.significanceMethod == 4) {
                    bl = d2 <= (double)this.alpha;
                } else if (this.significanceMethod == 5) {
                    double d3 = (double)this.alpha / (double)this.numGenes;
                    bl = d2 <= d3;
                }
            }
        }
        return bl;
    }

    private float calculateTValue(float[] fArray, float[] fArray2) {
        int n;
        int n2 = fArray.length;
        int n3 = fArray2.length;
        float f = this.getMean(fArray);
        float f2 = this.getMean(fArray2);
        float f3 = this.getVar(fArray);
        float f4 = this.getVar(fArray2);
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            ++n4;
        }
        for (n = 0; n < fArray2.length; ++n) {
            if (Float.isNaN(fArray2[n])) continue;
            ++n5;
        }
        if (n4 < 2 || n5 < 2) {
            return Float.NaN;
        }
        float f5 = (float)((double)(f - f2) / Math.sqrt(f3 / (float)n2 + f4 / (float)n3));
        return Math.abs(f5);
    }

    private int calculateDf(float[] fArray, float[] fArray2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            ++n2;
        }
        for (n = 0; n < fArray2.length; ++n) {
            if (Float.isNaN(fArray2[n])) continue;
            ++n3;
        }
        float f = this.getMean(fArray);
        float f2 = this.getMean(fArray2);
        float f3 = this.getVar(fArray);
        float f4 = this.getVar(fArray2);
        float f5 = (float)Math.pow(f3 / (float)n2 + f4 / (float)n3, 2.0);
        float f6 = (float)(Math.pow(f3 / (float)n2, 2.0) / (double)(n2 - 1) + Math.pow(f4 / (float)n3, 2.0) / (double)(n3 - 1));
        int n4 = Math.round(f5 / f6);
        return n4;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f += fArray[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float f2 = f / (float)n;
        if (Float.isInfinite(f2)) {
            return Float.NaN;
        }
        return f2;
    }

    private float getVar(float[] fArray) {
        float f = this.getMean(fArray);
        int n = 0;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f2 = (float)((double)f2 + Math.pow(fArray[i] - f, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float f3 = f2 / (float)(n - 1);
        if (Float.isInfinite(f3)) {
            return Float.NaN;
        }
        return f3;
    }
}

