/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.awt.Container;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterAttributesDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class ClusterRepository
extends Vector {
    public static final int GENE_CLUSTER = 0;
    public static final int EXPERIMENT_CLUSTER = 1;
    private int numberOfElements;
    private ClusterList[] elementClusters;
    private int clusterSerialCounter = 0;
    private boolean geneClusterRepository = false;
    private IFramework framework;

    public ClusterRepository(int n, IFramework iFramework) {
        this.numberOfElements = n;
        this.elementClusters = new ClusterList[n];
        this.addClusterList(new ClusterList("Cluster Ops."));
        this.framework = iFramework;
    }

    public ClusterRepository(int n, IFramework iFramework, boolean bl) {
        this.numberOfElements = n;
        this.elementClusters = new ClusterList[n];
        this.geneClusterRepository = bl;
        this.addClusterList(new ClusterList("Cluster Ops."));
        this.framework = iFramework;
    }

    public Color getColor(int n) {
        if (this.elementClusters[n] == null || this.elementClusters[n].size() == 0) {
            return null;
        }
        return this.elementClusters[n].lastCluster().getClusterColor();
    }

    public Color[] getColors(int n) {
        if (this.elementClusters[n] == null) {
            return null;
        }
        ClusterList clusterList = this.elementClusters[n];
        Color[] colorArray = new Color[clusterList.size()];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = clusterList.getClusterAt(i).getClusterColor();
        }
        return colorArray;
    }

    public int getDataElementCount() {
        return this.numberOfElements;
    }

    public boolean isGeneClusterRepository() {
        return this.geneClusterRepository;
    }

    public ClusterList getClusterList(int n) {
        if (this.isInRange(n)) {
            return (ClusterList)this.elementAt(n);
        }
        return null;
    }

    public void addClusterList(ClusterList clusterList) {
        this.add(clusterList);
    }

    public void addCluster(ClusterList clusterList, Cluster cluster) {
        if (cluster == null) {
            return;
        }
        if (!cluster.getSource().equals("Cluster Op.") && clusterList.isClusterSaved(cluster.getClusterID())) {
            Cluster cluster2 = clusterList.getCluster(cluster.getClusterID());
            if (cluster2 == null) {
                clusterList.addCluster(cluster);
                this.updateClusterMembership(cluster);
                return;
            }
            cluster2.setClusterColor(cluster.getClusterColor());
            cluster2.setClusterLabel(cluster.getClusterLabel());
            cluster2.setClusterDescription(cluster.getClusterDescription());
            this.setClusterSerialCounter(this.getMaxClusterSerialNumber() - 1);
            this.moveClusterToEndInMembershipLists(cluster2);
        } else {
            clusterList.addCluster(cluster);
            this.updateClusterMembership(cluster);
        }
    }

    public void addSubCluster(ClusterList clusterList, Cluster cluster) {
        if (cluster == null) {
            return;
        }
        clusterList.addCluster(cluster);
        this.updateClusterMembership(cluster);
    }

    private void updateClusterMembership(Cluster cluster) {
        int[] nArray = cluster.getIndices();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.elementClusters[nArray[i]] == null) {
                this.elementClusters[nArray[i]] = new ClusterList("element " + nArray[i]);
            }
            this.elementClusters[nArray[i]].add(cluster);
        }
    }

    private void moveClusterToEndInMembershipLists(Cluster cluster) {
        int[] nArray = cluster.getIndices();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.elementClusters[nArray[i]] == null) {
                this.elementClusters[nArray[i]] = new ClusterList("element " + nArray[i]);
            }
            if (!this.elementClusters[nArray[i]].contains(cluster)) continue;
            this.elementClusters[nArray[i]].removeElement(cluster);
            this.elementClusters[nArray[i]].addElement(cluster);
        }
    }

    private void removeClusterMembership(Cluster cluster) {
        int[] nArray = cluster.getIndices();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.elementClusters[nArray[i]] == null) continue;
            this.elementClusters[nArray[i]].removeElement(cluster);
        }
    }

    public void clearClusterLists() {
        for (int i = 0; i < this.size(); ++i) {
            this.getClusterList(i).clear();
        }
        this.clearElementClusters();
    }

    private void clearElementClusters() {
        for (int i = 0; i < this.numberOfElements; ++i) {
            this.elementClusters[i] = null;
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getClusterList(i).size() <= 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isInRange(int n) {
        return n > -1 && n < this.size();
    }

    public Cluster storeCluster(int n, String string, String string2, int[] nArray, Experiment experiment) {
        Container container;
        ClusterList clusterList = this.findClusterList(string);
        if (clusterList == null) {
            clusterList = new ClusterList(string);
            this.addClusterList(clusterList);
        } else if (clusterList.isClusterSaved(string2)) {
            container = new JOptionPane("Cluster has already been saved.  Would you like to replace the existing attributes?", 3, 1);
            ((JComponent)container).setVisible(true);
            int n2 = ((JOptionPane)container).getOptionType();
            if (n2 == 2 || n2 == 1) {
                return null;
            }
        }
        container = new ClusterAttributesDialog("Store Cluster Attributes", string, string2);
        if (((ClusterAttributesDialog)container).showModal() != 0) {
            return null;
        }
        Color color = ((ClusterAttributesDialog)container).getColor();
        String string3 = ((ClusterAttributesDialog)container).getLabel();
        String string4 = ((ClusterAttributesDialog)container).getDescription();
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(nArray, "Algorithm", string3, string, string2, string4, n, this.clusterSerialCounter, color, experiment);
        this.addCluster(clusterList, cluster);
        return cluster;
    }

    public Cluster storeCluster(int n, String string, String string2, int[] nArray, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        int n2;
        ClusterList clusterList = this.findClusterList(string);
        if (clusterList == null) {
            clusterList = new ClusterList(string);
            this.addClusterList(clusterList);
        } else if (clusterList.isClusterSaved(string2) && (n2 = JOptionPane.showConfirmDialog(this.framework.getFrame(), "Cluster has already been saved.  Would you like to modify the existing attributes?", "Cluster Saved Alert", 0, 3)) == 1) {
            return null;
        }
        ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Store Cluster Attributes", string, string2);
        if (clusterAttributesDialog.showModal() != 0) {
            return null;
        }
        Color color = clusterAttributesDialog.getColor();
        String string3 = clusterAttributesDialog.getLabel();
        String string4 = clusterAttributesDialog.getDescription();
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(nArray, "Algorithm", string3, string, string2, string4, n, this.clusterSerialCounter, color, defaultMutableTreeNode, experiment);
        this.addCluster(clusterList, cluster);
        return cluster;
    }

    public Cluster storeSubCluster(int n, String string, String string2, int[] nArray, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        ClusterList clusterList = this.findClusterList(string);
        boolean bl = false;
        if (clusterList == null) {
            clusterList = new ClusterList(string);
            this.addClusterList(clusterList);
        } else if (clusterList.isClusterSaved(string2) && clusterList.getCluster(string2).doIndicesMatch(nArray)) {
            int n2 = JOptionPane.showConfirmDialog(this.framework.getFrame(), "Cluster has already been saved.  Would you like to modify the existing attributes?", "Cluster Saved Alert", 0, 3);
            bl = true;
            if (n2 == 1) {
                return null;
            }
        }
        ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Store Cluster Attributes", string, string2);
        if (clusterAttributesDialog.showModal() != 0) {
            return null;
        }
        Color color = clusterAttributesDialog.getColor();
        String string3 = clusterAttributesDialog.getLabel();
        String string4 = clusterAttributesDialog.getDescription();
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(nArray, "Algorithm", string3, string, string2, string4, n, this.clusterSerialCounter, color, defaultMutableTreeNode, experiment);
        if (bl) {
            this.addCluster(clusterList, cluster);
        } else {
            this.addSubCluster(clusterList, cluster);
        }
        return cluster;
    }

    private ClusterList findClusterList(String string) {
        for (int i = 0; i < this.size(); ++i) {
            ClusterList clusterList = this.getClusterList(i);
            if (clusterList.getAlgorithmName() != string) continue;
            return clusterList;
        }
        return null;
    }

    public ClusterList getClusterOperationsList() {
        return this.findClusterList("Cluster Ops.");
    }

    public void removeCluster(int[] nArray, String string, String string2) {
        ClusterList clusterList = this.findClusterList(string);
        if (clusterList == null || clusterList.size() == 0) {
            return;
        }
        Cluster cluster = clusterList.getCluster(string2);
        clusterList.removeCluster(string2);
        this.removeElementClusters(nArray, cluster);
    }

    public void removeSubCluster(int[] nArray, String string, String string2) {
        ClusterList clusterList = this.findClusterList(string);
        if (clusterList == null || clusterList.size() == 0) {
            return;
        }
        Cluster cluster = null;
        Cluster cluster2 = null;
        for (int i = 0; i < clusterList.size(); ++i) {
            cluster2 = clusterList.getClusterAt(i);
            if (!cluster2.doIndicesMatch(nArray)) continue;
            cluster = cluster2;
        }
        if (cluster == null) {
            return;
        }
        clusterList.removeCluster(cluster);
        this.removeElementClusters(nArray, cluster);
    }

    private void removeElementClusters(int[] nArray, Cluster cluster) {
        for (int i = 0; i < nArray.length; ++i) {
            this.elementClusters[nArray[i]].remove(cluster);
        }
    }

    public void updateClusterColor(int n, Color color) {
        Cluster cluster = this.getCluster(n);
        if (cluster != null) {
            cluster.setClusterColor(color);
        }
    }

    public Cluster getCluster(int n) {
        Cluster cluster = null;
        ClusterList clusterList = null;
        for (int i = 0; i < this.size(); ++i) {
            clusterList = this.getClusterList(i);
            for (int j = 0; j < clusterList.size(); ++j) {
                cluster = clusterList.getClusterAt(j);
                if (n != cluster.getSerialNumber()) continue;
                return cluster;
            }
        }
        return cluster;
    }

    public void removeCluster(int n) {
        Cluster cluster = this.getCluster(n);
        for (int i = 0; i < this.size(); ++i) {
            ClusterList clusterList = this.getClusterList(i);
            for (int j = 0; j < clusterList.size(); ++j) {
                if (clusterList.getClusterAt(j) != cluster) continue;
                clusterList.removeCluster(n);
            }
        }
        int[] nArray = cluster.getIndices();
        this.removeClusterMembership(cluster);
    }

    public int takeNextClusterSerialNumber() {
        ++this.clusterSerialCounter;
        return this.clusterSerialCounter;
    }

    public int getMaxClusterSerialNumber() {
        return this.clusterSerialCounter;
    }

    public void setClusterSerialCounter(int n) {
        this.clusterSerialCounter = n;
    }

    public void printRepository() {
    }

    public void saveCluster(int n) {
        Cluster cluster = this.getCluster(n);
        try {
            if (this.geneClusterRepository) {
                ExperimentUtil.saveGeneCluster(this.framework.getFrame(), this.framework.getData(), cluster.getIndices());
            } else {
                ExperimentUtil.saveExperimentCluster(this.framework.getFrame(), cluster.getExperiment(), this.framework.getData(), cluster.getIndices());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Error saving cluster.  Cluster not saved.", "Save Error", 2);
            exception.printStackTrace();
        }
    }
}

