/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterAttributesDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;

public class ClusterWorker {
    ClusterRepository repository;

    public ClusterWorker(ClusterRepository clusterRepository) {
        this.repository = clusterRepository;
    }

    public Cluster intersection(Cluster[] clusterArray) {
        HashSet[] hashSetArray = new HashSet[clusterArray.length];
        int n = 0;
        for (int i = 0; i < hashSetArray.length; ++i) {
            hashSetArray[i] = clusterArray[i].getHashSet();
            n = Math.min(n, clusterArray[i].getSize());
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.intersect(hashSetArray));
        Iterator iterator = hashSet.iterator();
        int n2 = hashSet.size();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (Integer)iterator.next();
        }
        return this.buildResultCluster("Intersection", clusterArray, nArray);
    }

    private Cluster buildResultCluster(String string, Cluster[] clusterArray, int[] nArray) {
        String string2 = "";
        for (int i = 0; i < clusterArray.length - 1; ++i) {
            string2 = string2 + clusterArray[i].getSerialNumber() + ":";
        }
        if (clusterArray.length - 1 > -1) {
            string2 = string2 + clusterArray[clusterArray.length - 1].getSerialNumber();
        }
        Experiment experiment = this.getMinExperiment(clusterArray);
        ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Cluster Operation: " + string + "( " + string2 + " )", "Cluster Op", string + "( " + string2 + " )", null, null, Color.lightGray);
        if (clusterAttributesDialog.showModal() == 0) {
            return new Cluster(nArray, "Cluster Op.", clusterAttributesDialog.getLabel(), string + "( " + string2 + " )", "", clusterAttributesDialog.getDescription(), -1, this.repository.takeNextClusterSerialNumber(), clusterAttributesDialog.getColor(), experiment);
        }
        return null;
    }

    private Cluster buildBasicCluster(String string, Cluster[] clusterArray, int[] nArray) {
        String string2 = "";
        for (int i = 0; i < clusterArray.length - 1; ++i) {
            string2 = string2 + clusterArray[i].getSerialNumber() + ":";
        }
        if (clusterArray.length - 1 > -1) {
            string2 = string2 + clusterArray[clusterArray.length - 1].getSerialNumber();
        }
        Experiment experiment = this.getMinExperiment(clusterArray);
        return new Cluster(nArray, "Cluster Op.", "", string + "( " + string2 + " )", "", "", -1, -1, Color.lightGray, experiment);
    }

    public Experiment getMinExperiment(Cluster[] clusterArray) {
        Experiment experiment;
        Experiment experiment2 = experiment = clusterArray[0].getExperiment();
        for (int i = 0; i < clusterArray.length; ++i) {
            experiment2 = clusterArray[i].getExperiment();
            if (experiment2.getNumberOfGenes() >= experiment.getNumberOfGenes()) continue;
            experiment = experiment2;
        }
        return experiment;
    }

    private HashSet intersect(HashSet[] hashSetArray) {
        HashSet hashSet = this.intersect(hashSetArray[0], hashSetArray[1]);
        if (hashSetArray.length == 2) {
            return hashSet;
        }
        for (int i = 2; i < hashSetArray.length; ++i) {
            hashSet = this.intersect(hashSet, hashSetArray[i]);
        }
        return hashSet;
    }

    private HashSet intersect(HashSet hashSet, HashSet hashSet2) {
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        for (Integer n : hashSet) {
            if (!hashSet2.contains(n)) continue;
            hashSet3.add(n);
        }
        return hashSet3;
    }

    public Cluster union(Cluster[] clusterArray) {
        int[] nArray = this.getUniqueIndices(clusterArray);
        return this.buildResultCluster("Union", clusterArray, nArray);
    }

    public int[] getUniqueIndices(Cluster[] clusterArray) {
        int[][] nArrayArray = new int[clusterArray.length][];
        int n = 0;
        for (int i = 0; i < clusterArray.length; ++i) {
            Cluster cluster = clusterArray[i];
            nArrayArray[i] = cluster.getIndices();
            n += nArrayArray[i].length;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArrayArray.length; ++i) {
            for (int j = 0; j < nArrayArray[i].length; ++j) {
                nArray[n2] = nArrayArray[i][j];
                ++n2;
            }
        }
        nArray = this.makeIndicesUnique(nArray);
        return nArray;
    }

    private int[] makeIndicesUnique(int[] nArray) {
        int n = this.repository.getDataElementCount();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (blArray[nArray[i]]) continue;
            blArray[nArray[i]] = true;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            nArray2[n3] = i;
            ++n3;
        }
        return nArray2;
    }

    public String[] getClusterLabels(Cluster[] clusterArray) {
        String[] stringArray = new String[clusterArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = clusterArray[i].getClusterLabel();
        }
        return stringArray;
    }

    public Cluster xor(Cluster[] clusterArray) {
        Cluster cluster = this.utilityUnion(clusterArray);
        Cluster cluster2 = this.utilityIntersection(clusterArray);
        HashSet hashSet = cluster.getHashSet();
        HashSet hashSet2 = cluster2.getHashSet();
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            hashSet.remove(iterator.next());
        }
        return this.buildResultCluster("XOR", clusterArray, this.getIndices(hashSet));
    }

    public Cluster utilityUnion(Cluster[] clusterArray) {
        int[] nArray = this.getUniqueIndices(clusterArray);
        return this.buildBasicCluster("Union", clusterArray, nArray);
    }

    public Cluster utilityIntersection(Cluster[] clusterArray) {
        HashSet[] hashSetArray = new HashSet[clusterArray.length];
        int n = 0;
        for (int i = 0; i < hashSetArray.length; ++i) {
            hashSetArray[i] = clusterArray[i].getHashSet();
            n = Math.min(n, clusterArray[i].getSize());
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.intersect(hashSetArray));
        Iterator iterator = hashSet.iterator();
        int n2 = hashSet.size();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (Integer)iterator.next();
        }
        return this.buildBasicCluster("Intersection", clusterArray, nArray);
    }

    private int[] getIndices(HashSet hashSet) {
        Object[] objectArray = hashSet.toArray();
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = (Integer)objectArray[i];
        }
        return nArray;
    }
}

