/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.IExperimentHeader;

public class ExperimentClusterHeader
extends JPanel
implements IExperimentHeader {
    private static final int RECT_HEIGHT = 15;
    private static final int COLOR_BAR_HEIGHT = 10;
    private Experiment experiment;
    private IData data;
    private int[][] samplesOrder;
    private int elementWidth;
    private boolean isAntiAliasing = true;
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    int clusterIndex = 0;
    private String centroidName;
    private boolean hasCentroid;
    private BufferedImage negColorImage;
    private BufferedImage posColorImage;
    private Insets insets = new Insets(0, 10, 0, 0);

    public ExperimentClusterHeader(Experiment experiment, int[] nArray) {
        this.experiment = experiment;
        this.samplesOrder = new int[1][];
        this.samplesOrder[0] = nArray;
        this.hasCentroid = false;
        this.setBackground(Color.white);
    }

    public ExperimentClusterHeader(Experiment experiment, int[][] nArray) {
        this.experiment = experiment;
        this.samplesOrder = nArray;
        this.hasCentroid = false;
        this.setBackground(Color.white);
    }

    public ExperimentClusterHeader(Experiment experiment, int[][] nArray, String string) {
        this.experiment = experiment;
        this.samplesOrder = nArray;
        this.centroidName = string;
        this.hasCentroid = true;
        this.setBackground(Color.white);
    }

    public JComponent getContentComponent() {
        return this;
    }

    public void setData(IData iData) {
        this.data = iData;
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    public void setValues(float f, float f2) {
        this.maxValue = f;
        this.minValue = f2;
    }

    public void setNegAndPosColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.negColorImage = bufferedImage;
        this.posColorImage = bufferedImage2;
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    private void setElementWidth(int n) {
        this.elementWidth = n;
        if (n > 12) {
            n = 12;
        }
        this.setFont(new Font("monospaced", 0, n));
    }

    public void setLeftInset(int n) {
        this.insets.left = n;
    }

    public void updateSizes(int n, int n2) {
        this.setElementWidth(n2);
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = 0;
        int n4 = this.samplesOrder[this.clusterIndex].length;
        for (int i = 0; i < n4; ++i) {
            String string = this.data.getSampleName(this.experiment.getSampleIndex(this.samplesOrder[this.clusterIndex][i]));
            n3 = Math.max(n3, fontMetrics.stringWidth(string));
        }
        if (this.hasCentroid) {
            n3 = Math.max(n3, fontMetrics.stringWidth(this.centroidName));
        }
        n3 += 15 + fontMetrics.getHeight() + 10;
        n3 += this.getColorBarHeight();
        if (!this.hasCentroid) {
            this.setSize(n, n3);
            this.setPreferredSize(new Dimension(n, n3));
        } else {
            this.setSize(n, n3);
            this.setPreferredSize(new Dimension(n, n3));
        }
    }

    private int getColorBarHeight() {
        for (int i = 0; i < this.samplesOrder[this.clusterIndex].length; ++i) {
            if (this.data.getExperimentColor(this.experiment.getSampleIndex(this.samplesOrder[this.clusterIndex][i])) == null) continue;
            return 10;
        }
        return 0;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.data == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawHeader(graphics2D);
    }

    private void drawHeader(Graphics2D graphics2D) {
        int n = this.samplesOrder[this.clusterIndex].length;
        if (n == 0) {
            return;
        }
        int n2 = n * this.elementWidth;
        if (this.hasCentroid) {
            n2 += this.elementWidth + 5;
        }
        graphics2D.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)n2 / 2.0f), 15, null);
        graphics2D.drawImage(this.posColorImage, (int)((float)n2 / 2.0f + (float)this.insets.left), 0, (int)((float)n2 / 2.0f), 15, null);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.getDescent();
        int n4 = fontMetrics.getHeight();
        graphics2D.setColor(Color.black);
        graphics2D.drawString(String.valueOf(this.maxValue), this.insets.left, 15 + n4);
        int n5 = fontMetrics.stringWidth("1:1");
        graphics2D.drawString("1:1", (int)((float)(n2 + this.insets.left) / 2.0f) - n5 / 2, 15 + n4);
        n5 = fontMetrics.stringWidth(String.valueOf(this.minValue));
        graphics2D.drawString(String.valueOf(this.minValue), n2 - n5 + this.insets.left, 15 + n4);
        graphics2D.rotate(-1.5707963267948966);
        int n6 = -this.getSize().height + 5;
        boolean bl = false;
        int n7 = 0;
        if (this.getColorBarHeight() > 0) {
            n6 += 10;
            bl = true;
        }
        if (this.hasCentroid) {
            n7 = this.elementWidth + 5;
            graphics2D.drawString(this.centroidName, n6, n3 + this.elementWidth / 2 + this.insets.left);
        }
        for (int i = 0; i < n; ++i) {
            String string = this.data.getSampleName(this.experiment.getSampleIndex(this.samplesOrder[this.clusterIndex][i]));
            graphics2D.drawString(string, n6, n3 + this.elementWidth * i + this.elementWidth / 2 + this.insets.left + n7);
        }
        graphics2D.rotate(1.5707963267948966);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                Color color = this.data.getExperimentColor(this.experiment.getSampleIndex(this.samplesOrder[this.clusterIndex][i]));
                if (color != null) {
                    graphics2D.setColor(color);
                } else {
                    graphics2D.setColor(Color.white);
                }
                graphics2D.fillRect(i * this.elementWidth + this.insets.left + n7, this.getSize().height - 10 - 2, this.elementWidth, 10);
            }
        }
    }
}

