/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.cast;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.util.FloatMatrix;

public class CASTGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;
    private int k;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        float f = 0.5f;
        boolean bl = true;
        CASTInitDialog cASTInitDialog = new CASTInitDialog((JFrame)iFramework.getFrame(), bl);
        cASTInitDialog.setVisible(true);
        if (!cASTInitDialog.isOkPressed()) {
            return null;
        }
        this.clusterGenes = cASTInitDialog.isClusterGenes();
        f = Float.parseFloat(cASTInitDialog.thresholdTextField.getText());
        boolean bl2 = cASTInitDialog.isHCLSelected();
        int n = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl2) {
            object = new HCLInitDialog(iFramework.getFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n = ((HCLInitDialog)object).getMethod();
            bl3 = ((HCLInitDialog)object).isClusterExperience();
            bl4 = ((HCLInitDialog)object).isClusterGenes();
        }
        this.experiment = iFramework.getData().getExperiment();
        object = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("CAST");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            int n2 = this.experiment.getNumberOfGenes();
            AlgorithmData algorithmData = new AlgorithmData();
            FloatMatrix floatMatrix = this.experiment.getMatrix();
            if (!this.clusterGenes) {
                floatMatrix = floatMatrix.transpose();
            }
            algorithmData.addMatrix("experiment", floatMatrix);
            algorithmData.addParam("cast-cluster-genes", String.valueOf(this.clusterGenes));
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            algorithmData.addParam("threshold", String.valueOf(f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n3 = iDistanceMenu.getDistanceFunction();
            int n4 = 4;
            if (n3 == 0) {
                n3 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n3));
            if (bl2) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n));
                algorithmData.addParam("calculate-genes", String.valueOf(bl4));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl3));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            AlgorithmParameters algorithmParameters = algorithmData2.getParams();
            this.k = algorithmParameters.getInt("number-of-clusters");
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.clusters = this.k;
            generalInfo.time = l2;
            generalInfo.threshold = f;
            generalInfo.isAbsolute = iDistanceMenu.isAbsoluteDistance();
            if (n3 == 0 || n3 == 2 || n3 == 3 || n3 == 4 || n3 == 5 || n3 == 8 || n3 == 9 || n3 == 10 || n3 == 11) {
                n4 = 4;
            } else if (n3 == 1 || n3 == 6 || n3 == 7) {
                n4 = 1;
            }
            generalInfo.function = iDistanceMenu.getFunctionName(n4);
            generalInfo.hcl = bl2;
            generalInfo.hcl_genes = bl4;
            generalInfo.hcl_samples = bl3;
            generalInfo.hcl_method = n;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
            }
        }
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("CAST - genes") : new DefaultMutableTreeNode("CAST - experiments");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        JPanel jPanel = this.clusterGenes ? new CASTExperimentViewer(this.experiment, this.clusters) : new CASTExperimentClusterViewer(this.experiment, this.clusters);
        for (int i = 0; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)((Object)jPanel), new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        if (!this.clusterGenes) {
            object = new int[this.k][];
            for (n = 0; n < this.k; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        for (n = 0; n < nodeList.getSize(); ++n) {
            if (this.clusterGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), new Integer(n))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", new CASTInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Experiments in Clusters (#,%)", new CASTInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            CASTCentroidViewer cASTCentroidViewer = new CASTCentroidViewer(this.experiment, this.clusters);
            cASTCentroidViewer.setMeans(this.means.A);
            cASTCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)cASTCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)cASTCentroidViewer, new CentroidUserObject(i, 1))));
            }
            CASTCentroidsViewer cASTCentroidsViewer = new CASTCentroidsViewer(this.experiment, this.clusters);
            cASTCentroidsViewer.setMeans(this.means.A);
            cASTCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)cASTCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)cASTCentroidsViewer, new Integer(1))));
        } else {
            CASTExperimentCentroidViewer cASTExperimentCentroidViewer = new CASTExperimentCentroidViewer(this.experiment, this.clusters);
            cASTExperimentCentroidViewer.setMeans(this.means.A);
            cASTExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)cASTExperimentCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)cASTExperimentCentroidViewer, new CentroidUserObject(i, 1))));
            }
            CASTExperimentCentroidsViewer cASTExperimentCentroidsViewer = new CASTExperimentCentroidsViewer(this.experiment, this.clusters);
            cASTExperimentCentroidsViewer.setMeans(this.means.A);
            cASTExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)cASTExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)cASTExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Clusters: " + String.valueOf(generalInfo.clusters)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Threshold: " + String.valueOf(generalInfo.threshold)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Absolute distance: " + String.valueOf(generalInfo.isAbsolute)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public long time;
        public float threshold;
        public boolean isAbsolute;
        public String function;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                CASTGUI.this.algorithm.abort();
                this.cleanUp();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            CASTGUI.this.algorithm.abort();
            this.cleanUp();
        }

        public void cleanUp() {
        }
    }
}

