/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLNodeHeightGraph;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.util.FloatMatrix;

public class HCLGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        HCLInitDialog hCLInitDialog = new HCLInitDialog(iFramework.getFrame());
        if (hCLInitDialog.showModal() != 0) {
            return null;
        }
        int n = hCLInitDialog.getMethod();
        Listener listener = new Listener();
        try {
            Experiment experiment = iFramework.getData().getExperiment();
            AlgorithmFactory algorithmFactory = iFramework.getAlgorithmFactory();
            this.algorithm = algorithmFactory.getAlgorithm("HCL");
            this.algorithm.addAlgorithmListener(listener);
            AlgorithmData algorithmData = new AlgorithmData();
            algorithmData.addMatrix("experiment", experiment.getMatrix());
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            int n2 = iDistanceMenu.getDistanceFunction();
            if (n2 == 0) {
                n2 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n2));
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            algorithmData.addParam("method-linkage", String.valueOf(n));
            this.progress = new Progress(iFramework.getFrame(), "", listener);
            this.progress.show();
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = null;
            if (hCLInitDialog.isClusterGenes()) {
                this.progress.setTitle("Clustering by Genes");
                algorithmData.addParam("calculate-genes", String.valueOf(true));
                algorithmData2 = this.algorithm.execute(algorithmData);
                this.validate(algorithmData2);
            }
            AlgorithmData algorithmData3 = null;
            if (hCLInitDialog.isClusterExperience()) {
                this.progress.setTitle("Clustering by Examples");
                algorithmData.addParam("calculate-genes", String.valueOf(false));
                algorithmData3 = this.algorithm.execute(algorithmData);
                this.validate(algorithmData3);
            }
            long l2 = System.currentTimeMillis() - l;
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.time = l2;
            generalInfo.method = n;
            generalInfo.function = iDistanceMenu.getFunctionName(n2);
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(experiment, algorithmData2, algorithmData3, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener(listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, AlgorithmData algorithmData, AlgorithmData algorithmData2, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("HCL");
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("HCL Tree", this.createHCLViewer(experiment, algorithmData, algorithmData2, defaultMutableTreeNode))));
        if (algorithmData != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Gene Node Height Plot", new HCLNodeHeightGraph(this.getHCLTreeData(algorithmData), true))));
        }
        if (algorithmData2 != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Experiment Node Height Plot", new HCLNodeHeightGraph(this.getHCLTreeData(algorithmData2), false))));
        }
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
        return defaultMutableTreeNode;
    }

    private HCLTreeData getHCLTreeData(AlgorithmData algorithmData) {
        if (algorithmData == null) {
            return null;
        }
        HCLTreeData hCLTreeData = new HCLTreeData();
        hCLTreeData.child_1_array = algorithmData.getIntArray("child-1-array");
        hCLTreeData.child_2_array = algorithmData.getIntArray("child-2-array");
        hCLTreeData.node_order = algorithmData.getIntArray("node-order");
        hCLTreeData.height = algorithmData.getMatrix("height").getRowPackedCopy();
        return hCLTreeData;
    }

    private IViewer createHCLViewer(Experiment experiment, AlgorithmData algorithmData, AlgorithmData algorithmData2, DefaultMutableTreeNode defaultMutableTreeNode) {
        return new HCLViewer(experiment, null, this.getHCLTreeData(algorithmData), this.getHCLTreeData(algorithmData2), defaultMutableTreeNode);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Linkage Method: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    public static void printResult(AlgorithmData algorithmData) {
        FloatMatrix floatMatrix = algorithmData.getMatrix("similarity-matrix");
        floatMatrix.print(5, 2);
        int[] nArray = algorithmData.getIntArray("parent-array");
        int[] nArray2 = algorithmData.getIntArray("child-1-array");
        int[] nArray3 = algorithmData.getIntArray("child-2-array");
        int[] nArray4 = algorithmData.getIntArray("node-order");
        int[] nArray5 = algorithmData.getIntArray("node-height");
        int[] nArray6 = algorithmData.getIntArray("number-of-children");
        float[] fArray = algorithmData.getMatrix("height").getRowPackedCopy();
    }

    public static class GeneralInfo {
        public long time;
        public int method;
        public String function;
        private static String[] methods = new String[]{"average linkage", "complete linkage", "single linkage"};

        public String getMethodName() {
            return GeneralInfo.getMethodName(this.method);
        }

        public static String getMethodName(int n) {
            n = n == -1 ? 2 : n;
            return methods[n];
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    HCLGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    HCLGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    HCLGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    HCLGUI.this.progress.setDescription(algorithmEvent.getDescription());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                HCLGUI.this.algorithm.abort();
                HCLGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            HCLGUI.this.algorithm.abort();
            HCLGUI.this.progress.dispose();
        }
    }
}

