/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmc;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Monitor;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCInitDialog;
import org.tigr.util.FloatMatrix;

public class KMCGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Monitor monitor;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;
    private int k;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        this.k = 10;
        int n = 50;
        boolean bl = true;
        KMCInitDialog kMCInitDialog = new KMCInitDialog(new JFrame(), this.k, n);
        if (kMCInitDialog.showModal() != 0) {
            return null;
        }
        this.k = kMCInitDialog.getClusters();
        n = kMCInitDialog.getIterations();
        bl = kMCInitDialog.calculateMeans();
        this.clusterGenes = kMCInitDialog.isClusterGenesSelected();
        if (this.k < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of clusters must be greater than 0!", "Error", 0);
            return null;
        }
        if (n < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of iterations must be greater than 0!", "Error", 0);
            return null;
        }
        boolean bl2 = kMCInitDialog.isHierarchicalTree();
        int n2 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl2) {
            object = new HCLInitDialog(new JFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n2 = ((HCLInitDialog)object).getMethod();
            bl3 = ((HCLInitDialog)object).isClusterExperience();
            bl4 = ((HCLInitDialog)object).isClusterGenes();
        }
        this.experiment = iFramework.getData().getExperiment();
        object = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("KMC");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            int n3 = this.experiment.getNumberOfGenes();
            this.monitor = new Monitor(iFramework.getFrame(), "Reallocations", 25, 100, 210.0 / (double)n3);
            this.monitor.setStepXFactor((int)Math.floor(245 / n));
            this.monitor.update(n3);
            this.monitor.show();
            this.progress = new Progress(iFramework.getFrame(), "Calculating clusters", (DialogListener)object);
            this.progress.show();
            AlgorithmData algorithmData = new AlgorithmData();
            if (this.clusterGenes) {
                algorithmData.addMatrix("experiment", this.experiment.getMatrix());
                algorithmData.addParam("kmc-cluster-genes", String.valueOf(true));
            } else {
                algorithmData.addMatrix("experiment", this.experiment.getMatrix().transpose());
                algorithmData.addParam("kmc-cluster-genes", String.valueOf(false));
            }
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n4 = iDistanceMenu.getDistanceFunction();
            if (n4 == 0) {
                n4 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n4));
            algorithmData.addParam("number_of_clusters", String.valueOf(this.k));
            algorithmData.addParam("number_of_iterations", String.valueOf(n));
            algorithmData.addParam("calculate-means", String.valueOf(bl));
            if (bl2) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n2));
                algorithmData.addParam("calculate-genes", String.valueOf(bl4));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl3));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.clusters = this.k;
            generalInfo.converged = algorithmData2.getParams().getBoolean("converged");
            generalInfo.iterations = algorithmData2.getParams().getInt("iterations");
            generalInfo.calculate_means = bl;
            generalInfo.time = l2;
            generalInfo.function = iDistanceMenu.getFunctionName(n4);
            generalInfo.hcl = bl2;
            generalInfo.hcl_genes = bl4;
            generalInfo.hcl_samples = bl3;
            generalInfo.hcl_method = n2;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
            if (this.monitor != null) {
                this.monitor.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("KMC - genes") : new DefaultMutableTreeNode("KMC - experiments");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        JPanel jPanel = this.clusterGenes ? new KMCExperimentViewer(this.experiment, this.clusters) : new KMCExperimentClusterViewer(this.experiment, this.clusters);
        for (int i = 0; i < this.clusters.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)((Object)jPanel), new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        if (!this.clusterGenes) {
            object = new int[this.k][];
            for (n = 0; n < this.k; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        for (n = 0; n < nodeList.getSize(); ++n) {
            if (this.clusterGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), new Integer(n))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", new KMCInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Experiments in Clusters (#,%)", new KMCInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            KMCCentroidViewer kMCCentroidViewer = new KMCCentroidViewer(this.experiment, this.clusters);
            kMCCentroidViewer.setMeans(this.means.A);
            kMCCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCCentroidViewer, new CentroidUserObject(i, 1))));
            }
            KMCCentroidsViewer kMCCentroidsViewer = new KMCCentroidsViewer(this.experiment, this.clusters);
            kMCCentroidsViewer.setMeans(this.means.A);
            kMCCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCCentroidsViewer, new Integer(1))));
        } else {
            KMCExperimentCentroidViewer kMCExperimentCentroidViewer = new KMCExperimentCentroidViewer(this.experiment, this.clusters);
            kMCExperimentCentroidViewer.setMeans(this.means.A);
            kMCExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCExperimentCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCExperimentCentroidViewer, new CentroidUserObject(i, 1))));
            }
            KMCExperimentCentroidsViewer kMCExperimentCentroidsViewer = new KMCExperimentCentroidsViewer(this.experiment, this.clusters);
            kMCExperimentCentroidsViewer.setMeans(this.means.A);
            kMCExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        if (generalInfo.calculate_means) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("KMC mode: Calculated Means"));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("KMC mode: Calculated Medians"));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Clusters: " + String.valueOf(generalInfo.clusters)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Converged: " + String.valueOf(generalInfo.converged)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Iterations: " + String.valueOf(generalInfo.iterations)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private class GeneralInfo {
        public int clusters;
        public boolean converged;
        public int iterations;
        public long time;
        public String function;
        public boolean calculate_means;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    KMCGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    KMCGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    KMCGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    KMCGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n == -1) {
                        KMCGUI.this.monitor.dispose();
                        break;
                    }
                    KMCGUI.this.monitor.update(n);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                KMCGUI.this.algorithm.abort();
                KMCGUI.this.progress.dispose();
                KMCGUI.this.monitor.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            KMCGUI.this.algorithm.abort();
            KMCGUI.this.progress.dispose();
            KMCGUI.this.monitor.dispose();
        }
    }
}

