/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmcs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class KMCSuppInfoViewer
extends ViewerAdapter {
    private JComponent header = this.createHeader();
    private JTextArea content;
    private boolean clusterGenes;
    private boolean unassignedExists;

    public KMCSuppInfoViewer(int[][] nArray, int n) {
        this.clusterGenes = true;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public KMCSuppInfoViewer(int[][] nArray, int n, boolean bl, boolean bl2) {
        this.unassignedExists = bl;
        this.clusterGenes = bl2;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent(int[][] nArray, int n) {
        JTextArea jTextArea = new JTextArea(nArray.length * 3, 20);
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 3 * 10);
        if (this.clusterGenes) {
            if (!this.unassignedExists) {
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append("Cluster " + (i + 1));
                    stringBuffer.append("\t");
                    stringBuffer.append("# of Genes in Cluster: " + nArray[i].length);
                    stringBuffer.append("\n\t");
                    stringBuffer.append("% of Genes in Cluster: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                    stringBuffer.append("\n\n");
                }
            } else {
                int n2;
                for (n2 = 0; n2 < nArray.length - 1; ++n2) {
                    stringBuffer.append("Cluster " + (n2 + 1));
                    stringBuffer.append("\t");
                    stringBuffer.append("# of Genes in Cluster: " + nArray[n2].length);
                    stringBuffer.append("\n\t");
                    stringBuffer.append("% of Genes in Cluster: " + Math.round((float)nArray[n2].length / (float)n * 100.0f) + "%");
                    stringBuffer.append("\n\n");
                }
                stringBuffer.append("Unassigned Genes ");
                stringBuffer.append("\n\t");
                stringBuffer.append("# of Unassighed Genes: " + nArray[n2].length);
                stringBuffer.append("\n\t");
                stringBuffer.append("% of Genes Unassigned: " + Math.round((float)nArray[n2].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
        } else if (!this.unassignedExists) {
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append("Cluster " + (i + 1));
                stringBuffer.append("\t");
                stringBuffer.append("# of Experiments in Cluster: " + nArray[i].length);
                stringBuffer.append("\n\t");
                stringBuffer.append("% of Experiments in Cluster: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
        } else {
            int n3;
            for (n3 = 0; n3 < nArray.length - 1; ++n3) {
                stringBuffer.append("Cluster " + (n3 + 1));
                stringBuffer.append("\t");
                stringBuffer.append("# of Experiments in Cluster: " + nArray[n3].length);
                stringBuffer.append("\n\t");
                stringBuffer.append("% of Experiments in Cluster: " + Math.round((float)nArray[n3].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
            stringBuffer.append("Unassigned Experiments ");
            stringBuffer.append("\n\t");
            stringBuffer.append("# of Unassiged Experiments: " + nArray[n3].length);
            stringBuffer.append("\n\t");
            stringBuffer.append("% of Experiments Unassigned: " + Math.round((float)nArray[n3].length / (float)n * 100.0f) + "%");
            stringBuffer.append("\n\n");
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

