/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.behaviors.PickRotateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickTranslateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickZoomBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PointLight;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.pca.OpenBehavior;
import org.tigr.util.FloatMatrix;

public class Content3D
extends JPanel {
    private IData data;
    private int mode;
    private FloatMatrix U;
    private Experiment experiment;
    private SimpleUniverse universe;
    private Canvas3D onScreenCanvas;
    private Canvas3D offScreenCanvas;
    private BranchGroup scene;
    private TransformGroup spinGroup;
    private boolean whiteBackground = false;
    private boolean selection = false;
    private boolean selectionBox = false;
    private boolean showSpheres = false;
    private boolean showText = false;
    private boolean geneViewer = true;
    private float scaleAxisX = 3.0f;
    private float scaleAxisY = 3.0f;
    private float scaleAxisZ = 3.0f;
    private float boxSizeX = 5.0f;
    private float boxSizeY = 5.0f;
    private float boxSizeZ = 5.0f;
    private float boxPositionX = 0.0f;
    private float boxPositionY = 0.0f;
    private float boxPositionZ = 0.0f;
    private float pointSize = 1.0f;
    private float selectedPointSize = 1.0f;
    private Color3f blackColor = new Color3f(0.0f, 0.0f, 0.0f);
    private Color3f whiteColor = new Color3f(0.98f, 0.98f, 0.98f);

    public Content3D(int n, FloatMatrix floatMatrix, Experiment experiment) {
        this.mode = n;
        this.U = floatMatrix;
        this.experiment = experiment;
        this.initScales(floatMatrix);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 10));
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(graphicsConfiguration);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.offScreenCanvas = new Canvas3D(graphicsConfiguration, true);
        Screen3D screen3D = this.onScreenCanvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        this.add((Component)this.onScreenCanvas, "Center");
    }

    public Content3D(int n, FloatMatrix floatMatrix, Experiment experiment, boolean bl) {
        this.mode = n;
        this.U = floatMatrix;
        this.experiment = experiment;
        this.geneViewer = bl;
        this.initScales(floatMatrix);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 10));
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(graphicsConfiguration);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.offScreenCanvas = new Canvas3D(graphicsConfiguration, true);
        Screen3D screen3D = this.onScreenCanvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        this.add((Component)this.onScreenCanvas, "Center");
    }

    public void setData(IData iData) {
        this.data = iData;
    }

    public float getPositionX() {
        return this.boxPositionX;
    }

    public float getPositionY() {
        return this.boxPositionY;
    }

    public float getPositionZ() {
        return this.boxPositionZ;
    }

    public float getSizeX() {
        return this.boxSizeX;
    }

    public float getSizeY() {
        return this.boxSizeY;
    }

    public float getSizeZ() {
        return this.boxSizeZ;
    }

    public void setBoxPosition(float f, float f2, float f3) {
        this.boxPositionX = f;
        this.boxPositionY = f2;
        this.boxPositionZ = f3;
    }

    public void setBoxSize(float f, float f2, float f3) {
        this.boxSizeX = f;
        this.boxSizeY = f2;
        this.boxSizeZ = f3;
    }

    public float getSelectedPointSize() {
        return this.selectedPointSize;
    }

    public void setSelectedPointSize(float f) {
        this.selectedPointSize = f;
    }

    public float getPointSize() {
        return this.pointSize;
    }

    private float getPointSize(boolean bl) {
        return bl ? this.getSelectedPointSize() : this.getPointSize();
    }

    public void setPointSize(float f) {
        this.pointSize = f;
    }

    public float getScaleAxisX() {
        return this.scaleAxisX;
    }

    public float getScaleAxisY() {
        return this.scaleAxisY;
    }

    public float getScaleAxisZ() {
        return this.scaleAxisZ;
    }

    public void setScale(float f, float f2, float f3) {
        this.scaleAxisX = f;
        this.scaleAxisY = f2;
        this.scaleAxisZ = f3;
    }

    public void setWhiteBackround(boolean bl) {
        this.whiteBackground = bl;
    }

    public boolean isWhiteBackground() {
        return this.whiteBackground;
    }

    public void setSelection(boolean bl) {
        this.selection = bl;
    }

    public boolean isSelection() {
        return this.selection;
    }

    public void setSelectionBox(boolean bl) {
        this.selectionBox = bl;
    }

    public boolean isSelectionBox() {
        return this.selectionBox;
    }

    public void setShowSpheres(boolean bl) {
        this.showSpheres = bl;
    }

    public boolean isShowSpheres() {
        return this.showSpheres;
    }

    public void setShowText(boolean bl) {
        this.showText = bl;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public BufferedImage createImage() {
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.onScreenCanvas.getWidth(), this.onScreenCanvas.getHeight()));
        this.offScreenCanvas.setOffScreenLocation(this.onScreenCanvas.getLocationOnScreen());
        this.offScreenCanvas.setOffScreenBuffer(imageComponent2D);
        this.offScreenCanvas.renderOffScreenBuffer();
        this.offScreenCanvas.waitForOffScreenRendering();
        BufferedImage bufferedImage = this.offScreenCanvas.getOffScreenBuffer().getImage();
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 5);
        bufferedImage2.setData(bufferedImage.getData());
        return bufferedImage2;
    }

    public void reset() {
        this.spinGroup.setTransform(new Transform3D());
    }

    protected void updateScene() {
        Transform3D transform3D = new Transform3D();
        if (this.scene != null) {
            this.spinGroup.getTransform(transform3D);
            this.scene.detach();
        }
        this.scene = this.createSceneGraph(this.onScreenCanvas, transform3D);
        this.universe.addBranchGraph(this.scene);
    }

    private void initScales(FloatMatrix floatMatrix) {
        int n;
        float f = 0.0f;
        int n2 = n = floatMatrix.getRowDimension();
        while (--n2 >= 0) {
            f = Math.max(f, Math.max(Math.max(Math.abs(floatMatrix.get(n2, 0)), Math.abs(floatMatrix.get(n2, 1))), Math.abs(floatMatrix.get(n2, 2))));
        }
        this.setScale(f, f, f);
    }

    private BranchGroup createSceneGraph(Canvas3D canvas3D) {
        return this.createSceneGraph(canvas3D, null);
    }

    private BranchGroup createSceneGraph(Canvas3D canvas3D, Transform3D transform3D) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.spinGroup = this.createCoordinateSystem(boundingSphere);
        if (transform3D != null) {
            this.spinGroup.setTransform(transform3D);
        }
        TransformGroup transformGroup = this.createScaleTransformGroup(boundingSphere);
        transformGroup.addChild((Node)this.spinGroup);
        branchGroup.addChild((Node)transformGroup);
        PickRotateBehavior pickRotateBehavior = new PickRotateBehavior(branchGroup, canvas3D, (Bounds)boundingSphere);
        branchGroup.addChild((Node)pickRotateBehavior);
        PickZoomBehavior pickZoomBehavior = new PickZoomBehavior(branchGroup, canvas3D, (Bounds)boundingSphere);
        branchGroup.addChild((Node)pickZoomBehavior);
        PickTranslateBehavior pickTranslateBehavior = new PickTranslateBehavior(branchGroup, canvas3D, (Bounds)boundingSphere);
        branchGroup.addChild((Node)pickTranslateBehavior);
        branchGroup.compile();
        return branchGroup;
    }

    private TransformGroup createScaleTransformGroup(BoundingSphere boundingSphere) {
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(0.22);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        Color3f color3f = this.isWhiteBackground() ? this.whiteColor : this.blackColor;
        Background background = new Background(color3f);
        background.setApplicationBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)background);
        transformGroup.addChild((Node)this.createAmbientLight(boundingSphere));
        transformGroup.addChild((Node)this.createLight(boundingSphere, new Vector3d(0.0, 0.0, 3.0)));
        transformGroup.addChild((Node)this.createLight(boundingSphere, new Vector3d(0.0, 0.0, 10.0)));
        return transformGroup;
    }

    private TransformGroup createCoordinateSystem(BoundingSphere boundingSphere) {
        Object object;
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        transformGroup.setCapability(1);
        transformGroup.addChild((Node)this.createXAxis());
        transformGroup.addChild((Node)this.createYAxis());
        transformGroup.addChild((Node)this.createZAxis());
        if (this.isShowSpheres()) {
            transformGroup.addChild((Node)this.createSpheres());
        } else if (this.getPointSize() > 0.0f) {
            Shape3D shape3D;
            object = this.createUsualPoints();
            if (object != null) {
                for (int i = 0; i < ((Shape3D[])object).length; ++i) {
                    transformGroup.addChild((Node)object[i]);
                }
            }
            if ((shape3D = this.createSelectedPoints()) != null) {
                transformGroup.addChild((Node)shape3D);
            }
        }
        if (this.isSelectionBox()) {
            transformGroup.addChild((Node)this.createSelectionBox());
        }
        if (this.isShowText()) {
            transformGroup.addChild((Node)this.createText());
        }
        object = new OpenBehavior(transformGroup);
        object.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)object);
        return transformGroup;
    }

    private TransformGroup createLight(BoundingSphere boundingSphere, Vector3d vector3d) {
        Transform3D transform3D = new Transform3D();
        transform3D.set(vector3d);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        transformGroup.setCapability(1);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        Color3f color3f = new Color3f(1.0f, 1.0f, 1.0f);
        coloringAttributes.setColor(color3f);
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(coloringAttributes);
        transformGroup.addChild((Node)new Sphere(0.01f, 1, 15, appearance));
        PointLight pointLight = new PointLight(color3f, new Point3f(0.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f));
        pointLight.setInfluencingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)pointLight);
        return transformGroup;
    }

    private AmbientLight createAmbientLight(BoundingSphere boundingSphere) {
        AmbientLight ambientLight = new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f));
        ambientLight.setInfluencingBounds((Bounds)boundingSphere);
        return ambientLight;
    }

    private Cone createCone() {
        return new Cone(0.05f, 0.2f);
    }

    private Cylinder createCylinder(Color3f color3f) {
        Material material = new Material(color3f, this.blackColor, color3f, this.whiteColor, 100.0f);
        if (this.isWhiteBackground()) {
            material.setEmissiveColor(new Color3f(0.0f, 0.0f, 1.0f));
        }
        Appearance appearance = new Appearance();
        appearance.setLineAttributes(new LineAttributes(10.0f, 0, true));
        appearance.setMaterial(material);
        return new Cylinder(0.025f, 6.0f, appearance);
    }

    private TransformGroup createSelectionBox() {
        Material material = new Material(new Color3f(0.5f, 0.5f, 0.5f), this.blackColor, new Color3f(0.5f, 0.5f, 0.5f), this.blackColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparency(0.5f);
        transparencyAttributes.setTransparencyMode(2);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setMaterial(material);
        Transform3D transform3D = new Transform3D();
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        Vector3f vector3f = new Vector3f(this.boxPositionX * f, this.boxPositionY * f2, this.boxPositionZ * f3);
        transform3D.set(vector3f);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)new Box(this.boxSizeX * f / 2.0f, this.boxSizeY * f2 / 2.0f, this.boxSizeZ * f3 / 2.0f, appearance));
        return transformGroup;
    }

    private boolean isPointSelected(float f, float f2, float f3) {
        float f4 = this.boxPositionX - this.boxSizeX / 2.0f;
        float f5 = this.boxPositionX + this.boxSizeX / 2.0f;
        float f6 = this.boxPositionY - this.boxSizeY / 2.0f;
        float f7 = this.boxPositionY + this.boxSizeY / 2.0f;
        float f8 = this.boxPositionZ - this.boxSizeZ / 2.0f;
        float f9 = this.boxPositionZ + this.boxSizeZ / 2.0f;
        return f >= f4 && f <= f5 && f2 >= f6 && f2 <= f7 && f3 >= f8 && f3 <= f9;
    }

    protected int[] getSelectedGenes() {
        int[] nArray = new int[this.getPointsCount(true)];
        int n = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            if (!this.isPointSelected(this.U.get(i, 0), this.U.get(i, 1), this.U.get(i, 2))) continue;
            nArray[n] = this.experiment.getGeneIndexMappedToData(i);
            ++n;
        }
        return nArray;
    }

    private int getPointsCount(boolean bl) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            if (this.isPointSelected(this.U.get(i, 0), this.U.get(i, 1), this.U.get(i, 2))) {
                ++n2;
                continue;
            }
            ++n;
        }
        return bl ? n2 : n;
    }

    private int getUsualPointsCount() {
        if (this.isSelection()) {
            return this.getPointsCount(false);
        }
        return this.U.getRowDimension();
    }

    private Shape3D createSelectedPoints() {
        if (!this.isSelection()) {
            return null;
        }
        int n = this.getPointsCount(true);
        if (n < 1) {
            return null;
        }
        Color3f color3f = new Color3f(1.0f, 0.3f, 1.0f);
        Material material = new Material(color3f, color3f, color3f, color3f, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setPointAttributes(new PointAttributes(this.getSelectedPointSize(), false));
        appearance.setMaterial(material);
        PointArray pointArray = new PointArray(n, 7);
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        int n2 = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            float f4;
            float f5;
            float f6 = this.U.get(i, 0);
            if (!this.isPointSelected(f6, f5 = this.U.get(i, 1), f4 = this.U.get(i, 2))) continue;
            pointArray.setCoordinate(n2, new Point3f(f6 * f, f5 * f2, f4 * f3));
            ++n2;
        }
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)pointArray);
        return shape3D;
    }

    private Appearance createPointAppearance(Color3f color3f) {
        Material material = new Material(color3f, color3f, color3f, color3f, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setPointAttributes(new PointAttributes(this.getPointSize(), false));
        appearance.setMaterial(material);
        return appearance;
    }

    private Shape3D[] createUsualPoints() {
        Color3f color3f;
        int n;
        int n2 = this.getUsualPointsCount();
        if (n2 < 1) {
            return null;
        }
        int n3 = this.data.getColoredProbesCount(-1);
        int n4 = n3 == 0 ? 0 : 1;
        Color[] colorArray = this.geneViewer ? this.data.getColors() : this.data.getExperimentColors();
        PointArray[] pointArrayArray = new PointArray[colorArray.length + n4];
        Appearance[] appearanceArray = new Appearance[colorArray.length + n4];
        int[] nArray = new int[colorArray.length + n4];
        if (n3 > 0) {
            appearanceArray[0] = this.createPointAppearance(this.isWhiteBackground() ? this.blackColor : this.whiteColor);
            pointArrayArray[0] = new PointArray(n3, 7);
            nArray[0] = 0;
        }
        if (this.geneViewer) {
            for (n = 0; n < colorArray.length; ++n) {
                color3f = new Color3f(colorArray[n]);
                appearanceArray[n + n4] = this.createPointAppearance(color3f);
                pointArrayArray[n + n4] = new PointArray(this.data.getColoredProbesCount(n), 7);
                nArray[n + n4] = 0;
            }
        } else {
            for (n = 0; n < colorArray.length; ++n) {
                color3f = new Color3f(colorArray[n]);
                appearanceArray[n + n4] = this.createPointAppearance(color3f);
                pointArrayArray[n + n4] = new PointArray(this.data.getColoredExperimentsCount(n), 7);
                nArray[n + n4] = 0;
            }
        }
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        int n5 = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            float f4 = this.U.get(i, 0);
            float f5 = this.U.get(i, 1);
            float f6 = this.U.get(i, 2);
            if (this.isSelection() && this.isPointSelected(f4, f5, f6)) continue;
            n5 = this.geneViewer ? this.data.getProbeColorIndex(i) + n4 : this.data.getExperimentColorIndex(i) + n4;
            pointArrayArray[n5].setCoordinate(nArray[n5], new Point3f(f4 * f, f5 * f2, f6 * f3));
            int n6 = n5;
            nArray[n6] = nArray[n6] + 1;
        }
        Shape3D[] shape3DArray = new Shape3D[pointArrayArray.length];
        for (int i = 0; i < shape3DArray.length; ++i) {
            shape3DArray[i] = new Shape3D();
            shape3DArray[i].setAppearance(appearanceArray[i]);
            shape3DArray[i].setGeometry((Geometry)pointArrayArray[i]);
        }
        return shape3DArray;
    }

    private Appearance createSphereAppearance(Color3f color3f) {
        Material material = new Material(color3f, color3f, color3f, color3f, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        return appearance;
    }

    private TransformGroup createSpheres() {
        TransformGroup transformGroup = new TransformGroup();
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        Color3f color3f = this.isWhiteBackground() ? this.blackColor : this.whiteColor;
        Appearance appearance = this.createSphereAppearance(color3f);
        Color3f color3f2 = this.isSelection() ? new Color3f(1.0f, 0.3f, 1.0f) : color3f;
        Appearance appearance2 = this.createSphereAppearance(color3f2);
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            boolean bl;
            float f4 = this.U.get(i, 0);
            float f5 = this.U.get(i, 1);
            float f6 = this.U.get(i, 2);
            Transform3D transform3D = new Transform3D();
            Vector3d vector3d = new Vector3d((double)(f4 * f), (double)(f5 * f2), (double)(f6 * f3));
            transform3D.set(vector3d);
            TransformGroup transformGroup2 = new TransformGroup(transform3D);
            boolean bl2 = bl = this.isSelection() && this.isPointSelected(f4, f5, f6);
            if (this.geneViewer) {
                if (this.data.getProbeColor(i) == null) {
                    transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : appearance));
                } else {
                    transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : this.createSphereAppearance(new Color3f(this.data.getProbeColor(i)))));
                }
            } else if (this.data.getExperimentColor(i) == null) {
                transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : appearance));
            } else {
                transformGroup2.addChild((Node)new Sphere(this.getPointSize(bl) / 20.0f, bl ? appearance2 : this.createSphereAppearance(new Color3f(this.data.getExperimentColor(i)))));
            }
            transformGroup.addChild((Node)transformGroup2);
        }
        return transformGroup;
    }

    private TransformGroup createText() {
        TransformGroup transformGroup = new TransformGroup();
        float f = 3.0f / this.scaleAxisX;
        float f2 = 3.0f / this.scaleAxisY;
        float f3 = 3.0f / this.scaleAxisZ;
        Font3D font3D = new Font3D(new Font("TestFont", 1, Math.round(this.getPointSize(false))), new FontExtrusion());
        Color3f color3f = !this.whiteBackground ? new Color3f(1.0f, 1.0f, 1.0f) : new Color3f(0.0f, 0.0f, 0.0f);
        Material material = !this.whiteBackground ? new Material(color3f, this.whiteColor, color3f, this.whiteColor, 100.0f) : new Material(color3f, this.blackColor, color3f, this.blackColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(0.1);
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            float f4 = this.U.get(i, 0);
            float f5 = this.U.get(i, 1);
            float f6 = this.U.get(i, 2);
            TransformGroup transformGroup2 = new TransformGroup(transform3D);
            String string = this.mode == 1 ? this.data.getUniqueId(i) : this.data.getSampleName(this.experiment.getSampleIndex(i));
            Text3D text3D = new Text3D(font3D, string, new Point3f(f4 * f * 10.0f + this.getPointSize(this.isPointSelected(f4, f5, f6)), (f5 - 0.035f) * f2 * 10.0f, f6 * f3 * 10.0f));
            Shape3D shape3D = new Shape3D();
            shape3D.setGeometry((Geometry)text3D);
            shape3D.setAppearance(appearance);
            transformGroup2.addChild((Node)shape3D);
            transformGroup.addChild((Node)transformGroup2);
        }
        return transformGroup;
    }

    private Shape3D createTextShape3D(String string) {
        Material material;
        Font3D font3D = new Font3D(new Font("TestFont", 1, 1), new FontExtrusion());
        Text3D text3D = new Text3D(font3D, string);
        Shape3D shape3D = new Shape3D();
        shape3D.setGeometry((Geometry)text3D);
        if (!this.whiteBackground) {
            Color3f color3f = new Color3f(0.5f, 0.5f, 0.5f);
            material = new Material(color3f, this.blackColor, color3f, this.whiteColor, 100.0f);
        } else {
            Color3f color3f = new Color3f(0.0f, 0.0f, 0.0f);
            material = new Material(color3f, this.blackColor, color3f, this.blackColor, 100.0f);
        }
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        shape3D.setAppearance(appearance);
        return shape3D;
    }

    private TransformGroup createXAxis() {
        Transform3D transform3D = new Transform3D();
        transform3D.rotZ(-1.5707963267948966);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotZ(1.5707963267948966);
        if (!this.whiteBackground) {
            return this.createAxis("X", new Color3f(0.5f, 0.5f, 0.5f), transform3D, transform3D2);
        }
        return this.createAxis("X", new Color3f(0.0f, 0.0f, 0.0f), transform3D, transform3D2);
    }

    private TransformGroup createYAxis() {
        if (!this.whiteBackground) {
            return this.createAxis("Y", new Color3f(0.3f, 0.3f, 1.0f), null, null);
        }
        return this.createAxis("Y", new Color3f(0.0f, 0.0f, 0.0f), null, null);
    }

    private TransformGroup createZAxis() {
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(-1.5707963267948966);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY(1.5707963267948966);
        transform3D.mul(transform3D2);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotZ(1.5707963267948966);
        if (!this.whiteBackground) {
            return this.createAxis("Z", new Color3f(1.0f, 0.3f, 1.0f), transform3D, transform3D3);
        }
        return this.createAxis("Z", new Color3f(0.0f, 0.0f, 0.0f), transform3D, transform3D3);
    }

    private TransformGroup createAxis(String string, Color3f color3f, Transform3D transform3D, Transform3D transform3D2) {
        TransformGroup transformGroup = new TransformGroup();
        if (transform3D != null) {
            transformGroup.setTransform(transform3D);
        }
        transformGroup.addChild((Node)this.createCylinder(color3f));
        Transform3D transform3D3 = new Transform3D();
        transform3D3.set(new Vector3d(0.0, 3.1, 0.0));
        TransformGroup transformGroup2 = new TransformGroup(transform3D3);
        transformGroup2.addChild((Node)this.createCone());
        Transform3D transform3D4 = new Transform3D();
        transform3D4.set(new Vector3d(0.0, -3.1, 0.0));
        Transform3D transform3D5 = new Transform3D();
        transform3D5.rotX(Math.PI);
        transform3D4.mul(transform3D5);
        TransformGroup transformGroup3 = new TransformGroup(transform3D4);
        transformGroup3.addChild((Node)this.createCone());
        Transform3D transform3D6 = new Transform3D();
        transform3D6.set(0.22, new Vector3d(0.25, 2.75, -0.0125));
        TransformGroup transformGroup4 = new TransformGroup(transform3D6);
        TransformGroup transformGroup5 = new TransformGroup();
        if (transform3D2 != null) {
            transformGroup5.setTransform(transform3D2);
        }
        Shape3D shape3D = this.createTextShape3D(string);
        transformGroup5.addChild((Node)shape3D);
        transformGroup4.addChild((Node)transformGroup5);
        transformGroup.addChild((Node)transformGroup4);
        transformGroup.addChild((Node)transformGroup2);
        transformGroup.addChild((Node)transformGroup3);
        return transformGroup;
    }
}

