/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class PCASelectionDialog
extends AlgorithmDialog {
    private int result = 2;
    private SampleSelectionPanel sampleSelectionPanel;

    public PCASelectionDialog(Frame frame) {
        super(new JFrame(), "PCA: Principal Components Analysis", true);
        this.setSize(300, 110);
        super.setResizable(false);
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.setActionListeners(new EventListener());
        this.addContent(this.sampleSelectionPanel);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isClusterGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
    }

    public static void main(String[] stringArray) {
        PCASelectionDialog pCASelectionDialog = new PCASelectionDialog(new Frame());
        int n = pCASelectionDialog.showModal();
        System.out.println("result = " + n);
        System.exit(0);
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                PCASelectionDialog.this.result = 0;
                PCASelectionDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                PCASelectionDialog.this.result = 2;
                PCASelectionDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                PCASelectionDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(PCASelectionDialog.this, "PCA Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 350);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }
    }
}

