/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class ValuesViewer
extends ViewerAdapter {
    private JComponent header;
    private JComponent content;

    public ValuesViewer(FloatMatrix floatMatrix) {
        this.content = this.createContent(floatMatrix);
        this.header = this.createHeader();
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        JLabel jLabel = new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Eigenvalues</b></font></body></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        return jPanel;
    }

    private JComponent createContent(FloatMatrix floatMatrix) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumIntegerDigits(2);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
        decimalFormat.setGroupingUsed(false);
        float f = 0.0f;
        int n = floatMatrix.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            f += floatMatrix.get(i, i);
        }
        float f2 = 100.0f / f;
        for (int i = 0; i < n; ++i) {
            jTextArea.append("Principal Component " + new Integer(i + 1).toString() + "\t" + decimalFormat.format(floatMatrix.get(i, i)) + "\t" + decimalFormat.format(floatMatrix.get(i, i) * f2) + " %\n");
        }
        if (n > 1) {
            jTextArea.append("\n");
            jTextArea.append("First 2 components: " + decimalFormat.format((floatMatrix.get(0, 0) + floatMatrix.get(1, 1)) * f2) + " %\n");
            if (n > 2) {
                jTextArea.append("First 3 components: " + decimalFormat.format((floatMatrix.get(0, 0) + floatMatrix.get(1, 1) + floatMatrix.get(2, 2)) * f2) + " %\n");
            }
        }
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

