/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class RNSubnetInfoViewer
extends ViewerAdapter {
    private JComponent header;
    private JTextArea content;
    private boolean clusterGenes;
    private int[] orderedIndices;

    public RNSubnetInfoViewer(int[][] nArray, int n) {
        this.header = this.createHeader();
        this.clusterGenes = true;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public RNSubnetInfoViewer(int[][] nArray, int[] nArray2, int n, boolean bl) {
        this.orderedIndices = nArray2;
        this.header = this.createHeader();
        this.clusterGenes = bl;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Subnet Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent(int[][] nArray, int n) {
        int n2;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 6 * 25);
        int n3 = 0;
        String string = "";
        if (this.clusterGenes) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                string = "";
                if (nArray[this.orderedIndices[n2]].length <= 1) continue;
                string = string + "Subnet " + (n2 + 1);
                string = string + "\t";
                string = string + "# of Genes in Subnet: " + nArray[this.orderedIndices[n2]].length;
                string = string + "\n\t";
                string = string + "% of Genes in Subnet: " + Math.round((float)nArray[this.orderedIndices[n2]].length / (float)n * 100.0f) + "%";
                string = string + "\n\n";
                stringBuffer.append(string);
                n3 += string.length();
            }
        } else {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                string = "";
                if (nArray[this.orderedIndices[n2]].length <= 1) continue;
                string = string + "Subnet " + (n2 + 1);
                string = string + "\t";
                string = string + "# of Experiments in Subnet: " + nArray[this.orderedIndices[n2]].length;
                string = string + "\n\t";
                string = string + "% of Experiments in Subnet: " + Math.round((float)nArray[this.orderedIndices[n2]].length / (float)n * 100.0f) + "%";
                string = string + "\n\n";
                stringBuffer.append(string);
                n3 += string.length();
            }
        }
        String string2 = stringBuffer.substring(0, n3);
        jTextArea.setText(string2);
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

