/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class RelNetExperimentViewer
extends ExperimentViewer {
    private static final String SET_COLOR_CMD = "set-color-cmd";
    private static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    private static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    private static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    private JPopupMenu popup;

    public RelNetExperimentViewer(Experiment experiment, int[][] nArray) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
        this.getHeaderComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu, Listener listener) {
        JMenuItem jMenuItem = new JMenuItem("Set public cluster...", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setActionCommand(SET_COLOR_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        jMenuItem.setActionCommand(SET_DEF_COLOR_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveClusters(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveCluster(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (color != null) {
            this.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(RelNetExperimentViewer.SAVE_CLUSTER_CMD)) {
                RelNetExperimentViewer.this.onSaveCluster();
            } else if (string.equals(RelNetExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                RelNetExperimentViewer.this.onSaveClusters();
            } else if (string.equals(RelNetExperimentViewer.SET_COLOR_CMD)) {
                RelNetExperimentViewer.this.onSetColor();
            } else if (string.equals(RelNetExperimentViewer.SET_DEF_COLOR_CMD)) {
                RelNetExperimentViewer.this.onSetDefaultColor();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || RelNetExperimentViewer.this.getCluster() == null || RelNetExperimentViewer.this.getCluster().length == 0) {
                return;
            }
            RelNetExperimentViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

