/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class SAMDeltaInfoViewer
extends ViewerAdapter {
    private JComponent header;
    private JTextArea content;
    private double[] deltaGrid;
    private double[] medNumFalse;
    private double[] false90th;
    private double[] FDRMedian;
    private double[] FDR90th;
    private int[] numSig;
    private JPopupMenu popup;

    public SAMDeltaInfoViewer(double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, double[] dArray4, double[] dArray5) {
        this.deltaGrid = dArray;
        this.medNumFalse = dArray2;
        this.false90th = dArray3;
        this.numSig = nArray;
        this.FDRMedian = dArray4;
        this.FDR90th = dArray5;
        this.header = this.createHeader();
        this.content = this.createContent();
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 200, 10, 200);
        JLabel jLabel = new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Delta Table</b></font></body></html>");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 80);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  Delta\tMedian false\t90th %ile false\t  # sig. genes\tFDR(%) Median\t   FDR(%) 90th %ile");
        jTextArea.setForeground(Color.blue);
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 20);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(jTextArea, gridBagConstraints);
        jPanel.add(jTextArea);
        return jPanel;
    }

    private JTextArea createContent() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
        for (int i = 0; i < this.deltaGrid.length; ++i) {
            stringBuffer.append("  " + this.printFormat(this.deltaGrid[i]) + "\t" + this.printFormat(this.medNumFalse[i]) + "\t" + this.printFormat(this.false90th[i]) + "\t  " + this.numSig[i] + "\t" + this.printFormat(this.FDRMedian[i]) + "\t   " + this.printFormat(this.FDR90th[i]) + "\n");
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("Data"));
        jFileChooser.setDialogTitle("Save delta table");
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save delta table", GUIFactory.getIcon("save16.gif"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jFileChooser.showSaveDialog(SAMDeltaInfoViewer.this.getHeaderComponent());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                        printWriter.print("Delta\tMedian false\t90th %ile false\t# sig. genes\tFDR(%) Median\tFDR(%) 90th %ile\n\n");
                        for (int i = 0; i < SAMDeltaInfoViewer.this.deltaGrid.length; ++i) {
                            printWriter.print(SAMDeltaInfoViewer.this.deltaGrid[i] + "\t" + SAMDeltaInfoViewer.this.medNumFalse[i] + "\t" + SAMDeltaInfoViewer.this.false90th[i] + "\t" + SAMDeltaInfoViewer.this.numSig[i] + "\t" + SAMDeltaInfoViewer.this.FDRMedian[i] + "\t" + SAMDeltaInfoViewer.this.FDR90th[i] + "\n");
                        }
                        printWriter.println();
                        printWriter.flush();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.popup.add(jMenuItem);
        jTextArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    SAMDeltaInfoViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }

    private String printFormat(double d) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
        if (Double.isNaN(d)) {
            return "N/A";
        }
        return decimalFormat.format(d);
    }
}

