/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.util.awt.ActionInfoDialog;

public class SAMGraph
extends ActionInfoDialog {
    private double[] observedYArray;
    private double[] expectedXArray;
    private double delta;
    private double maxDelta;
    private double minDelta;
    int studyDesign;
    boolean infiniteDeltaEncountered;
    double[] deltaGrid;
    int[] numSigGenesByDelta;
    double[] medNumFalse;
    double[] false90th;
    double[] FDRMedian;
    double[] FDR90th;
    GraphPanel gPanel;
    BottomPanel bPanel;
    private String pubNumSig;
    private String pubNumFalseSigMed;
    private String pubNumFalseSig90th;
    private String pubFDRMed;
    private String pubFDR90th;

    public SAMGraph(JFrame jFrame, int n, double[] dArray, double[] dArray2, double d, double[] dArray3, int[] nArray, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, boolean bl) {
        super(jFrame, "SAM Graph", bl);
        this.studyDesign = n;
        this.observedYArray = dArray2;
        this.expectedXArray = dArray;
        this.delta = d;
        this.deltaGrid = dArray3;
        this.numSigGenesByDelta = nArray;
        this.medNumFalse = dArray4;
        this.false90th = dArray5;
        this.FDRMedian = dArray6;
        this.FDR90th = dArray7;
        this.infiniteDeltaEncountered = false;
        this.setBounds(0, 0, 800, 700);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.gPanel = new GraphPanel(dArray, dArray2);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 70);
        gridBagLayout.setConstraints(this.gPanel, gridBagConstraints);
        jPanel.add(this.gPanel);
        this.bPanel = new BottomPanel();
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 30);
        gridBagLayout.setConstraints(this.bPanel, gridBagConstraints);
        jPanel.add(this.bPanel);
        this.setContentPane(jPanel);
    }

    public SAMGraph() {
        super(new JFrame(), "SAM Graph", true);
        this.setBounds(0, 0, 600, 600);
        this.setDefaultCloseOperation(2);
        this.observedYArray = this.observedYArray;
        this.expectedXArray = this.expectedXArray;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.gPanel = new GraphPanel(this.expectedXArray, this.observedYArray);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.gPanel, gridBagConstraints);
        jPanel.add(this.gPanel);
        this.setContentPane(jPanel);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private float getMax(float[] fArray) {
        float f = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(f < fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    private float getMin(float[] fArray) {
        float f = Float.POSITIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(f > fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    private double getMax(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    private double getMin(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d > dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    private String getNumSig(double d) {
        String string = "";
        int n = 0;
        if (d >= this.maxDelta) {
            string = "0";
        } else if (d <= this.minDelta) {
            string = String.valueOf(this.observedYArray.length);
        } else {
            int n2 = 0;
            for (int i = 0; i < this.deltaGrid.length; ++i) {
                if (!(this.deltaGrid[i] > d)) continue;
                n2 = i;
                break;
            }
            n = this.deltaGrid[n2] - d > d - this.deltaGrid[n2 - 1] ? n2 - 1 : n2;
            string = String.valueOf(this.numSigGenesByDelta[n]);
        }
        this.pubNumSig = string;
        return string;
    }

    private String getNumFalseSig(double d) {
        String string = "";
        String string2 = "";
        int n = 0;
        if (d >= this.maxDelta || d <= this.minDelta) {
            this.pubNumFalseSigMed = string = "N/A        ";
            this.pubNumFalseSig90th = string;
            this.pubFDRMed = string;
            this.pubFDR90th = string;
            return string;
        }
        int n2 = 0;
        for (int i = 0; i < this.deltaGrid.length; ++i) {
            if (!(this.deltaGrid[i] > d)) continue;
            n2 = i;
            break;
        }
        n = this.deltaGrid[n2] - d > d - this.deltaGrid[n2 - 1] ? n2 - 1 : n2;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(5);
        decimalFormat.setMinimumFractionDigits(5);
        string = decimalFormat.format(this.medNumFalse[n]);
        this.pubNumFalseSig90th = decimalFormat.format(this.false90th[n]);
        this.pubFDRMed = decimalFormat.format(this.FDRMedian[n]);
        this.pubFDR90th = decimalFormat.format(this.FDR90th[n]);
        this.pubNumFalseSigMed = string;
        return string;
    }

    public String getNumSig() {
        return this.pubNumSig;
    }

    public String getNumFalseSigMed() {
        return this.pubNumFalseSigMed;
    }

    public String getNumFalseSig90th() {
        return this.pubNumFalseSig90th;
    }

    public String getFDRMedian() {
        return this.pubFDRMed;
    }

    public String getFDR90th() {
        return this.pubFDR90th;
    }

    public boolean useFoldChange() {
        return this.bPanel.useFoldChangeBox.isSelected();
    }

    public double getFoldChangeValue() {
        String string = this.bPanel.foldChangeTextField.getText();
        return Double.parseDouble(string);
    }

    public double getDelta() {
        String string = this.bPanel.deltaTextField.getText();
        if (this.infiniteDeltaEncountered) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.parseDouble(string);
    }

    public static void main(String[] stringArray) {
        SAMGraph sAMGraph = new SAMGraph();
        sAMGraph.setVisible(true);
    }

    private class GraphPanel
    extends JPanel {
        private double[] xArray;
        private double[] yArray;
        int originX;
        int originY;

        GraphPanel(double[] dArray, double[] dArray2) {
            this.setBorder(new LineBorder(Color.black));
            this.setBackground(Color.white);
            this.xArray = dArray;
            this.yArray = dArray2;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (SAMGraph.this.studyDesign == 4 || SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 7) {
                this.paint1(graphics);
            } else if (SAMGraph.this.studyDesign == 6) {
                this.paint2(graphics);
            }
        }

        private void paint1(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            this.originX = (int)Math.round((double)(this.getWidth() / 2));
            this.originY = (int)Math.round((double)(this.getHeight() / 2));
            double d = SAMGraph.this.getMax(this.xArray);
            double d2 = SAMGraph.this.getMax(this.yArray);
            double d3 = SAMGraph.this.getMin(this.xArray);
            double d4 = SAMGraph.this.getMin(this.yArray);
            double d5 = this.getXScalingFactor(d, d3);
            double d6 = this.getYScalingFactor(d2, d4);
            float[] fArray = new float[]{10.0f};
            BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
            graphics2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
            double[] dArray = new double[6];
            double[] dArray2 = new double[6];
            double d7 = 0.0;
            double d8 = 0.0;
            d7 = Math.abs(d) > Math.abs(d3) ? Math.abs(d / 5.0) : Math.abs(d3 / 5.0);
            d8 = Math.abs(d2) > Math.abs(d4) ? Math.abs(d2 / 5.0) : Math.abs(d4 / 5.0);
            double d9 = 0.0;
            double d10 = 0.0;
            for (n4 = 0; n4 < dArray.length; ++n4) {
                dArray[n4] = d9;
                d9 += d7;
                dArray2[n4] = d10;
                d10 += d8;
            }
            for (n4 = 1; n4 < dArray.length; ++n4) {
                graphics2D.drawLine((int)Math.round(dArray[n4] * d5) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(dArray[n4] * d5) + this.getWidth() / 2, this.getHeight() / 2 + 5);
            }
            for (n4 = 1; n4 < dArray.length; ++n4) {
                graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray[n4] * d5), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(dArray[n4] * d5), this.getHeight() / 2 + 5);
            }
            graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray[5] * d5), this.getHeight() / 2 + (int)Math.round(dArray[5] * d6), this.getWidth() / 2 + (int)Math.round(dArray[5] * d5), this.getHeight() / 2 - (int)Math.round(dArray[5] * d6));
            graphics2D.setColor(Color.gray);
            graphics2D.setStroke(new BasicStroke(1.0f));
            for (n4 = 1; n4 < dArray2.length; ++n4) {
                graphics2D.drawLine(0, this.getHeight() / 2 + (int)Math.round(dArray2[n4] * d6), this.getWidth(), this.getHeight() / 2 + (int)Math.round(dArray2[n4] * d6));
            }
            for (n4 = 1; n4 < dArray2.length; ++n4) {
                graphics2D.drawLine(0, this.getHeight() / 2 - (int)Math.round(dArray2[n4] * d6), this.getWidth(), this.getHeight() / 2 - (int)Math.round(dArray2[n4] * d6));
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.black);
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMaximumFractionDigits(2);
            for (n3 = 1; n3 < dArray.length; ++n3) {
                graphics2D.drawString(decimalFormat.format(dArray[n3]), (int)Math.round(dArray[n3] * d5) + this.getWidth() / 2 - 10, this.getHeight() / 2 + 20);
            }
            for (n3 = 1; n3 < dArray.length; ++n3) {
                graphics2D.drawString("-" + decimalFormat.format(dArray[n3]), this.getWidth() / 2 - (int)Math.round(dArray[n3] * d5) - 10, this.getHeight() / 2 + 20);
            }
            for (n3 = 1; n3 < dArray2.length; ++n3) {
                graphics2D.drawString(decimalFormat.format(dArray2[n3]), this.getWidth() / 2 - 30, this.getHeight() / 2 - (int)Math.round(dArray2[n3] * d6) - 5);
            }
            for (n3 = 1; n3 < dArray2.length; ++n3) {
                graphics2D.drawString("-" + decimalFormat.format(dArray2[n3]), this.getWidth() / 2 - 30, this.getHeight() / 2 + (int)Math.round(dArray2[n3] * d6) - 5);
            }
            n3 = (int)Math.round(SAMGraph.this.delta * d6);
            graphics2D.setStroke(basicStroke);
            graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray[5] * d5), this.getHeight() / 2 + (int)Math.round(dArray[5] * d6) - n3, this.getWidth() / 2 + (int)Math.round(dArray[5] * d5), this.getHeight() / 2 - (int)Math.round(dArray[5] * d6) - n3);
            graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray[5] * d5), this.getHeight() / 2 + (int)Math.round(dArray[5] * d6) + n3, this.getWidth() / 2 + (int)Math.round(dArray[5] * d5), this.getHeight() / 2 - (int)Math.round(dArray[5] * d6) + n3);
            graphics2D.setStroke(new BasicStroke(2.0f));
            boolean bl = false;
            boolean bl2 = false;
            int n7 = 0;
            int n8 = 0;
            for (n2 = 0; n2 < this.xArray.length; ++n2) {
                if (!(this.xArray[n2] > 0.0) || !(this.yArray[n2] - this.xArray[n2] > SAMGraph.this.delta)) continue;
                n7 = n2;
                bl = true;
                break;
            }
            for (n2 = 0; n2 < this.xArray.length; ++n2) {
                if (!(this.xArray[n2] < 0.0) || !(this.xArray[n2] - this.yArray[n2] > SAMGraph.this.delta)) continue;
                n8 = n2;
                bl2 = true;
            }
            Color[] colorArray = new Color[this.xArray.length];
            if (bl && bl2) {
                for (n = 0; n < n8 + 1; ++n) {
                    colorArray[n] = Color.green.darker();
                }
                for (n = n8 + 1; n < n7; ++n) {
                    colorArray[n] = Color.black;
                }
                for (n = n7; n < this.xArray.length; ++n) {
                    colorArray[n] = Color.red;
                }
            } else if (bl && !bl2) {
                for (n = 0; n < n7; ++n) {
                    colorArray[n] = Color.black;
                }
                for (n = n7; n < this.xArray.length; ++n) {
                    colorArray[n] = Color.red;
                }
            } else if (!bl && bl2) {
                for (n = 0; n < n8 + 1; ++n) {
                    colorArray[n] = Color.green.darker();
                }
                for (n = n8 + 1; n < this.xArray.length; ++n) {
                    colorArray[n] = Color.black;
                }
            } else if (!bl && !bl2) {
                for (n = 0; n < this.xArray.length; ++n) {
                    colorArray[n] = Color.black;
                }
            }
            for (n = 0; n < SAMGraph.this.expectedXArray.length; ++n) {
                graphics2D.setColor(colorArray[n]);
                this.drawPoint(graphics2D, this.xArray[n], this.yArray[n], this.getXScalingFactor(d, d3), this.getYScalingFactor(d2, d4), 5);
                graphics2D.setColor(Color.black);
            }
            graphics2D.drawString("X axis = Expected, Y axis = Observed", this.getWidth() / 2 + 25, this.getHeight() - 25);
        }

        private void paint2(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            this.originX = 30;
            this.originY = (int)Math.round((double)(this.getHeight() - 30));
            double d = SAMGraph.this.getMax(this.xArray);
            double d2 = SAMGraph.this.getMax(this.yArray);
            double d3 = SAMGraph.this.getMin(this.xArray);
            double d4 = SAMGraph.this.getMin(this.yArray);
            double d5 = this.getXScalingFactor(d, d3);
            double d6 = this.getYScalingFactor(d2, d4);
            float[] fArray = new float[]{10.0f};
            BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.drawLine(0, (int)Math.round((double)(this.getHeight() - 30)), this.getWidth(), (int)Math.round((double)(this.getHeight() - 30)));
            graphics2D.drawLine(30, 0, 30, this.getHeight());
            double[] dArray = new double[6];
            double[] dArray2 = new double[6];
            double d7 = 0.0;
            double d8 = 0.0;
            d7 = Math.abs(d) > Math.abs(d3) ? Math.abs(d / 5.0) : Math.abs(d3 / 5.0);
            d8 = Math.abs(d2) > Math.abs(d4) ? Math.abs(d2 / 5.0) : Math.abs(d4 / 5.0);
            double d9 = 0.0;
            double d10 = 0.0;
            for (n4 = 0; n4 < dArray.length; ++n4) {
                dArray[n4] = d9;
                d9 += d7;
                dArray2[n4] = d10;
                d10 += d8;
            }
            for (n4 = 1; n4 < dArray.length; ++n4) {
                graphics2D.drawLine((int)Math.round(dArray[n4] * d5) + 30, this.getHeight() - 30 - 5, (int)Math.round(dArray[n4] * d5) + 30, this.getHeight() - 30 + 5);
            }
            graphics2D.drawLine(30, this.getHeight() - 30, 30 + (int)Math.round(dArray[5] * d5), this.getHeight() - 30 - (int)Math.round(dArray[5] * d6));
            graphics2D.setColor(Color.gray);
            graphics2D.setStroke(new BasicStroke(1.0f));
            for (n4 = 1; n4 < dArray2.length; ++n4) {
                graphics2D.drawLine(0, this.getHeight() - 30 - (int)Math.round(dArray2[n4] * d6), this.getWidth(), this.getHeight() - 30 - (int)Math.round(dArray2[n4] * d6));
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.black);
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMaximumFractionDigits(2);
            for (n3 = 1; n3 < dArray.length; ++n3) {
                graphics2D.drawString(decimalFormat.format(dArray[n3]), (int)Math.round(dArray[n3] * d5) + 10, this.getHeight() - 5);
            }
            for (n3 = 1; n3 < dArray2.length; ++n3) {
                graphics2D.drawString(decimalFormat.format(dArray2[n3]), 5, this.getHeight() - 30 - (int)Math.round(dArray2[n3] * d6) - 5);
            }
            n3 = (int)Math.round(SAMGraph.this.delta * d6);
            graphics2D.setStroke(basicStroke);
            graphics2D.drawLine(30, this.getHeight() - 30 - n3, 30 + (int)Math.round(dArray[5] * d5), this.getHeight() - 30 - (int)Math.round(dArray[5] * d6) - n3);
            graphics2D.drawLine(30, this.getHeight() - 30 + n3, 30 + (int)Math.round(dArray[5] * d5), this.getHeight() - 30 - (int)Math.round(dArray[5] * d6) + n3);
            graphics2D.setStroke(new BasicStroke(2.0f));
            boolean bl = false;
            boolean bl2 = false;
            int n7 = 0;
            int n8 = 0;
            for (n2 = 0; n2 < this.xArray.length; ++n2) {
                if (!(this.xArray[n2] > 0.0) || !(this.yArray[n2] - this.xArray[n2] > SAMGraph.this.delta)) continue;
                n7 = n2;
                bl = true;
                break;
            }
            for (n2 = 0; n2 < this.xArray.length; ++n2) {
                if (!(this.xArray[n2] < 0.0) || !(this.xArray[n2] - this.yArray[n2] > SAMGraph.this.delta)) continue;
                n8 = n2;
                bl2 = true;
            }
            Color[] colorArray = new Color[this.xArray.length];
            if (bl && bl2) {
                for (n = 0; n < n8 + 1; ++n) {
                    colorArray[n] = Color.green.darker();
                }
                for (n = n8 + 1; n < n7; ++n) {
                    colorArray[n] = Color.black;
                }
                for (n = n7; n < this.xArray.length; ++n) {
                    colorArray[n] = Color.red;
                }
            } else if (bl && !bl2) {
                for (n = 0; n < n7; ++n) {
                    colorArray[n] = Color.black;
                }
                for (n = n7; n < this.xArray.length; ++n) {
                    colorArray[n] = Color.red;
                }
            } else if (!bl && bl2) {
                for (n = 0; n < n8 + 1; ++n) {
                    colorArray[n] = Color.green.darker();
                }
                for (n = n8 + 1; n < this.xArray.length; ++n) {
                    colorArray[n] = Color.black;
                }
            } else if (!bl && !bl2) {
                for (n = 0; n < this.xArray.length; ++n) {
                    colorArray[n] = Color.black;
                }
            }
            for (n = 0; n < SAMGraph.this.expectedXArray.length; ++n) {
                graphics2D.setColor(colorArray[n]);
                this.drawPoint(graphics2D, this.xArray[n], this.yArray[n], this.getXScalingFactor(d, d3), this.getYScalingFactor(d2, d4), 5);
                graphics2D.setColor(Color.black);
            }
            graphics2D.drawString("X axis = Expected, Y axis = Observed", 40, 20);
        }

        private void drawPoint(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n) {
            int n2 = (int)Math.round(d * d3);
            int n3 = (int)Math.round(d2 * d4);
            int n4 = 0;
            int n5 = 0;
            if (SAMGraph.this.studyDesign == 4 || SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 7) {
                n4 = (int)Math.round((double)(this.getWidth() / 2)) + n2;
                n5 = (int)Math.round((double)(this.getHeight() / 2)) - n3;
            } else if (SAMGraph.this.studyDesign == 6) {
                n4 = 30 + n2;
                n5 = (int)Math.round((double)(this.getHeight() - 30)) - n3;
            }
            graphics2D.fillOval(n4, n5, n, n);
        }

        private double getXScalingFactor(double d, double d2) {
            double d3 = 1.0;
            if (d > 0.0 && d2 > 0.0) {
                d3 = d;
            } else if (d > 0.0 && d2 < 0.0) {
                d3 = d > Math.abs(d2) ? d : Math.abs(d2);
            } else if (d <= 0.0) {
                d3 = Math.abs(d2);
            } else if (d2 == 0.0) {
                d3 = d;
            }
            double d4 = 0.0;
            if (SAMGraph.this.studyDesign == 4 || SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 7) {
                d4 = (double)(this.getWidth() / 2 - 50) / d3;
            } else if (SAMGraph.this.studyDesign == 6) {
                d4 = (double)(this.getWidth() - 50 - 30) / d3;
            }
            return d4;
        }

        private double getYScalingFactor(double d, double d2) {
            double d3 = 1.0;
            if (d > 0.0 && d2 > 0.0) {
                d3 = d;
            } else if (d > 0.0 && d2 < 0.0) {
                d3 = d > Math.abs(d2) ? d : Math.abs(d2);
            } else if (d <= 0.0) {
                d3 = Math.abs(d2);
            } else if (d2 == 0.0) {
                d3 = d;
            }
            double d4 = 0.0;
            if (SAMGraph.this.studyDesign == 4 || SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 7) {
                d4 = (double)(this.getHeight() / 2 - 50) / d3;
            } else if (SAMGraph.this.studyDesign == 6) {
                d4 = (double)(this.getHeight() - 30 - 50) / d3;
            }
            return d4;
        }
    }

    private class BottomPanel
    extends JPanel {
        JSlider deltaSlider;
        JTextField deltaTextField;
        JTextField foldChangeTextField;
        JLabel sigLabel;
        JLabel falseSigLabel;
        double maxValue;
        double initDelta;
        JCheckBox useFoldChangeBox;
        JButton okButton;

        BottomPanel() {
            this.setBorder(new EtchedBorder());
            double[] dArray = new double[SAMGraph.this.observedYArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = Math.abs(SAMGraph.this.observedYArray[i] - SAMGraph.this.expectedXArray[i]);
            }
            SAMGraph.this.maxDelta = SAMGraph.this.getMax(dArray);
            SAMGraph.this.minDelta = SAMGraph.this.getMin(dArray);
            this.maxValue = 0.0;
            double d = SAMGraph.this.getMax(SAMGraph.this.observedYArray);
            double d2 = SAMGraph.this.getMin(SAMGraph.this.observedYArray);
            this.maxValue = Math.abs(d) > Math.abs(d2) ? Math.abs(d) : Math.abs(d2);
            this.initDelta = SAMGraph.this.delta;
            this.deltaSlider = new JSlider(0, 100, (int)Math.round(this.initDelta * 100.0 / this.maxValue));
            this.deltaTextField = new JTextField("" + this.initDelta, 7);
            this.deltaTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    try {
                        string = BottomPanel.this.deltaTextField.getText();
                        double d = Double.parseDouble(string);
                        int n = (int)Math.round(d * 100.0 / BottomPanel.this.maxValue);
                        if (n >= 100) {
                            BottomPanel.this.deltaSlider.setValue(100);
                            BottomPanel.this.deltaTextField.setText("" + (float)BottomPanel.this.maxValue);
                        } else if (n <= 0) {
                            BottomPanel.this.deltaSlider.setValue(0);
                            BottomPanel.this.deltaTextField.setText("0.0");
                        } else {
                            BottomPanel.this.deltaSlider.setValue(n);
                            BottomPanel.this.deltaTextField.setText("" + (float)d);
                        }
                    }
                    catch (Exception exception) {
                        BottomPanel.this.deltaSlider.setValue(25);
                        BottomPanel.this.deltaTextField.setText("" + (float)BottomPanel.this.initDelta);
                    }
                    string = BottomPanel.this.deltaTextField.getText();
                    SAMGraph.this.delta = Double.parseDouble(string);
                    BottomPanel.this.sigLabel.setText("Number of Significant Genes: " + SAMGraph.this.getNumSig(SAMGraph.this.delta));
                    BottomPanel.this.falseSigLabel.setText("Median number of false significant genes" + SAMGraph.this.getNumFalseSig(SAMGraph.this.delta));
                    SAMGraph.this.gPanel.repaint();
                }
            });
            this.deltaTextField.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent focusEvent) {
                    String string;
                    try {
                        string = BottomPanel.this.deltaTextField.getText();
                        double d = Double.parseDouble(string);
                        int n = (int)Math.round(d * 100.0 / BottomPanel.this.maxValue);
                        if (n >= 100) {
                            BottomPanel.this.deltaSlider.setValue(100);
                            BottomPanel.this.deltaTextField.setText("" + (float)BottomPanel.this.maxValue);
                        } else if (n <= 0) {
                            BottomPanel.this.deltaSlider.setValue(0);
                            BottomPanel.this.deltaTextField.setText("0.0");
                        } else {
                            BottomPanel.this.deltaSlider.setValue(n);
                            BottomPanel.this.deltaTextField.setText("" + (float)d);
                        }
                    }
                    catch (Exception exception) {
                        BottomPanel.this.deltaSlider.setValue(25);
                        BottomPanel.this.deltaTextField.setText("" + (float)BottomPanel.this.initDelta);
                    }
                    string = BottomPanel.this.deltaTextField.getText();
                    SAMGraph.this.delta = Double.parseDouble(string);
                    BottomPanel.this.sigLabel.setText("Number of Significant Genes: " + SAMGraph.this.getNumSig(SAMGraph.this.delta));
                    BottomPanel.this.falseSigLabel.setText("Median number of false significant genes: " + SAMGraph.this.getNumFalseSig(SAMGraph.this.delta));
                    SAMGraph.this.gPanel.repaint();
                }

                public void focusGained(FocusEvent focusEvent) {
                }
            });
            this.deltaSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    int n = jSlider.getValue();
                    double d = (double)n * BottomPanel.this.maxValue / 100.0;
                    if (n == 0) {
                        d = 0.0;
                    }
                    BottomPanel.this.deltaTextField.setText("" + (float)d);
                    String string = BottomPanel.this.deltaTextField.getText();
                    if (!Double.isInfinite(d)) {
                        SAMGraph.this.delta = Double.parseDouble(string);
                    } else {
                        SAMGraph.this.infiniteDeltaEncountered = true;
                        SAMGraph.this.delta = Double.POSITIVE_INFINITY;
                    }
                    BottomPanel.this.sigLabel.setText("Number of Significant Genes: " + SAMGraph.this.getNumSig(SAMGraph.this.delta));
                    BottomPanel.this.falseSigLabel.setText("Median number of false significant genes: " + SAMGraph.this.getNumFalseSig(SAMGraph.this.delta));
                    SAMGraph.this.gPanel.repaint();
                }
            });
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.sigLabel = new JLabel("Number of significant genes: " + SAMGraph.this.getNumSig(SAMGraph.this.delta));
            SAMGraph.this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 50, 30);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.sigLabel, gridBagConstraints);
            this.add(this.sigLabel);
            this.falseSigLabel = new JLabel("Median number of falsely significant genes: " + SAMGraph.this.getNumFalseSig(SAMGraph.this.delta));
            SAMGraph.this.buildConstraints(gridBagConstraints, 1, 0, 2, 1, 50, 0);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.falseSigLabel, gridBagConstraints);
            this.add(this.falseSigLabel);
            JLabel jLabel = new JLabel("Use slider to set delta value: ");
            SAMGraph.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 25, 40);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            SAMGraph.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 25, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.deltaSlider, gridBagConstraints);
            this.add(this.deltaSlider);
            JLabel jLabel2 = new JLabel("Or enter delta value here: ");
            SAMGraph.this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 25, 0);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            this.add(jLabel2);
            SAMGraph.this.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 25, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.deltaTextField, gridBagConstraints);
            this.add(this.deltaTextField);
            this.useFoldChangeBox = new JCheckBox("Use Fold Change:", false);
            if (SAMGraph.this.studyDesign == 5 || SAMGraph.this.studyDesign == 4) {
                this.useFoldChangeBox.setEnabled(true);
            } else {
                this.useFoldChangeBox.setEnabled(false);
            }
            this.foldChangeTextField = new JTextField("", 7);
            this.foldChangeTextField.setBackground(Color.darkGray);
            this.foldChangeTextField.setEnabled(false);
            this.useFoldChangeBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        BottomPanel.this.foldChangeTextField.setBackground(Color.darkGray);
                        BottomPanel.this.foldChangeTextField.setText("");
                        BottomPanel.this.foldChangeTextField.setEnabled(false);
                    } else if (itemEvent.getStateChange() == 1) {
                        BottomPanel.this.foldChangeTextField.setBackground(Color.white);
                        BottomPanel.this.foldChangeTextField.setText("2.0");
                        BottomPanel.this.foldChangeTextField.setEnabled(true);
                    }
                }
            });
            SAMGraph.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 30, 30);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.useFoldChangeBox, gridBagConstraints);
            this.add(this.useFoldChangeBox);
            SAMGraph.this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 30, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.foldChangeTextField, gridBagConstraints);
            this.add(this.foldChangeTextField);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (BottomPanel.this.useFoldChangeBox.isSelected()) {
                        try {
                            String string = BottomPanel.this.foldChangeTextField.getText();
                            double d = Double.parseDouble(string);
                            SAMGraph.this.dispose();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, "Either deselect the Use Fold Change CheckBox or enter a valid fold change value", "Error!", 2);
                        }
                    } else {
                        SAMGraph.this.dispose();
                    }
                }
            });
            SAMGraph.this.buildConstraints(gridBagConstraints, 2, 2, 2, 1, 40, 0);
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
            this.add(this.okButton);
        }
    }
}

