/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.som.SOMExperimentHeader;
import org.tigr.util.FloatMatrix;

public class SOMExperimentViewer
implements IViewer {
    private JPopupMenu popup;
    private ExperimentViewer expViewer;
    private SOMExperimentHeader header;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";

    public SOMExperimentViewer(Experiment experiment, int[][] nArray, FloatMatrix floatMatrix) {
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.expViewer = new ExperimentViewer(experiment, nArray);
        this.expViewer.getContentComponent().addMouseListener(listener);
        this.header = new SOMExperimentHeader(this.expViewer.getHeaderComponent(), floatMatrix, nArray);
        this.header.setColorImages(this.expViewer.getNegColorImage(), this.expViewer.getPosColorImage());
        this.header.setMissingColor(this.expViewer.getMissingColor());
        this.header.addMouseListener(listener);
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this.expViewer.getContentComponent();
    }

    public BufferedImage getImage() {
        return this.expViewer.getImage();
    }

    public void onSelected(IFramework iFramework) {
        this.expViewer.onSelected(iFramework);
        this.header.setCurrentCluster((Integer)iFramework.getUserObject());
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.header.setColorImages(iDisplayMenu.getPositiveGradientImage(), iDisplayMenu.getNegativeGradientImage());
        this.header.setValues(Math.abs(iDisplayMenu.getMaxRatioScale()), -Math.abs(iDisplayMenu.getMinRatioScale()));
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.header.updateSize(iDisplayMenu.getElementSize());
    }

    public void onDataChanged(IData iData) {
        this.expViewer.onDataChanged(iData);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.expViewer.onMenuChanged(iDisplayMenu);
        this.header.setColorImages(iDisplayMenu.getPositiveGradientImage(), iDisplayMenu.getNegativeGradientImage());
        this.header.setValues(Math.abs(iDisplayMenu.getMaxRatioScale()), -Math.abs(iDisplayMenu.getMinRatioScale()));
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.header.updateSize(iDisplayMenu.getElementSize());
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("Store cluster", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("analysis16.gif"));
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        jMenuItem.setActionCommand(SET_DEF_COLOR_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.expViewer.saveClusters(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.expViewer.saveCluster(frame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (color != null) {
            this.expViewer.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.expViewer.setClusterColor(null);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SOMExperimentViewer.SAVE_CLUSTER_CMD)) {
                SOMExperimentViewer.this.onSaveCluster();
            } else if (string.equals(SOMExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                SOMExperimentViewer.this.onSaveClusters();
            } else if (string.equals(SOMExperimentViewer.SET_DEF_COLOR_CMD)) {
                SOMExperimentViewer.this.onSetDefaultColor();
            } else if (string.equals(SOMExperimentViewer.STORE_CLUSTER_CMD)) {
                SOMExperimentViewer.this.expViewer.storeCluster();
            } else if (string.equals(SOMExperimentViewer.LAUNCH_NEW_SESSION_CMD)) {
                SOMExperimentViewer.this.expViewer.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || SOMExperimentViewer.this.expViewer.getCluster() == null || SOMExperimentViewer.this.expViewer.getCluster().length == 0) {
                return;
            }
            SOMExperimentViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

