/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.LineBorder;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.sota.SOTATreeData;
import org.tigr.util.FloatMatrix;

public class SOTAExperimentViewer
extends JPanel
implements IViewer {
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    private static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    private static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private JPopupMenu popup;
    JSplitPane viewSplitPane;
    private IViewer expViewer;
    private JComponent header;
    private InfoPanel infoPanel;
    private JPanel viewPanel;
    private int[][] clusters;
    private FloatMatrix clusterDivFM;
    private FloatMatrix centroidDataFM;
    private int numberOfCells;
    private float factor;
    private int function;
    private boolean geneClusterViewer = true;

    public SOTAExperimentViewer(Experiment experiment, int[][] nArray, FloatMatrix floatMatrix, FloatMatrix floatMatrix2, SOTATreeData sOTATreeData) {
        this.setLayout(new GridBagLayout());
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusters = nArray;
        this.clusterDivFM = floatMatrix2;
        this.numberOfCells = 0;
        if (this.clusterDivFM != null) {
            this.numberOfCells = this.clusterDivFM.getRowDimension();
        }
        this.centroidDataFM = floatMatrix;
        this.factor = sOTATreeData.factor;
        this.function = sOTATreeData.function;
        this.expViewer = new ExperimentViewer(experiment, nArray);
        this.expViewer.getContentComponent().addMouseListener(listener);
        this.header = new CentroidExperimentHeader(this.expViewer.getHeaderComponent(), floatMatrix, nArray, "SOTA Centroid Vector");
        ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(((ExperimentViewer)this.expViewer).getNegColorImage(), ((ExperimentViewer)this.expViewer).getPosColorImage());
        this.infoPanel = new InfoPanel();
        this.infoPanel.addMouseListener(listener);
        ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(((ExperimentViewer)this.expViewer).getNegColorImage(), ((ExperimentViewer)this.expViewer).getPosColorImage());
        ((CentroidExperimentHeader)this.header).setMissingColor(((ExperimentViewer)this.expViewer).getMissingColor());
        ((CentroidExperimentHeader)this.header).addMouseListener(listener);
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new GridBagLayout());
        this.viewPanel.add((Component)((JComponent)((Object)this.expViewer)), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.viewPanel.add((Component)this.infoPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.viewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public SOTAExperimentViewer(Experiment experiment, int[][] nArray, FloatMatrix floatMatrix, FloatMatrix floatMatrix2, SOTATreeData sOTATreeData, boolean bl) {
        this.setLayout(new GridBagLayout());
        this.geneClusterViewer = bl;
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusters = nArray;
        this.clusterDivFM = floatMatrix2;
        this.numberOfCells = 0;
        if (this.clusterDivFM != null) {
            this.numberOfCells = this.clusterDivFM.getRowDimension();
        }
        this.centroidDataFM = floatMatrix;
        this.factor = sOTATreeData.factor;
        this.function = sOTATreeData.function;
        if (!bl) {
            this.expViewer = new ExperimentClusterViewer(experiment, nArray, "Sota Centroid Vector", floatMatrix.getArrayCopy());
            this.header = (ExperimentClusterHeader)this.expViewer.getHeaderComponent();
        } else {
            this.expViewer = new ExperimentViewer(experiment, nArray);
            this.header = new CentroidExperimentHeader(this.expViewer.getHeaderComponent(), floatMatrix, this.clusters, "SOTA Centroid Vector");
        }
        this.expViewer.getContentComponent().addMouseListener(listener);
        this.infoPanel = new InfoPanel();
        this.infoPanel.addMouseListener(listener);
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new GridBagLayout());
        this.viewPanel.add((Component)((JComponent)((Object)this.expViewer)), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.viewPanel.add((Component)this.infoPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.viewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addComponents(JComponent jComponent, ExperimentViewer experimentViewer, InfoPanel infoPanel) {
        this.add((Component)experimentViewer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)infoPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return this.expViewer.getImage();
    }

    public void onSelected(IFramework iFramework) {
        if (this.geneClusterViewer) {
            ((ExperimentViewer)this.expViewer).onSelected(iFramework);
        } else {
            ((ExperimentClusterViewer)this.expViewer).onSelected(iFramework);
        }
        Integer n = (Integer)iFramework.getUserObject();
        this.infoPanel.setCurrentCluster(n == null ? 0 : n);
        this.infoPanel.onSelected();
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        if (this.geneClusterViewer) {
            ((CentroidExperimentHeader)this.header).setCurrentCluster(n == null ? 0 : n);
            ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(iDisplayMenu.getNegativeGradientImage(), iDisplayMenu.getPositiveGradientImage());
            ((CentroidExperimentHeader)this.header).setValues(Math.abs(iDisplayMenu.getMaxRatioScale()), -Math.abs(iDisplayMenu.getMinRatioScale()));
            ((CentroidExperimentHeader)this.header).setAntiAliasing(iDisplayMenu.isAntiAliasing());
            ((CentroidExperimentHeader)this.header).setDrawBorders(iDisplayMenu.isDrawingBorder());
            ((CentroidExperimentHeader)this.header).updateSize(iDisplayMenu.getElementSize());
            int n2 = ((CentroidExperimentHeader)this.header).getCurrHeight();
            this.header.setSize(this.getContentWidth(), n2);
            this.header.setPreferredSize(new Dimension(this.getContentWidth(), n2));
        } else {
            ((ExperimentClusterHeader)this.header).updateSizes(this.getContentWidth(), iDisplayMenu.getElementSize().width);
        }
        this.repaint();
    }

    private int getContentWidth() {
        int n = this.geneClusterViewer ? ((ExperimentViewer)this.expViewer).getContentWidth() : ((ExperimentClusterViewer)this.expViewer).getContentWidth();
        return n += this.infoPanel.INFO_PANEL_WIDTH;
    }

    public void onDataChanged(IData iData) {
        this.expViewer.onDataChanged(iData);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        if (this.geneClusterViewer) {
            ((ExperimentViewer)this.expViewer).onMenuChanged(iDisplayMenu);
        } else {
            ((ExperimentClusterViewer)this.expViewer).onMenuChanged(iDisplayMenu);
        }
        if (this.geneClusterViewer) {
            ((CentroidExperimentHeader)this.header).setNegAndPosColorImages(iDisplayMenu.getNegativeGradientImage(), iDisplayMenu.getPositiveGradientImage());
            ((CentroidExperimentHeader)this.header).setValues(Math.abs(iDisplayMenu.getMaxRatioScale()), -Math.abs(iDisplayMenu.getMinRatioScale()));
            ((CentroidExperimentHeader)this.header).setAntiAliasing(iDisplayMenu.isAntiAliasing());
            ((CentroidExperimentHeader)this.header).setDrawBorders(iDisplayMenu.isDrawingBorder());
            ((CentroidExperimentHeader)this.header).updateSize(iDisplayMenu.getElementSize());
            this.header.setSize(this.getContentWidth(), this.header.getHeight());
            this.header.setPreferredSize(new Dimension(this.getContentWidth(), this.header.getHeight()));
        } else {
            ((ExperimentClusterHeader)this.header).updateSizes(this.getContentWidth(), iDisplayMenu.getElementSize().width);
        }
        this.repaint();
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("Store cluster", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("analysis16.gif"));
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        jMenuItem.setActionCommand(SET_DEF_COLOR_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            if (this.expViewer instanceof ExperimentViewer) {
                ((ExperimentViewer)this.expViewer).saveClusters(frame);
            } else {
                ((ExperimentClusterViewer)this.expViewer).saveClusters(frame);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            if (this.expViewer instanceof ExperimentViewer) {
                ((ExperimentViewer)this.expViewer).saveCluster(frame);
            } else {
                ((ExperimentClusterViewer)this.expViewer).saveCluster(frame);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (color != null) {
            if (this.expViewer instanceof ExperimentViewer) {
                ((ExperimentViewer)this.expViewer).setClusterColor(color);
            } else {
                ((ExperimentClusterViewer)this.expViewer).setClusterColor(color);
            }
        }
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            if (this.expViewer instanceof ExperimentViewer) {
                ((ExperimentViewer)this.expViewer).setClusterColor(null);
            } else {
                ((ExperimentClusterViewer)this.expViewer).setClusterColor(null);
            }
        }
    }

    public void launchNewSession() {
        if (this.expViewer instanceof ExperimentViewer) {
            ((ExperimentViewer)this.expViewer).launchNewSession();
        } else {
            ((ExperimentClusterViewer)this.expViewer).launchNewSession();
        }
    }

    public void storeCluster() {
        if (this.expViewer instanceof ExperimentViewer) {
            ((ExperimentViewer)this.expViewer).storeCluster();
        } else {
            ((ExperimentClusterViewer)this.expViewer).storeCluster();
        }
    }

    private void onSetDefaultColor() {
        if (this.expViewer instanceof ExperimentViewer) {
            ((ExperimentViewer)this.expViewer).setClusterColor(null);
        } else {
            ((ExperimentClusterViewer)this.expViewer).setClusterColor(null);
        }
    }

    public class InfoPanel
    extends JPanel {
        private int currCluster;
        public int INFO_PANEL_WIDTH = 300;
        private JSplitPane jSplitPane1;
        private JScrollPane viewerPane;
        private JPanel infoPanel;
        private JLabel jLabel10;
        private JLabel jLabel11;
        private JLabel jLabel12;
        private JLabel jLabel13;
        private JLabel jLabel14;
        private JLabel jLabel15;
        private JLabel jLabel16;
        private JLabel jLabel17;
        private JLabel c1Label;
        private JLabel c1PopLabel;
        private JLabel c1DivLabel;
        private JLabel distLabel;
        private JLabel c2Label;
        private JLabel c2DivLabel;
        private JLabel c2PopLabel;

        public InfoPanel() {
            this.initComponents();
            this.currCluster = 0;
            this.setSize(this.INFO_PANEL_WIDTH, 350);
            this.setPreferredSize(new Dimension(this.INFO_PANEL_WIDTH, 350));
            this.setVisible(true);
            this.setBackground(Color.white);
            super.setBackground(Color.white);
        }

        private void initComponents() {
            this.jLabel10 = new JLabel();
            this.jLabel11 = new JLabel();
            this.jLabel12 = new JLabel();
            this.jLabel13 = new JLabel();
            this.jLabel14 = new JLabel();
            this.jLabel15 = new JLabel();
            this.jLabel16 = new JLabel();
            this.jLabel17 = new JLabel();
            this.c1Label = new JLabel();
            this.c1PopLabel = new JLabel();
            this.c1DivLabel = new JLabel();
            this.distLabel = new JLabel();
            this.c2Label = new JLabel();
            this.c2DivLabel = new JLabel();
            this.c2PopLabel = new JLabel();
            this.setLayout(null);
            this.setBackground(Color.white);
            super.setBackground(Color.white);
            this.setBorder(new LineBorder(Color.black, 1));
            this.setAlignmentY(1.0f);
            this.setAlignmentX(1.0f);
            this.setOpaque(false);
            this.jLabel10.setText("Cluster ID#:");
            this.jLabel10.setForeground(Color.black);
            this.add(this.jLabel10);
            this.jLabel10.setBounds(20, 30, 65, 17);
            this.jLabel11.setText("Cluster Population:");
            this.jLabel11.setForeground(Color.black);
            this.add(this.jLabel11);
            this.jLabel11.setBounds(20, 60, 107, 17);
            this.jLabel12.setText("Cluster Diversity:");
            this.jLabel12.setForeground(Color.black);
            this.add(this.jLabel12);
            this.jLabel12.setBounds(20, 90, 96, 17);
            this.jLabel13.setText("Distance to");
            this.jLabel13.setForeground(Color.black);
            this.add(this.jLabel13);
            this.jLabel13.setBounds(20, 130, 64, 17);
            this.jLabel14.setText("Closest Neighbor:");
            this.jLabel14.setForeground(Color.black);
            this.add(this.jLabel14);
            this.jLabel14.setBounds(20, 150, 100, 17);
            this.jLabel15.setText("Neighbor ID#:");
            this.jLabel15.setForeground(Color.black);
            this.add(this.jLabel15);
            this.jLabel15.setBounds(20, 190, 75, 17);
            this.jLabel16.setText("Neighbor Population:");
            this.jLabel16.setForeground(Color.black);
            this.add(this.jLabel16);
            this.jLabel16.setBounds(20, 220, 117, 17);
            this.jLabel17.setText("Neighbor Diversity:");
            this.jLabel17.setForeground(Color.black);
            this.add(this.jLabel17);
            this.jLabel17.setBounds(20, 250, 106, 17);
            this.c1Label.setForeground(Color.black);
            this.add(this.c1Label);
            this.c1Label.setBounds(150, 30, 70, 20);
            this.c1PopLabel.setForeground(Color.black);
            this.add(this.c1PopLabel);
            this.c1PopLabel.setBounds(150, 60, 70, 20);
            this.c1DivLabel.setForeground(Color.black);
            this.add(this.c1DivLabel);
            this.c1DivLabel.setBounds(150, 90, 110, 20);
            this.distLabel.setForeground(Color.black);
            this.add(this.distLabel);
            this.distLabel.setBounds(150, 150, 110, 20);
            this.c2Label.setForeground(Color.black);
            this.add(this.c2Label);
            this.c2Label.setBounds(150, 190, 70, 20);
            this.c2DivLabel.setForeground(Color.black);
            this.add(this.c2DivLabel);
            this.c2DivLabel.setBounds(150, 250, 110, 20);
            this.c2PopLabel.setForeground(Color.black);
            this.add(this.c2PopLabel);
            this.c2PopLabel.setBounds(150, 220, 70, 20);
        }

        private void setData(int n, int n2, float f, float f2, int n3, int n4, float f3) {
            this.c1Label.setText(String.valueOf(n + 1));
            this.c1PopLabel.setText(String.valueOf(n2));
            this.c1DivLabel.setText(String.valueOf(f));
            this.distLabel.setText(String.valueOf(f2 * SOTAExperimentViewer.this.factor));
            this.c2Label.setText(String.valueOf(n3 + 1));
            this.c2PopLabel.setText(String.valueOf(n4));
            this.c2DivLabel.setText(String.valueOf(f3));
            this.repaint();
        }

        private void clearData(int n) {
            this.c1Label.setText(String.valueOf(n + 1));
            this.c1PopLabel.setText("");
            this.c1DivLabel.setText("");
            this.distLabel.setText("");
            this.c2Label.setText("");
            this.c2PopLabel.setText("");
            this.c2DivLabel.setText("");
            this.repaint();
        }

        private int getClosestCentroid(int n) {
            float f = Float.POSITIVE_INFINITY;
            int n2 = n;
            for (int i = 0; i < SOTAExperimentViewer.this.numberOfCells; ++i) {
                float f2 = ExperimentUtil.geneDistance(SOTAExperimentViewer.this.centroidDataFM, null, n, i, SOTAExperimentViewer.this.function, 1.0f, false);
                if (!(f2 < f) || i == n) continue;
                f = f2;
                n2 = i;
            }
            return n2;
        }

        public void setCurrentCluster(int n) {
            this.currCluster = n;
        }

        public void onSelected() {
            int n = this.getClosestCentroid(this.currCluster);
            if (n == this.currCluster) {
                return;
            }
            float f = ExperimentUtil.geneDistance(SOTAExperimentViewer.this.centroidDataFM, null, this.currCluster, n, SOTAExperimentViewer.this.function, 1.0f, false);
            if (f == Float.POSITIVE_INFINITY || f == 0.0f || n >= SOTAExperimentViewer.this.numberOfCells || SOTAExperimentViewer.this.clusterDivFM == null || SOTAExperimentViewer.this.clusters[this.currCluster].length <= 0) {
                this.clearData(this.currCluster);
            } else {
                this.setData(this.currCluster, SOTAExperimentViewer.this.clusters[this.currCluster].length, SOTAExperimentViewer.this.clusterDivFM.get(this.currCluster, 0), f, n, SOTAExperimentViewer.this.clusters[n].length, SOTAExperimentViewer.this.clusterDivFM.get(n, 0));
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SOTAExperimentViewer.SAVE_CLUSTER_CMD)) {
                SOTAExperimentViewer.this.onSaveCluster();
            } else if (string.equals(SOTAExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                SOTAExperimentViewer.this.onSaveClusters();
            } else if (string.equals(SOTAExperimentViewer.SET_DEF_COLOR_CMD)) {
                SOTAExperimentViewer.this.onSetDefaultColor();
            } else if (string.equals(SOTAExperimentViewer.STORE_CLUSTER_CMD)) {
                SOTAExperimentViewer.this.storeCluster();
            } else if (string.equals(SOTAExperimentViewer.LAUNCH_NEW_SESSION_CMD)) {
                SOTAExperimentViewer.this.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            int[] nArray = null;
            nArray = SOTAExperimentViewer.this.expViewer instanceof ExperimentViewer ? ((ExperimentViewer)SOTAExperimentViewer.this.expViewer).getCluster() : ((ExperimentClusterViewer)SOTAExperimentViewer.this.expViewer).getCluster();
            if (!mouseEvent.isPopupTrigger() || nArray == null || nArray.length == 0) {
                return;
            }
            SOTAExperimentViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

