/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.event.MouseInputAdapter;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

abstract class SVMResultViewer
extends JPanel
implements IViewer {
    protected JTextArea Log;
    protected JPanel resultPanel;
    private JPopupMenu MyPopup;
    private JMenuItem menuItem1;
    protected int labelIndex;
    protected IFramework framework;
    private Experiment analysisExperiment;
    protected String[] fieldNames;
    JPanel panel1 = new JPanel();

    public SVMResultViewer(IFramework iFramework) {
        JPanel jPanel = new JPanel();
        this.framework = iFramework;
        this.labelIndex = iFramework.getDisplayMenu().getLabelIndex();
        this.analysisExperiment = iFramework.getData().getExperiment();
        this.fieldNames = iFramework.getData().getFieldNames();
        BorderLayout borderLayout = new BorderLayout();
        BorderLayout borderLayout2 = new BorderLayout();
        JLabel jLabel = new JLabel();
        this.Log = new JTextArea();
        this.Log.setFont(new Font("monospaced", 0, 14));
        this.Log.setTabSize(3);
        this.Log.setEditable(false);
        this.Log.setAutoscrolls(true);
        this.Log.setBackground(new Color(208, 208, 208));
        this.Log.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Parameters"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.Log, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.MyPopup = new JPopupMenu();
        this.menuItem1 = new JMenuItem("Save classification...", GUIFactory.getIcon("save_as16.gif"));
        this.menuItem1.setActionCommand("save-result-command");
        this.menuItem1.addActionListener(new Listener());
        this.MyPopup.add(this.menuItem1);
        MyListener myListener = new MyListener();
        this.addMouseListener(myListener);
        this.addMouseMotionListener(myListener);
        this.Log.addMouseListener(myListener);
        this.Log.addMouseMotionListener(myListener);
    }

    protected abstract void displayData();

    protected abstract void onSaveResult();

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
        this.onMenuChanged(iFramework.getDisplayMenu());
    }

    public void onDataChanged(IData iData) {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.labelIndex = this.framework.getDisplayMenu().getLabelIndex();
        this.displayData();
        this.updateSize();
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    protected abstract Dimension updateSize();

    protected int getMultipleArrayDataRow(int n) {
        return this.analysisExperiment.getGeneIndexMappedToData(n);
    }

    class Listener
    implements ActionListener {
        Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getActionCommand().equals("save-result-command")) {
                SVMResultViewer.this.onSaveResult();
            }
        }
    }

    class MyListener
    extends MouseInputAdapter {
        MyListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SVMResultViewer.this.MyPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

