/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.KeyMotionBehavior;

public class NavigationPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private static final int FWD_CMD = 0;
    private static final int BWD_CMD = 1;
    private static final int UP_CMD = 2;
    private static final int DOWN_CMD = 3;
    private static final int LEFT_CMD = 4;
    private static final int RIGHT_CMD = 5;
    private AbstractButton lu_btn;
    private AbstractButton lm_btn;
    private AbstractButton lb_btn;
    private AbstractButton mu_btn;
    private AbstractButton mm_btn;
    private AbstractButton mb_btn;
    private AbstractButton ru_btn;
    private AbstractButton rm_btn;
    private AbstractButton rb_btn;
    private TimerHandler timerHandler;
    private KeyMotionBehavior behavior;
    private static final int MOVE_MODE = 0;
    private static final int TURN_MODE = 1;
    private static final int ROT_MODE = 2;
    private static Icon[] mode_icons = new Icon[3];
    private int state = 0;

    public NavigationPanel(KeyMotionBehavior keyMotionBehavior) {
        this.setLayout(new GridBagLayout());
        this.behavior = keyMotionBehavior;
        this.timerHandler = new TimerHandler();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.lu_btn = this.createJButton("left-up-command", GUIFactory.getIcon("arrow_left_up.gif"));
        this.add((Component)this.lu_btn, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.mu_btn = this.createJButton("middle-up-command", GUIFactory.getIcon("arrow_up.gif"));
        this.add((Component)this.mu_btn, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.ru_btn = this.createJButton("right-up-command", GUIFactory.getIcon("arrow_right_up.gif"));
        this.add((Component)this.ru_btn, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.lm_btn = this.createJButton("left-middle-command", GUIFactory.getIcon("arrow_left.gif"));
        this.add((Component)this.lm_btn, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.mm_btn = this.createStateButton("middle-middle-command", mode_icons[0]);
        this.add((Component)this.mm_btn, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.rm_btn = this.createJButton("right-middle-command", GUIFactory.getIcon("arrow_right.gif"));
        this.add((Component)this.rm_btn, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.lb_btn = this.createJButton("left-bottom-command", GUIFactory.getIcon("arrow_left_down.gif"));
        this.add((Component)this.lb_btn, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.mb_btn = this.createJButton("middle-bottom-command", GUIFactory.getIcon("arrow_down.gif"));
        this.add((Component)this.mb_btn, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.rb_btn = this.createJButton("right-bottom-command", GUIFactory.getIcon("arrow_right_down.gif"));
        this.add((Component)this.rb_btn, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        JButton jButton = new JButton("<html><body><table cellspacing=0 cellpadding=0><tr><td>R</td></tr><tr><td>E</td></tr><tr><td>S</td></tr><tr><td>E</td></tr><tr><td>T</td></tr></table></body></html>");
        jButton.setActionCommand("reset-command");
        jButton.addActionListener(this);
        this.add((Component)jButton, gridBagConstraints);
        this.setTooltips(this.state);
    }

    protected AbstractButton createStateButton(String string, Icon icon) {
        JButton jButton = new JButton(icon);
        this.configureButton(jButton);
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected AbstractButton createJButton(String string, Icon icon) {
        JButton jButton = new JButton(icon);
        this.configureButton(jButton);
        jButton.setActionCommand(string);
        jButton.addChangeListener(this);
        return jButton;
    }

    protected void configureButton(AbstractButton abstractButton) {
        abstractButton.setContentAreaFilled(false);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        abstractButton.setFocusPainted(false);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            this.timerHandler.start(abstractButton.getActionCommand());
        } else {
            this.timerHandler.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("middle-middle-command")) {
            if (this.state == 2) {
                this.state = -1;
            }
            ++this.state;
            this.mm_btn.setIcon(mode_icons[this.state]);
            this.setTooltips(this.state);
        } else if (string.equals("reset-command")) {
            this.behavior.execute(18);
        } else if (string.equals("left-up-command")) {
            this.behavior.execute(this.getMotionCommand(0));
        } else if (string.equals("middle-up-command")) {
            this.behavior.execute(this.getMotionCommand(2));
        } else if (string.equals("right-up-command")) {
            this.behavior.execute(this.getMotionCommand(0));
        } else if (string.equals("left-middle-command")) {
            this.behavior.execute(this.getMotionCommand(4));
        } else if (string.equals("right-middle-command")) {
            this.behavior.execute(this.getMotionCommand(5));
        } else if (string.equals("left-bottom-command")) {
            this.behavior.execute(this.getMotionCommand(1));
        } else if (string.equals("middle-bottom-command")) {
            this.behavior.execute(this.getMotionCommand(3));
        } else if (string.equals("right-bottom-command")) {
            this.behavior.execute(this.getMotionCommand(1));
        }
    }

    protected int getMotionCommand(int n) {
        switch (this.state) {
            case 0: {
                switch (n) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 5;
                    }
                    case 4: {
                        return 0;
                    }
                    case 5: {
                        return 1;
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        return 11;
                    }
                    case 1: {
                        return 10;
                    }
                    case 2: {
                        return 8;
                    }
                    case 3: {
                        return 9;
                    }
                    case 4: {
                        return 6;
                    }
                    case 5: {
                        return 7;
                    }
                }
                break;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        return 14;
                    }
                    case 1: {
                        return 17;
                    }
                    case 2: {
                        return 12;
                    }
                    case 3: {
                        return 15;
                    }
                    case 4: {
                        return 16;
                    }
                    case 5: {
                        return 13;
                    }
                }
            }
        }
        return -1;
    }

    protected void setTooltips(int n) {
        switch (n) {
            case 0: {
                this.lu_btn.setToolTipText("move view forward");
                this.lm_btn.setToolTipText("move view left");
                this.lb_btn.setToolTipText("move view backward");
                this.mu_btn.setToolTipText("move view up");
                this.mm_btn.setToolTipText("switch to turn mode");
                this.mb_btn.setToolTipText("move view down");
                this.ru_btn.setToolTipText("move view forward");
                this.rm_btn.setToolTipText("move view right");
                this.rb_btn.setToolTipText("move view backward");
                break;
            }
            case 1: {
                this.lu_btn.setToolTipText("tilt view right");
                this.lm_btn.setToolTipText("turn view left");
                this.lb_btn.setToolTipText("tilt view left");
                this.mu_btn.setToolTipText("turn view up");
                this.mm_btn.setToolTipText("switch to rotation mode");
                this.mb_btn.setToolTipText("turn view down");
                this.ru_btn.setToolTipText("tilt view right");
                this.rm_btn.setToolTipText("turn view right");
                this.rb_btn.setToolTipText("tilt view left");
                break;
            }
            case 2: {
                this.lu_btn.setToolTipText("rotate z");
                this.lm_btn.setToolTipText("rotate y");
                this.lb_btn.setToolTipText("rotate z");
                this.mu_btn.setToolTipText("rotate x");
                this.mm_btn.setToolTipText("switch to motion mode");
                this.mb_btn.setToolTipText("rotate x");
                this.ru_btn.setToolTipText("rotate z");
                this.rm_btn.setToolTipText("rotate y");
                this.rb_btn.setToolTipText("rotate z");
            }
        }
    }

    static {
        NavigationPanel.mode_icons[0] = GUIFactory.getIcon("move_mode.gif");
        NavigationPanel.mode_icons[1] = GUIFactory.getIcon("turn_mode.gif");
        NavigationPanel.mode_icons[2] = GUIFactory.getIcon("rot_mode.gif");
    }

    private class TimerHandler
    implements ActionListener {
        private Timer timer = new Timer(100, this);
        private String command;

        public void start(String string) {
            this.command = string;
            this.actionPerformed(null);
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NavigationPanel.this.actionPerformed(new ActionEvent(this, 1001, this.command));
        }
    }
}

