/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class TerrainInitDialog
extends AlgorithmDialog {
    private int result;
    private JRadioButton genRadio;
    private JRadioButton expRadio;
    private JTextField neighboursField;

    public TerrainInitDialog(Frame frame) {
        super((JFrame)frame, "Terrain Initialization", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(20, 10, 20, 10));
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.genRadio = new JRadioButton("Genes");
        this.genRadio.setFocusPainted(false);
        this.genRadio.setBackground(Color.white);
        this.genRadio.setForeground(UIManager.getColor("Label.foreground"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.genRadio, gridBagConstraints);
        this.expRadio = new JRadioButton("Experiments");
        this.expRadio.setForeground(UIManager.getColor("Label.foreground"));
        this.expRadio.setFocusPainted(false);
        this.expRadio.setBackground(Color.white);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.left = 25;
        jPanel.add((Component)this.expRadio, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 20;
        jPanel.add((Component)new JLabel("Neighbors:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets.left = 25;
        this.neighboursField = new JTextField(String.valueOf(20), 5);
        jPanel.add((Component)this.neighboursField, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.genRadio);
        buttonGroup.add(this.expRadio);
        this.genRadio.setSelected(true);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setForeground(Color.white);
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)new JLabel(GUIFactory.getIcon("tigr_logo.gif")), "East");
        this.setActionListeners(listener);
        this.addContent(jPanel2);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isGenes() {
        return this.genRadio.isSelected();
    }

    public int getNeighbours() {
        return Integer.parseInt(this.neighboursField.getText());
    }

    public static void main(String[] stringArray) {
        TerrainInitDialog terrainInitDialog = new TerrainInitDialog(new JFrame());
        if (terrainInitDialog.showModal() == 0) {
            System.out.println("ok");
        }
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    int n = Integer.parseInt(TerrainInitDialog.this.neighboursField.getText());
                    if (n < 1) {
                        throw new NumberFormatException("value must be more than 0.");
                    }
                    TerrainInitDialog.this.result = 0;
                    TerrainInitDialog.this.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(TerrainInitDialog.this, "Error number: " + numberFormatException.getMessage(), "Input Error!", 0);
                }
            } else if (string.equals("cancel-command")) {
                TerrainInitDialog.this.result = 2;
                TerrainInitDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    TerrainInitDialog.this.genRadio.setSelected(true);
                    TerrainInitDialog.this.neighboursField.setText("20");
                    TerrainInitDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(TerrainInitDialog.this, "Terrain Map Initialization Dialog");
                    TerrainInitDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            TerrainInitDialog.this.result = -1;
            TerrainInitDialog.this.dispose();
        }
    }
}

