/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class TtestCentroidsViewer
extends CentroidsViewer {
    private static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    private static final String SET_Y_TO_EXPERIMENT_MAX_CMD = "set-y-to-exp-max-cmd";
    private static final String SET_Y_TO_CLUSTER_MAX_CMD = "set-y-to-cluster-max-cmd";
    private JPopupMenu popup;
    private JMenuItem setOverallMaxMenuItem;
    private JMenuItem setClusterMaxMenuItem;
    private Vector tValues;
    private Vector pValues;
    private Vector dfValues;
    private Vector meansA;
    private Vector meansB;
    private Vector sdA;
    private Vector sdB;

    public TtestCentroidsViewer(Experiment experiment, int[][] nArray, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6, Vector vector7) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.pValues = vector5;
        this.tValues = vector6;
        this.dfValues = vector7;
        this.meansA = vector;
        this.meansB = vector2;
        this.sdA = vector3;
        this.sdB = vector4;
        this.getContentComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu, Listener listener) {
        JMenuItem jMenuItem = new JMenuItem("Save all clusters", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        this.setOverallMaxMenuItem = new JMenuItem("Set Y to overall max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setOverallMaxMenuItem.setActionCommand(SET_Y_TO_EXPERIMENT_MAX_CMD);
        this.setOverallMaxMenuItem.addActionListener(listener);
        this.setOverallMaxMenuItem.setEnabled(false);
        jPopupMenu.add(this.setOverallMaxMenuItem);
        this.setClusterMaxMenuItem = new JMenuItem("Set Y to cluster max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setClusterMaxMenuItem.setActionCommand(SET_Y_TO_CLUSTER_MAX_CMD);
        this.setClusterMaxMenuItem.addActionListener(listener);
        jPopupMenu.add(this.setClusterMaxMenuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData iData, int[][] nArray) throws Exception {
        File file = TtestCentroidsViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(file2, experiment, iData, nArray[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData iData, int[] nArray) throws Exception {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            printWriter.print("\t");
        }
        printWriter.print("GroupA mean\t");
        printWriter.print("GroupA std.dev.\t");
        printWriter.print("GroupB mean\t");
        printWriter.print("GroupB std.dev.\t");
        printWriter.print("Absolute t value");
        printWriter.print("\t");
        printWriter.print("Degrees of freedom\t");
        printWriter.print("p value");
        for (n = 0; n < experiment.getNumberOfSamples(); ++n) {
            printWriter.print("\t");
            printWriter.print(iData.getFullSampleName(experiment.getSampleIndex(n)));
        }
        printWriter.print("\n");
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(nArray[n]) + 1));
            printWriter.print("\t");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(nArray[n]), n2));
                printWriter.print("\t");
            }
            printWriter.print(((Float)this.meansA.get(nArray[n])).floatValue() + "\t");
            printWriter.print(((Float)this.sdA.get(nArray[n])).floatValue() + "\t");
            printWriter.print(((Float)this.meansB.get(nArray[n])).floatValue() + "\t");
            printWriter.print(((Float)this.sdB.get(nArray[n])).floatValue() + "\t");
            printWriter.print("" + ((Float)this.tValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.dfValues.get(nArray[n])).intValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.pValues.get(nArray[n])).floatValue());
            for (n2 = 0; n2 < experiment.getNumberOfSamples(); ++n2) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(nArray[n], n2)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(new ExpressionFileFilter());
        jFileChooser.setFileView(new ExpressionFileView());
        int n = jFileChooser.showSaveDialog(frame);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(TtestCentroidsViewer.SAVE_ALL_CLUSTERS_CMD)) {
                TtestCentroidsViewer.this.onSaveClusters();
            } else if (string.equals(TtestCentroidsViewer.SET_Y_TO_EXPERIMENT_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_EXPERIMENT_MAX);
                TtestCentroidsViewer.this.setClusterMaxMenuItem.setEnabled(true);
                TtestCentroidsViewer.this.setOverallMaxMenuItem.setEnabled(false);
                TtestCentroidsViewer.this.repaint();
            } else if (string.equals(TtestCentroidsViewer.SET_Y_TO_CLUSTER_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_CLUSTER_MAX);
                TtestCentroidsViewer.this.setClusterMaxMenuItem.setEnabled(false);
                TtestCentroidsViewer.this.setOverallMaxMenuItem.setEnabled(true);
                TtestCentroidsViewer.this.repaint();
            }
        }

        private void setAllYRanges(int n) {
            int n2 = TtestCentroidsViewer.this.getClusters().length;
            for (int i = 0; i < n2; ++i) {
                TtestCentroidsViewer.this.centroidViewer.setClusterIndex(i);
                TtestCentroidsViewer.this.centroidViewer.setYRangeOption(n);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            TtestCentroidsViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

