/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.StringSplitter;

public class TtestInitDialog
extends AlgorithmDialog {
    GroupExperimentsPanel gPanel;
    PValuePanel pPanel;
    SignificancePanel sPanel;
    HCLSelectionPanel hclOpsPanel;
    Vector exptNames;
    public static final int GROUP_A = 1;
    public static final int GROUP_B = 2;
    public static final int NEITHER_GROUP = 3;
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    boolean okPressed = false;
    boolean permParamOkPressed = false;
    private int userNumCombs = 0;
    private boolean allCombsUsed = false;
    private int allPossCombs;
    private Color LABEL_COLOR = UIManager.getColor("Label.foreground");
    boolean tooMany = false;
    int count;

    public TtestInitDialog(JFrame jFrame, boolean bl, Vector vector) {
        super(jFrame, "TTEST: T-test", bl);
        this.exptNames = vector;
        this.setBounds(0, 0, 800, 800);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.pPanel = new PValuePanel();
        this.gPanel = new GroupExperimentsPanel(vector);
        this.count = 0;
        while (this.count < this.gPanel.groupARadioButtons.length) {
            this.gPanel.groupARadioButtons[this.count].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            ++this.count;
        }
        this.count = 0;
        while (this.count < this.gPanel.groupBRadioButtons.length) {
            this.gPanel.groupBRadioButtons[this.count].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            ++this.count;
        }
        this.count = 0;
        while (this.count < this.gPanel.neitherGroupRadioButtons.length) {
            this.gPanel.neitherGroupRadioButtons[this.count].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            ++this.count;
        }
        this.count = 0;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 45);
        gridBagLayout.setConstraints(this.gPanel, gridBagConstraints);
        jPanel.add(this.gPanel);
        this.pPanel.permutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == TtestInitDialog.this.pPanel.permutButton) {
                    int n;
                    int[] nArray = TtestInitDialog.this.getGroupAssignments();
                    int n2 = 0;
                    int n3 = 0;
                    for (n = 0; n < nArray.length; ++n) {
                        if (nArray[n] == 1) {
                            ++n2;
                            continue;
                        }
                        if (nArray[n] != 2) continue;
                        ++n3;
                    }
                    if (n2 < 2 || n3 < 2) {
                        TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.red);
                        TtestInitDialog.this.pPanel.numCombsLabel.setText("Error! Group A and Group B must each contain more than one experiment");
                    } else {
                        n = 0;
                        TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                        TtestInitDialog.this.pPanel.numCombsLabel.setText("There are too many unique permutations                                  ");
                        TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                        TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                        TtestInitDialog.this.pPanel.randomGroupsButton.setSelected(true);
                        TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                        TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                        TtestInitDialog.this.pPanel.timesField.setText("100");
                        if (n2 + n3 <= 20) {
                            n = TtestInitDialog.this.getNumCombs(n2 + n3, n2);
                            TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are " + n + " unique permutations                                ");
                            TtestInitDialog.this.allPossCombs = n;
                            TtestInitDialog.this.pPanel.allCombsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 25);
        gridBagLayout.setConstraints(this.pPanel, gridBagConstraints);
        jPanel.add(this.pPanel);
        this.sPanel = new SignificancePanel();
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 20);
        gridBagLayout.setConstraints(this.sPanel, gridBagConstraints);
        jPanel.add(this.sPanel);
        this.hclOpsPanel = new HCLSelectionPanel();
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0, 10);
        gridBagLayout.setConstraints(this.hclOpsPanel, gridBagConstraints);
        jPanel.add(this.hclOpsPanel);
        this.addContent(jPanel);
        this.setActionListeners(new EventListener());
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private long factorial(int n) {
        if (n == 1 || n == 0) {
            return 1L;
        }
        return this.factorial(n - 1) * (long)n;
    }

    private int getNumCombs(int n, int n2) {
        return Math.round(this.factorial(n) / (this.factorial(n2) * this.factorial(n - n2)));
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isDrawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public int[] getGroupAssignments() {
        int[] nArray = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            nArray[i] = this.gPanel.groupARadioButtons[i].isSelected() ? 1 : (this.gPanel.groupBRadioButtons[i].isSelected() ? 2 : 3);
        }
        return nArray;
    }

    public boolean isPermut() {
        return this.pPanel.permutButton.isSelected();
    }

    public int getUserNumCombs() {
        String string = this.pPanel.timesField.getText();
        int n = !this.useAllCombs() ? Integer.parseInt(string) : this.allPossCombs;
        return n;
    }

    public double getAlphaValue() {
        String string = this.pPanel.alphaInputField.getText();
        return Double.parseDouble(string);
    }

    public boolean validateAlpha(String string) {
        float f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Alpha value is not a valid input value.", "Input Error", 2);
            this.pPanel.alphaInputField.requestFocus();
            this.pPanel.alphaInputField.selectAll();
            return false;
        }
        if (f <= 0.0f || f >= 1.0f) {
            JOptionPane.showMessageDialog(this, "Alpha value must be > 0 and < 1.0", "Input Error", 2);
            this.pPanel.alphaInputField.requestFocus();
            this.pPanel.alphaInputField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validatePermutations(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Number of Permutations is not a valid input value.", "Input Error", 2);
            this.pPanel.timesField.requestFocus();
            this.pPanel.timesField.selectAll();
            return false;
        }
        if (n <= 0) {
            JOptionPane.showMessageDialog(this, "Number of Permutations must be > 0", "Input Error", 2);
            this.pPanel.timesField.requestFocus();
            this.pPanel.timesField.selectAll();
            return false;
        }
        return true;
    }

    public int getSignificanceMethod() {
        if (this.sPanel.justAlphaButton.isSelected()) {
            return 4;
        }
        if (this.sPanel.stdBonfButton.isSelected()) {
            return 5;
        }
        return 6;
    }

    public boolean useAllCombs() {
        return this.pPanel.allCombsButton.isSelected();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 10; ++i) {
            vector.add("Exp " + i);
        }
        TtestInitDialog ttestInitDialog = new TtestInitDialog(jFrame, true, vector);
        ttestInitDialog.setVisible(true);
        System.exit(0);
    }

    public class EventListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                int[] nArray = TtestInitDialog.this.getGroupAssignments();
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 1) {
                        ++n;
                        continue;
                    }
                    if (nArray[i] != 2) continue;
                    ++n2;
                }
                if (n < 2 || n2 < 2) {
                    JOptionPane.showMessageDialog(TtestInitDialog.this.gPanel, "Group A and Group B must each contain more than one experiment", "Error", 2);
                } else {
                    String string2;
                    String string3 = TtestInitDialog.this.pPanel.alphaInputField.getText();
                    if (TtestInitDialog.this.pPanel.permutButton.isSelected() && TtestInitDialog.this.pPanel.randomGroupsButton.isSelected() && !TtestInitDialog.this.validatePermutations(string2 = TtestInitDialog.this.pPanel.timesField.getText())) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (!TtestInitDialog.this.validateAlpha(string3)) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    TtestInitDialog.this.okPressed = true;
                    TtestInitDialog.this.hide();
                    TtestInitDialog.this.dispose();
                }
            } else if (string.equals("reset-command")) {
                TtestInitDialog.this.gPanel.reset();
                TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                TtestInitDialog.this.pPanel.timesField.setText("100");
                TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                TtestInitDialog.this.pPanel.alphaInputField.setText("0.01");
                TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                TtestInitDialog.this.hclOpsPanel.setHCLSelected(false);
            } else if (string.equals("cancel-command")) {
                TtestInitDialog.this.okPressed = false;
                TtestInitDialog.this.setVisible(false);
                TtestInitDialog.this.dispose();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(TtestInitDialog.this, "TTEST Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }
    }

    class OkCancelPanel
    extends JPanel {
        JButton okButton;
        JButton cancelButton;
        JCheckBox drawTreesBox;

        OkCancelPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "General"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.drawTreesBox = new JCheckBox("Draw hierarchical trees", false);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 100, 50);
            gridBagLayout.setConstraints(this.drawTreesBox, gridBagConstraints);
            this.add(this.drawTreesBox);
            this.okButton = new JButton("OK");
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 50);
            gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
            this.add(this.okButton);
            this.cancelButton = new JButton("Cancel");
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
            gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
            this.add(this.cancelButton);
        }
    }

    class SignificancePanel
    extends JPanel {
        JRadioButton justAlphaButton;
        JRadioButton stdBonfButton;
        JRadioButton adjBonfButton;

        SignificancePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "Alpha Corrections", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.justAlphaButton = new JRadioButton("just alpha (no correction)", true);
            this.justAlphaButton.setFocusPainted(false);
            this.justAlphaButton.setForeground(UIManager.getColor("Label.foreground"));
            this.justAlphaButton.setBackground(Color.white);
            buttonGroup.add(this.justAlphaButton);
            this.stdBonfButton = new JRadioButton("standard Bonferroni correction", false);
            this.stdBonfButton.setFocusPainted(false);
            this.stdBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.stdBonfButton.setBackground(Color.white);
            buttonGroup.add(this.stdBonfButton);
            this.adjBonfButton = new JRadioButton("adjusted Bonferroni correction", false);
            this.adjBonfButton.setFocusPainted(false);
            this.adjBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.adjBonfButton.setBackground(Color.white);
            buttonGroup.add(this.adjBonfButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout.setConstraints(this.justAlphaButton, gridBagConstraints);
            this.add(this.justAlphaButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout.setConstraints(this.stdBonfButton, gridBagConstraints);
            this.add(this.stdBonfButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
            gridBagLayout.setConstraints(this.adjBonfButton, gridBagConstraints);
            this.add(this.adjBonfButton);
        }
    }

    class PValuePanel
    extends JPanel {
        JRadioButton tDistButton;
        JRadioButton permutButton;
        JRadioButton randomGroupsButton;
        JRadioButton allCombsButton;
        JLabel numCombsLabel;
        JTextField timesField;
        JTextField alphaInputField;

        PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "P-Value Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            this.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.tDistButton = new JRadioButton("p-values based on t-distribution", true);
            this.tDistButton.setFocusPainted(false);
            this.tDistButton.setForeground(UIManager.getColor("Label.foreground"));
            this.tDistButton.setBackground(Color.white);
            buttonGroup.add(this.tDistButton);
            this.permutButton = new JRadioButton("p-values based on permutation:  ", false);
            this.permutButton.setFocusPainted(false);
            this.permutButton.setForeground(UIManager.getColor("Label.foreground"));
            this.permutButton.setBackground(Color.white);
            buttonGroup.add(this.permutButton);
            this.numCombsLabel = new JLabel("                                       ");
            this.numCombsLabel.setOpaque(false);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel.setLayout(gridBagLayout2);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30, 50);
            gridBagLayout2.setConstraints(this.tDistButton, gridBagConstraints);
            jPanel.add(this.tDistButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 30, 50);
            gridBagConstraints.anchor = 17;
            gridBagLayout2.setConstraints(this.permutButton, gridBagConstraints);
            jPanel.add(this.permutButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 70, 0);
            gridBagConstraints.ipadx = 50;
            gridBagConstraints.anchor = 17;
            gridBagLayout2.setConstraints(this.numCombsLabel, gridBagConstraints);
            jPanel.add(this.numCombsLabel);
            gridBagConstraints.ipadx = 100;
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 20);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(Color.white);
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            jPanel2.setBorder(new EtchedBorder());
            this.randomGroupsButton = new JRadioButton("Randomly group experiments ", true);
            this.randomGroupsButton.setFocusPainted(false);
            this.randomGroupsButton.setForeground(UIManager.getColor("Label.foreground"));
            this.randomGroupsButton.setBackground(Color.white);
            this.randomGroupsButton.setEnabled(false);
            this.allCombsButton = new JRadioButton("Use all permutations                 ", false);
            this.allCombsButton.setFocusPainted(false);
            this.allCombsButton.setForeground(UIManager.getColor("Label.foreground"));
            this.allCombsButton.setBackground(Color.white);
            this.allCombsButton.setEnabled(false);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 60, 50);
            gridBagLayout3.setConstraints(this.randomGroupsButton, gridBagConstraints);
            jPanel2.add(this.randomGroupsButton);
            this.timesField = new JTextField("100", 7);
            this.timesField.setEnabled(false);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 20, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout3.setConstraints(this.timesField, gridBagConstraints);
            jPanel2.add(this.timesField);
            JLabel jLabel = new JLabel("times");
            jLabel.setOpaque(false);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 20, 0);
            gridBagLayout3.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 60, 0);
            gridBagConstraints.anchor = 13;
            gridBagLayout3.setConstraints(this.allCombsButton, gridBagConstraints);
            jPanel2.add(this.allCombsButton);
            buttonGroup2.add(this.randomGroupsButton);
            buttonGroup2.add(this.allCombsButton);
            this.allCombsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == PValuePanel.this.allCombsButton) {
                        PValuePanel.this.timesField.setText("");
                        PValuePanel.this.timesField.setBackground(Color.gray);
                        PValuePanel.this.timesField.setEnabled(false);
                    }
                }
            });
            this.randomGroupsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == PValuePanel.this.randomGroupsButton) {
                        PValuePanel.this.timesField.setText("100");
                        PValuePanel.this.timesField.setBackground(Color.white);
                        PValuePanel.this.timesField.setEnabled(true);
                    }
                }
            });
            this.tDistButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == PValuePanel.this.tDistButton) {
                        PValuePanel.this.randomGroupsButton.setEnabled(false);
                        PValuePanel.this.allCombsButton.setEnabled(false);
                        PValuePanel.this.timesField.setEnabled(false);
                        PValuePanel.this.numCombsLabel.setText("                                                                            ");
                    }
                }
            });
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 60);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 3;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
            gridBagConstraints.fill = 0;
            JPanel jPanel3 = new JPanel();
            jPanel3.setBackground(Color.white);
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            jPanel3.setLayout(gridBagLayout4);
            JLabel jLabel2 = new JLabel("Overall alpha (critical p-value):                   ");
            jLabel2.setOpaque(false);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 75, 100);
            gridBagConstraints.anchor = 17;
            gridBagLayout4.setConstraints(jLabel2, gridBagConstraints);
            jPanel3.add(jLabel2);
            this.alphaInputField = new JTextField("0.01", 7);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 25, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout4.setConstraints(this.alphaInputField, gridBagConstraints);
            jPanel3.add(this.alphaInputField);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 20);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            this.add(jPanel3);
        }
    }

    class GroupExperimentsPanel
    extends JPanel {
        JLabel[] expLabels;
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;
        JRadioButton[] neitherGroupRadioButtons;

        GroupExperimentsPanel(Vector vector) {
            Object object;
            this.setBorder(new TitledBorder(new EtchedBorder(1), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            JPanel jPanel = new JPanel();
            this.expLabels = new JLabel[vector.size()];
            this.groupARadioButtons = new JRadioButton[vector.size()];
            this.groupBRadioButtons = new JRadioButton[vector.size()];
            this.neitherGroupRadioButtons = new JRadioButton[vector.size()];
            ButtonGroup[] buttonGroupArray = new ButtonGroup[vector.size()];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout2);
            jPanel.setLayout(gridBagLayout);
            for (int i = 0; i < vector.size(); ++i) {
                object = (String)vector.get(i);
                this.expLabels[i] = new JLabel((String)object);
                this.expLabels[i].setForeground(Color.black);
                buttonGroupArray[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                buttonGroupArray[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                buttonGroupArray[i].add(this.groupBRadioButtons[i]);
                this.neitherGroupRadioButtons[i] = new JRadioButton("Neither group", false);
                buttonGroupArray[i].add(this.neitherGroupRadioButtons[i]);
                TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.expLabels[i], gridBagConstraints);
                jPanel.add(this.expLabels[i]);
                TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupARadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupARadioButtons[i]);
                TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupBRadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupBRadioButtons[i]);
                TtestInitDialog.this.buildConstraints(gridBagConstraints, 3, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.neitherGroupRadioButtons[i], gridBagConstraints);
                jPanel.add(this.neitherGroupRadioButtons[i]);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            object = new JLabel("                                                Note: Group A and Group B  MUST each contain more than one experiment.");
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 5);
            gridBagConstraints.anchor = 13;
            gridBagLayout2.setConstraints((Component)object, gridBagConstraints);
            this.add((Component)object);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(Color.white);
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            JButton jButton = new JButton(" Save grouping ");
            jButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
            jButton.setFocusPainted(false);
            jButton.setPreferredSize(new Dimension(100, 30));
            JButton jButton2 = new JButton(" Load grouping ");
            jButton2.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
            jButton2.setFocusPainted(false);
            jButton2.setPreferredSize(new Dimension(100, 30));
            JButton jButton3 = new JButton(" Reset ");
            jButton3.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
            jButton3.setFocusPainted(false);
            jButton3.setPreferredSize(new Dimension(55, 30));
            final int n = vector.size();
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < n; ++i) {
                        GroupExperimentsPanel.this.groupARadioButtons[i].setSelected(true);
                    }
                }
            });
            final JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = jFileChooser.showSaveDialog(GroupExperimentsPanel.this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        try {
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            int[] nArray = TtestInitDialog.this.getGroupAssignments();
                            for (int i = 0; i < nArray.length; ++i) {
                                printWriter.print(nArray[i]);
                                if (i >= nArray.length - 1) continue;
                                printWriter.print("\t");
                            }
                            printWriter.println();
                            printWriter.flush();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    block10: {
                        int n3 = jFileChooser.showOpenDialog(GroupExperimentsPanel.this);
                        if (n3 == 0) {
                            try {
                                Object object;
                                FileReader fileReader = new FileReader(jFileChooser.getSelectedFile());
                                BufferedReader bufferedReader = new BufferedReader(fileReader);
                                String string = bufferedReader.readLine();
                                StringSplitter stringSplitter = new StringSplitter('\t');
                                stringSplitter.init(string);
                                Vector<Integer> vector = new Vector<Integer>();
                                while (stringSplitter.hasMoreTokens()) {
                                    object = stringSplitter.nextToken();
                                    vector.add(new Integer((String)object));
                                }
                                bufferedReader.close();
                                object = TtestInitDialog.this.getGroupAssignments();
                                if (vector.size() != ((Object)object).length) {
                                    JOptionPane.showMessageDialog(TtestInitDialog.this.gPanel, "Incompatible file!", "Error", 2);
                                    break block10;
                                }
                                for (int i = 0; i < vector.size(); ++i) {
                                    int n2 = (Integer)vector.get(i);
                                    if (n2 == 1) {
                                        GroupExperimentsPanel.this.groupARadioButtons[i].setSelected(true);
                                        continue;
                                    }
                                    if (n2 == 2) {
                                        GroupExperimentsPanel.this.groupBRadioButtons[i].setSelected(true);
                                        continue;
                                    }
                                    if (n2 == 3) {
                                        GroupExperimentsPanel.this.neitherGroupRadioButtons[i].setSelected(true);
                                        continue;
                                    }
                                    for (int j = 0; j < n; ++j) {
                                        GroupExperimentsPanel.this.groupARadioButtons[j].setSelected(true);
                                    }
                                    JOptionPane.showMessageDialog(TtestInitDialog.this.gPanel, "Incompatible file!", "Error", 2);
                                    break;
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(TtestInitDialog.this.gPanel, "Incompatible file!", "Error", 2);
                            }
                        }
                    }
                }
            });
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout3.setConstraints(jButton, gridBagConstraints);
            jPanel2.add(jButton);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout3.setConstraints(jButton2, gridBagConstraints);
            jPanel2.add(jButton2);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
            gridBagLayout3.setConstraints(jButton3, gridBagConstraints);
            jPanel2.add(jButton3);
            TtestInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 5);
            gridBagConstraints.anchor = 10;
            gridBagLayout2.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
        }

        public void reset() {
            int n = TtestInitDialog.this.exptNames.size();
            for (int i = 0; i < n; ++i) {
                this.groupARadioButtons[i].setSelected(true);
            }
        }
    }
}

