/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.util;

public class FloatArray {
    private float[] elementData;
    private int size;

    public FloatArray(int n) {
        this.elementData = new float[n];
    }

    public float[] toArray() {
        float[] fArray = new float[this.size];
        System.arraycopy(this.elementData, 0, fArray, 0, this.size);
        return fArray;
    }

    public float get(int n) {
        this.RangeCheck(n);
        return this.elementData[n];
    }

    public void set(int n, float f) {
        this.RangeCheck(n);
        this.elementData[n] = f;
    }

    public boolean add(float f) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = f;
        return true;
    }

    public int getSize() {
        return this.size;
    }

    private void RangeCheck(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            float[] fArray = this.elementData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new float[n3];
            System.arraycopy(fArray, 0, this.elementData, 0, this.size);
        }
    }
}

