/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePane;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;

public class TavFileLoader
extends ExpressionFileLoader {
    private GBA gba = new GBA();
    private TavFileLoaderPanel tflp = new TavFileLoaderPanel();
    private boolean loadEnabled = false;
    private boolean stop = false;
    private ISlideMetaData meta;
    private boolean fillMissingSpots = false;
    private static final int BUFFER_SIZE = 131072;

    public TavFileLoader(SuperExpressionFileLoader superExpressionFileLoader) {
        super(superExpressionFileLoader);
    }

    public Vector loadExpressionFiles() throws IOException {
        Object[] objectArray = this.tflp.getTavSelectedListModel().toArray();
        Vector<ISlideData> vector = new Vector<ISlideData>(objectArray.length);
        if (objectArray.length < 1) {
            return null;
        }
        this.setFilesCount(objectArray.length);
        int n = this.getCountOfLines((File)objectArray[0]);
        for (int i = 0; i < objectArray.length; ++i) {
            ISlideData iSlideData;
            if (this.stop) {
                return null;
            }
            this.setFilesProgress(i);
            this.setRemain(objectArray.length - i);
            this.setFileName(((File)objectArray[i]).getPath());
            if (i == 0) {
                this.setLinesCount(n);
                if (this.meta == null) {
                    iSlideData = this.fillMissingSpots ? this.loadSlideDataFillAllSpots((File)objectArray[i]) : this.loadSlideData((File)objectArray[i]);
                    this.meta = iSlideData.getSlideMetaData();
                } else {
                    iSlideData = this.loadFloatSlideData((File)objectArray[i], n, this.meta);
                }
            } else {
                iSlideData = this.loadFloatSlideData((File)objectArray[i], n, this.meta);
            }
            vector.add(iSlideData);
        }
        return vector;
    }

    public ISlideData loadExpressionFile(File file) throws IOException {
        return null;
    }

    private ISlideData loadSlideData(File file) throws IOException {
        String string;
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 9);
            TMEV.setNameIndex(TMEV.getNameIndex() - 9);
            TMEV.setIndicesAdjusted(true);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 3;
        int n4 = 2;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        float[] fArray = new float[n4];
        String[] stringArray = new String[TMEV.getFieldNames().length];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n5 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n5 < 0) {
                ++n5;
                continue;
            }
            stringSplitter.init(string);
            int n6 = stringSplitter.nextIntToken();
            int n7 = stringSplitter.nextIntToken();
            if (n6 > n) {
                n = n6;
            }
            if (n7 <= n2) continue;
            n2 = n7;
        }
        SlideData slideData = new SlideData(n, n2);
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(file));
        n5 = 0;
        int n8 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            int n9;
            if (n5 < 0) {
                ++n5;
                continue;
            }
            this.setFileProgress(n8++);
            stringSplitter.init(string);
            for (n9 = 0; n9 < n3; ++n9) {
                nArray[n9] = stringSplitter.nextIntToken();
                nArray2[n9] = stringSplitter.nextIntToken();
            }
            for (n9 = 0; n9 < n4; ++n9) {
                fArray[n9] = stringSplitter.nextFloatToken(0.0f);
            }
            for (n9 = 0; n9 < TMEV.getFieldNames().length; ++n9) {
                if (stringSplitter.hasMoreTokens()) {
                    String string2 = stringSplitter.nextToken();
                    if (string2.equals("null")) {
                        stringArray[n9] = "";
                        continue;
                    }
                    stringArray[n9] = string2;
                    continue;
                }
                stringArray[n9] = "";
            }
            SlideDataElement slideDataElement = new SlideDataElement(nArray, nArray2, fArray, stringArray);
            slideData.addSlideDataElement(slideDataElement);
        }
        bufferedReader.close();
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    private ISlideData loadFloatSlideData(File file, int n, ISlideMetaData iSlideMetaData) throws IOException {
        String string;
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 9);
            TMEV.setNameIndex(TMEV.getNameIndex() - 9);
            TMEV.setIndicesAdjusted(true);
        }
        FloatSlideData floatSlideData = new FloatSlideData(iSlideMetaData);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter stringSplitter = new StringSplitter('\t');
        float[] fArray = new float[2];
        int n2 = 0;
        int n3 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n2 < 0) {
                ++n2;
                continue;
            }
            this.setFileProgress(n3);
            stringSplitter.init(string);
            stringSplitter.passTokens(6);
            for (int i = 0; i < 2; ++i) {
                fArray[i] = stringSplitter.nextFloatToken(0.0f);
            }
            floatSlideData.setIntensities(n3, fArray[0], fArray[1]);
            ++n3;
        }
        bufferedReader.close();
        floatSlideData.setSlideDataName(file.getName());
        floatSlideData.setSlideFileName(file.getPath());
        return floatSlideData;
    }

    private ISlideData loadSlideDataFillAllSpots(File file) throws IOException {
        int n;
        SlideDataElement slideDataElement;
        String string;
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 9);
            TMEV.setNameIndex(TMEV.getNameIndex() - 9);
            TMEV.setIndicesAdjusted(true);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = TMEV.getCoordinatePairCount();
        int n5 = TMEV.getIntensityCount();
        int n6 = TMEV.getHeaderRowCount();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        float[] fArray = new float[n5];
        String[] stringArray = new String[TMEV.getFieldNames().length];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n7 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n7 < n6) {
                ++n7;
                continue;
            }
            stringSplitter.init(string);
            int n8 = stringSplitter.nextIntToken();
            int n9 = stringSplitter.nextIntToken();
            if (n8 > n2) {
                n2 = n8;
            }
            if (n9 <= n3) continue;
            n3 = n9;
        }
        SlideData slideData = new SlideData(n2, n3);
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(file));
        n7 = 0;
        int n10 = 0;
        boolean[][] blArray = new boolean[n2][n3];
        while ((string = bufferedReader.readLine()) != null) {
            int n11;
            if (n7 < n6) {
                ++n7;
                continue;
            }
            this.setFileProgress(n10++);
            stringSplitter.init(string);
            for (n11 = 0; n11 < n4; ++n11) {
                nArray[n11] = stringSplitter.nextIntToken();
                nArray2[n11] = stringSplitter.nextIntToken();
            }
            for (n11 = 0; n11 < n5; ++n11) {
                fArray[n11] = stringSplitter.nextFloatToken(0.0f);
            }
            for (n11 = 0; n11 < TMEV.getFieldNames().length; ++n11) {
                if (stringSplitter.hasMoreTokens()) {
                    String string2 = stringSplitter.nextToken();
                    if (string2.equals("null")) {
                        stringArray[n11] = "";
                        continue;
                    }
                    stringArray[n11] = string2;
                    continue;
                }
                stringArray[n11] = "";
            }
            blArray[nArray[0] - 1][nArray2[0] - 1] = true;
            slideDataElement = new SlideDataElement(nArray, nArray2, fArray, stringArray);
            slideData.addSlideDataElement(slideDataElement);
        }
        bufferedReader.close();
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        String[] stringArray2 = new String[TMEV.getFieldNames().length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = "";
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (blArray[n][i]) continue;
                slideDataElement = new SlideDataElement(new int[]{n + 1, 1, 1}, new int[]{i + 1, 1, 1}, fArray, stringArray2);
                slideData.insertElementAt(slideDataElement, n * n3 + i);
            }
        }
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    public FileFilter getFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".tav");
            }

            public String getDescription() {
                return "TIGR ArrayViewer Expression Files (*.tav)";
            }
        };
        return fileFilter;
    }

    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    public void markLoadEnabled(boolean bl) {
        this.loadEnabled = bl;
        this.checkLoadEnable();
    }

    public JPanel getFileLoaderPanel() {
        return this.tflp;
    }

    public void processFileList(String string, Vector vector) {
        this.tflp.setPath(string);
        if (vector == null) {
            return;
        }
        FileFilter fileFilter = this.getFileFilter();
        this.tflp.getTavAvailableListModel().clear();
        for (int i = 0; i < vector.size(); ++i) {
            File file = new File((String)vector.elementAt(i));
            if (!fileFilter.accept(file)) continue;
            this.tflp.getTavAvailableListModel().addElement(new File((String)vector.elementAt(i)));
        }
    }

    private class TavFileLoaderPanel
    extends JPanel {
        FileTreePane fileTreePane;
        JTextField pathTextField;
        JPanel tavSelectionPanel;
        JPanel tavListPanel;
        JLabel tavAvailableLabel;
        JLabel tavSelectedLabel;
        JList tavAvailableList;
        JList tavSelectedList;
        JScrollPane tavAvailableScrollPane;
        JScrollPane tavSelectedScrollPane;
        JButton tavAddButton;
        JButton tavAddAllButton;
        JButton tavRemoveButton;
        JButton tavRemoveAllButton;
        JPanel tavButtonPanel;
        JTextField preferencesTextField;
        JButton browseButton;
        JPanel preferencesSelectionPanel;
        JPanel preferencesPanel;
        JPanel manualPanel;
        JPanel genericPanel;
        JTabbedPane fieldsTabbedPane;
        JPanel fieldsPanel;
        JPanel selectionPanel;
        JSplitPane splitPane;
        JPanel fileLoaderPanel;

        public TavFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileTreePane = new FileTreePane();
            this.fileTreePane.addFileTreePaneListener(new FileTreePaneEventHandler());
            this.fileTreePane.setPreferredSize(new Dimension(200, 50));
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setBorder(new TitledBorder(new EtchedBorder(), "Selected Path"));
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            this.tavSelectionPanel = new JPanel();
            this.tavSelectionPanel.setLayout(new GridBagLayout());
            this.tavSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), TavFileLoader.this.getFileFilter().getDescription()));
            this.tavAvailableLabel = new JLabel("Available");
            this.tavSelectedLabel = new JLabel("Selected");
            this.tavAvailableList = new JList(new DefaultListModel());
            this.tavAvailableList.setCellRenderer(new ListRenderer());
            this.tavSelectedList = new JList(new DefaultListModel());
            this.tavSelectedList.setCellRenderer(new ListRenderer());
            this.tavAvailableScrollPane = new JScrollPane(this.tavAvailableList);
            this.tavSelectedScrollPane = new JScrollPane(this.tavSelectedList);
            this.tavAddButton = new JButton("Add");
            this.tavAddButton.addActionListener(new EventHandler());
            this.tavAddAllButton = new JButton("Add All");
            this.tavAddAllButton.addActionListener(new EventHandler());
            this.tavRemoveButton = new JButton("Remove");
            this.tavRemoveButton.addActionListener(new EventHandler());
            this.tavRemoveAllButton = new JButton("Remove All");
            this.tavRemoveAllButton.addActionListener(new EventHandler());
            Dimension dimension = this.tavRemoveAllButton.getPreferredSize();
            this.tavAddButton.setPreferredSize(dimension);
            this.tavAddAllButton.setPreferredSize(dimension);
            this.tavRemoveButton.setPreferredSize(dimension);
            this.tavRemoveAllButton.setPreferredSize(dimension);
            this.tavAddButton.setFocusPainted(false);
            this.tavAddAllButton.setFocusPainted(false);
            this.tavRemoveButton.setFocusPainted(false);
            this.tavRemoveAllButton.setFocusPainted(false);
            this.tavButtonPanel = new JPanel();
            this.tavButtonPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.tavButtonPanel, this.tavAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavButtonPanel, this.tavAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavButtonPanel, this.tavRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavButtonPanel, this.tavRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.tavListPanel = new JPanel();
            this.tavListPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavAvailableScrollPane, 0, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavButtonPanel, 1, 1, 1, 4, 0, 1, 3, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavSelectedScrollPane, 2, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavSelectionPanel, this.tavListPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.preferencesTextField = new JTextField();
            this.preferencesTextField.setEditable(false);
            this.preferencesTextField.setForeground(Color.black);
            this.preferencesTextField.setFont(new Font("monospaced", 1, 12));
            this.browseButton = new JButton("Browse Preferences");
            this.browseButton.addActionListener(new EventHandler());
            this.preferencesSelectionPanel = new JPanel();
            this.preferencesSelectionPanel.setLayout(new GridBagLayout());
            this.preferencesSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "Selected Preferences File"));
            TavFileLoader.this.gba.add(this.preferencesSelectionPanel, this.preferencesTextField, 0, 0, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.preferencesSelectionPanel, this.browseButton, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.preferencesPanel = new JPanel();
            this.preferencesPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.preferencesPanel, this.preferencesSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.manualPanel = new JPanel();
            this.manualPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.manualPanel, new JPanel(), 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.genericPanel = new JPanel();
            this.genericPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.genericPanel, new JPanel(), 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fieldsTabbedPane = new JTabbedPane();
            this.fieldsTabbedPane.addTab("Preferences", this.preferencesPanel);
            this.fieldsTabbedPane.addTab("Manual", this.manualPanel);
            this.fieldsTabbedPane.addTab("Generic", this.genericPanel);
            this.fieldsTabbedPane.setEnabledAt(1, false);
            this.fieldsTabbedPane.setEnabledAt(2, false);
            this.fieldsTabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    TavFileLoaderPanel.this.validateLists();
                }
            });
            this.fieldsPanel = new JPanel();
            this.fieldsPanel.setLayout(new GridBagLayout());
            this.fieldsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Additional Fields Selection"));
            TavFileLoader.this.gba.add(this.fieldsPanel, this.fieldsTabbedPane, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.selectionPanel, this.pathTextField, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.selectionPanel, this.tavSelectionPanel, 0, 1, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.selectionPanel, this.fieldsPanel, 0, 3, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.splitPane = new JSplitPane(1, this.fileTreePane, this.selectionPanel);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.fileLoaderPanel, this.splitPane, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        public void setPath(String string) {
            this.pathTextField.setText(string);
        }

        public void validateLists() {
            if (((DefaultListModel)this.tavSelectedList.getModel()).size() <= 0) {
                TavFileLoader.this.markLoadEnabled(false);
                return;
            }
            Component component = this.fieldsTabbedPane.getSelectedComponent();
            if (component == this.preferencesPanel) {
                if (this.preferencesTextField.getText().length() <= 0) {
                    TavFileLoader.this.markLoadEnabled(false);
                    return;
                }
                TavFileLoader.this.markLoadEnabled(true);
                return;
            }
            if (component == this.manualPanel) {
                TavFileLoader.this.markLoadEnabled(true);
                return;
            }
            TavFileLoader.this.markLoadEnabled(true);
        }

        public void onTavAdd() {
            int n;
            int[] nArray = this.tavAvailableList.getSelectedIndices();
            Object[] objectArray = new Object[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                Object e = ((DefaultListModel)this.tavAvailableList.getModel()).getElementAt(nArray[n]);
                objectArray[n] = e;
            }
            for (n = 0; n < nArray.length; ++n) {
                ((DefaultListModel)this.tavSelectedList.getModel()).addElement(objectArray[n]);
            }
            this.validateLists();
        }

        public void onTavAddAll() {
            int n = ((DefaultListModel)this.tavAvailableList.getModel()).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((DefaultListModel)this.tavAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.tavSelectedList.getModel()).addElement(e);
            }
            this.validateLists();
        }

        public void onTavRemove() {
            int[] nArray = this.tavSelectedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.tavSelectedList.getModel()).remove(nArray[i]);
            }
            this.validateLists();
        }

        public void onTavRemoveAll() {
            ((DefaultListModel)this.tavSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public DefaultListModel getTavAvailableListModel() {
            return (DefaultListModel)this.tavAvailableList.getModel();
        }

        public DefaultListModel getTavSelectedListModel() {
            return (DefaultListModel)this.tavSelectedList.getModel();
        }

        public void processPreferencesFile(File file) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    string.trim();
                    if (string.startsWith("//") || string.length() == 0 || !string.startsWith("Additional Fields")) continue;
                    StringSplitter stringSplitter = new StringSplitter('\t');
                    stringSplitter.init(string);
                    stringSplitter.nextToken();
                    String string2 = stringSplitter.nextToken();
                    stringSplitter = new StringSplitter(':');
                    stringSplitter.init(string2);
                    String[] stringArray = new String[stringSplitter.countTokens() + 1];
                    int n = 0;
                    while (stringSplitter.hasMoreTokens()) {
                        stringArray[n] = stringSplitter.nextToken();
                        ++n;
                    }
                    TMEV.setFieldNames(stringArray);
                    this.preferencesTextField.setText(file.getPath());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            this.validateLists();
        }

        public void selectPreferencesFile() {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir") + "\\Preferences");
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getName();
                    if (string.endsWith("Preferences")) {
                        return true;
                    }
                    if (string.endsWith("preferences")) {
                        return true;
                    }
                    return string.endsWith(".pref");
                }

                public String getDescription() {
                    return "Preference Files";
                }
            };
            jFileChooser.setFileFilter(fileFilter);
            int n = jFileChooser.showDialog(this, "Select");
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.processPreferencesFile(file);
            }
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            public void nodeSelected(FileTreePaneEvent fileTreePaneEvent) {
                String string = (String)fileTreePaneEvent.getValue("Path");
                Vector vector = (Vector)fileTreePaneEvent.getValue("Filenames");
                TavFileLoader.this.processFileList(string, vector);
            }

            public void nodeCollapsed(FileTreePaneEvent fileTreePaneEvent) {
            }

            public void nodeExpanded(FileTreePaneEvent fileTreePaneEvent) {
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == TavFileLoaderPanel.this.tavAddButton) {
                    TavFileLoaderPanel.this.onTavAdd();
                } else if (object == TavFileLoaderPanel.this.tavAddAllButton) {
                    TavFileLoaderPanel.this.onTavAddAll();
                } else if (object == TavFileLoaderPanel.this.tavRemoveButton) {
                    TavFileLoaderPanel.this.onTavRemove();
                } else if (object == TavFileLoaderPanel.this.tavRemoveAllButton) {
                    TavFileLoaderPanel.this.onTavRemoveAll();
                } else if (object == TavFileLoaderPanel.this.browseButton) {
                    TavFileLoaderPanel.this.selectPreferencesFile();
                }
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                File file = (File)object;
                this.setText(file.getName());
                return this;
            }
        }
    }
}

