/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorSchemeSelectionDialog
extends JDialog {
    private ButtonGroup chanelSelectionGroup;
    private JPanel channelSelectionPanel;
    private JRadioButton negativeColorButton;
    private JRadioButton positiveColorButton;
    private JPanel actionButtonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JColorChooser colorChooser;
    private JPanel gradientPreviewPanel;
    private Color posColor = Color.red;
    private Color negColor = Color.green;
    private Color neutralColor = Color.black;
    private PreviewPanel previewer;
    private int result = 0;
    private JCheckBox neutralColorCheckBox;

    public ColorSchemeSelectionDialog(Frame frame, boolean bl, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        super(frame, bl);
        this.setTitle("Color Scheme Selection");
        this.previewer = new PreviewPanel(bufferedImage, bufferedImage2);
        this.initComponents();
        this.negativeColorButton.setFocusPainted(false);
        this.positiveColorButton.setFocusPainted(false);
        this.neutralColorCheckBox = new JCheckBox("Use Black as Neutral Color", true);
        this.neutralColorCheckBox.setFocusPainted(false);
        if (bufferedImage2.getRGB(0, 0) == Color.white.getRGB()) {
            this.neutralColorCheckBox.setSelected(false);
            this.neutralColor = Color.white;
        } else {
            this.neutralColor = Color.black;
        }
        this.neutralColorCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorSchemeSelectionDialog.this.neutralColorCheckBox.isSelected()) {
                    ColorSchemeSelectionDialog.this.neutralColor = Color.black;
                } else {
                    ColorSchemeSelectionDialog.this.neutralColor = Color.white;
                }
                ColorSchemeSelectionDialog.this.previewer.refreshPreview();
            }
        });
        this.channelSelectionPanel.add((Component)this.neutralColorCheckBox, new GridBagConstraints(0, 1, 2, 0, 0.0, 0.0, 10, 2, new Insets(0, 50, 0, 0), 0, 0));
        this.channelSelectionPanel.validate();
        this.colorChooser.setPreviewPanel(new JPanel());
        this.gradientPreviewPanel.add((Component)this.previewer, "Center");
        this.colorChooser.getSelectionModel().addChangeListener(this.previewer);
        this.setSize(450, 465);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorSchemeSelectionDialog.this.result = 0;
                ColorSchemeSelectionDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorSchemeSelectionDialog.this.result = 2;
                ColorSchemeSelectionDialog.this.setVisible(false);
            }
        });
    }

    private void initComponents() {
        this.chanelSelectionGroup = new ButtonGroup();
        this.channelSelectionPanel = new JPanel();
        this.negativeColorButton = new JRadioButton();
        this.positiveColorButton = new JRadioButton();
        this.actionButtonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(this.previewer);
        this.gradientPreviewPanel = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ColorSchemeSelectionDialog.this.closeDialog(windowEvent);
            }
        });
        this.channelSelectionPanel.setLayout(new GridBagLayout());
        this.negativeColorButton.setSelected(true);
        this.negativeColorButton.setText("Select Negative Color");
        this.chanelSelectionGroup.add(this.negativeColorButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.channelSelectionPanel.add((Component)this.negativeColorButton, gridBagConstraints);
        this.positiveColorButton.setText("Select Positive Color");
        this.chanelSelectionGroup.add(this.positiveColorButton);
        gridBagConstraints = new GridBagConstraints();
        this.channelSelectionPanel.add((Component)this.positiveColorButton, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        this.getContentPane().add((Component)this.channelSelectionPanel, gridBagConstraints2);
        this.actionButtonPanel.setLayout(new GridBagLayout());
        this.okButton.setText(" Apply Color Scheme");
        this.okButton.setFocusPainted(false);
        this.okButton.setSelected(true);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(10, 0, 10, 10);
        this.actionButtonPanel.add((Component)this.okButton, gridBagConstraints3);
        this.cancelButton.setText("Cancel");
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 0);
        this.actionButtonPanel.add((Component)this.cancelButton, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 1;
        this.getContentPane().add((Component)this.actionButtonPanel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 1;
        this.getContentPane().add((Component)this.colorChooser, gridBagConstraints2);
        this.gradientPreviewPanel.setLayout(new BorderLayout());
        this.gradientPreviewPanel.setBorder(new TitledBorder(new EtchedBorder(), "Gradient Preview"));
        this.gradientPreviewPanel.setPreferredSize(new Dimension(200, 70));
        this.gradientPreviewPanel.setMinimumSize(new Dimension(200, 70));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 1;
        this.getContentPane().add((Component)this.gradientPreviewPanel, gridBagConstraints2);
        this.pack();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public BufferedImage getPositiveGradient() {
        return this.previewer.getPositiveGradient();
    }

    public BufferedImage getNegativeGradient() {
        return this.previewer.getNegativeGradient();
    }

    public class PreviewPanel
    extends JPanel
    implements ChangeListener {
        BufferedImage currentPosGradient;
        BufferedImage currentNegGradient;

        public PreviewPanel(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            this.currentNegGradient = bufferedImage;
            this.currentPosGradient = bufferedImage2;
            ColorSchemeSelectionDialog.this.posColor = new Color(bufferedImage2.getRGB(bufferedImage2.getWidth() - 1, 0));
            ColorSchemeSelectionDialog.this.negColor = new Color(bufferedImage.getRGB(0, 0));
            super.setBorder(new TitledBorder(new EtchedBorder(1), "Gradient Preview"));
            this.setSize(200, 70);
            this.setPreferredSize(new Dimension(200, 70));
            this.setVisible(true);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Color color = ColorSchemeSelectionDialog.this.colorChooser.getColor();
            if (color == null) {
                return;
            }
            if (ColorSchemeSelectionDialog.this.positiveColorButton.isSelected()) {
                ColorSchemeSelectionDialog.this.posColor = color;
                this.currentPosGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.neutralColor, ColorSchemeSelectionDialog.this.posColor);
            } else if (ColorSchemeSelectionDialog.this.negativeColorButton.isSelected()) {
                ColorSchemeSelectionDialog.this.negColor = color;
                this.currentNegGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.negColor, ColorSchemeSelectionDialog.this.neutralColor);
            }
            this.repaint();
        }

        public void refreshPreview() {
            this.currentPosGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.neutralColor, ColorSchemeSelectionDialog.this.posColor);
            this.currentNegGradient = this.createGradientImage(ColorSchemeSelectionDialog.this.negColor, ColorSchemeSelectionDialog.this.neutralColor);
            this.repaint();
        }

        public void paint(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.currentNegGradient, 0, 0, this.getWidth() / 2, this.getHeight(), null);
            graphics.drawImage(this.currentPosGradient, this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight(), null);
        }

        private BufferedImage createGradientImage(Color color, Color color2) {
            BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.drawRect(0, 0, 255, 1);
            return bufferedImage;
        }

        public BufferedImage getPositiveGradient() {
            return this.currentPosGradient;
        }

        public BufferedImage getNegativeGradient() {
            return this.currentNegGradient;
        }
    }
}

