/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.engine;

import java.io.FileNotFoundException;
import org.tigr.midas.display.ParameterPane;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.midas.util.logger;

public class RatioStats {
    private static final double[] meanCoef = new double[]{1.001, -0.0427, 1.279, 0.364};
    private static final double[] stdCoef = new double[]{0.00225, 1.341, 0.19, 6.259};
    private static final double[] low95Coef = new double[]{0.979, -2.706, 2.911, -2.805};
    private static final double[] high95Coef = new double[]{0.989, 3.082, -2.83, 28.664};
    private static final double[] low99Coef = new double[]{0.9968, -3.496, 4.462, -5.002};
    private static final double[] high99Coef = new double[]{0.9648, 4.81, -15.161, 78.349};
    private ColumnWorker fCW;
    private int totalRowCount;
    private double[] cy3Column;
    private double[] cy5Column;
    private double calcMean;
    private double plainMean;
    private double cVal;
    private double calcSD;
    private double high99;
    private double low99;
    private double high95;
    private double low95;
    private int validRatioCounts;
    private int confidentCounts;
    private int iterCount;

    public RatioStats(ColumnWorker fileCW, boolean confidenceChk, int pctConfidence) throws Exception {
        double mLimit = 1.0E-10;
        int maxIterations = 100;
        this.fCW = fileCW;
        this.cy3Column = fileCW.getColumnOneArray();
        this.cy5Column = fileCW.getColumnTwoArray();
        boolean[] tempFlag = fileCW.getRowFlagArray();
        boolean[] outputFlag = new boolean[tempFlag.length];
        System.arraycopy(tempFlag, 0, outputFlag, 0, tempFlag.length);
        double[] ratios = new double[this.fCW.getRowCounts()];
        double oldCalcMean = 1.0;
        double ratioSum = 0.0;
        this.plainMean = 0.0;
        this.calcMean = 1.0;
        this.validRatioCounts = 0;
        this.confidentCounts = 0;
        this.totalRowCount = this.fCW.getRowCounts();
        int rawNdx = 0;
        while (rawNdx < this.fCW.getRowCounts()) {
            if (this.cy3Column[rawNdx] > 1.0 && this.cy5Column[rawNdx] > 1.0 && outputFlag[rawNdx]) {
                ratios[rawNdx] = this.cy5Column[rawNdx] / this.cy3Column[rawNdx];
                ratioSum += ratios[rawNdx];
                ++this.validRatioCounts;
            } else {
                ratios[rawNdx] = 0.0;
                outputFlag[rawNdx] = false;
            }
            ++rawNdx;
        }
        logger.log("    Valid Ratio Counts = " + this.validRatioCounts);
        this.iterCount = 1;
        while (true) {
            double accumulator = 0.0;
            this.plainMean = ratioSum / (double)this.validRatioCounts / oldCalcMean;
            ratioSum = 0.0;
            int i = 0;
            while (i < this.fCW.getRowCounts()) {
                if (outputFlag[i]) {
                    int n = i;
                    ratios[n] = ratios[n] / this.plainMean;
                    accumulator += MathTools.sqr((double)(ratios[i] - 1.0)) / (1.0 + MathTools.sqr((double)ratios[i]));
                    ratioSum += ratios[i];
                }
                ++i;
            }
            this.cVal = Math.sqrt(accumulator / (double)this.validRatioCounts);
            this.calcMean = meanCoef[3] * this.cVal * this.cVal * this.cVal + meanCoef[2] * this.cVal * this.cVal + meanCoef[1] * this.cVal + meanCoef[0];
            logger.log("    ---- Iteration " + this.iterCount + ", plainMean = " + this.plainMean + ", calcMean = " + this.calcMean);
            if (Math.abs(this.calcMean - oldCalcMean) < mLimit || this.iterCount >= maxIterations) break;
            oldCalcMean = this.calcMean;
            ++this.iterCount;
        }
        this.calcSD = stdCoef[3] * this.cVal * this.cVal * this.cVal + stdCoef[2] * this.cVal * this.cVal + stdCoef[1] * this.cVal + stdCoef[0];
        this.high99 = high99Coef[3] * this.cVal * this.cVal * this.cVal + high99Coef[2] * this.cVal * this.cVal + high99Coef[1] * this.cVal + high99Coef[0];
        this.high99 *= this.plainMean;
        this.low99 = low99Coef[3] * this.cVal * this.cVal * this.cVal + low99Coef[2] * this.cVal * this.cVal + low99Coef[1] * this.cVal + low99Coef[0];
        this.low99 *= this.plainMean;
        this.high95 = high95Coef[3] * this.cVal * this.cVal * this.cVal + high95Coef[2] * this.cVal * this.cVal + high95Coef[1] * this.cVal + high95Coef[0];
        this.high95 *= this.plainMean;
        this.low95 = low95Coef[3] * this.cVal * this.cVal * this.cVal + low95Coef[2] * this.cVal * this.cVal + low95Coef[1] * this.cVal + low95Coef[0];
        this.low95 *= this.plainMean;
        logger.log("    ratio mean = " + this.plainMean);
        logger.log("    ratio function mean = " + this.calcMean);
        logger.log("    ratio density SD = " + this.calcSD);
        logger.log("    maximum-likelyhood estimator = " + this.cVal);
        logger.log("    95% confidence lower limit = " + this.low95 + ", upper limit = " + this.high95);
        logger.log("    99% confidence lower limit = " + this.low99 + ", upper limit = " + this.high99);
        int rawNdx2 = 0;
        while (rawNdx2 < this.fCW.getRowCounts()) {
            if (outputFlag[rawNdx2]) {
                if (confidenceChk) {
                    if (pctConfidence == 95) {
                        if (ratios[rawNdx2] > this.low95 && ratios[rawNdx2] < this.high95) {
                            if (ParameterPane.pRefStr.equalsIgnoreCase("Cy3")) {
                                this.cy5Column[rawNdx2] = this.cy3Column[rawNdx2] * ratios[rawNdx2];
                            } else {
                                this.cy3Column[rawNdx2] = this.cy5Column[rawNdx2] / ratios[rawNdx2];
                            }
                            ++this.confidentCounts;
                        } else {
                            outputFlag[rawNdx2] = false;
                        }
                    } else if (ratios[rawNdx2] > this.low99 && ratios[rawNdx2] < this.high99) {
                        if (ParameterPane.pRefStr.equalsIgnoreCase("Cy3")) {
                            this.cy5Column[rawNdx2] = this.cy3Column[rawNdx2] * ratios[rawNdx2];
                        } else {
                            this.cy3Column[rawNdx2] = this.cy5Column[rawNdx2] / ratios[rawNdx2];
                        }
                        ++this.confidentCounts;
                    } else {
                        outputFlag[rawNdx2] = false;
                    }
                } else if (ParameterPane.pRefStr.equalsIgnoreCase("Cy3")) {
                    this.cy5Column[rawNdx2] = this.cy3Column[rawNdx2] * ratios[rawNdx2];
                } else {
                    this.cy3Column[rawNdx2] = this.cy5Column[rawNdx2] / ratios[rawNdx2];
                }
            } else {
                this.cy3Column[rawNdx2] = 0.0;
                this.cy5Column[rawNdx2] = 0.0;
            }
            ++rawNdx2;
        }
        if (confidenceChk) {
            logger.log("    Gene counts within confidence range = " + this.confidentCounts);
        }
        this.fCW.setColOneArray(this.cy3Column);
        this.fCW.setColTwoArray(this.cy5Column);
        this.fCW.setRowFlag(outputFlag);
    }

    public final ColumnWorker getRatioStatsColumnWorker() {
        return this.fCW;
    }

    public final double getPlainMean() {
        return this.plainMean;
    }

    public final double getCalcMean() {
        return this.calcMean;
    }

    public final double getCalcSD() {
        return this.calcSD;
    }

    public final double getLow95() {
        return this.low95;
    }

    public final double getHigh95() {
        return this.high95;
    }

    public final double getLow99() {
        return this.low95;
    }

    public final double getHigh99() {
        return this.high95;
    }

    public final double getCval() {
        return this.cVal;
    }

    public final int getIterationCounts() {
        return this.iterCount;
    }

    public final int getValidRatioCounts() {
        return this.validRatioCounts;
    }

    public final int getConfidentCounts() {
        return this.confidentCounts;
    }

    public final int getTotalRowCounts() {
        return this.totalRowCount;
    }

    public static void main(String[] args) {
        try {
            ColumnWorker fileCW = new ColumnWorker("C:\\DataFiles0\\32K\\SimonData\\1233259D2F.tav");
            fileCW.setColumnsForMeta(2, 3);
            fileCW.setColumns(6, 7, 15, 16);
            fileCW.computeGoodRatiosAndLogRatios(0L, 0L);
            RatioStats ratioStats = new RatioStats(fileCW, true, 99);
        }
        catch (FileNotFoundException nfex) {
            nfex.printStackTrace();
        }
        catch (NumberFormatException nex) {
            nex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

