/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.mevdialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class LinRegNormInitDialog
extends AlgorithmDialog {
    private JComboBox sdComboBox;
    JRadioButton blockButton;
    JRadioButton globalButton;
    private int result = 2;
    private final String[] SD_VALUES = new String[]{"+/-0.50 SD", "+/-1.00 SD", "+/-1.50 SD", "+/-1.96 SD", "+/-2.00 SD", "+/-2.50 SD", "+/-3.00 SD"};

    public LinRegNormInitDialog() {
        super(new JFrame(), "Iterative Linear Regression", true);
        this.blockButton = new JRadioButton("Block Mode", true);
        this.blockButton.setFocusPainted(false);
        this.blockButton.setBackground(Color.white);
        this.blockButton.setHorizontalAlignment(0);
        this.globalButton = new JRadioButton("Global Mode");
        this.globalButton.setFocusPainted(false);
        this.globalButton.setBackground(Color.white);
        this.globalButton.setHorizontalAlignment(0);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.blockButton);
        bg.add(this.globalButton);
        this.sdComboBox = new JComboBox<String>(this.SD_VALUES);
        this.sdComboBox.setEditable(false);
        this.sdComboBox.setSelectedIndex(4);
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBackground(Color.white);
        parameters.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Normalization Parameters"));
        JPanel modePanel = new JPanel(new GridBagLayout());
        modePanel.setBackground(Color.white);
        modePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Normalization Mode"));
        JPanel sdPanel = new JPanel(new GridBagLayout());
        sdPanel.setBackground(Color.white);
        sdPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Standard Deviation Range"));
        modePanel.add((Component)this.blockButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(15, 0, 15, 0), 0, 0));
        modePanel.add((Component)this.globalButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(15, 0, 15, 0), 0, 0));
        sdPanel.add((Component)this.sdComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 20, 0), 0, 0));
        parameters.add((Component)modePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)sdPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(new Listener());
        ((Component)this).setSize(new Dimension(450, 350));
        this.setResizable(false);
        this.pack();
    }

    public double getSD() {
        double sd = 0.0;
        String sdString = (String)this.sdComboBox.getSelectedItem();
        sdString = sdString.substring(3, 7);
        try {
            sd = Double.parseDouble(sdString);
        }
        catch (Exception e) {
            // empty catch block
        }
        return sd;
    }

    public String getMode() {
        if (this.blockButton.isSelected()) {
            return "block";
        }
        return "global";
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        this.dispose();
        return this.result;
    }

    public static void main(String[] args) {
        LinRegNormInitDialog dialog = new LinRegNormInitDialog();
        dialog.showModal();
        System.exit(0);
    }

    public class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                LinRegNormInitDialog.this.result = 0;
                LinRegNormInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                LinRegNormInitDialog.this.blockButton.setSelected(true);
                LinRegNormInitDialog.this.sdComboBox.setSelectedIndex(4);
            } else if (command.equals("cancel-command")) {
                LinRegNormInitDialog.this.result = 2;
                LinRegNormInitDialog.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow hw = new HelpWindow(LinRegNormInitDialog.this, "Linear Regression Initialization Dialog");
                if (hw.getWindowContent()) {
                    ((Component)hw).setSize(450, 550);
                    hw.setLocation();
                    hw.show();
                } else {
                    ((Component)hw).setVisible(false);
                    hw.dispose();
                }
            }
        }
    }
}

