/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.mevdialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class RatioStatsNormInitDialog
extends AlgorithmDialog {
    private JComboBox ciComboBox;
    private int result = 2;
    private final String[] CI_VALUES = new String[]{"95%", "99%"};

    public RatioStatsNormInitDialog() {
        super(new JFrame(), "Ratio Statistics Normalization", true);
        this.ciComboBox = new JComboBox<String>(this.CI_VALUES);
        this.ciComboBox.setEditable(false);
        this.ciComboBox.setSelectedIndex(0);
        JPanel ciPanel = new JPanel(new GridBagLayout());
        ciPanel.setBackground(Color.white);
        ciPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Confidence Interval"));
        ciPanel.add((Component)this.ciComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(30, 0, 30, 0), 0, 0));
        this.addContent(ciPanel);
        this.setActionListeners(new Listener());
        ((Component)this).setSize(new Dimension(450, 220));
        this.setResizable(false);
        this.pack();
    }

    public int getCI() {
        int ci = 0;
        String ciString = (String)this.ciComboBox.getSelectedItem();
        ciString = ciString.substring(0, 2);
        try {
            ci = Integer.parseInt(ciString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ci;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        this.dispose();
        return this.result;
    }

    public static void main(String[] args) {
        RatioStatsNormInitDialog dialog = new RatioStatsNormInitDialog();
        dialog.show();
        System.out.println("ci = " + dialog.getCI());
        System.exit(0);
    }

    public class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                RatioStatsNormInitDialog.this.result = 0;
                RatioStatsNormInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                RatioStatsNormInitDialog.this.ciComboBox.setSelectedIndex(0);
            } else if (command.equals("cancel-command")) {
                RatioStatsNormInitDialog.this.result = 2;
                RatioStatsNormInitDialog.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow hw = new HelpWindow(RatioStatsNormInitDialog.this, "Ratio Statistics Initialization Dialog");
                if (hw.getWindowContent()) {
                    ((Component)hw).setSize(450, 420);
                    hw.setLocation();
                    hw.show();
                } else {
                    ((Component)hw).setVisible(false);
                    hw.dispose();
                }
            }
        }
    }
}

