/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 * FileBrowser.java
 *
 * Created on September 24, 2001, 1:51 PM
 * @author  wliang
 * @version
 */

package org.tigr.midas.util;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;
import org.tigr.midas.Constant;


public class FileBrowser {
    
    public static String fsep = System.getProperty("file.separator");
    private String workingFullDir;
    private String workingDir;
    private Vector filesVecLong, filesVecShort;
    private File dir;
    private File subDir;
    private String[] exts;
    
    public FileBrowser() {
    }
    
    public FileBrowser(String directory, int file_type){
        
        workingFullDir = directory;
        filesVecLong = new Vector();
        filesVecShort = new Vector();
        //File dir = new File((new File(directory)).getParentFile(), "DataFiles");
        dir = new File(directory);
        workingDir = dir.getAbsolutePath();
        File checkFile;
        
        if (file_type == Constant.READ_FILE || file_type == Constant.READ_PAIR || file_type == Constant.READ_FOLDER){
            String[] s = {"tav", "mev"};
            exts = s;
        }else if (file_type == Constant.READ_INTENSITY_PLOT_DATA){
            String[] s = {"ity", "lty"};
            exts = s;
        }else if (file_type == Constant.READ_DISTRIBUTION_PLOT_DATA){
            String[] s = {"dis"};
            exts = s;
        }else if (file_type == Constant.READ_RI_PLOT_DATA){
            String[] s = {"prc"};
            exts = s;
        }else if (file_type == Constant.READ_RR_PLOT_DATA){
            String[] s = {"rrc"};
            exts = s;
        }else if (file_type == Constant.READ_BOX_PLOT_DATA){
            String[] s = {"box"};
            exts = s;
        }else if (file_type == Constant.READ_VOLCANO_PLOT_DATA){
            String[] s = {"dis"};
            exts = s;
        }
        
        String[] available = dir.list();
        
        
        try{
            if (! dir.isDirectory()) {
                workingDir = workingDir.substring(0, workingDir.lastIndexOf(FileBrowser.fsep));
            }else if (dir.isDirectory()){
                for (int i = 0; i < available.length; i++) {
                    for (int j = 0; j < exts.length; j++) {
                        if (available[i].endsWith(exts[j])) {
                            checkFile = new File(dir, available[i]);
                            if (checkFile.isFile()) {
                                filesVecLong.addElement(workingDir + FileBrowser.fsep + available[i]);
                                filesVecShort.addElement(available[i]);
                            }
                        }
                    }
                }
            }
        }catch (StringIndexOutOfBoundsException ex){
            ex.printStackTrace();
        }
    }
    
    public Vector getFileNamesVec(String s){
        Vector filesVec = null;
        if (s.equalsIgnoreCase("long")){
            filesVec = filesVecLong;
        }else if (s.equalsIgnoreCase("short")){
            filesVec = filesVecShort;
        }
        return filesVec;
    }
    
    public final int getFileCounts(){
        return filesVecLong.size();
    }
    
    public final String getAbsolutePath(){
        return workingDir;
    }
    
    public final String createSubDir(String sub){

        subDir = new File(workingFullDir + sub + fsep);

        if (subDir.mkdir()){
            logger.log("    " + workingFullDir + sub + fsep + " created");
        }else{
            logger.log("    " + workingFullDir + sub + fsep + " NOT created, it might already exist");
        }
        return workingFullDir + sub + this.fsep;
    }
    
    public final static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');
        
        if (i > 0 &&  i < s.length() - 1) {
            ext = s.substring(i+1).toLowerCase();
        }
        return ext;
    }
}
