package org.tigr.midas.util.mevFileParser;

import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;

public class MeVParser {
	
	public static void test() {
		
		long startTestTime = 0;
		long stopTestTime = 0;
		long elapsedTime = 0;
		
		JFrame frame = new JFrame("MeVParser");
		frame.setVisible(true);
		
		MevFileParser mfp = new MevFileParser();
		File targetFile = MevFileParser.selectFile(frame);
		
		startTestTime = System.currentTimeMillis();
		if (! validateFile(targetFile)) return;
		stopTestTime = System.currentTimeMillis();
		elapsedTime = stopTestTime - startTestTime;
		System.out.println("\nMeV file validated in: " + ((float) elapsedTime / 1000) + " seconds");
		
		if (targetFile != null) {
			startTestTime = System.currentTimeMillis();
			mfp.loadFile(targetFile);
		}
		
		stopTestTime = System.currentTimeMillis();
		elapsedTime = stopTestTime - startTestTime;
		System.out.println("\nMeV file loaded: " + mfp.isMevFileLoaded());
		System.out.println("File loading time: " + ((float) elapsedTime / 1000) + " seconds");
		
		startTestTime = System.currentTimeMillis();
		
		printColumnHeaders(mfp);
		printLines(mfp);
	//	printColumns(mfp); //Uncomment to get a column of data -- could be a lot of output
		printElements(mfp);
	//	printMatrix(mfp); //Uncomment to get a matrix of data -- could be a lot of output
		
		stopTestTime = System.currentTimeMillis();
		elapsedTime = stopTestTime - startTestTime;
		System.out.println("\nMevFileParser test completed");
		System.out.println("MevFileParser output test time: " + ((float) elapsedTime / 1000) + " seconds");
	}
	
	public static boolean validateFile(File targetFile) {
		
		switch (MevFileParser.validate(targetFile)) {
			case MevFileParser.MEV_FILE:
				System.out.println(targetFile.getName() + " is a valid mev file.");
				return true;
			case MevFileParser.INVALID_FILE:
				System.out.println(targetFile.getName() + " is an invalid mev file.");
			default:
				return false;
		}
	}
	
	public static void printColumnHeaders(MevFileParser mfp) {
		
		//
		System.out.println("\nColumn Headers");
		Vector columnHeaders = mfp.getColumnHeaders();
		for (int i = 0; i < columnHeaders.size(); i++) {
			if (i > 0) System.out.print(", ");
			System.out.print((String) columnHeaders.elementAt(i));
		}
		System.out.print("\n");
		//
	}
	
	public static void printLines(MevFileParser mfp) {
		
		//
		int targetRawLine = 1; // Change this index to print a different 'raw' line
		System.out.println("\nRaw Line " + targetRawLine);
		System.out.println(mfp.getLineAt(targetRawLine));
		//
	}
	
	public static void printColumns(MevFileParser mfp) {
		
		//
		int targetColumn = 1; // Change this index to print a different column
		System.out.println("\nElements of column " + targetColumn);
		Vector columnVectorA = mfp.getColumnAt(targetColumn);
		for (int i = 0; i < columnVectorA.size(); i++) {
			System.out.println(columnVectorA.elementAt(i));
		}
		//
		
		//
		String columnName = "QCscore"; // Change this name to print a different column
		System.out.println("\nElements of column " + columnName);
		
		try {
			Vector columnVectorB = mfp.getColumnNamed(columnName);
			for (int i = 0; i < columnVectorB.size(); i++) {
				System.out.println(columnVectorB.elementAt(i));
			}
		} catch (FieldNotFoundException fnfe) {
			System.out.println("Field " + columnName + " not found.");
		}
		//
	}
	
	public static void printElements(MevFileParser mfp) {
		
		//
		int targetIndex = 3; // Change this index to print a different element
		System.out.println("\nElement at index " + targetIndex);
		System.out.println(mfp.getElementAtIndex(targetIndex));
		//
		
		//
		String uniqueId = "27643"; // Change this UID to print a different element
		System.out.println("\nElement with UID " + uniqueId);
		
		try {
			System.out.println(mfp.getElementById(uniqueId));
		} catch (FieldNotFoundException fnfe) {
			fnfe.printStackTrace();
		}
		//
		
		//
		String targetField = "QCscore"; // Change this field/value pair to print a different element
		String targetValue = "0.6201";
		System.out.println("\nElement with " + targetField + " = " + targetValue);
		
		try {
			System.out.println(mfp.getElementByField(targetField, targetValue));
		} catch (FieldNotFoundException fnfe) {
			System.out.println("Field " + targetField + " not found.");
		}
		//
		
		//
		String targetField2 = "I1";  // Change this field/value pair to print different elements
		String targetValue2 = "209760";
		System.out.println("\nElements with " + targetField2 + " = " + targetValue2);
		
		try {
			Vector matches = mfp.getElementsByField(targetField2, targetValue2);
			if (matches == null) {
				System.out.println("No elements with " + targetField2 + " = " + targetValue2);
			} else {
				System.out.println(matches.size() + " elements with " + targetField2 + " = " + targetValue2);
				for (int i = 0; i < matches.size(); i++) {
					System.out.println(matches.elementAt(i));
				}
			}
		} catch (FieldNotFoundException fnfe) {
			System.out.println("Field " + targetField2 + " not found.");
		}
		//
	}
	
	public static void printMatrix(MevFileParser mfp) {
		
		//
		System.out.println("\nData matrix with headers");
		String[][] matrixA = mfp.getDataMatrix(true);
		for (int i = 0; i < matrixA.length; i++) {
			for (int j = 0; j < matrixA[0].length; j++) {
				System.out.print(matrixA[i][j] + "\t");
			}
			System.out.print("\n");
		}
		//
		
		//
		System.out.println("\nData matrix without headers");
		String[][] matrixB = mfp.getDataMatrix(false);
		for (int i = 0; i < matrixB.length; i++) {
			for (int j = 0; j < matrixB[0].length; j++) {
				System.out.print(matrixB[i][j] + "\t");
			}
			System.out.print("\n");
		}
		//
	}
	
	public static void main(String[] args) {
		System.out.println("Beginning MevFileParser test");
		test();
		System.out.println("\nFinished MevFileParser test");
	}
}