package nsdb;


/**
* nsdb/NucSeqOperations.java .
* Generated by the IDL-to-Java compiler (portable), version "3.1"
* from corba/nsdb.idl
* Tuesday, March 7, 2006 12:49:15 PM GMT
*/


/**
       * Generic Nucleotide sequence interface.
       * The accession number is retrieved using the getBioSeqId method inherited from BioSeq.
       * @see EmblSeq
       * @see seqdb::BioSeq
       */
public interface NucSeqOperations  extends seqdb.BioSeqOperations
{

  /**
  	 * retrieve string representation of nucleotide sequence. Each character
  	 * in the string is a 
  	 *   <href="http://www.ebi.ac.uk/ebi_docs/embl_db/ft/iupac_codes.html">
  	 *   IUPAC nucleotide base code</A>
  	 * <P>
  	 * This method can be used instead of the getAnySeq() 
  	 * method in seqdb::BioSeq
  	 * @see seqdb::BioSeq
  	 */
  String getSeq ();

  /**
  	 * Checksum on sequence to allow validation.
  	 * 
  	 */
  int getCheckSum ();

  /**
  	 * topology of the nucleotide sequence
  	 * @see meta::nsdb
  	 */
  String getTopology ();

  /**
  	 * molecule type of the nucleotide sequence
  	 * @see meta::nsdb
  	 */
  String getMoleculeType ();

  /**
  	 * retrieve sequence of NucFeatureList associated with
  	 * the nucleotide sequence.
  	 * A sequence has <I>ownership</I> of all these 
  	 * features. It is possible on the other hand that
  	 * features, owned by another sequence, reference 
  	 * the current sequence. Currently there is no way to find out.
  	 * @raises type::NoResult if no features are owned by the sequence
  	 */
  nsdb.NucFeature[] getNucFeatures () throws type.NoResult;

  /**
  	 * A location of a NucFeature can span multiple sequences.
  	 * If only the location of a feature relevant to the current
  	 * sequence is required, this method will calculate that.
  	 * @parm nuc_feature Feature from which location needs to be
  	 *   intersected with the current sequence.
  	 * @raises type::InvalidRelation if the nuc_feature 
  	 *   is not associated to the current sequence
  	 */
  nsdb.Location getLocalLocation (nsdb.NucFeature nuc_feature) throws type.InvalidRelation;

  /**
  	 * organism(s) from which the NucSeq was obtained.
  	 * If the sequence is chimeric, multiple organisms will be returned.
  	 * For each organism, there should be a source feature associated
  	 * with the current sequence. This source feature has a location
  	 * defining which part of the sequence was derived from the specified
  	 * organism.
  	 * This method provides a shortcut to:
  	 * invoke getNucFeaturesByKey("source"), invoke getQualifiers() on each 
  	 * source feature and loop through qualifiers to find DbXref. 
  	 * @raises type::NoResult if no source features are associated with
  	 * the sequence (should never happen).
  	 */
  type.DbXref[] getOrganisms () throws type.NoResult;

  /**
  	 * retreive all features of a specific kind (FeatureKey)
  	 * @parm key Type of features to be retrieved
  	 * @raises type::NoResult if the sequence has no associated features
  	 *     of the requested type.
  	 * @raises type::InvalidArgumentValue if the key is not a 
  	 * <A href="http://www.ebi.ac.uk/ebi_docs/embl_db/ft/feature_table.html">
  	 * valid feature key</A>
  	 * @see NucFeature
  	 */
  nsdb.NucFeature[] getNucFeaturesByKey (String key) throws type.NoResult, type.InvalidArgumentValue;

  /**
  	 * Create nucleotide sequence of the segment specified
  	 * The first base in the sequence is numbered 1
  	 *
  	 * @parm start first base of sub-sequence (inclusive)
  	 * @parm end last base of sub-sequence (inclusive)
  	 * @raises type::IndexOutOfRange if start &lt 1
  	 *   or end &gt length
  	 */
  String getSubSeq (int start, int end) throws type.IndexOutOfRange;

  /** 
  	  * Create nucleotide sequence of the location derived from the specified feature
  	  * and contained in the current NucSeq.
  	  * @raises type::InvalidRelation if the nuc_feature 
  	  *   is not associated to the current sequence
            * @raises InexactLocation if an exact sequence cannot be
  	  *   determined due to the feature's location being inexact
  	  */
  String getSubSeqByFeature (nsdb.NucFeature feature) throws type.InvalidRelation, nsdb.InexactLocation;

  /**
             * @raises type::InvalidRelation if reference does not exist
             * @raises type::InvalidRelation if reference is not 
             *   associated to the current sequence
             * @raises type::NoResult if there is no location associated with this reference
             */
  nsdb.Location getReferenceLocation (String reference_id) throws type.InvalidRelation, type.NoResult;
} // interface NucSeqOperations
