/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas;

import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import org.biolegato.core.plugintypes.PropertiesExtension;
import org.biolegato.core.properties.BLProperties;
import org.biolegato.core.properties.PropertiesCheckbox;

/**
 * A class for adding GDE canvas specific properties to.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class GDECanvasProperties implements PropertiesExtension {
    /**
     * The BLProperties object to associate the properties extension with.
     */
    private final BLProperties properties;
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622777011L;

    /**
     * Creates a new GDECanvasProperties object.
     *
     * @param properties BioLegato's internal property registry.
     */
    public GDECanvasProperties (final BLProperties properties) {
        this.properties = properties;

        properties.setProperty("font.bold", "false");
    }

    /**
     * Displays all of the widgets available for modifying the associated properties.
     *
     * @param propertiesBox the container to add the properties widgets to.
     */
    public void propertiesComponent(Container propertiesBox) {
        Box protectionBox = new Box(BoxLayout.PAGE_AXIS);
        PropertiesCheckbox boldCB = new PropertiesCheckbox(properties, "Use bold fonts", "font.bold");

        propertiesBox.add(boldCB);
    }
}
