/*
 * BLComponent.java
 *
 * Created on November 20, 2009, 10:15 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.textarea;

import java.awt.Font;
import javax.swing.JComponent;

/**
 *
 * @author alvare
 */
public abstract class BLComponent extends JComponent {
    
    /**
     * The height of each row in the textarea
     */
    protected int rowHeight = 1;
    /**
     * The width of each column in the textarea
     */
    protected int columnWidth = 1;
    
    /** Creates a new instance of BLComponent */
    public BLComponent() {
    }

    /**
     * Updates the font for the canvas (ensures repaint)
     *
     * @param font the new font to handle.
     */
    @Override
    public void setFont(Font font) {
        super.setFont(font);
        columnWidth = 0;
        for (int fontWidth : getFontMetrics(getFont()).getWidths()) {
            columnWidth = Math.max(columnWidth, fontWidth);
        }
        rowHeight = getFontMetrics(getFont()).getHeight();
        repaint();
    }

////////////////////
//****************//
//* MATH METHODS *//
//****************//
////////////////////

    protected abstract void refreshSize();
    
    /**
     * Converts a row number into a Y co-ordinate
     *
     * @param r the row number
     * @return the corresponding Y value
     */
    public int row2Y (int r) {
        return (r * rowSize());
    }

    /**
     * Converts a column number into a X co-ordinate
     *
     * @param c the column number
     * @return the corresponding X value
     */
    public int column2X (int c) {
        return (c * columnSize());
    }
    
    /**
     * Returns the size of one row of the textarea.
     *
     * @return the row size of textarea.
     */
    public int rowSize() {
        return rowHeight;
    }
    
    /**
     * Returns the size of one column of the textarea.
     *
     * @return the column size of textarea.
     */
    public int columnSize() {
        return columnWidth;
    }

    /**
     * Converts a Y co-ordinate into a row number
     *
     * @param Y the Y value
     * @return the corresponding row number
     */
    public int Y2Row (int Y) {
        return Math.round(Y / rowSize());
    }

    /**
     * Converts a X co-ordinate into a column number
     *
     * @param X the X value
     * @return the corresponding column number
     */
    public int X2Column (int X) {
        return Math.round(X/ columnSize());
    }

    /**
     * Returns the current maximum number of visible rows
     *
     * @return the number of visible rows
     */
    public int maxRows () {
        return (getHeight() / rowSize());
    }

    /**
     * Returns the current maximum number of visible columns
     *
     * @return the number of visible columns
     */
    public int maxColumns () {
        return (getWidth() / columnSize());
    }
}
